//
//  SCPSetupAttemptCardPresentDetails.h
//  StripeTerminal
//
//  Created by James Little on 1/18/21.
//  Copyright © 2021 Stripe. All rights reserved.
//
//  Use of this SDK is subject to the Stripe Terminal Terms:
//  https://stripe.com/terminal/legal
//

#import <Foundation/Foundation.h>
#import <StripeTerminal/SCPJSONDecodable.h>

NS_ASSUME_NONNULL_BEGIN

/**
 An object representing details from a transaction using a card_present
 payment method.

 @see https://stripe.com/docs/api/charges/object#charge_object-payment_method_details-card_present
 */
NS_SWIFT_NAME(SetupAttemptCardPresentDetails)
@interface SCPSetupAttemptCardPresentDetails : NSObject <SCPJSONDecodable>

/**
 The ID of the Card PaymentMethod which was generated by this SetupAttempt.
 */
@property (nonatomic, readonly) NSString *generatedCard;

/**
 The Authorization Response Cryptogram (ARPC) from the issuer.
 */
@property (nonatomic, readonly) NSString *emvAuthData;

/**
 You cannot directly instantiate this class.
 */
- (instancetype)init NS_UNAVAILABLE;

/**
 You cannot directly instantiate this class.
 */
+ (instancetype)new NS_UNAVAILABLE;

@end

NS_ASSUME_NONNULL_END
