// Copyright 2019 Google
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

#import <Foundation/Foundation.h>

NS_ASSUME_NONNULL_BEGIN

FOUNDATION_EXPORT NSString *const FIRCLSDeveloperToken;

// User Messages
FOUNDATION_EXPORT NSString *const FIRCLSMissingConsumerKeyMsg;
FOUNDATION_EXPORT NSString *const FIRCLSMissingConsumerSecretMsg;

// Exceptions
FOUNDATION_EXPORT NSString *const FIRCLSException;

// Endpoints
FOUNDATION_EXPORT NSString *const FIRCLSSettingsEndpoint;
FOUNDATION_EXPORT NSString *const FIRCLSConfigureEndpoint;
FOUNDATION_EXPORT NSString *const FIRCLSReportsEndpoint;

// Network requests
FOUNDATION_EXPORT NSString *const FIRCLSNetworkAccept;
FOUNDATION_EXPORT NSString *const FIRCLSNetworkAcceptCharset;
FOUNDATION_EXPORT NSString *const FIRCLSNetworkApplicationJson;
FOUNDATION_EXPORT NSString *const FIRCLSNetworkAcceptLanguage;
FOUNDATION_EXPORT NSString *const FIRCLSNetworkContentLanguage;
FOUNDATION_EXPORT NSString *const FIRCLSNetworkCrashlyticsAPIClientDisplayVersion;
FOUNDATION_EXPORT NSString *const FIRCLSNetworkCrashlyticsAPIClientId;
FOUNDATION_EXPORT NSString *const FIRCLSNetworkCrashlyticsDeveloperToken;
FOUNDATION_EXPORT NSString *const FIRCLSNetworkCrashlyticsGoogleAppId;
FOUNDATION_EXPORT NSString *const FIRCLSNetworkCrashlyticsOrgId;
FOUNDATION_EXPORT NSString *const FIRCLSNetworkUserAgent;
FOUNDATION_EXPORT NSString *const FIRCLSNetworkUTF8;

NSString *FIRCLSSDKGeneratorName(void);

NSString *FIRCLSSDKVersion(void);

NS_ASSUME_NONNULL_END
