// Copyright 2019 Google
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

#pragma once

#include <stdint.h>

#include "Crashlytics/Crashlytics/Helpers/FIRCLSFeatures.h"

#if CLS_CPU_X86_64
enum {
  CLS_DWARF_X86_64_RAX = 0,
  CLS_DWARF_X86_64_RDX = 1,
  CLS_DWARF_X86_64_RCX = 2,
  CLS_DWARF_X86_64_RBX = 3,
  CLS_DWARF_X86_64_RSI = 4,
  CLS_DWARF_X86_64_RDI = 5,
  CLS_DWARF_X86_64_RBP = 6,
  CLS_DWARF_X86_64_RSP = 7,
  CLS_DWARF_X86_64_R8 = 8,
  CLS_DWARF_X86_64_R9 = 9,
  CLS_DWARF_X86_64_R10 = 10,
  CLS_DWARF_X86_64_R11 = 11,
  CLS_DWARF_X86_64_R12 = 12,
  CLS_DWARF_X86_64_R13 = 13,
  CLS_DWARF_X86_64_R14 = 14,
  CLS_DWARF_X86_64_R15 = 15,

  CLS_DWARF_X86_64_RET_ADDR = 16
};

#define CLS_DWARF_REG_RETURN CLS_DWARF_X86_64_RET_ADDR
#define CLS_DWARF_REG_SP CLS_DWARF_X86_64_RSP
#define CLS_DWARF_REG_FP CLS_DWARF_X86_64_RBP

#define CLS_DWARF_MAX_REGISTER_NUM (CLS_DWARF_X86_64_RET_ADDR)

#elif CLS_CPU_I386

enum {
  CLS_DWARF_X86_EAX = 0,
  CLS_DWARF_X86_ECX = 1,
  CLS_DWARF_X86_EDX = 2,
  CLS_DWARF_X86_EBX = 3,
  CLS_DWARF_X86_EBP = 4,
  CLS_DWARF_X86_ESP = 5,
  CLS_DWARF_X86_ESI = 6,
  CLS_DWARF_X86_EDI = 7,

  CLS_DWARF_X86_RET_ADDR = 8
};

#define CLS_DWARF_REG_RETURN CLS_DWARF_X86_RET_ADDR
#define CLS_DWARF_REG_SP CLS_DWARF_X86_ESP
#define CLS_DWARF_REG_FP CLS_DWARF_X86_EBP

#define CLS_DWARF_MAX_REGISTER_NUM (CLS_DWARF_X86_RET_ADDR)

#elif CLS_CPU_ARM64

// 64-bit ARM64 registers
enum {
  CLS_DWARF_ARM64_X0 = 0,
  CLS_DWARF_ARM64_X1 = 1,
  CLS_DWARF_ARM64_X2 = 2,
  CLS_DWARF_ARM64_X3 = 3,
  CLS_DWARF_ARM64_X4 = 4,
  CLS_DWARF_ARM64_X5 = 5,
  CLS_DWARF_ARM64_X6 = 6,
  CLS_DWARF_ARM64_X7 = 7,
  CLS_DWARF_ARM64_X8 = 8,
  CLS_DWARF_ARM64_X9 = 9,
  CLS_DWARF_ARM64_X10 = 10,
  CLS_DWARF_ARM64_X11 = 11,
  CLS_DWARF_ARM64_X12 = 12,
  CLS_DWARF_ARM64_X13 = 13,
  CLS_DWARF_ARM64_X14 = 14,
  CLS_DWARF_ARM64_X15 = 15,
  CLS_DWARF_ARM64_X16 = 16,
  CLS_DWARF_ARM64_X17 = 17,
  CLS_DWARF_ARM64_X18 = 18,
  CLS_DWARF_ARM64_X19 = 19,
  CLS_DWARF_ARM64_X20 = 20,
  CLS_DWARF_ARM64_X21 = 21,
  CLS_DWARF_ARM64_X22 = 22,
  CLS_DWARF_ARM64_X23 = 23,
  CLS_DWARF_ARM64_X24 = 24,
  CLS_DWARF_ARM64_X25 = 25,
  CLS_DWARF_ARM64_X26 = 26,
  CLS_DWARF_ARM64_X27 = 27,
  CLS_DWARF_ARM64_X28 = 28,
  CLS_DWARF_ARM64_X29 = 29,
  CLS_DWARF_ARM64_FP = 29,
  CLS_DWARF_ARM64_X30 = 30,
  CLS_DWARF_ARM64_LR = 30,
  CLS_DWARF_ARM64_X31 = 31,
  CLS_DWARF_ARM64_SP = 31,
  // reserved block
  CLS_DWARF_ARM64_D0 = 64,
  CLS_DWARF_ARM64_D1 = 65,
  CLS_DWARF_ARM64_D2 = 66,
  CLS_DWARF_ARM64_D3 = 67,
  CLS_DWARF_ARM64_D4 = 68,
  CLS_DWARF_ARM64_D5 = 69,
  CLS_DWARF_ARM64_D6 = 70,
  CLS_DWARF_ARM64_D7 = 71,
  CLS_DWARF_ARM64_D8 = 72,
  CLS_DWARF_ARM64_D9 = 73,
  CLS_DWARF_ARM64_D10 = 74,
  CLS_DWARF_ARM64_D11 = 75,
  CLS_DWARF_ARM64_D12 = 76,
  CLS_DWARF_ARM64_D13 = 77,
  CLS_DWARF_ARM64_D14 = 78,
  CLS_DWARF_ARM64_D15 = 79,
  CLS_DWARF_ARM64_D16 = 80,
  CLS_DWARF_ARM64_D17 = 81,
  CLS_DWARF_ARM64_D18 = 82,
  CLS_DWARF_ARM64_D19 = 83,
  CLS_DWARF_ARM64_D20 = 84,
  CLS_DWARF_ARM64_D21 = 85,
  CLS_DWARF_ARM64_D22 = 86,
  CLS_DWARF_ARM64_D23 = 87,
  CLS_DWARF_ARM64_D24 = 88,
  CLS_DWARF_ARM64_D25 = 89,
  CLS_DWARF_ARM64_D26 = 90,
  CLS_DWARF_ARM64_D27 = 91,
  CLS_DWARF_ARM64_D28 = 92,
  CLS_DWARF_ARM64_D29 = 93,
  CLS_DWARF_ARM64_D30 = 94,
  CLS_DWARF_ARM64_D31 = 95
};

#define CLS_DWARF_MAX_REGISTER_NUM (CLS_DWARF_ARM64_SP)

#define CLS_DWARF_REG_RETURN CLS_DWARF_ARM64_LR
#define CLS_DWARF_REG_SP CLS_DWARF_ARM64_SP
#define CLS_DWARF_REG_FP CLS_DWARF_ARM64_FP

#endif

#define CLS_DWARF_INVALID_REGISTER_NUM (CLS_DWARF_MAX_REGISTER_NUM + 1)
