// Copyright 2019 Google
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

#include "Crashlytics/Crashlytics/Handlers/FIRCLSHandler.h"

#include "Crashlytics/Crashlytics/Components/FIRCLSCrashedMarkerFile.h"
#include "Crashlytics/Crashlytics/Components/FIRCLSGlobals.h"
#include "Crashlytics/Crashlytics/Components/FIRCLSHost.h"
#include "Crashlytics/Crashlytics/Components/FIRCLSProcess.h"
#include "Crashlytics/Crashlytics/Helpers/FIRCLSUtility.h"

#import "Crashlytics/Crashlytics/Controllers/FIRCLSReportManager_Private.h"

void FIRCLSHandler(FIRCLSFile* file,
                   thread_t crashedThread,
                   void* uapVoid,
                   bool shouldSuspendThread) {
  FIRCLSProcess process;

  FIRCLSProcessInit(&process, crashedThread, uapVoid);

  if (shouldSuspendThread) {
    FIRCLSProcessSuspendAllOtherThreads(&process);
  }

  FIRCLSProcessRecordAllThreads(&process, file);

  FIRCLSProcessRecordRuntimeInfo(&process, file);
  // Get dispatch queue and thread names. Note that getting the thread names
  // can hang, so let's do that last
  FIRCLSProcessRecordDispatchQueueNames(&process, file);
  FIRCLSProcessRecordThreadNames(&process, file);

  // this stuff isn't super important, but we can try
  FIRCLSProcessRecordStats(&process, file);
  FIRCLSHostWriteDiskUsage(file);

  // This is the first common point where various crash handlers call into
  // Store a crash file marker to indicate that a crash has occurred
  FIRCLSCreateCrashedMarkerFile();

  if (shouldSuspendThread) {
    FIRCLSProcessResumeAllOtherThreads(&process);
  }
}
