//
//  CustomerListVC.swift
//  EPOS
//
//  Created by Apple on 23/07/21.
//

import UIKit

class CustomerListVC: UIViewController {

    //MARK: IBOutlets
    @IBOutlet weak var tblCustomers:UITableView!
    @IBOutlet weak var txtSearchCustomer:UITextField!
    
    //MARK: Instances
    var parentVC:SideMenuVC!
    var arrCustomers = [CustomerModel]()
    var arrSearchCustomers = [CustomerModel]()
    var isSearchEnabled = false
    var selectedCustomer:CustomerModel!
    
    //MARK: ViewController LifeCycle
    override func viewDidLoad() {
        super.viewDidLoad()

        // Do any additional setup after loading the view.
        
        arrCustomers = CoreDataHelper.shared.fetchCustomerData()
    }
    
    //MARK:  ViewController Instance
    static func addToParentView(parentVC:SideMenuVC)->CustomerListVC?{
        guard let VC = UIStoryboard.init(name: "SideMenu", bundle: nil).instantiateViewController(withIdentifier: "CustomerListVC") as? CustomerListVC else {
            return nil
        }
        VC.parentVC = parentVC
        parentVC.addChild(VC)
        parentVC.viewForContainer.addSubview(VC.view)
        VC.view.frame = CGRect.init(x: 0, y: 0, width: parentVC.viewForContainer.frame.width, height: parentVC.viewForContainer.frame.height)
        return VC
    }
    
    //MARK: Button Action
    @IBAction func txtSearchAction(_ sender:UITextField){
        if self.txtSearchCustomer.text ?? "" == ""{
            isSearchEnabled = false
        }else{
            isSearchEnabled = true
            arrSearchCustomers = arrCustomers.filter({ (model) -> Bool in
                return (model.name ?? "").lowercased().contains(self.txtSearchCustomer.text ?? "") || (model.mobile ?? "").lowercased().contains(self.txtSearchCustomer.text ?? "")
            })
        }
        tblCustomers.reloadData()
    }
    
    @IBAction func btnEditCustomerAction(_ sender:UIButton){
        selectedCustomer = isSearchEnabled ? arrSearchCustomers[sender.tag] : arrCustomers[sender.tag]
        if let VC = NewOrderVC.showPopup(parentVC: self.parentVC, orderType: nil, viewType: .changeCustomer, customer: self.selectedCustomer){
            VC.delegate = self
        }
    }
    
    //MARK: Webservice Method
    func SaveCustomer(){
        CoreDataHelper.shared.saveAndUpdateCusomer(customer: self.selectedCustomer, offline: self.selectedCustomer.offline, updated: 1)
        if Reachabilities.shared.isConnectedToNetwork(){
            var dictParam = [String:Any]()
            var strURL = AppConstants.APIURL.kCustomer
            if selectedCustomer.offline == 0{
                strURL = "\(AppConstants.APIURL.kCustomer)\(selectedCustomer.id ?? 0)"
            }
            dictParam["name"] = selectedCustomer.name ?? ""
            dictParam["mobile"] = selectedCustomer.mobile ?? ""
            dictParam["email"] = selectedCustomer.email ?? ""
            dictParam["house_no"] = selectedCustomer.houseNo ?? ""
            dictParam["street"] = selectedCustomer.street ?? ""
            dictParam["city"] = selectedCustomer.city ?? ""
            dictParam["postcode"] = selectedCustomer.postcode ?? ""
            dictParam["distance"] = selectedCustomer.distance ?? 0
            dictParam["unique_id"] = selectedCustomer.uniqueId
            AppCommonMethods.startProgressBar()
            WebServiceManager().requestAPI(params: dictParam, urlString: strURL, method: "POST") { (message, result) in
                DispatchQueue.main.async {
                    AppCommonMethods.stopProgressBar()
                    if let response = result as? NSDictionary{
                        let jsonDecoder = JSONDecoder()
                        if let data = AppCommonMethods.convertToJson(object: response), let aData = try? jsonDecoder.decode(CustomerModel.self, from: data){
                            aData.offline = 0
                            CoreDataHelper.shared.saveAndUpdateCusomer(customer: aData, offline: 0, updated: 0, isFromUpload: true)
                            self.arrCustomers = CoreDataHelper.shared.fetchCustomerData()
                            self.tblCustomers.reloadData()
                            return
                        }
                    }
                }
            }
        }
    }
}

//MARK:  UITableViewDataSource
extension CustomerListVC:UITableViewDelegate,UITableViewDataSource{
    func tableView(_ tableView: UITableView, numberOfRowsInSection section: Int) -> Int {
        return isSearchEnabled ? arrSearchCustomers.count : arrCustomers.count
    }
    
    func tableView(_ tableView: UITableView, cellForRowAt indexPath: IndexPath) -> UITableViewCell {
        let cell = tableView.dequeueReusableCell(withIdentifier: "CustomerViewCell", for: indexPath) as! CustomerViewCell
        let model = isSearchEnabled ? arrSearchCustomers[indexPath.row] : arrCustomers[indexPath.row]
        cell.lblName.text = model.name ?? ""
        cell.lblPostcode.text = model.postcode ?? ""
        cell.lblMobileNo.text = model.mobile ?? ""
        cell.btnEdit.tag = indexPath.row
        return cell
    }
}

//MARK:  NewOrderDelegate
extension CustomerListVC:NewOrderDelegate{
    func orderTypeSelected(orderType: OrderTypesModel?) {
        
    }
    
    func requestForNewOrder(customer: CustomerModel, orderType: OrderTypesModel?, delivery: DeliveryChargeModel?, table: TableModel?, noOfGuest:Int?) {
        self.selectedCustomer = customer
        SaveCustomer()
    }
}
