//
//  SettingsSplitVC.swift
//  EPOS
//
//  Created by Apple on 29/05/21.
//

import UIKit

class SettingsMainVC: UIViewController {
    
    //MARK: IBOutlet
    @IBOutlet weak var tblSettingsItem:UITableView!
    @IBOutlet weak var viewForContainer:UIView!
    
    //MARK: Instances
    var arrSettingss:[SettingsCellData] = [.init("Restaurant Details", .kRestaurantDetails),.init("Restaurant Management", .kRestaurantManagement),.init("Profile", .kProfile),.init("Feedback", .kFeedback),.init("Contact TiffinTom", .kContactTiffinTom),.init("Data Management", .kDataManagement)]
    var selectedSettings:SettingsCellData!
    var parentVC:SideMenuVC!
    
    //MARK:  ViewController LifeCycle
    override func viewDidLoad() {
        super.viewDidLoad()
        
        // Do any additional setup after loading the view.
        
        setSettingsMenu()
        AddContainerView()
    }
    
    //MARK:  ViewController Instance
    static func addToParentView(parentVC:SideMenuVC)->SettingsMainVC?{
        guard let VC = UIStoryboard.init(name: "Settings", bundle: nil).instantiateViewController(withIdentifier: "SettingsMainVC") as? SettingsMainVC else {
            return nil
        }
        VC.parentVC = parentVC
        parentVC.addChild(VC)
        parentVC.viewForContainer.addSubview(VC.view)
        VC.view.frame = CGRect.init(x: 0, y: 0, width: parentVC.viewForContainer.frame.width, height: parentVC.viewForContainer.frame.height)
        return VC
    }
    
    @IBAction func btnBackAction(_ sender:UIButton){
        self.parentVC.AddContainerView(data: parentVC.arrSideMenu.first!)
    }
    
    //MARK: General Methods
    func setSettingsMenu(){
        if AppCommonMethods.fetchSiteSettingValue(key: "is_weborder") ?? "" == "true" && AppConstants.userData?.permissions?.weborder?.actions?.list ?? 0 == 1{
            arrSettingss = [.init("Restaurant Details", .kRestaurantDetails),.init("Restaurant Management", .kRestaurantManagement),.init("Profile", .kProfile),.init("Feedback", .kFeedback),.init("Contact TiffinTom", .kContactTiffinTom),.init("Data Management", .kDataManagement)]
        }else{
            arrSettingss = [.init("Data Management", .kDataManagement)]
        }
        arrSettingss.append(.init("Send db file", .kSendDBFile))
        selectedSettings = arrSettingss.first!
    }
    
    func AddContainerView(){
        for child in self.children{
            child.view.removeFromSuperview()
            child.removeFromParent()
        }
        switch selectedSettings.type {
        case .kDataManagement:
            if let _ = DataManagementVC.addToParentView(parentVC: self, settingsData: selectedSettings){
                
            }
        case .kRestaurantDetails:
            if let _ = RestaurantDetailsVC.restDetailInstance(parentVC: self){
                
            }
        case .kProfile:
            if let _ = RestaurantDetailsVC.profileDetailInstance(parentVC: self){
                
            }
        case .kBankAccountDetails:
            if let _ = RestaurantDetailsVC.bankDetailInstance(parentVC: self){
                
            }
        case .kFeedback:
            if let _ = FeedbackVC.instance(parentVC: self){
                
            }
        case .kRestaurantManagement:
            if let _ = DataManagementVC.addToParentView(parentVC: self, settingsData: selectedSettings){
                
            }
        default:
            break
        }
    }
    
    func sendDBFileToServer(){
        if let fileURL = SQLiteManage.getDBPath(),let fileData = try? Data(contentsOf: fileURL) {
            let dictParam = [String:Any]()
            let dictFileParam = NSMutableDictionary()
            dictFileParam["names"] = ["db_\(Int(Date().timeIntervalSinceReferenceDate)).sqlite"]
            dictFileParam["keys"] = ["log_file"]
            dictFileParam["files"] = [fileData]
            
            AppCommonMethods.startProgressBar()
            WebServiceManager().requestAPI(params: dictParam, fileParam: dictFileParam, urlString: AppConstants.APIURL.kOrderLogs, method: "POST") { (message, response) in
                DispatchQueue.main.async {
                    AppCommonMethods.stopProgressBar()
                    var settings = BottomAlertSettings()
                    if let result = response as? [String:Any], let _ = result["file_url"] as? String{
                        settings.strMessage = "File uploaded successfully."
                    }else{
                        settings.strMessage = "Failed to upload file."
                    }
                    AppValidation().showBottomAlertView(settings: settings)
                }
            }
        }
    }
}

//MARK: UITableViewDataSource
extension SettingsMainVC:UITableViewDataSource,UITableViewDelegate{
    func tableView(_ tableView: UITableView, numberOfRowsInSection section: Int) -> Int {
        return arrSettingss.count
    }
    
    func tableView(_ tableView: UITableView, cellForRowAt indexPath: IndexPath) -> UITableViewCell {
        let cell = tableView.dequeueReusableCell(withIdentifier: "PaymentDashboardCell", for: indexPath) as! PaymentDashboardCell
        let model = arrSettingss[indexPath.row]
        cell.lblTitle.text = model.title
        if model.type == selectedSettings.type{
            cell.imgArrow.imageColor = .white
            cell.lblTitle.textColor = .white
            cell.viewForBG.backgroundColor = AppConstants.Colors.kAppThemeAquaColor
        }else{
            cell.imgArrow.imageColor = AppConstants.Colors.kAppDarkGrayColor
            cell.lblTitle.textColor = AppConstants.Colors.kAppThemeTextColor
            cell.viewForBG.backgroundColor = .white
        }
        cell.imgArrow.isHidden = true
        return cell
    }
    
    func tableView(_ tableView: UITableView, didSelectRowAt indexPath: IndexPath) {
        if arrSettingss[indexPath.row].type == .kContactTiffinTom{
            if let _ = ContactTiffinTomVC.showPopup(parentVC:self.parentVC){
                
            }
            return
        }
        if arrSettingss[indexPath.row].type == .kSendDBFile{
            sendDBFileToServer()
            return
        }
        if selectedSettings.type != arrSettingss[indexPath.row].type{
            selectedSettings = arrSettingss[indexPath.row]
            AddContainerView()
            self.tblSettingsItem.reloadData()
        }
    }
}

extension SettingsMainVC:AlertControllerDelegate{
    func alertButtonAction(index: Int, data: alertViewData, type: AlertType) {
        if index == 1{
            AddContainerView()
            self.tblSettingsItem.reloadData()
        }
    }
}
