//
//  RestaurantDetailsVC.swift
//  TiffinTomPartner
//
//  Created by Tushar Premal on 20/11/20.
//

import UIKit

enum DetailViewType {
    case kRestDetail
    case kProfileDetail
    case kBankDetail
}

class RestaurantDetailsVC: UIViewController {

    //MARK: IBOutlet
    @IBOutlet weak var txtRestaurantName:UITextField!
    @IBOutlet weak var txtRestaurantNumber:UITextField!
    @IBOutlet weak var txtRestaurantEmailId:UITextField!
    @IBOutlet weak var txtRestaurantDesription:UITextView!
    @IBOutlet weak var txtBankName:UITextField!
    @IBOutlet weak var txtBankSortNo:UITextField!
    @IBOutlet weak var txtBankAccNo:UITextField!
    @IBOutlet weak var txtBankAccType:UITextField!
    @IBOutlet weak var txtAccName:UITextField!
    @IBOutlet weak var txtContactName:UITextField!
    @IBOutlet weak var txtContactNo:UITextField!
    @IBOutlet weak var txtContactEmail:UITextField!
    
    //MARK: Instances
    var viewType = DetailViewType.kRestDetail
    
    //MARK: ViewController LifeCycle
    override func viewDidLoad() {
        super.viewDidLoad()

        // Do any additional setup after loading the view.
        
        if viewType == .kRestDetail{
            txtRestaurantName.text = AppConstants.restaurantData?.storename ?? ""
            txtRestaurantNumber.text = AppConstants.restaurantData?.storePhone ?? ""
            txtRestaurantEmailId.text = AppConstants.restaurantData?.username ?? ""
            txtRestaurantDesription.text = String((AppConstants.restaurantData?.restaurantDescription ?? "").suffix(300))
        }else if viewType == .kProfileDetail{
            txtContactNo.text = AppConstants.restaurantData?.phone ?? ""
            txtContactName.text = AppConstants.restaurantData?.contactName ?? ""
            txtContactEmail.text = AppConstants.restaurantData?.email ?? ""
        }else if viewType == .kBankDetail{
            txtBankName.text = AppConstants.restaurantData?.bankDetail?.bankName ?? ""
            txtAccName.text = AppConstants.restaurantData?.bankDetail?.accountName ?? ""
            txtBankAccNo.text = AppConstants.restaurantData?.bankDetail?.accountNumber ?? ""
            txtBankSortNo.text = AppConstants.restaurantData?.bankDetail?.sortCode ?? ""
            txtBankAccType.text = AppConstants.restaurantData?.bankDetail?.accountType ?? ""
        }
    }
    
    //MARK: Create Viewcontrlloer instance
    static func restDetailInstance(parentVC:SettingsMainVC)->RestaurantDetailsVC?{
        guard let VC = UIStoryboard.init(name: "Settings", bundle: nil).instantiateViewController(withIdentifier: "RestaurantDetailsVC") as? RestaurantDetailsVC else {
            return nil
        }
        VC.viewType = .kRestDetail
        parentVC.addChild(VC)
        parentVC.viewForContainer.addSubview(VC.view)
        VC.view.frame = CGRect.init(x: 0, y: 0, width: parentVC.viewForContainer.frame.width, height: parentVC.viewForContainer.frame.height)
        return VC
    }
    
    static func bankDetailInstance(parentVC:SettingsMainVC)->RestaurantDetailsVC?{
        guard let VC = UIStoryboard.init(name: "Settings", bundle: nil).instantiateViewController(withIdentifier: "BankDetailsVC") as? RestaurantDetailsVC else {
            return nil
        }
        VC.viewType = .kBankDetail
        parentVC.addChild(VC)
        parentVC.viewForContainer.addSubview(VC.view)
        VC.view.frame = CGRect.init(x: 0, y: 0, width: parentVC.viewForContainer.frame.width, height: parentVC.viewForContainer.frame.height)
        return VC
    }
    
    static func profileDetailInstance(parentVC:SettingsMainVC)->RestaurantDetailsVC?{
        guard let VC = UIStoryboard.init(name: "Settings", bundle: nil).instantiateViewController(withIdentifier: "ProfileDetailsVC") as? RestaurantDetailsVC else {
            return nil
        }
        VC.viewType = .kProfileDetail
        parentVC.addChild(VC)
        parentVC.viewForContainer.addSubview(VC.view)
        VC.view.frame = CGRect.init(x: 0, y: 0, width: parentVC.viewForContainer.frame.width, height: parentVC.viewForContainer.frame.height)
        return VC
    }
    
    //MARK: Button Actions
    @IBAction func btnEditDescriptionAction(_ sender:UIButton){
        if let VC = EditRestaurantVC.show(){
            self.present(VC, animated: true, completion: nil)
            if let controller = VC.childViewController as? EditRestaurantVC{
                controller.delegate = self
            }
        }
    }
}

//MARK: EditRestaurantDelegate
extension RestaurantDetailsVC:EditRestaurantDelegate{
    func restaurantUpdated() {
        txtRestaurantDesription.text = AppConstants.restaurantData?.restaurantDescription ?? ""
    }
}
