//
//  PreOrderVC.swift
//  TiffinTomPartner
//
//  Created by Tushar Premal on 07/12/20.
//

import UIKit
import ActionSheetPicker_3_0

class PreOrderVC: UIViewController {

    //MARK: IBOutlet
    @IBOutlet weak var tblPreOrder:UITableView!
    
    //MARK: Instances
    var arrPreOrder:[PreOrderCellData] = [.init(weekDay: "Monday", preOrderTime: 1, isTakingPreOrder: false),.init(weekDay: "Tuesday", preOrderTime: 1, isTakingPreOrder: false),.init(weekDay: "Wednesday", preOrderTime: 1, isTakingPreOrder: false),.init(weekDay: "Thursday", preOrderTime: 1, isTakingPreOrder: false),.init(weekDay: "Friday", preOrderTime: 1, isTakingPreOrder: false),.init(weekDay: "Saturday", preOrderTime: 1, isTakingPreOrder: false),.init(weekDay: "Sunday", preOrderTime: 1, isTakingPreOrder: false)]
    
    //MARK: ViewController LifeCycle
    override func viewDidLoad() {
        super.viewDidLoad()

        // Do any additional setup after loading the view.
    }
    
    //MARK: Create Viewcontrlloer instance
    static func instance(parentVC:SettingsMainVC)->PreOrderVC?{
        guard let VC = UIStoryboard.init(name: "Settings", bundle: nil).instantiateViewController(withIdentifier: "PreOrderVC") as? PreOrderVC else {
            return nil
        }
        parentVC.addChild(VC)
        parentVC.viewForContainer.addSubview(VC.view)
        VC.view.frame = CGRect.init(x: 0, y: 0, width: parentVC.viewForContainer.frame.width, height: parentVC.viewForContainer.frame.height)
        return VC
    }
    
    //MARK: Button Actions
    @IBAction func switchPreOrderChanged(_ sender:UISwitch){
        self.arrPreOrder[sender.tag].isTakingPreOrder = sender.isOn
        self.tblPreOrder.reloadData()
    }
    
    @IBAction func btnUpdateAction(_ sender:UIButton){
        
    }
    
    @IBAction func btnBackAction(_ sender:UIButton){
        self.view.removeFromSuperview()
        self.removeFromParent()
    }
    
    @IBAction func btnPreOrderTimeAction(_ sender:UIButton){
        let stringPicker = ActionSheetStringPicker.init(title: "Select pre-order time", rows: ["1 hour before opening","2 hour before opening","3 hour before opening","4 hour before opening","5 hour before opening", "6 hour before opening" ,"7 hour before opening"], initialSelection: 0, doneBlock: { (pickerView, index, value) in
            self.arrPreOrder[sender.tag].preOrderTime = index+1
            self.tblPreOrder.reloadData()
        }, cancel: { (picker) in
        
        }, origin: sender)
        
        stringPicker?.show()
    }
}

//MARK: UITableViewDataSource
extension PreOrderVC:UITableViewDataSource,UITableViewDelegate{
    func tableView(_ tableView: UITableView, numberOfRowsInSection section: Int) -> Int {
        return arrPreOrder.count
    }
    
    func tableView(_ tableView: UITableView, cellForRowAt indexPath: IndexPath) -> UITableViewCell {
        let cell = tableView.dequeueReusableCell(withIdentifier: "PreOrderViewCell", for: indexPath) as! PreOrderViewCell
        let data = arrPreOrder[indexPath.row]
        if !data.isTakingPreOrder{
            cell.lblPreOrderTime.text = "Not taking pre-orders"
            cell.switchPreOrder.isOn = false
            cell.lblTakingPreOrder.text = "Not taking pre-orders"
            cell.lblTakingPreOrder.textColor = AppConstants.Colors.kAppThemeRedColor
            cell.btnPreOrder.isHidden = true
            cell.imgDownArrow.isHidden = true
        }else{
            cell.lblPreOrderTime.text = "\(data.preOrderTime) hours before opening"
            cell.switchPreOrder.isOn = true
            cell.lblTakingPreOrder.text = "Taking pre-orders"
            cell.lblTakingPreOrder.textColor = AppConstants.Colors.kAppThemeAquaColor
            cell.btnPreOrder.isHidden = false
            cell.imgDownArrow.isHidden = false
        }
        cell.switchPreOrder.tag = indexPath.row
        cell.btnPreOrder.tag = indexPath.row
        cell.lblWeekDay.text = data.weekDay
        return cell
    }
}
