//
//  FeedbackVC.swift
//  TiffinTom
//
//  Created by Tushar Premal on 17/07/20.
//  Copyright © 2020 8Dots. All rights reserved.
//

import UIKit
import ActionSheetPicker_3_0

class FeedbackVC: UIViewController {

    //MARK: IBOutlet
    @IBOutlet weak var txtSubject:UITextField!
    @IBOutlet weak var txtSubjectOther:UITextField!
    @IBOutlet weak var txtFeedback:UITextView!
    @IBOutlet weak var lblFeedbackCount:UILabel!
    @IBOutlet weak var lblPlaceHolder:UILabel!
    
    //MARK: ViewController LifeCycle
    override func viewDidLoad() {
        super.viewDidLoad()

        // Do any additional setup after loading the view.
    }

    //MARK: create viewcontroller instance
    static func instance(parentVC:SettingsMainVC)->FeedbackVC?{
        guard let VC = UIStoryboard.init(name: "Settings", bundle: nil).instantiateViewController(withIdentifier: "FeedbackVC") as? FeedbackVC else {
            return nil
        }
        parentVC.addChild(VC)
        parentVC.viewForContainer.addSubview(VC.view)
        VC.view.frame = CGRect.init(x: 0, y: 0, width: parentVC.viewForContainer.frame.width, height: parentVC.viewForContainer.frame.height)
        return VC
    }
    
    //MARK: validation methods
    func checkValidation()->Bool{
        if (txtSubject.text?.trimmingCharacters(in: .whitespaces).isEmpty)!{
            AppValidation().showAlertView(parentVC: self, withAlertTile: AppConstants.GlobalAlert.ALERT_TITLE, withAlertMsg: AppConstants.GlobalAlert.ALERT_EMPTY_SUBJECT, withActionsTitle: [AppConstants.GlobalAlert.ALERT_BTN_OK]) { (index) in
                
            }
            return false
        }else if (txtFeedback.text?.trimmingCharacters(in: .whitespaces).isEmpty)!{
            AppValidation().showAlertView(parentVC: self, withAlertTile: AppConstants.GlobalAlert.ALERT_TITLE, withAlertMsg: AppConstants.GlobalAlert.ALERT_EMPTY_FEEDBACK, withActionsTitle: [AppConstants.GlobalAlert.ALERT_BTN_OK]) { (index) in
                
            }
            return false
        }
        if !txtSubjectOther.superview!.isHidden{
            if (txtSubjectOther.text?.trimmingCharacters(in: .whitespaces).isEmpty)!{
                AppValidation().showAlertView(parentVC: self, withAlertTile: AppConstants.GlobalAlert.ALERT_TITLE, withAlertMsg: AppConstants.GlobalAlert.ALERT_EMPTY_SUBJECT, withActionsTitle: [AppConstants.GlobalAlert.ALERT_BTN_OK]) { (index) in
                    
                }
                return false
            }
        }
        return true
    }
    
    //MARK: Button Actions
    @IBAction func btnSendAction(_ sender:UIButton){
        self.view.endEditing(true)
        if checkValidation(){
            CallSubmitFeedbackAPI()
        }
    }
    
    func CallSubmitFeedbackAPI(){
        var dictParam = [String:String]()
        dictParam["subject"] = txtSubjectOther.superview!.isHidden ? (txtSubject.text ?? "") : (txtSubjectOther.text ?? "")
        dictParam["message"] = txtFeedback.text ?? ""
        dictParam["customer_id"] = AppConstants.webResId ?? ""
        
        AppCommonMethods.startProgressBar()
        WebServiceManager().requestAPI(params: dictParam, urlString: AppConstants.APIURL.kAppFeedback, method: "POST") { (message, response) in
            DispatchQueue.main.async {
                AppCommonMethods.stopProgressBar()
                if let result = response as? NSDictionary, let _ = result.getIntValue("id"){
                    var settings = BottomAlertSettings()
                    settings.strMessage = AppConstants.GlobalAlert.ALERT_SUCCESS_FEEDBACK
                    AppValidation().showBottomAlertView(settings: settings)
                    self.txtSubject.text = ""
                    self.txtFeedback.text = ""
                    self.txtSubjectOther.text = ""
                    self.txtSubjectOther.superview?.isHidden = false
                    self.lblFeedbackCount.text = "0/300"
                }else{
                    AppValidation().showAlertView(parentVC: self, withAlertTile: AppConstants.GlobalAlert.ALERT_TITLE, withAlertMsg: message, withActionsTitle: [AppConstants.GlobalAlert.ALERT_BTN_OK]) { (index) in
                        
                    }
                }
            }
        }
    }
}

//MARK: UITextViewDelegate
extension FeedbackVC:UITextViewDelegate{
    func textViewDidChange(_ textView: UITextView) {
        lblFeedbackCount.text = "\(textView.text!.count)/300"
        if textView.text! == ""{
            lblPlaceHolder.isHidden = false
        }else{
            lblPlaceHolder.isHidden = true
        }
    }
    
    func textView(_ textView: UITextView, shouldChangeTextIn range: NSRange, replacementText text: String) -> Bool {
        if text == ""{
            return true
        }
        if textView.text.count >= 300{
            return false
        }
        return true
    }
}


//MARK: UITextFieldDelegate
extension FeedbackVC:UITextFieldDelegate{
    func textFieldShouldBeginEditing(_ textField: UITextField) -> Bool {
        if textField == txtSubject{
            self.view.endEditing(true)
            let stringPicker = ActionSheetStringPicker.init(title: "Select Subject", rows: ["App crashed","App not working","App location data inaccurate","App is very slow","Payment on app not working", "Any suggestions?" ,"Other"], initialSelection: 0, doneBlock: { (pickerView, index, value) in
                if (value as! String) == "Other"{
                    self.txtSubjectOther.superview?.isHidden = false
                    self.txtSubjectOther.text = ""
                }else{
                    self.txtSubjectOther.superview?.isHidden = true
                }
                self.txtSubject.text = value as? String
                
            }, cancel: { (picker) in
            
            }, origin: self.txtSubject)
            
            stringPicker?.show()
            return false
        }
        return true
    }
    
    func textFieldShouldReturn(_ textField: UITextField) -> Bool {
        return textField.resignFirstResponder()
    }
    
}
