//
//  AutoDiscountVC.swift
//  TiffinTomPartner
//
//  Created by Tushar Premal on 07/12/20.
//

import UIKit
import ActionSheetPicker_3_0

class AutoDiscountVC: UIViewController {

    //MARK: IBOutlet
    @IBOutlet weak var tblAutoDiscount:UITableView!
    @IBOutlet weak var lblViewTitle:UILabel!
    
    //MARK: Instances
    var selectedRowIndex = 0
    var viewType = SettingManagementType.kAutoDiscount
    var arrOffers = [OfferModel]()
    var arrVouchers = [RestaurantVoucherModel]()
    var arrRemovedOffers = [OfferModel]()
    var arrRemovedVouchers = [RestaurantVoucherModel]()
    var parentVC:SettingsMainVC!
    
    //MARK: ViewController LifeCycle
    override func viewDidLoad() {
        super.viewDidLoad()

        // Do any additional setup after loading the view.
        if viewType == .kAutoDiscount{
            lblViewTitle.text = "Auto discounts"
        }else if viewType == .kDiscountCode{
            lblViewTitle.text = "Discount codes"
        }
        CallGetOfferListAPI()
    }
    
    //MARK: Create Viewcontrlloer instance
    static func instance(parentVC:SettingsMainVC,viewType:SettingManagementType)->AutoDiscountVC?{
        guard let VC = UIStoryboard.init(name: "Settings", bundle: nil).instantiateViewController(withIdentifier: "AutoDiscountVC") as? AutoDiscountVC else {
            return nil
        }
        VC.parentVC = parentVC
        VC.viewType = viewType
        parentVC.addChild(VC)
        parentVC.viewForContainer.addSubview(VC.view)
        VC.view.frame = CGRect.init(x: 0, y: 0, width: parentVC.viewForContainer.frame.width, height: parentVC.viewForContainer.frame.height)
        return VC
    }
    
    //MARK: General Methods
    func checkOfferValidation()->Bool{
        for model in arrOffers{
            if model.normalPercentage ?? 0 == 0{
                AppValidation().showAlertView(parentVC: self, withAlertTile: AppConstants.GlobalAlert.ALERT_TITLE, withAlertMsg: AppConstants.GlobalAlert.offerAmountNotZero, withActionsTitle: [AppConstants.GlobalAlert.ALERT_BTN_OK]) { (index) in
                    
                }
                return false
            }
            if model.normalPrice ?? 0 == 0{
                AppValidation().showAlertView(parentVC: self, withAlertTile: AppConstants.GlobalAlert.ALERT_TITLE, withAlertMsg: AppConstants.GlobalAlert.spentAmountNotZero, withActionsTitle: [AppConstants.GlobalAlert.ALERT_BTN_OK]) { (index) in
                    
                }
                return false
            }
            if model.deliveryType ?? 0 == 0 && model.pickupType ?? 0 == 0 && model.dineinType ?? 0 == 0{
                AppValidation().showAlertView(parentVC: self, withAlertTile: AppConstants.GlobalAlert.ALERT_TITLE, withAlertMsg: AppConstants.GlobalAlert.ALERT_OFFER_TYPE, withActionsTitle: [AppConstants.GlobalAlert.ALERT_BTN_OK]) { (index) in
                    
                }
                return false
            }
        }
        return true
    }
    
    //MARK: Button Action
    @IBAction func btnBackAction(_ sender:UIButton){
        self.view.removeFromSuperview()
        self.removeFromParent()
    }
    
    @IBAction func btnDateAction(_ sender:UIButton){
        var date = Date()
        if sender.accessibilityIdentifier == "0"{
            date = (arrOffers[sender.tag].offerFrom ?? "").getDateFromString(format: "yyyy-MM-dd") ?? Date()
        }else{
            date = (arrOffers[sender.tag].offerTo ?? "").getDateFromString(format: "yyyy-MM-dd") ?? Date()
        }
        let datePicker = ActionSheetDatePicker(title: "Select date", datePickerMode: UIDatePicker.Mode.date, selectedDate: date, doneBlock: {
            picker, value, index in
            if sender.accessibilityIdentifier == "0"{
                self.arrOffers[sender.tag].offerFrom = (value as! Date).getDateInString(format: "yyyy-MM-dd")
            }else{
                self.arrOffers[sender.tag].offerTo = (value as! Date).getDateInString(format: "yyyy-MM-dd")
            }
            self.tblAutoDiscount.reloadData()
        }, cancel: { ActionStringCancelBlock in return }, origin: sender)
        if sender.accessibilityIdentifier == "0"{
            datePicker?.maximumDate = ((arrOffers[sender.tag].offerTo ?? "").getDateFromString(format: "yyyy-MM-dd") ?? Date()).addingTimeInterval(-24*60*60)
            datePicker?.minimumDate = Date()
        }else{
            datePicker?.minimumDate = ((arrOffers[sender.tag].offerFrom ?? "").getDateFromString(format: "yyyy-MM-dd") ?? Date()).addingTimeInterval(24*60*60)
        }
        datePicker?.show()
    }
    
    @IBAction func btnOfferTypeAction(_ sender:UIButton){
        if sender.accessibilityIdentifier ?? "" == "0"{
            arrOffers[sender.tag].deliveryType = (arrOffers[sender.tag].deliveryType ?? 0 == 0) ? 1 : 0
        }else if sender.accessibilityIdentifier ?? "" == "1"{
            arrOffers[sender.tag].pickupType = (arrOffers[sender.tag].pickupType ?? 0 == 0) ? 1 : 0
        }else{
            arrOffers[sender.tag].dineinType = (arrOffers[sender.tag].dineinType ?? 0 == 0) ? 1 : 0
        }
        tblAutoDiscount.reloadData()
    }
    
    @IBAction func btnUpdateAction(_ sender:UIButton){
        if viewType == .kAutoDiscount{
            if checkOfferValidation(){
                CallSaveOffersAPI()
            }
        }else{
            CallSaveOffersAPI()
        }
    }
    
    @IBAction func btnRemoveOfferAction(_ sender:UIButton){
        if viewType == .kAutoDiscount{
            let offer = arrOffers[sender.tag]
            if offer.status != nil{
                offer.status = 0
                arrRemovedOffers.append(offer)
            }
            arrOffers.remove(at: sender.tag)
        }else{
            let offer = arrVouchers[sender.tag]
            if offer.status != nil{
                offer.status = 0
                arrRemovedVouchers.append(offer)
            }
            arrVouchers.remove(at: sender.tag)
        }
        tblAutoDiscount.reloadData()
    }
    
    @IBAction func btnEditVoucherAction(_ sender:UIButton){
        selectedRowIndex = sender.tag
        if let VC = AddDiscountCodeVC.show(voucher: arrVouchers[sender.tag]){
            if let controller = VC.childViewController as? AddDiscountCodeVC{
                controller.delegate = self
            }
            self.present(VC, animated: true, completion: nil)
        }
    }
    
    @IBAction func btnAddAnotherAction(_ sender:UIButton){
        if viewType == .kDiscountCode{
            selectedRowIndex = arrVouchers.count
            let voucher = RestaurantVoucherModel()
            voucher.deliveryType = 0
            voucher.pickupType = 0
            voucher.dineinType = 0
            voucher.day = "all"
            voucher.voucherFrom = Date().getDateInString(format: "dd-MM-yyyy")
            voucher.voucherTo = Date().addingTimeInterval(24*60*60).getDateInString(format: "dd-MM-yyyy")
            voucher.offerMode = "price"
            voucher.deviceType = "web"
            voucher.resId = Int(AppConstants.webResId ?? "") ?? 0
            voucher.typeOffer = "single"
            if let VC = AddDiscountCodeVC.show(voucher: voucher){
                if let controller = VC.childViewController as? AddDiscountCodeVC{
                    controller.delegate = self
                }
                self.present(VC, animated: true, completion: nil)
            }
        }else{
            let offer = OfferModel()
            offer.normal = "Y"
            offer.normalPrice = 0
            offer.normalPercentage = 0
            offer.freePrice = 0
            offer.freePercentage = 0
            offer.deliveryType = 0
            offer.pickupType = 0
            offer.resid = Int(AppConstants.webResId ?? "") ?? 0
            offer.dineinType = 0
            offer.offerMode = "percentage"
            offer.offerFrom = Date().getDateInString(format: "yyyy-MM-dd")
            offer.offerTo = Date().addingTimeInterval(24*60*60).getDateInString(format: "yyyy-MM-dd")
            arrOffers.append(offer)
            tblAutoDiscount.reloadData()
        }
    }
    
    @IBAction func btnOfferAmountAction(_ sender:UIButton){
        var settings = AlertSetting()
        settings.alertTitle = AppConstants.GlobalAlert.ALERT_SELECT_PERCENTAGE_TITLE
        settings.type = .kEnterPercentage
        let discountData = arrOffers[sender.tag]
        settings.textTitle = String.init(format: "%.2f",discountData.normalPercentage ?? 0)
        settings.textPlcaeholder = "percentage"
        settings.titleColor = AppConstants.Colors.kAppLightGrayColor
        selectedRowIndex = sender.tag
        if let VC = AlertViewController.showPopup(parentVC: self.parentVC.parentVC, setting: settings){
            VC.delegate = self
        }
    }
    
    @IBAction func btnSpentAmountAction(_ sender:UIButton){
        var settings = AlertSetting()
        settings.alertTitle = AppConstants.GlobalAlert.ALERT_SELECT_AMOUNT_TITLE
        settings.textPlcaeholder = "amount"
        settings.type = .kEnterAmount
        let discountData = arrOffers[sender.tag]
        settings.textTitle = String.init(format: "%@%.2f", AppConstants.currencySign,discountData.normalPrice ?? 0)
        settings.titleColor = AppConstants.Colors.kAppLightGrayColor
        selectedRowIndex = sender.tag
        if let VC = AlertViewController.showPopup(parentVC: self.parentVC.parentVC, setting: settings){
            VC.delegate = self
        }
    }
    
    //MARK: WebService Methods
    func CallSaveOffersAPI(){
        var dictParam = [String:Any]()
        var strURL = ""
        if viewType == .kAutoDiscount{
            strURL = "\(AppConstants.APIURL.kRestaurantOffer)bulk"
            var arrO = arrOffers
            arrO.append(contentsOf: arrRemovedOffers)
            if let json = AppCommonMethods.getjsonDataFromCodable(object: arrO,isWithoutSlash: true), let string = String(data: json, encoding: String.Encoding.utf8){
                dictParam["offers"] = string
            }
        }else{
            strURL = "\(AppConstants.APIURL.kRestaurantVoucher)bulk"
            var arrV = arrVouchers
            arrV.append(contentsOf: arrRemovedVouchers)
            if let json = AppCommonMethods.getjsonDataFromCodable(object: arrV,isWithoutSlash: true), let string = String(data: json, encoding: String.Encoding.utf8){
                dictParam["restaurant_vouchers"] = string
            }
        }
        AppCommonMethods.startProgressBar()
        WebServiceManager().requestAPI(params: dictParam, urlString: strURL, method: "POST", isRestaurantAPI:true) { (message, response) in
            DispatchQueue.main.async {
                AppCommonMethods.stopProgressBar()
                if let result = response as? [NSDictionary]{
                    let jsonDecoder = JSONDecoder()
                    if self.viewType == .kAutoDiscount{
                        if let data = AppCommonMethods.convertToJson(object: result), let aData = try? jsonDecoder.decode([OfferModel].self, from: data){
                            self.arrOffers = aData.filter({ (model) -> Bool in
                                return (model.normal ?? "").lowercased() == "y"
                            })
                            self.tblAutoDiscount.reloadData()
                            var settings = BottomAlertSettings()
                            settings.strMessage = "Auto dicsounts updated"
                            AppValidation().showBottomAlertView(settings: settings)
                        }
                    }else{
                        if let data = AppCommonMethods.convertToJson(object: result), let aData = try? jsonDecoder.decode([RestaurantVoucherModel].self, from: data){
                            self.arrVouchers = aData
                            self.tblAutoDiscount.reloadData()
                            var settings = BottomAlertSettings()
                            settings.strMessage = "Dicsount codes updated"
                            AppValidation().showBottomAlertView(settings: settings)
                        }
                    }
                }else{
                    AppValidation().showAlertView(parentVC: self, withAlertTile: AppConstants.GlobalAlert.ALERT_TITLE, withAlertMsg: message, withActionsTitle: [AppConstants.GlobalAlert.ALERT_BTN_OK]) { (index) in
                        
                    }
                }
            }
        }
    }
    
    func CallGetOfferListAPI(){
        var dictParam = [String:Any]()
        dictParam["nopaginate"] = "1"
        dictParam["restaurant_id"] = AppConstants.webResId
        AppCommonMethods.startProgressBar()
        WebServiceManager().requestAPI(params: dictParam, urlString: (viewType == .kAutoDiscount) ? AppConstants.APIURL.kRestaurantOffer : AppConstants.APIURL.kRestaurantVoucher, method: "GET", isRestaurantAPI:true) { (message, response) in
            DispatchQueue.main.async {
                AppCommonMethods.stopProgressBar()
                if let result = response as? [NSDictionary]{
                    let jsonDecoder = JSONDecoder()
                    if self.viewType == .kAutoDiscount{
                        if let data = AppCommonMethods.convertToJson(object: result), let aData = try? jsonDecoder.decode([OfferModel].self, from: data){
                            self.arrOffers = aData.filter({ (model) -> Bool in
                                return (model.normal ?? "").lowercased() == "y" && (model.offerMode ?? "").lowercased() == "percentage"
                            })
                            self.tblAutoDiscount.reloadData()
                        }
                    }else{
                        if let data = AppCommonMethods.convertToJson(object: result), let aData = try? jsonDecoder.decode([RestaurantVoucherModel].self, from: data){
                            self.arrVouchers = aData
                            self.tblAutoDiscount.reloadData()
                        }
                    }
                }else{
                    AppValidation().showAlertView(parentVC: self, withAlertTile: AppConstants.GlobalAlert.ALERT_TITLE, withAlertMsg: message, withActionsTitle: [AppConstants.GlobalAlert.ALERT_BTN_OK]) { (index) in
                        
                    }
                }
            }
        }
    }
    
}

//MARK: UITableViewDataSource
extension AutoDiscountVC:UITableViewDataSource,UITableViewDelegate{
    func tableView(_ tableView: UITableView, numberOfRowsInSection section: Int) -> Int {
        return (viewType == .kAutoDiscount) ? arrOffers.count : arrVouchers.count
    }
    
    func tableView(_ tableView: UITableView, cellForRowAt indexPath: IndexPath) -> UITableViewCell {
        if viewType == .kAutoDiscount{
            let cell = tableView.dequeueReusableCell(withIdentifier: "AutoDiscountCell", for: indexPath) as! AutoDiscountCell
            let discountData = arrOffers[indexPath.row]
            cell.lblOfferAmount.text = String.init(format: "%.1f%@",discountData.normalPercentage ?? 0,"%")
            cell.lblFromDate.text = "From - " + ((discountData.offerFrom ?? "").changeDateFormat(fromFormat: "yyyy-MM-dd", toFormat: "dd/MM/yyyy") ?? "")
            cell.lbltoDate.text = "To - " + ((discountData.offerTo ?? "").changeDateFormat(fromFormat: "yyyy-MM-dd", toFormat: "dd/MM/yyyy") ?? "")
            cell.btnFromDate.tag = indexPath.row
            cell.btnToDate.tag = indexPath.row
            cell.btnDelivery.tag = indexPath.row
            cell.btnCollection.tag = indexPath.row
            cell.btnDineIn.tag = indexPath.row
            cell.btnRemove.tag = indexPath.row
            cell.btnOffer.tag = indexPath.row
            
            cell.btnFromDate.accessibilityIdentifier = "0"
            cell.btnToDate.accessibilityIdentifier = "1"
            cell.btnDelivery.accessibilityIdentifier = "0"
            cell.btnCollection.accessibilityIdentifier = "1"
            cell.btnDineIn.accessibilityIdentifier = "2"
            
            if discountData.deliveryType ?? 0 == 1{
                cell.btnDelivery.backgroundColor = AppConstants.Colors.kAppThemeAquaColor
                cell.btnDelivery.setTitleColor(.white, for: .normal)
            }else{
                cell.btnDelivery.backgroundColor = AppConstants.Colors.kAppThemeBGColor
                cell.btnDelivery.setTitleColor(AppConstants.Colors.kAppThemeTextColor, for: .normal)
            }
            if discountData.pickupType ?? 0 == 1{
                cell.btnCollection.backgroundColor = AppConstants.Colors.kAppThemeAquaColor
                cell.btnCollection.setTitleColor(.white, for: .normal)
            }else{
                cell.btnCollection.backgroundColor = AppConstants.Colors.kAppThemeBGColor
                cell.btnCollection.setTitleColor(AppConstants.Colors.kAppThemeTextColor, for: .normal)
            }
            if discountData.dineinType ?? 0 == 1{
                cell.btnDineIn.backgroundColor = AppConstants.Colors.kAppThemeAquaColor
                cell.btnDineIn.setTitleColor(.white, for: .normal)
            }else{
                cell.btnDineIn.backgroundColor = AppConstants.Colors.kAppThemeBGColor
                cell.btnDineIn.setTitleColor(AppConstants.Colors.kAppThemeTextColor, for: .normal)
            }
            cell.lblOfferTitle.text = "Offer \(indexPath.row+1)"
            cell.btnSpent.tag = indexPath.row
            cell.lblSpentAmount.text = String.init(format: "%@%.2f", AppConstants.currencySign,discountData.normalPrice ?? 0)
            return cell
        }else{
            let cell = tableView.dequeueReusableCell(withIdentifier: "CodeDiscountCell", for: indexPath) as! AutoDiscountCell
            cell.btnRemove.tag = indexPath.row
            cell.btnEditCode.tag = indexPath.row
            let discountData = arrVouchers[indexPath.row]
            if discountData.deliveryType ?? 0 == 1{
                cell.btnDelivery.backgroundColor = AppConstants.Colors.kAppThemeAquaColor
                cell.btnDelivery.setTitleColor(.white, for: .normal)
            }else{
                cell.btnDelivery.backgroundColor = AppConstants.Colors.kAppThemeBGColor
                cell.btnDelivery.setTitleColor(AppConstants.Colors.kAppThemeTextColor, for: .normal)
            }
            if discountData.pickupType ?? 0 == 1{
                cell.btnCollection.backgroundColor = AppConstants.Colors.kAppThemeAquaColor
                cell.btnCollection.setTitleColor(.white, for: .normal)
            }else{
                cell.btnCollection.backgroundColor = AppConstants.Colors.kAppThemeBGColor
                cell.btnCollection.setTitleColor(AppConstants.Colors.kAppThemeTextColor, for: .normal)
            }
            if discountData.dineinType ?? 0 == 1{
                cell.btnDineIn.backgroundColor = AppConstants.Colors.kAppThemeAquaColor
                cell.btnDineIn.setTitleColor(.white, for: .normal)
            }else{
                cell.btnDineIn.backgroundColor = AppConstants.Colors.kAppThemeBGColor
                cell.btnDineIn.setTitleColor(AppConstants.Colors.kAppThemeTextColor, for: .normal)
            }
            cell.lblOfferTitle.text = "Offer \(indexPath.row+1)"
            if discountData.offerMode ?? "" == "free_delivery"{
                cell.lblOfferAmount.text = "Free Delivery"
            }else if discountData.offerMode ?? "" == "price"{
                cell.lblOfferAmount.text = String.init(format: "%@%.2f", AppConstants.currencySign,discountData.offerValue ?? 0)
            }else{
                cell.lblOfferAmount.text = String.init(format: "%.1f%@",discountData.offerValue ?? 0,"%")
            }
            cell.lblVoucherCode.text = "Code: \(discountData.voucherCode ?? "")"
            cell.lblFromDate.text = "From - " + ((discountData.voucherFrom ?? "").changeDateFormat(fromFormat: "dd-MM-yyyy", toFormat: "dd/MM/yyyy") ?? "")
            cell.lbltoDate.text = "To - " + ((discountData.voucherTo ?? "").changeDateFormat(fromFormat: "dd-MM-yyyy", toFormat: "dd/MM/yyyy") ?? "")
            return cell
        }
    }
}

//MARK: AlertControllerDelegate
extension AutoDiscountVC:AlertControllerDelegate{
    func alertButtonAction(index: Int, data: alertViewData, type: AlertType) {
        if index == 1{
            if type == .kEnterAmount{
                arrOffers[selectedRowIndex].normalPrice = Double(data.value) ?? 0
            }else{
                arrOffers[selectedRowIndex].normalPercentage = Double(data.value) ?? 0
            }
            tblAutoDiscount.reloadData()
        }
    }
}

//MARK: AddDiscountCodeDelegate
extension AutoDiscountVC:AddDiscountCodeDelegate{
    func discountCodeAdded(voucher: RestaurantVoucherModel) {
        if selectedRowIndex < arrVouchers.count{
            arrVouchers[selectedRowIndex] = voucher
        }else{
            arrVouchers.append(voucher)
        }
        self.tblAutoDiscount.reloadData()
    }
}
