//
//  SendOrderPopup.swift
//  EPOS
//
//  Created by Apple on 16/04/21.
//

import UIKit

class SendOrderPopup: UIViewController {

    //MARK:  IBOutlets
    @IBOutlet weak var btnSendFullOrder:UIButton!
    @IBOutlet weak var btnPrintBill:UIButton!
    @IBOutlet weak var btnSendOrderUpdate:UIButton!
    @IBOutlet weak var btnSendDuplicateOrderUpdate:UIButton!
    @IBOutlet weak var btnSendDuplicateFullOrder:UIButton!
    @IBOutlet weak var btnPrintOrder:UIButton!
    
    //MARK:  Instances
    weak var delegate:SendOrderDelegate?
    var isSendOrder = false
    
    //MARK:  ViewController LifeCycle
    override func viewDidLoad() {
        super.viewDidLoad()

        // Do any additional setup after loading the view.
        btnSendOrderUpdate.isHidden = true
        btnSendFullOrder.isHidden = true
        btnSendDuplicateFullOrder.isHidden = true
        btnSendDuplicateOrderUpdate.isHidden = true
        btnPrintBill.isHidden = true
        btnPrintOrder.isHidden = true
        if isSendOrder{
            if AppCommonMethods.fetchSiteSettingValue(key: "is_sendorder") ?? "" == "true" && AppConstants.userData?.permissions?.sendOrder?.actions?.list ?? 0 == 1{
                btnSendFullOrder.isHidden = false
            }
            if AppCommonMethods.fetchSiteSettingValue(key: "is_sendorderupdate") ?? "" == "true"{
                btnSendOrderUpdate.isHidden = false
            }
            if AppCommonMethods.fetchSiteSettingValue(key: "is_sendduplicateorder") ?? "" == "true"{
                btnSendDuplicateFullOrder.isHidden = false
            }
            if AppCommonMethods.fetchSiteSettingValue(key: "is_sendduplicateorderupdate") ?? "" == "true"{
                btnSendDuplicateOrderUpdate.isHidden = false
            }
        }else{
            if AppCommonMethods.fetchSiteSettingValue(key: "is_printbill") ?? "" == "true" && AppConstants.userData?.permissions?.printBill?.actions?.list ?? 0 == 1{
                btnPrintBill.isHidden = false
            }
            if AppCommonMethods.fetchSiteSettingValue(key: "is_printall") ?? "" == "true" && AppConstants.userData?.permissions?.printAll?.actions?.list ?? 0 == 1{
                btnPrintOrder.isHidden = false
            }
        }
    }

    //MARK: create viewcontroller instance
    class func showPopup(parentVC:UIViewController,isSendOrder:Bool)->SendOrderPopup?{
        if let container = UIStoryboard.init(name: "Popups", bundle: nil).instantiateViewController(withIdentifier: "SendOrderPopup") as? SendOrderPopup{
            container.isSendOrder = isSendOrder
            parentVC.addChild(container)
            parentVC.view.addSubview(container.view)
            container.view.frame = CGRect.init(x: 0, y: 0, width: AppConstants.ScreenSize.SCREEN_WIDTH, height: AppConstants.ScreenSize.SCREEN_HEIGHT)
            container.view.alpha = 0.0
            
            UIView.animate(withDuration: 0.25) {
                container.view.alpha = 1.0
            }
            return container
        }
        return nil
    }
    
    //MARK:  General Methods
    func closePopup(){
        UIView.animate(withDuration: 0.25) {
            self.view.alpha = 0.0
        } completion: { (status) in
            self.view.removeFromSuperview()
            self.removeFromParent()
        }
    }
    
    //MARK:  Button Actions
    @IBAction func btnCancelAction(_ sender:UIButton){
        self.closePopup()
    }
    
    @IBAction func btnSendFullOrderAction(_ sender:UIButton){
        self.delegate?.sendOrder(index: 1)
        self.closePopup()
    }
    
    @IBAction func btnSendDuplicateFullOrderAction(_ sender:UIButton){
        self.delegate?.sendOrder(index: 2)
        self.closePopup()
    }
    
    @IBAction func btnSendDuplicateOrderUpdateAction(_ sender:UIButton){
        self.delegate?.sendOrder(index: 4)
        self.closePopup()
    }
    
    @IBAction func btnPrintOrderAction(_ sender:UIButton){
        self.delegate?.sendOrder(index: 6)
        self.closePopup()
    }
    
    @IBAction func btnSendOrderUPdateAction(_ sender:UIButton){
        self.delegate?.sendOrder(index: 3)
        self.closePopup()
    }
    
    @IBAction func btnPrintBillAction(_ sender:UIButton){
        self.delegate?.sendOrder(index: 5)
        self.closePopup()
    }
}

