//
//  SelectOrderVC.swift
//  TiffinTom
//
//  Created by Tushar Premal on 02/09/20.
//  Copyright © 2020 8Dots. All rights reserved.
//

import UIKit

class SelectOrderVC: UIViewController {
    
    //MARK:  IBOutlets
    @IBOutlet weak var collectionOrderList:UICollectionView!
    @IBOutlet weak var txtSearch:UITextField!
    
    //MARK:  Instances
    var arrOrderList = [WebOrderModel]()
    var arrSearchOrderList = [WebOrderModel]()
    var isSearchEnalbled = false
    weak var delegate:SelectOrderDelegate?
    
    //MARK:  ViewController LifeCycle
    override func viewDidLoad() {
        super.viewDidLoad()
        
        // Do any additional setup after loading the view.
        CallGetOrderHelpListAPI()
    }
    
    //MARK: create viewcontroller instance
    class func showPopup(parentVC:UIViewController)->SelectOrderVC?{
        if let container = UIStoryboard.init(name: "Popups", bundle: nil).instantiateViewController(withIdentifier: "SelectOrderVC") as? SelectOrderVC{
            parentVC.addChild(container)
            parentVC.view.addSubview(container.view)
            container.view.frame = CGRect.init(x: 0, y: 0, width: AppConstants.ScreenSize.SCREEN_WIDTH, height: AppConstants.ScreenSize.SCREEN_HEIGHT)
            container.view.alpha = 0.0
            UIView.animate(withDuration: 0.25) {
                container.view.alpha = 1.0
            }
            return container
        }
        return nil
    }
    
    //MARK:  General Methods
    func closePopup(){
        UIView.animate(withDuration: 0.25) {
            self.view.alpha = 0.0
        } completion: { (status) in
            self.view.removeFromSuperview()
            self.removeFromParent()
        }
    }
    
    //MARK: Button Actions
    @IBAction func btnCloseAction(_ sender:UIButton){
        self.closePopup()
    }
    
    @IBAction func txtSearchChanged(_ sender:UITextField){
        if sender.text ?? "" == ""{
            isSearchEnalbled = false
        }else{
            isSearchEnalbled = true
            arrSearchOrderList = arrOrderList.filter({ (model) -> Bool in
                return (model.customerName ?? "").lowercased().contains((sender.text ?? "").lowercased())
            })
        }
        collectionOrderList.reloadData()
    }
    
    //MARK: WebService Methods
    func CallGetOrderHelpListAPI(){
        let dictParam = [String:String]()
        
        AppCommonMethods.startProgressBar()
        WebServiceManager().requestAPI(params: dictParam,  urlString: AppConstants.APIURL.kOnlineOrder, method: "GET",isRestaurantAPI: true) { (message, result) in
            DispatchQueue.main.async {
                AppCommonMethods.stopProgressBar()
                let jsonDecoder = JSONDecoder()
                if let respone = result as? NSDictionary,let arrO = respone["data"] as? [NSDictionary], let data = AppCommonMethods.convertToJson(object: arrO), let aData = try? jsonDecoder.decode([WebOrderModel].self, from: data){
                    self.arrOrderList = aData
                    self.collectionOrderList.reloadData()
                }else{
                    AppValidation().showAlertView(parentVC: self, withAlertTile: AppConstants.GlobalAlert.ALERT_TITLE, withAlertMsg: message, withActionsTitle: [AppConstants.GlobalAlert.ALERT_BTN_OK]) { (index) in

                    }
                }
            }
        }
    }
}

//MARK:  UICollectionViewDataSource
extension SelectOrderVC:UICollectionViewDataSource,UICollectionViewDelegate, UICollectionViewDelegateFlowLayout{
    func collectionView(_ collectionView: UICollectionView, numberOfItemsInSection section: Int) -> Int {
        return isSearchEnalbled ? arrSearchOrderList.count : arrOrderList.count
    }
    
    func collectionView(_ collectionView: UICollectionView, cellForItemAt indexPath: IndexPath) -> UICollectionViewCell {
        let cell = collectionView.dequeueReusableCell(withReuseIdentifier: "SelectOrderCell", for: indexPath) as! SelectOrderCell
        let model = isSearchEnalbled ? arrSearchOrderList[indexPath.row] : arrOrderList[indexPath.row]
        cell.lblStoreName.text = model.customerName ?? ""
        cell.lblTotalPrice.text = String.init(format: "Total: %@%.2f", AppConstants.currencySign,model.orderGrandTotal ?? 0)
        cell.lblOrderDescription.text = "#\(model.orderNumber ?? "")"
        let payment = model.paymentMethod ?? ""
        if payment.lowercased() == "stripe"{
            cell.lblPaymentMEthod.text = "**** \(model.cardView?.cardNo ?? "")"
            
        }else if payment.lowercased() == "cod"{
            cell.lblPaymentMEthod.text = "Cash Payment"
        }else if payment.lowercased() == "wallet"{
            cell.lblPaymentMEthod.text = "Credit"
        }else{
            cell.lblPaymentMEthod.text = payment
        }
        return cell
    }
    
    func collectionView(_ collectionView: UICollectionView, didSelectItemAt indexPath: IndexPath) {
        let model = isSearchEnalbled ? arrSearchOrderList[indexPath.row] : arrOrderList[indexPath.row]
        self.closePopup()
        if self.delegate != nil{
            self.delegate!.orderSelected(order: model)
        }
    }
    
    func collectionView(_ collectionView: UICollectionView, layout collectionViewLayout: UICollectionViewLayout, sizeForItemAt indexPath: IndexPath) -> CGSize {
        return CGSize.init(width: (AppConstants.ScreenSize.SCREEN_WIDTH-202)/2, height: 85)
    }
}
