//
//  ManageQuantityVC.swift
//  EPOS
//
//  Created by Apple on 14/05/21.
//

import UIKit
import ActionSheetPicker_3_0

class ReservationTimeVC: UIViewController {

    //MARK:  IBOutlets
    @IBOutlet weak var lblSelectedTime:UILabel!
    @IBOutlet weak var btnConfirm:UIButton!
    @IBOutlet weak var collectionTime:UICollectionView!
    @IBOutlet weak var constCollectionTimeHeight:NSLayoutConstraint!
    
    //MARK:  Instances
    var strSelectedTime = ""
    var strCustomTime = ""
    weak var delegate:ReservationTimeDelegate?
    var arrTime = [String]()
    
    //MARK:  ViewController LifeCycle
    override func viewDidLoad() {
        super.viewDidLoad()

        // Do any additional setup after loading the view.
        
        if let startDate = AppCommonMethods.fetchSiteSettingValue(key: "reservation_start_time"), let endDate = AppCommonMethods.fetchSiteSettingValue(key: "reservation_end_time"), let date1 = startDate.getDateFromString(format: "HH:mm"), let date2 = endDate.getDateFromString(format: "HH:mm"){
            var i = 1
            while true {
                let date = date1.addingTimeInterval(TimeInterval(i*15*60))
                if date >= date2 {
                    break;
                }
                i += 1
                arrTime.append(date.getDateInString(format: "HH:mm"))
            }
        }
        calculateCollectionHeight()
        if strSelectedTime == ""{
            self.btnConfirm.isEnabled = false
            self.btnConfirm.backgroundColor = AppConstants.Colors.kAppThemeBGColor
        }else{
            if !arrTime.contains(strSelectedTime){
                strCustomTime = strSelectedTime
            }
            self.btnConfirm.isEnabled = true
            self.btnConfirm.backgroundColor = AppConstants.Colors.kAppMediumGreenColor
        }
    }

    //MARK: create viewcontroller instance
    class func showPopup(parentVC:UIViewController, selectedTime:String)->ReservationTimeVC?{
        if let container = UIStoryboard.init(name: "Popups", bundle: nil).instantiateViewController(withIdentifier: "ReservationTimeVC") as? ReservationTimeVC{
            container.strSelectedTime = selectedTime
            parentVC.addChild(container)
            parentVC.view.addSubview(container.view)
            
            container.view.frame = CGRect.init(x: 0, y: 0, width: AppConstants.ScreenSize.SCREEN_WIDTH, height: AppConstants.ScreenSize.SCREEN_HEIGHT)
            container.view.alpha = 0.0
            
            UIView.animate(withDuration: 0.25) {
                container.view.alpha = 1.0
            }
            return container
        }
        return nil
    }
    
    //MARK:  General Methods
    func closePopup(){
        UIView.animate(withDuration: 0.25) {
            self.view.alpha = 0.0
        } completion: { (status) in
            self.view.removeFromSuperview()
            self.removeFromParent()
        }
    }
    func calculateCollectionHeight(){
        let count = floor((AppConstants.ScreenSize.SCREEN_WIDTH - 180)/106)
        var dataCount = arrTime.count+1
        if strCustomTime != ""{
            dataCount = arrTime.count+2
        }
        let height = 57 * ceil(CGFloat(dataCount)/count)
        constCollectionTimeHeight.constant = min(height, AppConstants.ScreenSize.SCREEN_HEIGHT - 332)
    }
    
    //MARK:  Button Actions
    @IBAction func btnCancelAction(_ sender:UIButton){
        self.closePopup()
    }
    
    @IBAction func btnConfirmAction(_ sender:UIButton){
        if self.delegate != nil{
            self.delegate!.timeSelected(selectedTime: strSelectedTime)
        }
        self.closePopup()
    }
    
    @IBAction func btnTimeAction(_ sender:UIButton){
        var count = arrTime.count
        if strCustomTime != ""{
            count = arrTime.count+1
            if sender.tag == arrTime.count{
                strSelectedTime = strCustomTime
                self.btnConfirm.isEnabled = true
                self.btnConfirm.backgroundColor = AppConstants.Colors.kAppMediumGreenColor
                self.lblSelectedTime.text = "\(strSelectedTime) selected"
                self.collectionTime.reloadData()
                self.calculateCollectionHeight()
                return
            }
        }
        if sender.tag == count{
            let datePicker = ActionSheetDatePicker(title: "Select time", datePickerMode: UIDatePicker.Mode.time, selectedDate: Date(), doneBlock: {
                picker, value, index in
                self.strCustomTime = (value as! Date).getDateInString(format: "HH:mm")
                self.strSelectedTime = (value as! Date).getDateInString(format: "HH:mm")
                self.btnConfirm.isEnabled = true
                self.btnConfirm.backgroundColor = AppConstants.Colors.kAppMediumGreenColor
                self.collectionTime.reloadData()
                self.calculateCollectionHeight()
                self.lblSelectedTime.text = "\(self.strSelectedTime) selected"
            }, cancel: { ActionStringCancelBlock in return }, origin: sender)
            datePicker?.show()
        }else{
            strSelectedTime = arrTime[sender.tag]
            self.btnConfirm.isEnabled = true
            self.btnConfirm.backgroundColor = AppConstants.Colors.kAppMediumGreenColor
            self.lblSelectedTime.text = "\(strSelectedTime) selected"
            self.collectionTime.reloadData()
            self.calculateCollectionHeight()
        }
    }
}

//MARK:  UICollectionViewDataSource
extension ReservationTimeVC:UICollectionViewDataSource{
    func collectionView(_ collectionView: UICollectionView, numberOfItemsInSection section: Int) -> Int {
        return arrTime.count + ((strCustomTime == "")  ? 1 : 2)
    }
    
    func collectionView(_ collectionView: UICollectionView, cellForItemAt indexPath: IndexPath) -> UICollectionViewCell {
        let cell = collectionView.dequeueReusableCell(withReuseIdentifier: "TimseSlotViewCell", for: indexPath) as! TimseSlotViewCell
        cell.btnTimeSlot.tag = indexPath.row
        cell.btnTimeSlot.backgroundColor = AppConstants.Colors.kAppThemeAquaColor
        var count = arrTime.count
        if strCustomTime != ""{
            count = arrTime.count+1
            if indexPath.row == arrTime.count{
                cell.btnTimeSlot.setTitle(strCustomTime, for: .normal)
                if strSelectedTime == strCustomTime{
                    cell.btnTimeSlot.backgroundColor = AppConstants.Colors.kAppThemeDarkAquaColor
                }
                return cell
            }
        }
        if indexPath.row == count{
            cell.btnTimeSlot.setTitle("Custom", for: .normal)
        }else{
            if strSelectedTime == arrTime[indexPath.row]{
                cell.btnTimeSlot.backgroundColor = AppConstants.Colors.kAppThemeDarkAquaColor
            }
            cell.btnTimeSlot.setTitle(arrTime[indexPath.row], for: .normal)
        }
        return cell
    }
}
