//
//  PrintReportSelectionVC.swift
//  TiffinTomPartner
//
//  Created by Tushar Premal on 04/03/21.
//

import UIKit

protocol PrintReportDelegate: AnyObject {
    func selectedReportIndex(index:Int)
}

class PaymentReportModel: Codable {
    
    var filter: String?
    var report: MerchantReportModel?
    var fromDate: String?
    var toDate: String?
    
    enum CodingKeys: String, CodingKey {
        case filter, report
        case fromDate = "from_date"
        case toDate = "to_date"
    }
    
    required init(from decoder: Decoder) throws {
        let values = try decoder.container(keyedBy: CodingKeys.self)
        filter = values.getStringValue(key: CodingKeys.filter)
        fromDate = values.getStringValue(key: CodingKeys.fromDate)
        toDate = values.getStringValue(key: CodingKeys.toDate)
        report = try? values.decode(MerchantReportModel.self, forKey: .report)
    }
}

class MerchantReportModel: Codable {
    
    var totalTransaction = 0
    var totalRefundAmount: Double = 0
    var totalRefundTransactions = 0
    var totalSuccessfulAmount: Double = 0
    var totalSuccessfulTransactions = 0
    
    enum CodingKeys: String, CodingKey {
        case totalTransaction = "total_transaction"
        case totalRefundAmount = "total_refund_amount"
        case totalRefundTransactions = "total_refund_transactions"
        case totalSuccessfulAmount = "total_successful_amount"
        case totalSuccessfulTransactions = "total_successful_transactions"
    }
    
    required init(from decoder: Decoder) throws {
        let values = try decoder.container(keyedBy: CodingKeys.self)
        totalSuccessfulTransactions = values.getIntValue(key: CodingKeys.totalSuccessfulTransactions) ?? 0
        totalRefundTransactions = values.getIntValue(key: CodingKeys.totalRefundTransactions) ?? 0
        totalTransaction = values.getIntValue(key: CodingKeys.totalTransaction) ?? 0
        totalSuccessfulAmount = values.getDoubleValue(key: CodingKeys.totalSuccessfulAmount) ?? 0
        totalRefundAmount = values.getDoubleValue(key: CodingKeys.totalRefundAmount) ?? 0
    }
}


class PrintReportSelectionVC: UIViewController {

    @IBOutlet weak var btnToday:UIButton!
    @IBOutlet weak var btnYesterday:UIButton!
    @IBOutlet weak var btnLast3Day:UIButton!
    @IBOutlet weak var btnPrint:UIButton!
    @IBOutlet weak var lblDate:UILabel!
    @IBOutlet weak var lblTransaction:UILabel!
    @IBOutlet weak var lblRefundamount:UILabel!
    @IBOutlet weak var lblRefundTransaction:UILabel!
    @IBOutlet weak var lblSuccessAmount:UILabel!
    @IBOutlet weak var lblSuccessTransaction:UILabel!
    @IBOutlet weak var viewForReports:UIView!
    
    var selectedRange = 0
    weak var delegate:PrintReportDelegate?
    var arrPaymentReports = [PaymentReportModel]()
    var selectedReport:MerchantReportModel!
    var selectedDate = ""
    
    override func viewDidLoad() {
        super.viewDidLoad()

        // Do any additional setup after loading the view.
        setSelectionView()
        GetPrintReportData()
    }
    
    //MARK: create viewcontroller instance
    class func showPopup(parentVC:UIViewController)->PrintReportSelectionVC?{
        guard let VC = UIStoryboard.init(name: "Popups", bundle: nil).instantiateViewController(withIdentifier: "PrintReportSelectionVC") as? PrintReportSelectionVC else { return nil }
        parentVC.addChild(VC)
        parentVC.view.addSubview(VC.view)
        VC.view.alpha = 0
        UIView.animate(withDuration: 0.2) {
            VC.view.alpha = 1
        }
        VC.view.frame = parentVC.view.bounds
        return VC
    }
    
    func setSelectionView(){
        btnToday.backgroundColor = AppConstants.Colors.kAppThemeBGColor
        btnToday.setTitleColor(AppConstants.Colors.kAppThemeTextColor, for: .normal)
        btnYesterday.backgroundColor = AppConstants.Colors.kAppThemeBGColor
        btnYesterday.setTitleColor(AppConstants.Colors.kAppThemeTextColor, for: .normal)
        btnLast3Day.backgroundColor = AppConstants.Colors.kAppThemeBGColor
        btnLast3Day.setTitleColor(AppConstants.Colors.kAppThemeTextColor, for: .normal)
        switch selectedRange {
        case 0:
            btnToday.backgroundColor = AppConstants.Colors.kAppThemeAquaColor
            btnToday.setTitleColor(.white, for: .normal)
        case 1:
            btnYesterday.backgroundColor = AppConstants.Colors.kAppThemeAquaColor
            btnYesterday.setTitleColor(.white, for: .normal)
        case 2:
            btnLast3Day.backgroundColor = AppConstants.Colors.kAppThemeAquaColor
            btnLast3Day.setTitleColor(.white, for: .normal)
        default:
            break
        }
    }
    
    @IBAction func btnSelectionAction(_ sender:UIButton){
        selectedRange = sender.tag
        setSelectionView()
    }
    
    @IBAction func btnConfirmAction(_ sender:UIButton){
        var strDay = "today"
        if selectedRange == 1{
            strDay = "yesterday"
        }else if selectedRange == 2{
            strDay = "last_3_days"
        }
        let report = arrPaymentReports.filter { model in
            return model.filter ?? "" == strDay
        }.first
        if report != nil, let data = report!.report{
            selectedReport = data
            self.viewForReports.isHidden = false
            var fromDate = (report?.fromDate ?? "").components(separatedBy: " ").first ?? ""
            var toDate = (report?.toDate ?? "").components(separatedBy: " ").first ?? ""
            if let fDate = (report?.fromDate ?? "").components(separatedBy: " ").first?.getDateFromString(format: "yyyy-MM-dd"), let tDate = (report?.toDate ?? "").components(separatedBy: " ").first?.getDateFromString(format: "yyyy-MM-dd"){
                fromDate = fDate.getDateInString(format: fDate.gatDateFormat())
                toDate = tDate.getDateInString(format: tDate.gatDateFormat())
            }
            if fromDate == toDate{
                selectedDate = "Date: \(fromDate)"
            }else{
                selectedDate = "Date: \(fromDate) to: \(toDate)"
            }
            self.lblDate.text = selectedDate
            self.lblTransaction.text = data.totalTransaction.description
            self.lblRefundamount.text = String.init(format: "%@%.2f", AppConstants.currencySign, data.totalRefundAmount/10)
            self.lblSuccessAmount.text = String.init(format: "%@%.2f", AppConstants.currencySign, data.totalSuccessfulAmount/10)
            self.lblRefundTransaction.text = data.totalRefundTransactions.description
            self.lblSuccessTransaction.text = data.totalSuccessfulTransactions.description
        }else{
            AppCommonMethods.showToastAlert(message: "Report data not found")
        }
    }
    
    @IBAction func btnPrintAction(_ sender:UIButton){
        PrintManager.shared.strHeaderDate = selectedDate
        PrintManager.shared.connectToPrinterWithPrint(model: selectedReport!, controller: self)
        self.removePopView()
    }
    
    @IBAction func btnCnacelAction(_ sender:UIButton){
        self.removePopView()
    }
    
    func GetPrintReportData(){
        var dictParam = [String:String]()
        dictParam["dynamic"] = "1"
        AppCommonMethods.startProgressBar()
        WebServiceManager().requestAPI(params: dictParam, urlString: "\(AppConstants.APIURL.kMerchantBusiness)\(AppConstants.businessData?.id ?? 0)/report-summary", method: "POST") { (message, result) in
            DispatchQueue.main.async {
                AppCommonMethods.stopProgressBar()
                let jsonDecoder = JSONDecoder()
                if let response = result as? [NSDictionary], let data = AppCommonMethods.convertToJson(object: response), let aData = try? jsonDecoder.decode([PaymentReportModel].self, from: data){
                    self.arrPaymentReports = aData
                }
            }
        }
    }
    
    //MARK:  General Methods
    func removePopView(){
        UIView.animate(withDuration: 0.25) {
            self.view.alpha = 0.0
        } completion: { (status) in
            self.view.removeFromSuperview()
            self.removeFromParent()
        }
    }
}
