//
//  OrderTypeSelectionVc.swift
//  EPOS
//
//  Created by Apple on 13/07/21.
//

import UIKit

class OrderTypeSelectionVc: UIViewController {
    
    //MARK:  IBOutlets
    @IBOutlet weak var viewForDelivery:UIView!
    @IBOutlet weak var viewForCollection:UIView!
    @IBOutlet weak var viewForWaiting:UIView!
    
    @IBOutlet weak var lblDelivery:UILabel!
    @IBOutlet weak var lblCollection:UILabel!
    @IBOutlet weak var lblWaiting:UILabel!
    
    //MARK:  Instances
    weak var delegate:NewOrderDelegate?
    
    //MARK:  ViewController LifeCycle
    override func viewDidLoad() {
        super.viewDidLoad()
        
        // Do any additional setup after loading the view.
        checkForOrderType()
        AppConstants.arrOrderTypes.forEach { orderType in
            if orderType.id ?? 0 == 2{
                self.viewForCollection.backgroundColor = UIColor.hexStr(hexStr: orderType.topColor ?? "")
                self.lblCollection.textColor = UIColor.hexStr(hexStr: orderType.bottomColor ?? "")
            }else if orderType.id ?? 0 == 3{
                self.viewForDelivery.backgroundColor = UIColor.hexStr(hexStr: orderType.topColor ?? "")
                self.lblDelivery.textColor = UIColor.hexStr(hexStr: orderType.bottomColor ?? "")
            }else if orderType.id ?? 0 == 5{
                self.viewForWaiting.backgroundColor = UIColor.hexStr(hexStr: orderType.topColor ?? "")
                self.lblWaiting.textColor = UIColor.hexStr(hexStr: orderType.bottomColor ?? "")
            }
        }
    }
    
    //MARK: create ViewController Instance
    class func showPopup(parentVC:UIViewController)->OrderTypeSelectionVc?{
        if let container = UIStoryboard.init(name: "Popups", bundle: nil).instantiateViewController(withIdentifier: "OrderTypeSelectionVc") as? OrderTypeSelectionVc{
            parentVC.addChild(container)
            parentVC.view.addSubview(container.view)
            container.view.frame = CGRect.init(x: 0, y: 0, width: AppConstants.ScreenSize.SCREEN_WIDTH, height: AppConstants.ScreenSize.SCREEN_HEIGHT)
            container.view.alpha = 0.0
            UIView.animate(withDuration: 0.25) {
                container.view.alpha = 1.0
            }
            return container
        }
        return nil
    }
    
    //MARK: General Methods
    func closePopup(){
        UIView.animate(withDuration: 0.25) {
            self.view.alpha = 0.0
        } completion: { (status) in
            self.view.removeFromSuperview()
            self.removeFromParent()
        }
    }
    
    func checkForOrderType(){
        if AppCommonMethods.fetchSiteSettingValue(key: "is_delivery") ?? "" == "true" && AppConstants.userData?.permissions?.delivery?.actions?.list ?? 0 == 1{
            viewForDelivery.isHidden = false
        }else{
            viewForDelivery.isHidden = true
        }
        if AppCommonMethods.fetchSiteSettingValue(key: "is_collection") ?? "" == "true" && AppConstants.userData?.permissions?.collection?.actions?.list ?? 0 == 1{
            viewForCollection.isHidden = false
        }else{
            viewForCollection.isHidden = true
        }
        if AppCommonMethods.fetchSiteSettingValue(key: "is_waiting") ?? "" == "true" && AppConstants.userData?.permissions?.waiting?.actions?.list ?? 0 == 1{
            viewForWaiting.isHidden = false
        }else{
            viewForWaiting.isHidden = true
        }
    }
    
    //MARK: Button Actions
    @IBAction func btnTypeSelectionAction(_ sender:UIButton){
        let selectedCutomer = CustomerModel()
        selectedCutomer.id = Date().millisecondsSince1970
        selectedCutomer.uniqueId = "\(Int(Date().timeIntervalSinceReferenceDate))\(AppConstants.businessData?.id ?? 0)\(AppConstants.DeviceId)"
        selectedCutomer.offline = 1
        let orderType = AppConstants.arrOrderTypes.filter({ model in
            return model.id ?? 0 == sender.tag
        }).first
        if orderType != nil{
            CoreDataHelper.shared.saveAndUpdateCusomer(customer: selectedCutomer, offline: selectedCutomer.offline, updated: 1)
            UIView.animate(withDuration: 0.25) {
                self.view.alpha = 0.0
            } completion: { (status) in
                if self.delegate != nil{
                    self.delegate?.orderTypeSelected(orderType: orderType!)
                }
                self.view.removeFromSuperview()
                self.removeFromParent()
            }
        }
        
    }
    
    @IBAction func btnCancelAction(_ sender:UIButton){
        closePopup()
    }
}
