//
//  NewOrderVC.swift
//  EPOS
//
//  Created by Apple on 05/03/21.
//

import UIKit
import DropDown
import CoreLocation

class NewOrderVC: UIViewController {
    
    //MARK:  IBOutlets
    @IBOutlet weak var txtName:UITextField!
    @IBOutlet weak var txtMobileNo:UITextField!
    @IBOutlet weak var txtDeliveryName:UITextField!
    @IBOutlet weak var txtEmailId:UITextField!
    @IBOutlet weak var txtDeliveryMobileNo:UITextField!
    @IBOutlet weak var txtPostCode:UITextField!
    @IBOutlet weak var txtHouseNo:UITextField!
    @IBOutlet weak var txtStreetName:UITextField!
    @IBOutlet weak var txtCityName:UITextField!
    @IBOutlet weak var txtDeliveryEmail:UITextField!
    @IBOutlet weak var lblTitle:UILabel!
    @IBOutlet weak var lblDistance:UILabel!
    @IBOutlet weak var stackDelivery:UIStackView!
    @IBOutlet weak var stackCollection:UIStackView!
    @IBOutlet weak var btnSearch:UIButton!
    @IBOutlet weak var btnNewsLetter:UIButton!
    
    //MARK:  Instances
    var selectedOrderType:OrderTypesModel?
    var arrUserName = [String]()
    var arrCustomer = [CustomerModel]()
    var selectedCutomer:CustomerModel?
    let customerDropDown = DropDown()
    var selectedPostCode:PostCodeModel?
    var deliveryCharge:DeliveryChargeModel?
    weak var delegate:NewOrderDelegate?
    var viewType = NewOrderViewType.newOrder
    var oldTable:TableModel?
    var shouldLookupPostcode = true
    var distance:Double?
    var orderData:OrderModel?
    var isCustomerEditable = true
    
    //MARK:  ViewController LifeCycle
    override func viewDidLoad() {
        super.viewDidLoad()
        
        // Do any additional setup after loading the view.
        customerDropDown.dismissMode = .automatic
        customerDropDown.bottomOffset = CGPoint(x: 0, y: txtName.bounds.height)
        // Action triggered on selection
        customerDropDown.selectionAction = { [unowned self] (index, item) in
            self.selectedCutomer = self.arrCustomer[index]
            self.view.endEditing(true)
            self.setCustomerData()
        }
        
        if selectedOrderType?.id ?? 0 == 3 || selectedOrderType?.id ?? 0 == 0{
            stackDelivery.isHidden = false
            stackCollection.isHidden = true
            customerDropDown.anchorView = self.txtDeliveryName
        }else{
            stackDelivery.isHidden = true
            stackCollection.isHidden = false
            customerDropDown.anchorView = self.txtName
            if selectedOrderType?.id ?? 0 == 5{
                txtMobileNo.isHidden = true
            }else{
                txtEmailId.isHidden = true
            }
        }
        
        if viewType == .changeCustomer{
            lblTitle.text = "Customer Info"
            setCustomerData()
            btnNewsLetter.superview?.isHidden = true
            if orderData?.orderStatusId ?? 0 == 10 || orderData?.orderStatusId ?? 0 == 5 || orderData?.totalPaid ?? 0 > 0 || orderData?.orderStatusId ?? 0 == 4 || orderData?.orderStatusId ?? 0 == 6 || AppConstants.userData?.permissions?.customerInfo?.actions?.list ?? 0 == 0{
                isCustomerEditable = false
                txtDeliveryName.isUserInteractionEnabled = false
                txtDeliveryMobileNo.isUserInteractionEnabled = false
                txtName.isUserInteractionEnabled = false
                txtMobileNo.isUserInteractionEnabled = false
                txtEmailId.isUserInteractionEnabled = false
                txtHouseNo.isUserInteractionEnabled = false
                txtPostCode.isUserInteractionEnabled = false
                txtCityName.isUserInteractionEnabled = false
                txtStreetName.isUserInteractionEnabled = false
            }
        }else{
            lblTitle.text = selectedOrderType?.type ?? ""
        }
        shouldLookupPostcode = (AppCommonMethods.fetchSiteSettingValue(key: "postcode_lookup_visible") == "yes")
        if !shouldLookupPostcode || !Reachabilities.shared.isConnectedToNetwork(){
            btnSearch.isHidden = true
        }
        
    }
    
    //MARK: create viewcontroller instance
    class func showPopup(parentVC:UIViewController, orderType:OrderTypesModel?, viewType:NewOrderViewType = .newOrder, customer:CustomerModel? = nil, table:TableModel? = nil, orderData:OrderModel? = nil)->NewOrderVC?{
        if let container = UIStoryboard.init(name: "Popups", bundle: nil).instantiateViewController(withIdentifier: "NewOrderVC") as? NewOrderVC{
            container.viewType = viewType
            container.selectedOrderType = orderType
            container.selectedCutomer = customer
            container.oldTable = table
            container.orderData = orderData
            parentVC.addChild(container)
            parentVC.view.addSubview(container.view)
            container.view.frame = CGRect.init(x: 0, y: 0, width: AppConstants.ScreenSize.SCREEN_WIDTH, height: AppConstants.ScreenSize.SCREEN_HEIGHT)
            container.view.alpha = 0.0
            UIView.animate(withDuration: 0.25) {
                container.view.alpha = 1.0
            }
            return container
        }
        return nil
    }
    
    //MARK:  General Methods
    func closePopup(){
        UIView.animate(withDuration: 0.25) {
            self.view.alpha = 0.0
        } completion: { (status) in
            self.view.removeFromSuperview()
            self.removeFromParent()
        }
    }
    
    func setCustomerData(){
        txtDeliveryName.text = selectedCutomer?.name ?? ""
        txtDeliveryMobileNo.text = selectedCutomer?.mobile ?? ""
        txtName.text = selectedCutomer?.name ?? ""
        txtMobileNo.text = selectedCutomer?.mobile ?? ""
        txtDeliveryEmail.text = selectedCutomer?.email ?? ""
        txtEmailId.text = selectedCutomer?.email ?? ""
        txtHouseNo.text = selectedCutomer?.houseNo ?? ""
        txtPostCode.text = selectedCutomer?.postcode ?? ""
        txtCityName.text = selectedCutomer?.city ?? ""
        txtStreetName.text = selectedCutomer?.street ?? ""
        distance = selectedCutomer?.distance
        btnNewsLetter.isSelected = ((selectedCutomer?.newsLetter ?? 0) == 1)
        if distance != nil && selectedOrderType?.id ?? 0 == 3{
            self.lblDistance.text = String.init(format: "Distance: %.2f Miles", self.distance ?? 0)
            self.lblDistance.superview?.isHidden = false
        }else{
            self.lblDistance.superview?.isHidden = true
        }
    }
    
    func checkValidation() -> Bool {
        if selectedOrderType?.id ?? 0 == 3{
            if (txtDeliveryName.text?.trimmingCharacters(in: .whitespaces).isEmpty)!{
                AppValidation().showAlertView(parentVC: self, withAlertTile: AppConstants.GlobalAlert.ALERT_TITLE, withAlertMsg:  AppConstants.GlobalAlert.ALERT_ENTER_NAME, withActionsTitle: [AppConstants.GlobalAlert.ALERT_BTN_OK]) { (index) in
                    _ = self.txtDeliveryName.becomeFirstResponder()
                }
                return false
            }
            if (txtDeliveryMobileNo.text?.trimmingCharacters(in: .whitespaces).isEmpty)!{
                AppValidation().showAlertView(parentVC: self, withAlertTile: AppConstants.GlobalAlert.ALERT_TITLE, withAlertMsg:  AppConstants.GlobalAlert.ALERT_ENTER_MOBILENO, withActionsTitle: [AppConstants.GlobalAlert.ALERT_BTN_OK]) { (index) in
                    _ = self.txtDeliveryMobileNo.becomeFirstResponder()
                }
                return false
            }
            if (txtDeliveryMobileNo.text ?? "").trimmingCharacters(in: .whitespaces).count < 10 || (txtDeliveryMobileNo.text ?? "").trimmingCharacters(in: .whitespaces).count > 11{
                AppValidation().showAlertView(parentVC: self, withAlertTile: AppConstants.GlobalAlert.ALERT_TITLE, withAlertMsg: AppConstants.GlobalAlert.ALERT_MOBILE_10_DIGIT, withActionsTitle: [AppConstants.GlobalAlert.ALERT_BTN_OK]) { (index) in
                    _ = self.txtDeliveryMobileNo.becomeFirstResponder()
                }
                return false
            }
            if (txtPostCode.text?.trimmingCharacters(in: .whitespaces).isEmpty)!{
                AppValidation().showAlertView(parentVC: self, withAlertTile: AppConstants.GlobalAlert.ALERT_TITLE, withAlertMsg:  AppConstants.GlobalAlert.ALERT_ENTER_POSTCODE, withActionsTitle: [AppConstants.GlobalAlert.ALERT_BTN_OK]) { (index) in
                    _ = self.txtPostCode.becomeFirstResponder()
                }
                return false
            }
            if (txtHouseNo.text?.trimmingCharacters(in: .whitespaces).isEmpty)!{
                AppValidation().showAlertView(parentVC: self, withAlertTile: AppConstants.GlobalAlert.ALERT_TITLE, withAlertMsg:  AppConstants.GlobalAlert.ALERT_ENTER_HOUSENO, withActionsTitle: [AppConstants.GlobalAlert.ALERT_BTN_OK]) { (index) in
                    _ = self.txtHouseNo.becomeFirstResponder()
                }
                return false
            }
        }else{
            if !(txtEmailId.text?.trimmingCharacters(in: .whitespaces).isEmpty)!{
                if !AppValidation().isValidRegEx(txtEmailId.text ?? "", RegEx.email){
                    AppValidation().showAlertView(parentVC: self, withAlertTile: AppConstants.GlobalAlert.ALERT_TITLE, withAlertMsg:  AppConstants.GlobalAlert.ALERT_ENTER_VALID_EMAIL, withActionsTitle: [AppConstants.GlobalAlert.ALERT_BTN_OK]) { (index) in
                        _ = self.txtEmailId.becomeFirstResponder()
                    }
                    return false
                }
            }
        }
        if self.viewType == .changeCustomer{
            if !(txtDeliveryEmail.text?.trimmingCharacters(in: .whitespaces).isEmpty)!{
                if !AppValidation().isValidRegEx(txtEmailId.text ?? "", RegEx.email){
                    AppValidation().showAlertView(parentVC: self, withAlertTile: AppConstants.GlobalAlert.ALERT_TITLE, withAlertMsg:  AppConstants.GlobalAlert.ALERT_ENTER_VALID_EMAIL, withActionsTitle: [AppConstants.GlobalAlert.ALERT_BTN_OK]) { (index) in
                        _ = self.txtDeliveryEmail.becomeFirstResponder()
                    }
                    return false
                }
            }
        }
        return true
    }
    
    func saveCustomer(){
        if selectedCutomer == nil{
            selectedCutomer = CustomerModel()
            selectedCutomer?.id = Date().millisecondsSince1970
            selectedCutomer?.offline = 1
            selectedCutomer?.uniqueId = "\(Int(Date().timeIntervalSinceReferenceDate))\(AppConstants.businessData?.id ?? 0)\(AppConstants.DeviceId)"
        }
        if selectedOrderType?.id ?? 0 == 3{
            selectedCutomer?.name = txtDeliveryName.text ?? ""
            selectedCutomer?.mobile = txtDeliveryMobileNo.text ?? ""
            selectedCutomer?.houseNo = txtHouseNo.text ?? ""
            selectedCutomer?.street = txtStreetName.text ?? ""
            selectedCutomer?.city = txtCityName.text ?? ""
            selectedCutomer?.postcode = txtPostCode.text ?? ""
            selectedCutomer?.email = txtDeliveryEmail.text ?? ""
            if distance != 0{
                selectedCutomer?.distance = distance
            }
        }else{
            if selectedOrderType?.id ?? 0 == 5 || viewType == .changeCustomer{
                selectedCutomer?.email = txtEmailId.text ?? ""
            }else{
                selectedCutomer?.mobile = txtMobileNo.text ?? ""
            }
            selectedCutomer?.name = txtName.text ?? ""
        }
        
        selectedCutomer?.newsLetter = (btnNewsLetter.isSelected) ? 1 : 0
        CoreDataHelper.shared.saveAndUpdateCusomer(customer: selectedCutomer!, offline: selectedCutomer?.offline ?? 1, updated: 1)
        UIView.animate(withDuration: 0.25) {
            self.view.alpha = 0.0
        } completion: { (status) in
            if self.deliveryCharge == nil && self.selectedOrderType?.id ?? 0 == 3{
                self.deliveryCharge = DeliveryChargeModel()
                self.deliveryCharge?.distance = self.distance
            }
            if self.delegate != nil{
                self.delegate?.requestForNewOrder(customer: self.selectedCutomer!, orderType: self.selectedOrderType,delivery: self.deliveryCharge, table: self.oldTable, noOfGuest: nil)
            }
            self.view.removeFromSuperview()
            self.removeFromParent()
        }
    }
    
    @objc func fetchCustomerOffline(){
        if selectedOrderType?.id ?? 0 == 3{
            arrCustomer = CoreDataHelper.shared.fetchCustomerData(name: txtDeliveryName.text ?? "")
        }else{
            arrCustomer = CoreDataHelper.shared.fetchCustomerData(name: txtName.text ?? "")
        }
        
        var arrCustomerName = [String]()
        self.arrCustomer.forEach { (model) in
            if model.mobile ?? "" != ""{
                arrCustomerName.append("\(model.name ?? "") (\(model.mobile ?? ""))")
            }else{
                arrCustomerName.append(model.name ?? "")
            }
        }
        self.customerDropDown.dataSource = arrCustomerName
        self.customerDropDown.show()
    }
    
    //MARK:  Button Actions
    @IBAction func btnCancelAction(_ sender:UIButton){
        self.closePopup()
    }
    
    @IBAction func btnSearchPostCodeAction(_ sender:UIButton){
        self.view.endEditing(true)
        if !isCustomerEditable{
            return
        }
        if (txtPostCode.text?.trimmingCharacters(in: .whitespaces).isEmpty)!{
            AppValidation().showAlertView(parentVC: self, withAlertTile: AppConstants.GlobalAlert.ALERT_TITLE, withAlertMsg:  AppConstants.GlobalAlert.ALERT_ENTER_POSTCODE, withActionsTitle: [AppConstants.GlobalAlert.ALERT_BTN_OK]) { (index) in
                _ = self.txtPostCode.becomeFirstResponder()
            }
        }else{
            getPostCodeData()
        }
    }
    
    @IBAction func btnNewsLetterAction(_ sender:UIButton){
        sender.isSelected = !sender.isSelected
    }
    
    @IBAction func btnConfirmAction(_ sender:UIButton){
        self.view.endEditing(true)
        if checkValidation(){
            if selectedOrderType?.id ?? 0 == 3{
                if distance != nil && AppCommonMethods.fetchSiteSettingValue(key: "delivery_charge_type_option") ?? "" != "manual"{
                    if Reachabilities.shared.isConnectedToNetwork(){
                        calculateDeliveryCharge()
                        return
                    }
                }
            }
            self.saveCustomer()
        }
    }
    
    @IBAction func txtNameChanged(_ sender:UITextField){
        if AppCommonMethods.fetchSiteSettingValue(key: "customer_search_setting") ?? "" == "no"{
            return
        }
        if sender.text?.count ?? 0 > 2{
            NSObject.cancelPreviousPerformRequests(withTarget: self, selector: #selector(fetchCustomerOffline), object: nil)
            self.perform(#selector(fetchCustomerOffline), with: nil, afterDelay: 0.1)
        }else{
            self.customerDropDown.hide()
        }
    }
    
    //MARK: WebService Methods
    func getPostCodeData(){
        let dictParam = [String:String]()
        AppCommonMethods.startProgressBar()
        WebServiceManager().requestAPI(params: dictParam, urlString: "\(AppConstants.APIURL.kSearchPostCode)\((txtPostCode.text ?? "").replacingOccurrences(of: " ", with: ""))", method: "GET") { (message, result) in
            DispatchQueue.main.async {
                AppCommonMethods.stopProgressBar()
                if let response = result as? NSDictionary{
                    let jsonDecoder = JSONDecoder()
                    if let data = AppCommonMethods.convertToJson(object: response), let aData = try? jsonDecoder.decode(PostCodeModel.self, from: data){
                        self.selectedPostCode = aData
                        self.txtCityName.text = self.selectedPostCode?.postTown ?? ""
                        self.txtStreetName.text = self.selectedPostCode?.street ?? ""
                        self.txtPostCode.text = self.selectedPostCode?.postCode ?? ""
                        self.distance = AppCommonMethods.fetchDistance(fLat:self.selectedPostCode?.latitude ?? 0,fLong:self.selectedPostCode?.longitude ?? 0,tLat:Double(AppCommonMethods.fetchSiteSettingValue(key: "address_latitude") ?? "") ?? 0,tLong:Double(AppCommonMethods.fetchSiteSettingValue(key: "address_longitude") ?? "") ?? 0)
                        if self.selectedOrderType?.id ?? 0 == 3{
                            self.lblDistance.text = String.init(format: "Distance: %.2f Miles", self.distance ?? 0)
                            self.lblDistance.superview?.isHidden = false
                        }
                        return
                    }
                }
                
                AppValidation().showAlertView(parentVC: self, withAlertTile: AppConstants.GlobalAlert.ALERT_TITLE, withAlertMsg: message, withActionsTitle: [AppConstants.GlobalAlert.ALERT_BTN_OK]) { (index) in
                    
                }
            }
        }
    }
    
    func calculateDeliveryCharge(){
        var dictParam = [String:String]()
        dictParam["distance"] = "\(self.distance ?? 0)"
        AppCommonMethods.startProgressBar()
        WebServiceManager().requestAPI(params: dictParam, urlString: AppConstants.APIURL.kDeliveryCharge, method: "POST") { (message, result) in
            DispatchQueue.main.async {
                AppCommonMethods.stopProgressBar()
                if let response = result as? NSDictionary{
                    let jsonDecoder = JSONDecoder()
                    if let data = AppCommonMethods.convertToJson(object: response), let aData = try? jsonDecoder.decode(DeliveryChargeModel.self, from: data){
                        self.deliveryCharge = aData
                    }
                }
                self.saveCustomer()
            }
        }
    }
}

//MARK:  UITextFieldDelegate
extension NewOrderVC:UITextFieldDelegate{
    func textField(_ textField: UITextField, shouldChangeCharactersIn range: NSRange, replacementString string: String) -> Bool {
        if textField == txtMobileNo || textField == txtDeliveryMobileNo{
            let allowedCharacters = CharacterSet(charactersIn:"0123456789")
            let characterSet = CharacterSet(charactersIn: string)
            if allowedCharacters.isSuperset(of: characterSet){
                if string == ""{
                    return true
                }
                let count = (textField.text ?? "").count
                if count >= 10{
                    return false
                }
                return true
            }
            return false
        }
        return true
    }
    
    func textFieldShouldReturn(_ textField: UITextField) -> Bool {
        if textField == txtPostCode{
            if shouldLookupPostcode{
                btnSearchPostCodeAction(UIButton())
            }
        }
        return textField.resignFirstResponder()
    }
    
    
}
