//
//  NewOnlineOrderVC.swift
//  EPOS
//
//  Created by Apple on 04/06/21.
//

import UIKit

class NewOnlineOrderVC: UIViewController {

    //MARK:  IBOutlets
    @IBOutlet weak var lblOrderTitle:UILabel!
    @IBOutlet weak var viewForBG:UIView!
    
    //MARK:  Instances
    var orderDetail:WebOrderModel!
    var orderType = ""
    var parentVC:UIViewController?
    
    //MARK:  ViewController LifeCycle
    override func viewDidLoad() {
        super.viewDidLoad()

        // Do any additional setup after loading the view.
        
        if let strDate = orderDetail.deliveryDate{
            let cDate = strDate.components(separatedBy: "T").first ?? ""
            if let date = cDate.getDateFromString(format: "yyyy-MM-dd", locale: nil){
                let currentDate = Date().getDateInString(format: "yyyy-MM-dd").getDateFromString(format: "yyyy-MM-dd", locale: nil)!
                if date > currentDate{
                    lblOrderTitle.text = "Preorder for \(date.getDateInString(format: "dd/MM/yyyy"))"
                }
            }
        }
        if lblOrderTitle.text ?? "" != ""{
            let strPaid = (orderDetail.paymentStatus ?? "" == "P") ? "Paid" : "Unpaid"
            if orderType.lowercased() == "delivery"{
                lblOrderTitle.text = "Delivery - \(strPaid)"
                self.viewForBG.backgroundColor = AppConstants.Colors.kAppDarkGreenColor
            }else if orderType.lowercased() == "pickup"{
                lblOrderTitle.text = "Collection - \(strPaid)"
                self.viewForBG.backgroundColor = AppConstants.Colors.kAppThemeBlueColor
            }else if orderType.lowercased() == "dine in"{
                let method = orderDetail.paymentStatus ?? ""
                if method.lowercased() == "stripe"{
                    lblOrderTitle.text = "Dine in - Credit/Debit card"
                }else if method.lowercased() == "cod"{
                    lblOrderTitle.text = "Dine in - Cash"
                }else if method.lowercased() == "wallet"{
                    lblOrderTitle.text = "Dine in - TiffinTom Credit"
                }else{
                    lblOrderTitle.text = "Dine in - \(method.capitalized)"
                }
                self.viewForBG.backgroundColor = AppConstants.Colors.kAppThemeYellowColor
            }
        }
    }
    
    //MARK: create ViewController Instance
    class func showPopup(order:WebOrderModel, orderType:String)->NewOnlineOrderVC?{
        if let container = UIStoryboard.init(name: "Popups", bundle: nil).instantiateViewController(withIdentifier: "NewOnlineOrderVC") as? NewOnlineOrderVC{
            container.orderDetail = order
            container.orderType = orderType
            if var VC = UIApplication.topViewController(){
                if let sheetVC = VC as? SheetViewController{
                    if let controller = UIApplication.topViewController(controller: sheetVC.presentingViewController){
                        VC = controller
                    }
                }
                VC.addChild(container)
                VC.view.addSubview(container.view)
            }else{
                AppConstants.appDelegate.window?.addSubview(container.view)
            }
            container.view.frame = CGRect.init(x: 0, y: 0, width: AppConstants.ScreenSize.SCREEN_WIDTH, height: AppConstants.ScreenSize.SCREEN_HEIGHT)
            container.view.alpha = 0.0
            UIView.animate(withDuration: 0.25) {
                container.view.alpha = 1.0
            }
            return container
        }
        return nil
    }
    
    //MARK: General Methods
    func closePopup(){
        UIView.animate(withDuration: 0.25) {
            self.view.alpha = 0.0
        } completion: { (status) in
            self.view.removeFromSuperview()
            self.removeFromParent()
        }
    }
    
    //MARK: Button Actions
    @IBAction func btnCloseAction(_ sender:UIButton){
        closePopup()
    }
    
    @IBAction func btnViewOrderAction(_ sender:UIButton){
        closePopup()
        if var topVC = UIApplication.topViewController(){
            if let sheetVC = topVC as? SheetViewController{
                sheetVC.dismiss(animated: true, completion: nil)
                if let controller = UIApplication.topViewController(controller: sheetVC.presentingViewController){
                    topVC = controller
                }
            }
            if let controller = topVC as? SideMenuVC{
                if let lastVC = controller.children.last as? OrderDetailVC{
                    lastVC.CallGetOrderDetailAPI()
                }else{
                    if let _ = OrderDetailVC.addToParentView(parentVC: controller, orderId: orderDetail.id ?? 0, orderType: orderType){
                    }
                }
            }else{
                if let sideVC = SideMenuVC.instance(){
                    let navc = UINavigationController.init(rootViewController: sideVC)
                    navc.isNavigationBarHidden = true
                    AppConstants.appDelegate.window?.rootViewController = navc
                    DispatchQueue.main.asyncAfter(deadline: .now()+0.1) { [self] in
                        if let _ = OrderDetailVC.addToParentView(parentVC: sideVC, orderId: self.orderDetail.id ?? 0, orderType: self.orderType){
                        }
                    }
                }
            }
        }
    }
}
