//
//  NewDineInOrderVC.swift
//  EPOS
//
//  Created by Apple on 05/03/21.
//

import UIKit
import DropDown

class NewDineInOrderVC: UIViewController {
    
    //MARK: IBOutlets
    @IBOutlet weak var txtName:UITextField!
    @IBOutlet weak var txtMobileNo:UITextField!
    @IBOutlet weak var txtEmailId:UITextField!
    @IBOutlet weak var txtNoOfGuest:UITextField!
    @IBOutlet weak var lblTableNo:UILabel!
    @IBOutlet weak var lblViewTitle:UILabel!
    @IBOutlet weak var btnNewsLetter:UIButton!
    @IBOutlet weak var btnDecrement:UIButton!
    @IBOutlet weak var btnIncrement:UIButton!
    @IBOutlet weak var viewForDecrement:UIView!
    @IBOutlet weak var viewForIncrement:UIView!
    
    //MARK: Instances
    var arrUserName = [String]()
    let userDropDown = DropDown()
    var arrCustomer = [CustomerModel]()
    var selectedCutomer:CustomerModel?
    let customerDropDown = DropDown()
    weak var delegate:NewOrderDelegate?
    var selectedTable:TableModel!
    var orderData:OrderModel?
    var noOfGuest = 1
    var viewType = NewOrderViewType.newOrder
    var orderType:OrderTypesModel?
    var isCustomerEditable = true
    
    //MARK:  ViewController LifeCycle
    override func viewDidLoad() {
        super.viewDidLoad()
        
        // Do any additional setup after loading the view.
        customerDropDown.dismissMode = .automatic
        customerDropDown.anchorView = txtName
        customerDropDown.bottomOffset = CGPoint(x: 0, y: txtName.bounds.height)
        // Action triggered on selection
        customerDropDown.selectionAction = { [weak self] (index, item) in
            self?.selectedCutomer = self?.arrCustomer[index]
            self?.view.endEditing(true)
            self?.setCustomerData()
        }
        lblTableNo.text = "Table No: \(selectedTable.number ?? "")"
        if viewType == .changeCustomer{
            btnNewsLetter.superview?.isHidden = true
            lblViewTitle.text = "Customer Info"
            txtNoOfGuest.text = "\(noOfGuest)"
            if orderData?.orderStatusId ?? 0 == 10 || orderData?.orderStatusId ?? 0 == 5 || orderData?.totalPaid ?? 0 > 0 || orderData?.orderStatusId ?? 0 == 4 || orderData?.orderStatusId ?? 0 == 6 || AppConstants.userData?.permissions?.customerInfo?.actions?.list ?? 0 == 0{
                isCustomerEditable = false
                btnIncrement.isHidden = true
                btnDecrement.isHidden = true
                viewForDecrement.isHidden = true
                viewForIncrement.isHidden = true
                txtName.isUserInteractionEnabled = false
                txtMobileNo.isUserInteractionEnabled = false
            }
        }
        self.setCustomerData()
    }
    
    //MARK: create viewcontroller instance
    class func showPopup(parentVC:UIViewController, table:TableModel, customer:CustomerModel? = nil, viewType:NewOrderViewType = .newOrder, orderType:OrderTypesModel? = nil, noOfDiner:Int = 1, orderData:OrderModel? = nil)->NewDineInOrderVC?{
        if let container = UIStoryboard.init(name: "Popups", bundle: nil).instantiateViewController(withIdentifier: "NewDineInOrderVC") as? NewDineInOrderVC{
            container.selectedTable = table
            container.viewType = viewType
            container.orderType = orderType
            container.noOfGuest = noOfDiner
            container.orderData = orderData
            container.selectedCutomer = customer
            parentVC.addChild(container)
            parentVC.view.addSubview(container.view)
            container.view.frame = CGRect.init(x: 0, y: 0, width: AppConstants.ScreenSize.SCREEN_WIDTH, height: AppConstants.ScreenSize.SCREEN_HEIGHT)
            container.view.alpha = 0.0
            UIView.animate(withDuration: 0.25) {
                container.view.alpha = 1.0
            }
            return container
        }
        return nil
    }
    
    //MARK:  General Methods
    func closePopup(){
        UIView.animate(withDuration: 0.25) {
            self.view.alpha = 0.0
        } completion: { (status) in
            self.view.removeFromSuperview()
            self.removeFromParent()
        }
    }
    
    func setCustomerData(){
        btnNewsLetter.isSelected = ((selectedCutomer?.newsLetter ?? 0) == 1)
        txtMobileNo.text = selectedCutomer?.mobile ?? ""
        txtName.text = selectedCutomer?.name ?? ""
        txtEmailId.text = selectedCutomer?.email ?? ""
    }
    
    func saveCustomer(){
        if selectedCutomer == nil{
            selectedCutomer = CustomerModel()
            selectedCutomer?.offline = 1
            selectedCutomer?.id = Date().millisecondsSince1970
            selectedCutomer?.uniqueId = "\(Int(Date().timeIntervalSinceReferenceDate))\(AppConstants.businessData?.id ?? 0)\(AppConstants.DeviceId)"
        }
        selectedCutomer?.newsLetter = (btnNewsLetter.isSelected) ? 1 : 0
        selectedCutomer?.name = txtName.text ?? ""
        selectedCutomer?.mobile = txtMobileNo.text ?? ""
        selectedCutomer?.email = txtEmailId.text ?? ""
        CoreDataHelper.shared.saveAndUpdateCusomer(customer: selectedCutomer!, offline: selectedCutomer?.offline ?? 1, updated: 1)
        UIView.animate(withDuration: 0.25) {
            self.view.alpha = 0.0
        } completion: { (status) in
            if self.delegate != nil{
                if self.viewType == .changeCustomer{
                    self.delegate?.requestForNewOrder(customer: self.selectedCutomer!, orderType: self.orderType, delivery: nil, table: nil, noOfGuest: self.noOfGuest)
                }else{
                    self.delegate?.requestForNewOrder(customer: self.selectedCutomer!, orderType: self.orderType, delivery: nil, table: self.selectedTable, noOfGuest: self.noOfGuest)
                }
            }
            self.view.removeFromSuperview()
            self.removeFromParent()
        }
    }
    
    //MARK:  Button Actions
    @IBAction func btnCancelAction(_ sender:UIButton){
        self.closePopup()
    }
    
    @IBAction func btnNewsLetterAction(_ sender:UIButton){
        sender.isSelected = !sender.isSelected
    }
    
    @IBAction func btnGuestChangeAction(_ sender:UIButton){
        if !isCustomerEditable{
            return
        }
        self.view.endEditing(true)
        if sender.tag == 0{
            if noOfGuest > 1{
                noOfGuest -= 1
            }
        }else{
            noOfGuest += 1
        }
        txtNoOfGuest.text = "\(noOfGuest)"
    }
    
    @IBAction func btnConfirmAction(_ sender:UIButton){
        self.view.endEditing(true)
        if !(txtEmailId.text?.trimmingCharacters(in: .whitespaces).isEmpty)!{
            if !AppValidation().isValidRegEx(txtEmailId.text ?? "", RegEx.email){
                AppValidation().showAlertView(parentVC: self, withAlertTile: AppConstants.GlobalAlert.ALERT_TITLE, withAlertMsg:  AppConstants.GlobalAlert.ALERT_ENTER_VALID_EMAIL, withActionsTitle: [AppConstants.GlobalAlert.ALERT_BTN_OK]) { (index) in
                    _ = self.txtEmailId.becomeFirstResponder()
                }
                return
            }
        }
        let guest = Int(txtNoOfGuest.text ?? "") ?? 0
        if guest == 0{
            AppValidation().showAlertView(parentVC: self, withAlertTile: AppConstants.GlobalAlert.ALERT_TITLE, withAlertMsg:  AppConstants.GlobalAlert.ALERT_GUEST_ZERO, withActionsTitle: [AppConstants.GlobalAlert.ALERT_BTN_OK]) { (index) in
                _ = self.txtNoOfGuest.becomeFirstResponder()
            }
            return
        }
        self.saveCustomer()
    }
    
    @IBAction func txtNameChanged(_ sender:UITextField){
        if AppCommonMethods.fetchSiteSettingValue(key: "customer_search_setting") ?? "" == "no"{
            return
        }
        if sender.text?.count ?? 0 > 2{
            NSObject.cancelPreviousPerformRequests(withTarget: self, selector: #selector(fetchCustomerOffline), object: nil)
            self.perform(#selector(fetchCustomerOffline), with: nil, afterDelay: 0.1)
        }else{
            self.customerDropDown.hide()
        }
    }
    
    //MARK: WebService Methods
    @objc func fetchCustomerOffline(){
        arrCustomer = CoreDataHelper.shared.fetchCustomerData(name: txtName.text ?? "")
        var arrCustomerName = [String]()
        self.arrCustomer.forEach { (model) in
            if model.mobile ?? "" != ""{
                arrCustomerName.append("\(model.name ?? "") (\(model.mobile ?? ""))")
            }else{
                arrCustomerName.append(model.name ?? "")
            }
        }
        self.customerDropDown.dataSource = arrCustomerName
        self.customerDropDown.show()
    }
}

//MARK:  UITextFieldDelegate
extension NewDineInOrderVC:UITextFieldDelegate{
    func textFieldShouldBeginEditing(_ textField: UITextField) -> Bool {
        return true
    }
    
    func textField(_ textField: UITextField, shouldChangeCharactersIn range: NSRange, replacementString string: String) -> Bool {
        if textField == txtMobileNo || textField == txtNoOfGuest{
            let allowedCharacters = CharacterSet(charactersIn:"0123456789")
            let characterSet = CharacterSet(charactersIn: string)
            if allowedCharacters.isSuperset(of: characterSet){
                if string == ""{
                    return true
                }
                let count = (textField.text ?? "").count
                if count >= 10{
                    return false
                }
                return true
            }
            return false
        }
        return true
    }
    
    func textFieldShouldReturn(_ textField: UITextField) -> Bool {
        return textField.resignFirstResponder()
    }
}
