//
//  FailedPrintVC.swift
//  EPOS
//
//  Created by Tushar Premal on 28/02/25.
//

import UIKit

class FailedPrintVC: UIViewController {

    @IBOutlet weak var txtMessage:UITextView!
    @IBOutlet weak var messageHeightConstraint:NSLayoutConstraint!
    
    var order:OrderModel!
    var dictProducts:[String:[OrderProductModel]]!
    
    override func viewDidLoad() {
        super.viewDidLoad()

        // Do any additional setup after loading the view.
        var message = ""
        PrintManager.shared.dictFailedProduct
            .compactMap { (key, values) -> (String, [String])? in
                guard let keyInt = Int(key),
                      let prepLoc = CoreDataHelper.shared.fetchPrepLocationData(id: keyInt) else {
                    return nil
                }
                
                let productDetails = values.map {
                    var name = $0.product?.shortName ?? ""
                    if name.isEmpty{
                        name = $0.product?.name ?? ""
                    }
                    return "\($0.quantity ?? 0)x \(name)"
                }
                
                return (prepLoc.name ?? "", productDetails)
            }
            .forEach { prepName, productLines in
                message.append("\(prepName):\n  \(productLines.joined(separator: "\n  "))\n")
            }

        txtMessage.text = message

        let height = message.getHeightFromString(
            font: AppConstants.GlobalFontConstants.kMediumFont(size: 22),
            width: 760
        )

        let maxAllowedHeight = UIScreen.main.bounds.height - 375
        messageHeightConstraint.constant = min(height, maxAllowedHeight)
        txtMessage.isScrollEnabled = height > maxAllowedHeight


    }
    

    //MARK: create viewcontroller instance
    static func showPopup(order:OrderModel, dictProducts:[String:[OrderProductModel]])->FailedPrintVC?{
        guard let VC = UIStoryboard.init(name: "Popups", bundle: nil).instantiateViewController(withIdentifier: "FailedPrintVC") as? FailedPrintVC else { return nil }
        VC.order = order
        VC.dictProducts = dictProducts
        if let topVC = UIApplication.topViewController(){
            topVC.addChild(VC)
            topVC.view.addSubview(VC.view)
            VC.view.alpha = 0
            UIView.animate(withDuration: 0.2) {
                VC.view.alpha = 1
            }
            VC.view.frame = topVC.view.bounds
            return VC
        }
        return nil
    }
    
    @IBAction func btnCloseAction(){
        self.removePopupview()
    }

    @IBAction func btnResendAction(){
        self.removePopupview()
        PrintManager.shared.connectToPrinterWithPrintOrder(order: order, dictProducts: dictProducts)
    }
}
