//
//  ChatCustomerInfoVC.swift
//  EPOS
//
//  Created by Apple on 26/08/21.
//

import UIKit
import SDWebImage
import MessageUI

class ChatCustomerInfoVC: UIViewController {

    //MARK:  IBOutlets
    @IBOutlet weak var lblCustomerEmail:UILabel!
    @IBOutlet weak var lblCustomerMobile:UILabel!
    @IBOutlet weak var lblChatTitle:UILabel!
    @IBOutlet weak var lblImgTag:UILabel!
    @IBOutlet weak var imgUserProfile:UIImageView!
    
    //MARK:  Instances
    var chatData:orderChatModel?
    var orderData:WebOrderModel?
    var phoneNumber = ""
        
    //MARK:  ViewController LifeCycle
    override func viewDidLoad() {
        super.viewDidLoad()

        // Do any additional setup after loading the view.
        var name = "\(chatData?.user?.firstName ?? "") \(chatData?.user?.lastName ?? "")"
        var imageURL = chatData?.user?.imageUrl ?? ""
        var email = chatData?.user?.username ?? ""
        phoneNumber = chatData?.user?.phoneNumber ?? ""
        if orderData != nil{
            name = orderData?.customerName ?? ""
            imageURL = orderData?.customerImage ?? ""
            email = orderData?.customerEmail ?? ""
            phoneNumber = orderData?.phone ?? ""
        }
        lblChatTitle.text = name
        self.imgUserProfile.isHidden = true
        self.lblImgTag.text = name.getFirstCharOfEachString()
        
        if imageURL != "", let url = URL.init(string: imageURL){
            self.imgUserProfile.isHidden = false
            self.lblImgTag.text = ""
            self.imgUserProfile.sd_setImage(with: url, placeholderImage: UIImage.init(named: "profile_placeholder"), options: .avoidDecodeImage) { image, error, type, url in
                if image == nil{
                    self.lblImgTag.text = name.getFirstCharOfEachString()
                }
            }
        }
        if phoneNumber == ""{
            lblCustomerMobile.superview?.isHidden = true
        }else{
            lblCustomerMobile.superview?.isHidden = false
            lblCustomerMobile.text = phoneNumber
        }
        if email == ""{
            lblCustomerEmail.superview?.isHidden = true
        }else{
            lblCustomerEmail.superview?.isHidden = false
            lblCustomerEmail.text = email
        }
    }
    
    //MARK: create viewcontroller instance
    class func showPopup(parentVC:UIViewController, chat:orderChatModel?,  order:WebOrderModel?)->ChatCustomerInfoVC?{
        if let container = UIStoryboard.init(name: "Popups", bundle: nil).instantiateViewController(withIdentifier: "ChatCustomerInfoVC") as? ChatCustomerInfoVC{
            container.chatData = chat
            container.orderData = order
            parentVC.addChild(container)
            parentVC.view.addSubview(container.view)
            container.view.frame = CGRect.init(x: 0, y: 0, width: AppConstants.ScreenSize.SCREEN_WIDTH, height: AppConstants.ScreenSize.SCREEN_HEIGHT)
            container.view.alpha = 0.0
            UIView.animate(withDuration: 0.25) {
                container.view.alpha = 1.0
            }
            return container
        }
        return nil
    }
    
    //MARK:  General Methods
    func closePopup(){
        UIView.animate(withDuration: 0.25) {
            self.view.alpha = 0.0
        } completion: { (status) in
            self.view.removeFromSuperview()
            self.removeFromParent()
        }
    }
    
    //MARK: Button Actions
    @IBAction func btnCloseAction(_ sender:UIButton){
        self.closePopup()
    }
    
    @IBAction func btnCallAction(_ sender:UIButton){
        if let url = URL(string: "tel://\(phoneNumber)") {
            if UIApplication.shared.canOpenURL(url){
                UIApplication.shared.open(url, options: [:], completionHandler: nil)
            }else{
                AppValidation().showAlertView(parentVC: self, withAlertTile: AppConstants.GlobalAlert.ALERT_TITLE, withAlertMsg: AppConstants.GlobalAlert.FailedCall, withActionsTitle: [AppConstants.GlobalAlert.ALERT_BTN_OK]) { (index) in

                }
            }
        }else{
            AppValidation().showAlertView(parentVC: self, withAlertTile: AppConstants.GlobalAlert.ALERT_TITLE, withAlertMsg: AppConstants.GlobalAlert.FailedCall, withActionsTitle: [AppConstants.GlobalAlert.ALERT_BTN_OK]) { (index) in

            }
        }
    }
    
    @IBAction func btnSendMessageAction(_ sender:UIButton){
        if MFMessageComposeViewController.canSendText() {
            let controller = MFMessageComposeViewController()
            controller.body = ""
            controller.recipients = [phoneNumber]
            controller.messageComposeDelegate = self
            self.present(controller, animated: true, completion: nil)
        }else{
            AppValidation().showAlertView(parentVC: self, withAlertTile: AppConstants.GlobalAlert.ALERT_TITLE, withAlertMsg: AppConstants.GlobalAlert.FailedSendMessage, withActionsTitle: [AppConstants.GlobalAlert.ALERT_BTN_OK]) { (index) in

            }
        }
    }
}

//MARK:  MFMessageComposeViewControllerDelegate
extension ChatCustomerInfoVC:MFMessageComposeViewControllerDelegate{
    func messageComposeViewController(_ controller: MFMessageComposeViewController, didFinishWith result: MessageComposeResult) {
        self.dismiss(animated: true, completion: nil)
    }
}
