//
//  ChangeThemeVC.swift
//  EPOS
//
//  Created by Tushar Premal on 11/06/25.
//

import UIKit

class ChangeThemeVC: UIViewController {

    override func viewDidLoad() {
        super.viewDidLoad()

        // Do any additional setup after loading the view.
    }
    
    //MARK: create ViewController Instance
    class func showPopup(parentVC:UIViewController)->ChangeThemeVC?{
        if let container = UIStoryboard.init(name: "Popups", bundle: nil).instantiateViewController(withIdentifier: "ChangeThemeVC") as? ChangeThemeVC{
            parentVC.addChild(container)
            parentVC.view.addSubview(container.view)
            container.view.frame = CGRect.init(x: 0, y: 0, width: AppConstants.ScreenSize.SCREEN_WIDTH, height: AppConstants.ScreenSize.SCREEN_HEIGHT)
            container.view.alpha = 0.0
            UIView.animate(withDuration: 0.25) {
                container.view.alpha = 1.0
            }
            return container
        }
        return nil
    }
    
    //MARK: General Methods
    func closePopup(){
        UIView.animate(withDuration: 0.25) {
            self.view.alpha = 0.0
        } completion: { (status) in
            self.view.removeFromSuperview()
            self.removeFromParent()
        }
    }
    
    //MARK: Button Actions
    @IBAction func btnTypeSelectionAction(_ sender:UIButton){
        changeThemeAPI(sender.tag)
    }
    
    @IBAction func btnCancelAction(_ sender:UIButton){
        closePopup()
    }
    
    func changeThemeAPI(_ theme: Int)  {
        if let id = AppCommonMethods.fetchSiteSettingId(key: "home_theme"){
            var dictParam = [String:Any]()
            switch theme{
            case 0:
                dictParam["value"] = "theme1"
            case 1:
                dictParam["value"] = "theme2"
            case 2:
                dictParam["value"] = "theme3"
            case 3:
                dictParam["value"] = "theme4"
            case 4:
                dictParam["value"] = "theme5"
            default:
                break
            }
            AppCommonMethods.startProgressBar()
            WebServiceManager().requestAPI(params: dictParam, urlString: "\(AppConstants.APIURL.kSiteSettings)/\(id)", method: "POST") { (message, result) in
                DispatchQueue.main.async {
                    if let response = result as? NSDictionary{
                        let jsonDecoder = JSONDecoder()
                        if let data = AppCommonMethods.convertToJson(object: response), let aData = try? jsonDecoder.decode(SiteSettingsModel.self, from: data){
                            if var arr = AppConstants.siteSettings{
                                if let index = arr.firstIndex(where: { $0.id ?? 0 == aData.id ?? 0 }){
                                    arr[index] = aData
                                    if let encoded = AppCommonMethods.getjsonDataFromCodable(object: arr) {
                                        AppCommonMethods.saveDataIntoUserDefault(value: encoded, withKey: AppConstants.userDefaultKey.kSiteSettings)
                                    }
                                    NotificationCenter.default.post(name: AppConstants.notifications.kDatabasePulled, object: nil)
                                    AppCommonMethods.stopProgressBar()
                                    self.closePopup()
                                    return
                                }else{
                                    AppCommonMethods.FetchSiteSettings { success in
                                        NotificationCenter.default.post(name: AppConstants.notifications.kDatabasePulled, object: nil)
                                        AppCommonMethods.stopProgressBar()
                                        self.closePopup()
                                    }
                                    return
                                }
                            }
                        }
                    }
                    AppCommonMethods.stopProgressBar()
                }
            }
        }
    }
}
