//
//  AlertViewController.swift
//  EPOS
//
//  Created by Apple on 12/04/21.
//

import UIKit
import Lottie

class AlertViewController: UIViewController {

    //MARK:  IBOutlets
    @IBOutlet weak var lblAlertTitle:UILabel!
    @IBOutlet weak var lblAlertMessage:UILabel!
    @IBOutlet weak var lblAlertBoldMessage:UILabel!
    @IBOutlet weak var txtAlertField:UITextField!
    @IBOutlet weak var btnConfirm:UIButton!
    @IBOutlet weak var btnCancel:UIButton!
    @IBOutlet weak var viewForAnimation:UIView!
    
    //MARK: Instances
    var alertSetting:AlertSetting!
    var delegate:AlertControllerDelegate?
    var animationview:LottieAnimationView?
    
    //MARK:  ViewController LifeCycle
    override func viewDidLoad() {
        super.viewDidLoad()

        // Do any additional setup after loading the view.
        lblAlertTitle.text = alertSetting.alertTitle
        if alertSetting.confirmTitle == ""{
            btnConfirm.isHidden = true
        }else{
            btnConfirm.setTitle(alertSetting.confirmTitle, for: .normal)
        }
        if alertSetting.cancelTitle == ""{
            btnCancel.isHidden = true
        }else{
            btnCancel.setTitle(alertSetting.cancelTitle, for: .normal)
        }
        btnConfirm.setTitleColor(alertSetting.confirmColor, for: .normal)
        btnCancel.setTitleColor(alertSetting.cancelColor, for: .normal)
        btnCancel.backgroundColor = alertSetting.cancelBGColor
        btnConfirm.backgroundColor = alertSetting.confirmBGColor
        if alertSetting.alertMessage == ""{
            lblAlertMessage.isHidden = true
        }else{
            lblAlertMessage.text = alertSetting.alertMessage
        }
        if alertSetting.alertBoldMessage == ""{
            lblAlertBoldMessage.isHidden = true
        }else{
            lblAlertBoldMessage.textColor = alertSetting.alertBoldMessageColor
            lblAlertBoldMessage.text = alertSetting.alertBoldMessage
        }
        if alertSetting.textPlcaeholder == ""{
            txtAlertField.isHidden = true
        }else{
            txtAlertField.text = alertSetting.textTitle
            txtAlertField.placeholder = "Enter \(alertSetting.textPlcaeholder)"
            txtAlertField.keyboardType = alertSetting.textType
            if alertSetting.type == .kEnterPassword || alertSetting.type == .kEnterAdminPassword || alertSetting.type == .kEnterUserPassword || alertSetting.type == .kEnterSupervisorPassword || alertSetting.type == .kEnterEPOSPassword{
                txtAlertField.isSecureTextEntry = true
            }
        }
        AddAnimation()
    }
    
    override func viewWillAppear(_ animated: Bool) {
        if animationview != nil{
            animationview!.play()
        }
    }
    
    //MARK: create viewcontroller instance
    class func showPopup(parentVC:UIViewController? = nil, setting:AlertSetting)->AlertViewController?{
        if let container = UIStoryboard.init(name: "Popups", bundle: nil).instantiateViewController(withIdentifier: "AlertViewController") as? AlertViewController{
            container.alertSetting = setting
            if parentVC != nil{
                if let NAVC = parentVC as? UINavigationController{
                    if let VC = NAVC.viewControllers.last{
                        VC.addChild(container)
                        VC.view.addSubview(container.view)
                    }
                }else{
                    parentVC!.addChild(container)
                    parentVC!.view.addSubview(container.view)
                }
            }else{
                AppConstants.appDelegate.window?.addSubview(container.view)
            }
            
            container.view.frame = CGRect.init(x: 0, y: 0, width: AppConstants.ScreenSize.SCREEN_WIDTH, height: AppConstants.ScreenSize.SCREEN_HEIGHT)
            container.view.alpha = 0.0
            
            UIView.animate(withDuration: 0.25) {
                container.view.alpha = 1.0
            }
            return container
        }
        return nil
    }
    
    //MARK:  General Methods
    func closePopup(){
        UIView.animate(withDuration: 0.25) {
            self.view.alpha = 0.0
        } completion: { (status) in
            self.view.removeFromSuperview()
            self.removeFromParent()
        }
    }
    
    func AddAnimation(){
        if alertSetting.alertAnimation != ""{
            viewForAnimation.superview?.isHidden = false
            animationview = LottieAnimationView(name: alertSetting.alertAnimation)
            animationview!.frame = CGRect(x: 0, y: 0, width: 600, height: 600)
            animationview!.contentMode = .scaleAspectFit
            viewForAnimation.addSubview(animationview!)
            animationview!.play()
            animationview!.loopMode = .loop
            if btnConfirm.isHidden{
                DispatchQueue.main.asyncAfter(deadline: .now()+2.5) {
                    self.btnConfirmAction(UIButton())
                }
            }
        }
    }
    
    func checkValidation()->Bool{
        if !txtAlertField.isHidden{
            if (txtAlertField.text ?? "").trimmingCharacters(in: .whitespacesAndNewlines).isEmpty{
                AppValidation().showAlertView(parentVC: self, withAlertTile: AppConstants.GlobalAlert.ALERT_TITLE, withAlertMsg: "Please enter \(alertSetting.textPlcaeholder)", withActionsTitle: [AppConstants.GlobalAlert.ALERT_BTN_OK]) { (index) in
                    
                }
                return false
            }
            if alertSetting.textType == .decimalPad || alertSetting.textType == .numberPad{
                if Double((txtAlertField.text ?? "").replacingOccurrences(of: AppConstants.currencySign, with: "")) ?? 0 == 0{
                    AppValidation().showAlertView(parentVC: self, withAlertTile: AppConstants.GlobalAlert.ALERT_TITLE, withAlertMsg: "\(alertSetting.textPlcaeholder) can not be zero", withActionsTitle: [AppConstants.GlobalAlert.ALERT_BTN_OK]) { (index) in
                        
                    }
                    return false
                }
            }
            if alertSetting.type == .kEnterUserPassword{
                if txtAlertField.text ?? "" != AppConstants.userData?.password ?? ""{
                    AppValidation().showAlertView(parentVC: self, withAlertTile: AppConstants.GlobalAlert.ALERT_TITLE, withAlertMsg: AppConstants.GlobalAlert.ALERT_INVALID_PASSWORD, withActionsTitle: [AppConstants.GlobalAlert.ALERT_BTN_OK]) { (index) in
                        
                    }
                    return false
                }
            }else if alertSetting.type == .kEnterPassword{
                if txtAlertField.text ?? "" == AppConstants.businessData?.adminPassword ?? "" || txtAlertField.text ?? "" == AppConstants.businessData?.supervisorPassword ?? ""{
                    
                }else{
                    AppValidation().showAlertView(parentVC: self, withAlertTile: AppConstants.GlobalAlert.ALERT_TITLE, withAlertMsg: AppConstants.GlobalAlert.ALERT_INVALID_PASSWORD, withActionsTitle: [AppConstants.GlobalAlert.ALERT_BTN_OK]) { (index) in
                        
                    }
                    return false
                }
            }else if alertSetting.type == .kEnterEPOSPassword{
                if txtAlertField.text ?? "" != AppConstants.adminData?.password ?? ""{
                    AppValidation().showAlertView(parentVC: self, withAlertTile: AppConstants.GlobalAlert.ALERT_TITLE, withAlertMsg: AppConstants.GlobalAlert.ALERT_INVALID_PASSWORD, withActionsTitle: [AppConstants.GlobalAlert.ALERT_BTN_OK]) { (index) in
                        
                    }
                    return false
                }
            }
        }
        return true
    }
    
    //MARK:  Button Actions
    @IBAction func btnCancelAction(_ sender:UIButton){
        self.closePopup()
        delegate?.alertButtonAction(index:0, data: alertViewData(value: ""),type:alertSetting.type)
    }
    
    @IBAction func btnConfirmAction(_ sender:UIButton){
        if checkValidation(){
            self.closePopup()
            let data = alertViewData.init(value: (txtAlertField.text ?? "").replacingOccurrences(of: AppConstants.currencySign, with: ""), orderId: alertSetting.orderId, orderTpe: alertSetting.orderTpe)
            delegate?.alertButtonAction(index:1, data: data,type:alertSetting.type)
        }
    }

}

//MARK:  UITextFieldDelegate
extension AlertViewController:UITextFieldDelegate{
    func textField(_ textField: UITextField, shouldChangeCharactersIn range: NSRange, replacementString string: String) -> Bool {
        if alertSetting.textType == .decimalPad || alertSetting.textType == .numberPad{
            let allowedCharacters = CharacterSet(charactersIn:"0123456789")
            let characterSet = CharacterSet(charactersIn: string)
            if allowedCharacters.isSuperset(of: characterSet){
                if alertSetting.type == .kEnterAmount{
                    if txtAlertField.text ?? "" == ""{
                        textField.text = "\(AppConstants.currencySign)0.00"
                    }
                    var strText = (textField.text!).replacingOccurrences(of: "\(AppConstants.currencySign)", with: "").replacingOccurrences(of: ".", with: "")
                    if string == ""{
                        if strText != "000"{
                            if strText.count == 3{
                                strText.removeLast()
                                strText = "0\(strText)"
                            }else{
                                strText.removeLast()
                            }
                            strText.insert(".", at: strText.index(strText.endIndex, offsetBy: -2))
                            textField.text = "\(AppConstants.currencySign)\(strText)"
                        }
                    }else{
                        if strText.first! == "0"{
                            strText.removeFirst()
                            strText = "\(strText)\(string)"
                        }else{
                            strText = "\(strText)\(string)"
                        }
                        strText.insert(".", at: strText.index(strText.endIndex, offsetBy: -2))
                        textField.text = "\(AppConstants.currencySign)\(strText)"
                    }
                    return false
                }else if alertSetting.type == .kEnterPercentage{
                    if txtAlertField.text ?? "" == ""{
                        textField.text = "0.00"
                    }
                    var strText = textField.text!.replacingOccurrences(of: ".", with: "")
                    if string == ""{
                        if strText != "000"{
                            if strText.count == 3{
                                strText.removeLast()
                                strText = "0\(strText)"
                            }else{
                                strText.removeLast()
                            }
                            strText.insert(".", at: strText.index(strText.endIndex, offsetBy: -2))
                            textField.text = "\(strText)"
                        }
                    }else{
                        if strText.first! == "0"{
                            strText.removeFirst()
                            strText = "\(strText)\(string)"
                        }else{
                            strText = "\(strText)\(string)"
                        }
                        strText.insert(".", at: strText.index(strText.endIndex, offsetBy: -2))
                        textField.text = "\(strText)"
                    }
                    return false
                }
            }
            return allowedCharacters.isSuperset(of: characterSet)
            
        }
        return true
    }
    
    func textFieldShouldReturn(_ textField: UITextField) -> Bool {
        return textField.resignFirstResponder()
    }
}
