//
//  AddCommentVC.swift
//  EPOS
//
//  Created by Apple on 06/05/21.
//

import UIKit

class AddCommentVC: UIViewController {

    //MARK:  IBOutlets
    @IBOutlet weak var txtComment:UITextView!
    @IBOutlet weak var lblPlaceholder:UILabel!
    @IBOutlet weak var lblCommentCount:UILabel!
    @IBOutlet weak var btnConfirm:UIButton!
    @IBOutlet weak var btnRemoveComment:UIButton!
    @IBOutlet weak var btnOrderType:UIButton!
    
    //MARK:  Instances
    var comment = ""
    weak var delegate:CommentDelegate?
    var isInstruction = false
    var parentVC:CreateOrderVC!
    
    //MARK:  ViewController LifeCycle
    override func viewDidLoad() {
        super.viewDidLoad()

        // Do any additional setup after loading the view.
        txtComment.text = comment
        if txtComment.text ?? "" == ""{
            lblPlaceholder.isHidden = false
            btnConfirm.backgroundColor = AppConstants.Colors.kAppThemeBGColor
            btnConfirm.isEnabled = false
        }else{
            lblPlaceholder.isHidden = true
            btnConfirm.backgroundColor = AppConstants.Colors.kAppMediumGreenColor
            btnConfirm.isEnabled = true
            btnRemoveComment.isHidden = false
            if !isInstruction{
                lblCommentCount.text = "\((txtComment.text ?? "").count)/300"
                btnConfirm.setTitle("Update", for: .normal)
            }
        }
        if btnOrderType != nil{
            btnOrderType.setTitle(" \(parentVC.orderType?.type ?? "") ", for: .normal)
        }
    }
    
    //MARK: create viewcontroller instance
    class func addContainer(parentVC:CreateOrderVC, comment:String)->AddCommentVC?{
        for view in parentVC.viewForDiscountContainer.subviews{
            view.removeFromSuperview()
        }
        
        if let container = UIStoryboard.init(name: "Popups", bundle: nil).instantiateViewController(withIdentifier: "AddCommentContainer") as? AddCommentVC{
            container.parentVC = parentVC
            container.comment = comment
            parentVC.addChild(container)
            parentVC.viewForDiscountContainer.addSubview(container.view)
            
            container.view.frame = CGRect.init(x: 0, y: 0, width: parentVC.viewForDiscountContainer.frame.width, height: parentVC.viewForDiscountContainer.frame.height)
            parentVC.viewForDiscountContainer.alpha = 1.0
            
            return container
        }
        return nil
    }
    
    class func showPopup(parentVC:UIViewController, comment:String)->AddCommentVC?{
        if let container = UIStoryboard.init(name: "Popups", bundle: nil).instantiateViewController(withIdentifier: "AddCommentVC") as? AddCommentVC{
            container.comment = comment
            container.isInstruction = true
            parentVC.addChild(container)
            parentVC.view.addSubview(container.view)
            
            container.view.frame = CGRect.init(x: 0, y: 0, width: AppConstants.ScreenSize.SCREEN_WIDTH, height: AppConstants.ScreenSize.SCREEN_HEIGHT)
            container.view.alpha = 0.0
            
            UIView.animate(withDuration: 0.25) {
                container.view.alpha = 1.0
            }
            return container
        }
        return nil
    }
    
    //MARK:  General Methods
    func closePopup(){
        if isInstruction{
            UIView.animate(withDuration: 0.25) {
                self.view.alpha = 0.0
            } completion: { (status) in
                self.view.removeFromSuperview()
                self.removeFromParent()
            }
        }else{
            parentVC.viewForDiscountContainer.alpha = 0.0
            self.view.removeFromSuperview()
            self.removeFromParent()
        }
    }
    
    //MARK:  Button Actions
    @IBAction func btnCancelAction(_ sender:UIButton){
        if self.delegate != nil{
            self.delegate!.cancelClicked()
        }
        self.closePopup()
    }
    
    @IBAction func btnConfirmAction(_ sender:UIButton){
        if self.delegate != nil{
            self.delegate!.commentAdded(comment: txtComment.text ?? "")
        }
        self.closePopup()
    }
    
    @IBAction func btnRemoveCommentAction(_ sender:UIButton){
        if self.delegate != nil{
            self.delegate!.commentAdded(comment: "")
        }
        self.closePopup()
    }
}

//MARK:  UITextViewDelegate
extension AddCommentVC:UITextViewDelegate{
    func textViewDidChange(_ textView: UITextView) {
        if textView.text ?? "" == ""{
            lblPlaceholder.isHidden = false
            btnConfirm.backgroundColor = AppConstants.Colors.kAppThemeBGColor
            btnConfirm.isEnabled = false
        }else{
            lblPlaceholder.isHidden = true
            btnConfirm.backgroundColor = AppConstants.Colors.kAppMediumGreenColor
            btnConfirm.isEnabled = true
        }
        if !isInstruction{
            lblCommentCount.text = "\((txtComment.text ?? "").count)/300"
        }
    }
    
    func textView(_ textView: UITextView, shouldChangeTextIn range: NSRange, replacementText text: String) -> Bool {
        if !isInstruction{
            if text == ""{
                return true
            }
            if (textView.text ?? "").count >= 300{
                return false
            }
        }
        return true
    }
}
