//
//  TransactionVC.swift
//  EPOS
//
//  Created by Apple on 29/05/21.
//

import UIKit
import BetterSegmentedControl
import ActionSheetPicker_3_0

class TransactionVC: UIViewController {
    
    //MARK: IBOutlet
    @IBOutlet weak var viewForCustomDate:UIView!
    @IBOutlet weak var txtFromDate:UITextField!
    @IBOutlet weak var txtToDate:UITextField!
    @IBOutlet weak var lblTitle:UILabel!
    @IBOutlet weak var btnArchieve:UIButton!
    @IBOutlet weak var btnBack:UIButton!
    @IBOutlet weak var btnSelect:UIButton!
    @IBOutlet weak var segementTime:BetterSegmentedControl!
    @IBOutlet weak var viewForBG:UIViewX!
    @IBOutlet weak var lblTotalTransaction:UILabel!
    @IBOutlet weak var tblTransactions:UITableView!
    @IBOutlet weak var constTransactionBottomSpace:NSLayoutConstraint!
    
    //MARK: Instances
    var fromDate = Date()
    var toDate = Date()
    var selectedPayment:PaymentCellData!
    var dictTransaction = [String:[Any]]()
    var dictStatement = [String:[StatementModel]]()
    var dictLinks = [String:[PaymentLinkModel]]()
    var arrDates = [String]()
    var arrSelectedPaypalTranscation = [Int]()
    var arrSelectedMerchantTranscation = [Int]()
    var arrSelectedOrderTranscation = [Int]()
    var isTransactionSelected = false
    var selectedTransaction:Any!
    var refundedAmount:Double?
    var parentVC:PaymentMainVC!
    
    //MARK: ViewController LifeCycle
    override func viewDidLoad() {
        super.viewDidLoad()
        
        // Do any additional setup after loading the view.
        
        viewForCustomDate.isHidden = true
        lblTitle.text = selectedPayment.title
        
        self.segementTime.segments = LabelSegment.segments(withTitles: ["Today","This week","This month","Custom"], normalBackgroundColor: .white, normalFont: AppConstants.GlobalFontConstants.kBoldFont(size: 14), normalTextColor: AppConstants.Colors.kAppDarkGrayColor, selectedBackgroundColor: AppConstants.Colors.kAppThemeAquaColor , selectedFont: AppConstants.GlobalFontConstants.kBoldFont(size: 14), selectedTextColor: .white)
        
        if selectedPayment.type == .kArchive{
            btnArchieve.setTitle("Unarchieve", for: .normal)
        }else{
            btnArchieve.setTitle("Archive", for: .normal)
        }
        
        btnSelect.isHidden = true
        if selectedPayment.type == .kPaymentSMS{
            btnBack.isHidden = false
            self.lblTitle.text = "Payment Links"
        }
        if selectedPayment.type == .QRCode{
            btnBack.isHidden = false
        }
        
        if selectedPayment.type == .kTransaction || selectedPayment.type == .kRefundTransaction || selectedPayment.type == .kArchive{
            if AppConstants.isSupervisorLogin{
                if AppConstants.businessData?.supervisorPermissions?.archive ?? 0 == 1{
                    btnSelect.isHidden = false
                }
            }else if AppConstants.isAdminLogin{
                if AppConstants.businessData?.adminPermissions?.archive ?? 0 == 1{
                    btnSelect.isHidden = false
                }
            }
//            segementTime.superview?.isHidden = true
            self.segementTime.segments = LabelSegment.segments(withTitles: [Date().getDateInString(format: "  dd/MM/yy  "),Date().addingTimeInterval(-24*60*60).getDateInString(format: "  dd/MM/yy  "),Date().addingTimeInterval(-2*24*60*60).getDateInString(format: "  dd/MM/yy  "),Date().addingTimeInterval(-3*24*60*60).getDateInString(format: "  dd/MM/yy  ")], normalBackgroundColor: .white, normalFont: AppConstants.GlobalFontConstants.kBoldFont(size: 14), normalTextColor: AppConstants.Colors.kAppDarkGrayColor, selectedBackgroundColor: AppConstants.Colors.kAppThemeAquaColor , selectedFont: AppConstants.GlobalFontConstants.kBoldFont(size: 14), selectedTextColor: .white)
        }
        
        FetchTransactionData()
    }
    
    //MARK: Create ViewController Instance
    static func addToParentView(parentVC:PaymentMainVC,selectedPayment:PaymentCellData)->TransactionVC?{
        guard let VC = UIStoryboard.init(name: "Payments", bundle: nil).instantiateViewController(withIdentifier: "TransactionVC") as? TransactionVC else {
            return nil
        }
        VC.parentVC = parentVC
        VC.selectedPayment = selectedPayment
        parentVC.addChild(VC)
        parentVC.viewForContainer.addSubview(VC.view)
        VC.view.frame = CGRect.init(x: 0, y: 10, width: parentVC.viewForContainer.frame.width, height: parentVC.viewForContainer.frame.height-20)
        return VC
    }
    
    //MARK: Button Actions
    @IBAction func segmentValueChanged(_ sender:Any){
        viewForCustomDate.isHidden = true
        if selectedPayment.type == .kTransaction || selectedPayment.type == .kRefundTransaction || selectedPayment.type == .kArchive{
            if segementTime.index == 0{
                fromDate = Date()
                toDate = Date()
            }else if segementTime.index == 1{
                fromDate = Date().addingTimeInterval(-24*60*60)
                toDate = Date().addingTimeInterval(-24*60*60)
            }else if segementTime.index == 2{
                fromDate = Date().addingTimeInterval(-2*24*60*60)
                toDate = Date().addingTimeInterval(-2*24*60*60)
            }else{
                fromDate = Date().addingTimeInterval(-3*24*60*60)
                toDate = Date().addingTimeInterval(-3*24*60*60)
            }
        }else{
            if segementTime.index == 0{
                fromDate = Date().startOfDate() ?? Date()
                toDate = Date().endOfDate() ?? Date()
            }else if segementTime.index == 1{
                fromDate = Date().startOfWeek() ?? Date()
                toDate = Date().endOfWeek() ?? Date()
            }else if segementTime.index == 2{
                fromDate = Date().startOfMonth()
                toDate = Date().endOfMonth()
            }else{
                viewForCustomDate.isHidden = false
                txtToDate.text = "To - \(self.toDate.getDateInString(format: "dd/MM/yyyy"))"
                txtFromDate.text = "From - \(self.fromDate.getDateInString(format: "dd/MM/yyyy"))"
            }
        }
        
        FetchTransactionData()
    }
    
    @IBAction func btnBackAction(_ sender:Any){
        self.view.removeFromSuperview()
        self.removeFromParent()
    }
    
    @IBAction func btnDownloadStatementAction(_ sender:UIButton){
        downloadTransaction(statement: dictStatement[arrDates[Int(sender.accessibilityIdentifier ?? "") ?? 0]]![sender.tag])
    }
    
    @IBAction func btnViewStatementAction(_ sender:UIButton){
        if let VC = WebViewVC.instance(){
            let statement = dictStatement[arrDates[Int(sender.accessibilityIdentifier ?? "") ?? 0]]![sender.tag]
            VC.strURL = "\(AppConstants.APIURL.kMerchantBusiness)\(AppConstants.businessData?.id ?? 0)/statements/\(statement.id ?? 0)/download"
            self.navigationController?.pushViewController(VC, animated: true)
        }
    }
    
    @IBAction func btnSelectAction(_ sender:UIButton){
        isTransactionSelected = !isTransactionSelected
        if isTransactionSelected{
            constTransactionBottomSpace.constant = 100
            lblTotalTransaction.superview?.superview?.isHidden = false
        }else{
            constTransactionBottomSpace.constant = 0
            lblTotalTransaction.superview?.superview?.isHidden = true
        }
        arrSelectedOrderTranscation.removeAll()
        arrSelectedPaypalTranscation.removeAll()
        arrSelectedMerchantTranscation.removeAll()
        self.tblTransactions.reloadData()
    }
    
    @IBAction func btnCancelArchieveAction(_ sender:UIButton){
        isTransactionSelected = false
        constTransactionBottomSpace.constant = 0
        lblTotalTransaction.superview?.superview?.isHidden = true
        arrSelectedOrderTranscation.removeAll()
        arrSelectedPaypalTranscation.removeAll()
        arrSelectedMerchantTranscation.removeAll()
        self.tblTransactions.reloadData()
    }
    
    @IBAction func btnResendLinkAction(_ sender:UIButton){
        let model = dictLinks["\(arrDates[Int(sender.accessibilityIdentifier ?? "") ?? 0])"]![sender.tag]
        sendPaymentLinkList(id: model.id ?? 0)
    }
    
    @IBAction func btnArchieveAction(_ sender:UIButton){
        if (arrSelectedOrderTranscation.count + arrSelectedPaypalTranscation.count + arrSelectedMerchantTranscation.count) == 0{
            AppValidation().showAlertView(parentVC: self, withAlertTile: AppConstants.GlobalAlert.ALERT_TITLE, withAlertMsg: (selectedPayment.type == .kArchive) ? "Please select transaction to unarchive" : "Please select transaction to archive", withActionsTitle: [AppConstants.GlobalAlert.ALERT_BTN_OK]) { (index) in
                
            }
            return
        }
        var setting = AlertSetting()
        if selectedPayment.type == .kArchive{
            setting.alertMessage = AppConstants.GlobalAlert.ALERT_TRANSACTION_UNARCHIVE
        }else{
            setting.alertMessage = AppConstants.GlobalAlert.ALERT_TRANSACTION_ARCHIVE
        }
        refundedAmount = nil
        if let VC = AlertViewController.showPopup(parentVC: self.parentVC.parentVC, setting: setting){
            VC.delegate = self
        }
    }
    
    @IBAction func btnRefundAction(_ sender:UIButton){
        selectedTransaction = dictTransaction[arrDates[Int(sender.accessibilityIdentifier ?? "") ?? 0]]![sender.tag]
        var setting = AlertSetting()
        setting.alertTitle = AppConstants.GlobalAlert.ALERT_ENTER_AMOUNT
        setting.alertMessage = AppConstants.GlobalAlert.ALERT_ENTER_REFUNDAMOUNT
        setting.cancelBGColor = AppConstants.Colors.kAppMediumGrayColor
        setting.confirmBGColor = AppConstants.Colors.kAppDarkGrayColor
        setting.type = .kEnterAmount
        setting.textPlcaeholder = "amount"
        if let model = selectedTransaction as? TransactionModel{
            setting.textTitle = String.init(format: "%@%.2f", AppConstants.currencySign,Double(model.amount ?? 0)/100)
        }else if let model = selectedTransaction as? PaypalTransactionModel{
            setting.textTitle = String.init(format: "%@%.2f", AppConstants.currencySign,model.transactionAmount ?? 0)
        }
        if let VC = AlertViewController.showPopup(parentVC: self.parentVC.parentVC, setting: setting){
            VC.delegate = self
        }
    }
    
    @IBAction func btnReprintAction(_ sender:UIButton){
        if let transaction = dictTransaction[arrDates[Int(sender.accessibilityIdentifier ?? "") ?? 0]]?[sender.tag] as? TransactionModel{
            PrintManager.shared.cardBrand = transaction.cardBrand ?? ""
            PrintManager.shared.cardNumber = transaction.cardNumber ?? ""
            PrintManager.shared.isCustomerCopy = false
            PrintManager.shared.TID = transaction.txnId ?? ""
            PrintManager.shared.amount = Double(transaction.amount ?? 0)/100
            if transaction.type ?? "" == "refund"{
                PrintManager.shared.status = "Refunded"
            }else{
                PrintManager.shared.status = "Approved"
            }
            PrintManager.shared.tipAmount = 0
            PrintManager.shared.entryMode = "MOTO"
            PrintManager.shared.isReprint = true
            PrintManager.shared.connectToPrinterWithPrint(model: AppConstants.businessData!, controller: self)
        }
    }
    
    //MARK: General Methods
    func sortTransactions(arr:[Any]){
        if segementTime.index == 3 || selectedPayment.type == .kArchive || selectedPayment.type == .kRefundTransaction || selectedPayment.type == .kTransaction{
            arr.forEach { model in
                if let model = model as? TransactionModel{
                    let date = Date.init(timeIntervalSince1970: Double(model.created ?? "") ?? 0)
                    let strDate = date.getDateInString(format: "d'\(date.getDateSuffix())' MMMM yyyy")
                    if var arr = dictTransaction[strDate]{
                        arr.append(model)
                        dictTransaction[strDate] = arr
                    }else{
                        arrDates.append(strDate)
                        dictTransaction[strDate] = [model]
                    }
                }else if let order = model as? WebOrderModel{
                    let date = ((order.orderDate ?? "").components(separatedBy: " ").first ?? "").getDateFromString(format: "yyyy-MM-dd") ?? Date()
                    let strDate = date.getDateInString(format: "d'\(date.getDateSuffix())' MMMM yyyy")
                    if var arr = dictTransaction[strDate]{
                        arr.append(order)
                        dictTransaction[strDate] = arr
                    }else{
                        arrDates.append(strDate)
                        dictTransaction[strDate] = [order]
                    }
                }else if let order = model as? PaypalTransactionModel{
                    let saleCreatedAt = (order.saleCreatedAt ?? "").replacingOccurrences(of: "Z", with: "")
                    let date = saleCreatedAt.getDateFromString(format: "yyyy-MM-dd'T'HH:mm:ss") ?? Date()
                    let strDate = date.getDateInString(format: "d'\(date.getDateSuffix())' MMMM yyyy")
                    if var arr = dictTransaction[strDate]{
                        arr.append(order)
                        dictTransaction[strDate] = arr
                    }else{
                        arrDates.append(strDate)
                        dictTransaction[strDate] = [order]
                    }
                }else if let model = model as? StatementModel{
                    let date = ((model.toDate ?? "").components(separatedBy: " ").first ?? "").getDateFromString(format: "yyyy-MM-dd") ?? Date()
                    let strDate = date.getDateInString(format: "d'\(date.getDateSuffix())' MMMM yyyy")
                    if var arr = dictStatement[strDate]{
                        arr.append(model)
                        dictStatement[strDate] = arr
                    }else{
                        arrDates.append(strDate)
                        dictStatement[strDate] = [model]
                    }
                }else if let model = model as? PaymentLinkModel{
                    let date = ((model.created ?? "").components(separatedBy: "T").first ?? "").getDateFromString(format: "yyyy-MM-dd") ?? Date()
                    let strDate = date.getDateInString(format: "d'\(date.getDateSuffix())' MMMM yyyy")
                    if var arr = dictLinks[strDate]{
                        arr.append(model)
                        dictLinks[strDate] = arr
                    }else{
                        arrDates.append(strDate)
                        dictLinks[strDate] = [model]
                    }
                }
            }
        } else if segementTime.index == 1{
            fromDate = Date().startOfWeek() ?? Date()
            toDate = Date().endOfWeek() ?? Date()
            arr.forEach { model in
                if let model = model as? TransactionModel{
                    let date = Date.init(timeIntervalSince1970: Double(model.created ?? "") ?? 0)
                    let strDate = date.getDateInString(format: "d'\(date.getDateSuffix())' MMMM yyyy")
                    if var arr = dictTransaction[strDate]{
                        arr.append(model)
                        dictTransaction[strDate] = arr
                    }else{
                        arrDates.append(strDate)
                        dictTransaction[strDate] = [model]
                    }
                }else if let order = model as? WebOrderModel{
                    let date = ((order.orderDate ?? "").components(separatedBy: " ").first ?? "").getDateFromString(format: "yyyy-MM-dd") ?? Date()
                    let strDate = date.getDateInString(format: "d'\(date.getDateSuffix())' MMMM yyyy")
                    if var arr = dictTransaction[strDate]{
                        arr.append(order)
                        dictTransaction[strDate] = arr
                    }else{
                        arrDates.append(strDate)
                        dictTransaction[strDate] = [order]
                    }
                }else if let order = model as? PaypalTransactionModel{
                    let saleCreatedAt = (order.saleCreatedAt ?? "").replacingOccurrences(of: "Z", with: "")
                    let date = saleCreatedAt.getDateFromString(format: "yyyy-MM-dd'T'HH:mm:ss") ?? Date()
                    let strDate = date.getDateInString(format: "d'\(date.getDateSuffix())' MMMM yyyy")
                    if var arr = dictTransaction[strDate]{
                        arr.append(order)
                        dictTransaction[strDate] = arr
                    }else{
                        arrDates.append(strDate)
                        dictTransaction[strDate] = [order]
                    }
                }else if let model = model as? StatementModel{
                    let date = ((model.toDate ?? "").components(separatedBy: " ").first ?? "").getDateFromString(format: "yyyy-MM-dd") ?? Date()
                    let strDate = date.getDateInString(format: "d'\(date.getDateSuffix())' MMMM yyyy")
                    if var arr = dictStatement[strDate]{
                        arr.append(model)
                        dictStatement[strDate] = arr
                    }else{
                        arrDates.append(strDate)
                        dictStatement[strDate] = [model]
                    }
                }else if let model = model as? PaymentLinkModel{
                    let date = ((model.created ?? "").components(separatedBy: "T").first ?? "").getDateFromString(format: "yyyy-MM-dd") ?? Date()
                    let strDate = date.getDateInString(format: "d'\(date.getDateSuffix())' MMMM yyyy")
                    if var arr = dictLinks[strDate]{
                        arr.append(model)
                        dictLinks[strDate] = arr
                    }else{
                        arrDates.append(strDate)
                        dictLinks[strDate] = [model]
                    }
                }
            }
        }else if segementTime.index == 2{
            fromDate = Date().startOfMonth()
            toDate = Date().endOfMonth()
            let arrDate = Date.datesAtInterVal(fromDate: fromDate, toDate: toDate, duration: 7)
            arrDate.forEach { date in
                var date2 = date.addingTimeInterval(604799)
                if date2 > toDate{
                    date2 = toDate
                }
                if let arr = arr as? [StatementModel]{
                    let arrO = arr.filter { (model) -> Bool in
                        let Ddate = ((model.toDate ?? "").components(separatedBy: " ").first ?? "").getDateFromString(format: "yyyy-MM-dd") ?? Date()
                        if Ddate >= date && Ddate < date2{
                            return true
                        }
                        return false
                    }
                    self.arrDates.append("\(date.getDateInString(format: "dd/MM/yyyy")) - \(date2.getDateInString(format: "dd/MM/yyyy"))")
                    dictStatement["\(date.getDateInString(format: "dd/MM/yyyy")) - \(date2.getDateInString(format: "dd/MM/yyyy"))"] = arrO
                }else if let arr = arr as? [PaymentLinkModel]{
                    let arrO = arr.filter { (model) -> Bool in
                        let Ddate = ((model.created ?? "").components(separatedBy: "T").first ?? "").getDateFromString(format: "yyyy-MM-dd") ?? Date()
                        if Ddate >= date && Ddate < date2{
                            return true
                        }
                        return false
                    }
                    self.arrDates.append("\(date.getDateInString(format: "dd/MM/yyyy")) - \(date2.getDateInString(format: "dd/MM/yyyy"))")
                    dictLinks["\(date.getDateInString(format: "dd/MM/yyyy")) - \(date2.getDateInString(format: "dd/MM/yyyy"))"] = arrO
                }else{
                    let arrO = arr.filter { (model) -> Bool in
                        var Ddate = Date()
                        if let transaction = model as? TransactionModel{
                            Ddate = Date.init(timeIntervalSince1970: Double(transaction.created ?? "") ?? 0)
                        }else if let order = model as? WebOrderModel{
                            Ddate = ((order.orderDate ?? "").components(separatedBy: " ").first ?? "").getDateFromString(format: "yyyy-MM-dd") ?? Date()
                        }else if let model = model as? PaymentLinkModel{
                            Ddate = ((model.created ?? "").components(separatedBy: "T").first ?? "").getDateFromString(format: "yyyy-MM-dd") ?? Date()
                        }
                        if Ddate >= date && Ddate < date2{
                            return true
                        }
                        return false
                    }
                    self.arrDates.append("\(date.getDateInString(format: "dd/MM/yyyy")) - \(date2.getDateInString(format: "dd/MM/yyyy"))")
                    dictTransaction["\(date.getDateInString(format: "dd/MM/yyyy")) - \(date2.getDateInString(format: "dd/MM/yyyy"))"] = arrO
                }
            }
        }else{
            fromDate = Date().startOfDate() ?? Date()
            toDate = Date().endOfDate() ?? Date()
            if let arr = arr as? [StatementModel]{
                dictStatement[Date().getDateInString(format: "d'\(Date().getDateSuffix())' MMMM yyyy")] = arr
            }else if let arr = arr as? [PaymentLinkModel]{
                dictLinks[Date().getDateInString(format: "d'\(Date().getDateSuffix())' MMMM yyyy")] = arr
            }else{
                dictTransaction[Date().getDateInString(format: "d'\(Date().getDateSuffix())' MMMM yyyy")] = arr
            }
            arrDates.append(Date().getDateInString(format: "d'\(Date().getDateSuffix())' MMMM yyyy"))
        }
        if segementTime.index != 2{
            arrDates.sort { (str1, str2) -> Bool in
                let date1 = str1.removeDateSuffix().getDateFromString(format: "d MMMM yyyy") ?? Date()
                let date2 = str2.removeDateSuffix().getDateFromString(format: "d MMMM yyyy") ?? Date()
                return date2 < date1
            }
        }else{
            arrDates.sort { (str1, str2) -> Bool in
                let date1 = (str1.components(separatedBy: " - ").first ?? "").removeDateSuffix().getDateFromString(format: "d MMMM yyyy") ?? Date()
                let date2 = (str2.components(separatedBy: " - ").first ?? "").removeDateSuffix().getDateFromString(format: "d MMMM yyyy") ?? Date()
                return date2 < date1
            }
        }
        self.tblTransactions.reloadData()
    }
    
    //MARK: WebService Methods
    func sendPaymentLinkList(id:Int){
        let dictParam = [String:Any]()
        
        AppCommonMethods.startProgressBar()
        WebServiceManager().requestAPI(params: dictParam, urlString: "\(AppConstants.APIURL.kPaymentMessage)\(id)/resend", method: "POST") { (message, response) in
            DispatchQueue.main.async {
                AppCommonMethods.stopProgressBar()
                let jsonDecoder = JSONDecoder()
                if let result = response as? NSDictionary, let data = AppCommonMethods.convertToJson(object: result), let _ = try? jsonDecoder.decode(PaymentLinkModel.self, from: data){
                    var setting = BottomAlertSettings()
                    setting.strMessage = AppConstants.GlobalAlert.ALERT_PAYMENTLINK_SEND
                    AppValidation().showBottomAlertView(settings: setting)
                }else{
                    AppValidation().showAlertView(parentVC: self, withAlertTile: AppConstants.GlobalAlert.ALERT_TITLE, withAlertMsg: message, withActionsTitle: [AppConstants.GlobalAlert.ALERT_BTN_OK]) { (index) in
                        
                    }
                }
            }
        }
    }
    
    func FetchTransactionData(){
        var dictParam = [String:Any]()
        var strURL = "\(AppConstants.APIURL.kMerchantBusiness)\(AppConstants.businessData?.id ?? 0)/all-transactions"
        if selectedPayment.type == .kArchive{
            dictParam["filter"] = "archived"
        }else if selectedPayment.type == .kRefundTransaction{
            dictParam["filter"] = "refunded"
        }else if selectedPayment.type == .kStatement{
            strURL = "\(AppConstants.APIURL.kMerchantBusiness)\(AppConstants.businessData?.id ?? 0)/statements"
        }else if selectedPayment.type == .kPaymentSMS || selectedPayment.type == .QRCode{
            strURL = AppConstants.APIURL.kPaymentMessage
            dictParam["qr"] = selectedPayment.type == .QRCode ? 1 : 0
        }
        dictParam["from_date"] = fromDate.getDateInString(format: "yyyy-MM-dd")
        dictParam["to_date"] = toDate.getDateInString(format: "yyyy-MM-dd")
        dictParam["nopaginate"] = "1"
        AppCommonMethods.startProgressBar()
        WebServiceManager().requestAPI(params: dictParam, urlString: strURL, method: "GET") { (message, result) in
            DispatchQueue.main.async {
                AppCommonMethods.stopProgressBar()
                self.dictTransaction.removeAll()
                self.arrDates.removeAll()
                let jsonDecoder = JSONDecoder()
                if self.selectedPayment.type == .kStatement{
                    if let response = result as? [NSDictionary], let data = AppCommonMethods.convertToJson(object: response), let aData = try? jsonDecoder.decode([StatementModel].self, from: data){
                        self.sortTransactions(arr: aData)
                        return
                    }
                }else if self.selectedPayment.type == .kPaymentSMS || self.selectedPayment.type == .QRCode{
                    if let response = result as? [NSDictionary], let data = AppCommonMethods.convertToJson(object: response), let aData = try? jsonDecoder.decode([PaymentLinkModel].self, from: data){
                        self.sortTransactions(arr: aData)
                        return
                    }
                }else{
                    if let response = result as? NSDictionary{
                        var arrT = [Any]()
                        if let arr = response["card_transactions"] as? [NSDictionary], let data = AppCommonMethods.convertToJson(object: arr), let aData = try? jsonDecoder.decode([TransactionModel].self, from: data){
                            arrT = aData
                        }
                        if let arr = response["order_transactions"] as? [NSDictionary], let data = AppCommonMethods.convertToJson(object: arr), let aData = try? jsonDecoder.decode([WebOrderModel].self, from: data){
                            let arr = aData.filter { model in
                                return (model.orderStatus ?? "").lowercased() != "failed"
                            }
                            arrT.append(contentsOf: arr)
                        }
                        if let arr = response["paypal_transactions"] as? [NSDictionary], let data = AppCommonMethods.convertToJson(object: arr), let aData = try? jsonDecoder.decode([PaypalTransactionModel].self, from: data){
                            arrT.append(contentsOf: aData)
                        }
                        arrT.sort { model1, model2 in
                            var date1 = Date()
                            var date2 = Date()
                            if let transaction = model1 as? TransactionModel{
                                if transaction.transactionDateTime ?? "" != ""{
                                    date1 = (transaction.transactionDateTime ?? "").getDateFromString(format: "yyyy-MM-dd HH:mm:ss") ?? Date()
                                }else{
                                    date1 = Date.init(timeIntervalSince1970: Double(transaction.created ?? "") ?? 0)
                                }
                            }else if let transaction = model1 as? PaypalTransactionModel{
                                let date = (transaction.saleCreatedAt ?? "").replacingOccurrences(of: "Z", with: "")
                                date1 = date.getDateFromString(format: "yyyy-MM-dd'T'HH:mm:ss") ?? Date()
                            }else if let transaction = model1 as? WebOrderModel{
                                date1 = (transaction.orderDate ?? "").getDateFromString(format: "yyyy-MM-dd HH:mm:ss") ?? Date()
                            }
                            
                            if let transaction = model2 as? TransactionModel{
                                if transaction.transactionDateTime ?? "" != ""{
                                    date2 = (transaction.transactionDateTime ?? "").getDateFromString(format: "yyyy-MM-dd HH:mm:ss") ?? Date()
                                }else{
                                    date2 = Date.init(timeIntervalSince1970: Double(transaction.created ?? "") ?? 0)
                                }
                            }else if let transaction = model2 as? PaypalTransactionModel{
                                let date = (transaction.saleCreatedAt ?? "").replacingOccurrences(of: "Z", with: "")
                                date1 = date.getDateFromString(format: "yyyy-MM-dd'T'HH:mm:ss") ?? Date()
                            }else if let transaction = model2 as? WebOrderModel{
                                date1 = (transaction.orderDate ?? "").getDateFromString(format: "yyyy-MM-dd HH:mm:ss") ?? Date()
                            }
                            return date2 < date1
                        }
                        self.sortTransactions(arr: arrT)
                        return
                    }
                }
                self.tblTransactions.reloadData()
                AppValidation().showAlertView(parentVC: self, withAlertTile: AppConstants.GlobalAlert.ALERT_TITLE, withAlertMsg: message, withActionsTitle: [AppConstants.GlobalAlert.ALERT_BTN_OK]) { (index) in
                    
                }
            }
        }
    }
    
    func downloadTransaction(statement:StatementModel){
        let fileName = "Statement_\(statement.toDate ?? "").pdf"
        let documentsUrl =  FileManager.default.urls(for: .documentDirectory, in: .userDomainMask).first!
        let destinationFileUrl = documentsUrl.appendingPathComponent("\(fileName)")
        
        if FileManager.default.fileExists(atPath: destinationFileUrl.path){
            if let VC = WebViewVC.instance(){
                VC.strURL = destinationFileUrl.absoluteString
                self.navigationController?.pushViewController(VC, animated: true)
            }
        }else{
            if let fileURL = URL(string: "\(AppConstants.APIURL.kMerchantBusiness)\(AppConstants.businessData?.id ?? 0)/statements/\(statement.id ?? 0)/download"){
                AppCommonMethods.startProgressBar()
                DispatchQueue.global().async {
                    do{
                        let data = try Data.init(contentsOf: fileURL)
                        try data.write(to: destinationFileUrl)
                        DispatchQueue.main.async {
                            AppCommonMethods.stopProgressBar()
                            if let VC = WebViewVC.instance(){
                                VC.strURL = destinationFileUrl.absoluteString
                                self.navigationController?.pushViewController(VC, animated: true)
                            }
                        }
                    }catch (let err) {
                        AppCommonMethods.stopProgressBar()
                        print("error: \(err)")
                    }
                }
            }
        }
    }
    
    func RefundTransaction(){
        var dictParam = [String:Any]()
        dictParam["amount"] = refundedAmount ?? 0
        if AppConstants.isAdminLogin{
            dictParam["password"] = AppConstants.businessData?.adminPassword ?? ""
        }else if AppConstants.isSupervisorLogin{
            dictParam["password"] = AppConstants.businessData?.supervisorPassword ?? ""
        }else{
            return
        }
        var strURL = ""
        if let model = selectedTransaction as? TransactionModel{
            strURL = "\(AppConstants.APIURL.kMerchantBusiness)\(AppConstants.businessData?.id ?? 0)/card-transactions/\(model.id ?? 0)/refund"
        }else if let model = selectedTransaction as? PaypalTransactionModel{
            strURL = "\(AppConstants.APIURL.kMerchantBusiness)\(AppConstants.businessData?.id ?? 0)/paypal-transactions/\(model.id ?? 0)/refund"
        }
        AppCommonMethods.startProgressBar()
        WebServiceManager().requestAPI(params: dictParam, urlString: strURL, method: "POST") { (message, result) in
            DispatchQueue.main.async {
                AppCommonMethods.stopProgressBar()
                let jsonDecoder = JSONDecoder()
                if let response = result as? NSDictionary{
                    if let _ = self.selectedTransaction as? TransactionModel, let data = AppCommonMethods.convertToJson(object: response), let _ = try? jsonDecoder.decode(TransactionModel.self, from: data){
                        self.FetchTransactionData()
                        var setting = BottomAlertSettings()
                        setting.strMessage = "Transaction refunded sucessfully"
                        AppValidation().showBottomAlertView(settings: setting)
                        return
                    }else if let _ = self.selectedTransaction as? PaypalTransactionModel, let data = AppCommonMethods.convertToJson(object: response), let _ = try? jsonDecoder.decode(PaypalTransactionModel.self, from: data){
                        self.FetchTransactionData()
                        var setting = BottomAlertSettings()
                        setting.strMessage = "Transaction refunded sucessfully"
                        AppValidation().showBottomAlertView(settings: setting)
                        return
                    }
                }
                AppValidation().showAlertView(parentVC: self, withAlertTile: AppConstants.GlobalAlert.ALERT_TITLE, withAlertMsg: message, withActionsTitle: [AppConstants.GlobalAlert.ALERT_BTN_OK]) { (index) in
                    
                }
            }
        }
    }
    
    func ArchieveTransaction(){
        var dictParam = [String:Any]()
        var strURL = "\(AppConstants.APIURL.kMerchantBusiness)\(AppConstants.businessData?.id ?? 0)/all-transactions/archive"
        if selectedPayment.type == .kArchive{
            strURL = "\(AppConstants.APIURL.kMerchantBusiness)\(AppConstants.businessData?.id ?? 0)/all-transactions/unarchive"
        }
        dictParam["paypal_ids"] = arrSelectedPaypalTranscation
        dictParam["order_ids"] = arrSelectedOrderTranscation
        dictParam["stripe_ids"] = arrSelectedMerchantTranscation
        AppCommonMethods.startProgressBar()
        WebServiceManager().requestAPI(params: dictParam, urlString: strURL, method: "POST") { (message, result) in
            DispatchQueue.main.async {
                AppCommonMethods.stopProgressBar()
                if let response = result as? NSDictionary{
                    var arrT = [Any]()
                    let jsonDecoder = JSONDecoder()
                    if let arr = response["stripe_transactions"] as? [NSDictionary], let data = AppCommonMethods.convertToJson(object: arr), let aData = try? jsonDecoder.decode([TransactionModel].self, from: data){
                        arrT = aData
                    }
                    if let arr = response["order_transactions"] as? [NSDictionary], let data = AppCommonMethods.convertToJson(object: arr), let aData = try? jsonDecoder.decode([WebOrderModel].self, from: data){
                        arrT.append(contentsOf: aData)
                    }
                    if let arr = response["paypal_transactions"] as? [NSDictionary], let data = AppCommonMethods.convertToJson(object: arr), let aData = try? jsonDecoder.decode([PaypalTransactionModel].self, from: data){
                        arrT.append(contentsOf: aData)
                    }
                    if arrT.count > 0{
                        self.isTransactionSelected = false
                        self.constTransactionBottomSpace.constant = 0
                        self.lblTotalTransaction.superview?.superview?.isHidden = true
                        self.arrSelectedOrderTranscation.removeAll()
                        self.arrSelectedPaypalTranscation.removeAll()
                        self.arrSelectedMerchantTranscation.removeAll()
                        self.FetchTransactionData()
                        if self.selectedPayment.type == .kArchive{
                            AppCommonMethods.showToastAlert(message: AppConstants.GlobalAlert.ALERT_TRANSACTION_UNARCHIVE)
                        }else{
                            AppCommonMethods.showToastAlert(message: AppConstants.GlobalAlert.ALERT_TRANSACTION_ARCHIVE)
                        }
                        return
                    }
                }
                AppValidation().showAlertView(parentVC: self, withAlertTile: AppConstants.GlobalAlert.ALERT_TITLE, withAlertMsg: message, withActionsTitle: [AppConstants.GlobalAlert.ALERT_BTN_OK]) { (index) in
                    
                }
            }
        }
    }
}

//MARK: UITableViewDataSource
extension TransactionVC:UITableViewDataSource,UITableViewDelegate{
    func numberOfSections(in tableView: UITableView) -> Int {
        return arrDates.count
    }
    
    func tableView(_ tableView: UITableView, viewForHeaderInSection section: Int) -> UIView? {
        let cell = tableView.dequeueReusableCell(withIdentifier: "HeaderViewCell") as! ReservationHeaderCell
//        if selectedPayment.type == .kStatement || selectedPayment.type == .kPaymentSMS || selectedPayment.type == .QRCode{
            cell.lblTitle.text = arrDates[section]
//        }else{
////            var totalAmount = 0.0
////            if let arr = dictTransaction[arrDates[section]]{
////                arr.forEach { model in
////                    if let order = model as? WebOrderModel{
////                        var amount = order.grandTotal ?? 0
////                        if (order.paymentMethod ?? "").lowercased() == "cod"{
////                            amount = -(order.calculatedFees?.totalFee ?? 0)
////                        }
////                        totalAmount += amount
////                    }else if let transaction = model as? TransactionModel{
////                        totalAmount += (Double(transaction.amount ?? 0)/100)
////                    }else if let transaction = model as? PaypalTransactionModel{
////                        var amount = transaction.transactionAmount ?? 0
////                        if transaction.saleState ?? "" == "refunded"{
////                            amount = transaction.refundedAmount ?? 0
////                        }
////                        totalAmount += amount
////                    }
////                }
////            }
//            cell.lblTitle.text = String.init(format: "%@ (%@%.2f)", arrDates[section], AppConstants.currencySign, totalAmount)
//        }
        return cell
    }
    
    func tableView(_ tableView: UITableView, heightForHeaderInSection section: Int) -> CGFloat {
        let count = (selectedPayment.type == .kStatement) ? dictStatement[arrDates[section]]?.count ?? 0 : (selectedPayment.type == .kPaymentSMS || selectedPayment.type == .QRCode ? dictLinks[arrDates[section]]?.count ?? 0 : dictTransaction[arrDates[section]]?.count ?? 0)
        return (count == 0) ? 0 : 40
    }
    
    func tableView(_ tableView: UITableView, numberOfRowsInSection section: Int) -> Int {
        return (selectedPayment.type == .kStatement) ? dictStatement[arrDates[section]]?.count ?? 0 : (selectedPayment.type == .kPaymentSMS || selectedPayment.type == .QRCode ? dictLinks[arrDates[section]]?.count ?? 0 : dictTransaction[arrDates[section]]?.count ?? 0)
    }
    
    func tableView(_ tableView: UITableView, cellForRowAt indexPath: IndexPath) -> UITableViewCell {
        if selectedPayment.type == .kPaymentSMS || selectedPayment.type == .QRCode{
            let cell = tableView.dequeueReusableCell(withIdentifier: "PaymentLinkCell", for: indexPath) as! PaymentLinkCell
            let model = dictLinks[arrDates[indexPath.section]]![indexPath.row]
            cell.lblPhoneNo.text = model.phone ?? ""
            cell.lblDate.text = ((model.created ?? "").components(separatedBy: ".").first ?? "").changeDateFormat(fromFormat: "yyyy-MM-dd'T'HH:mm:ss", toFormat: "dd MMM hh:mm a") ?? ""
            cell.lblAmount.text = String.init(format: "%@%.2f", AppConstants.currencySign,model.amount ?? 0)
            let status = model.status ?? ""
            cell.lblStatus.text = status
            cell.btnResend.tag = indexPath.row
            cell.btnResend.isHidden = true
            if status == "Pending"{
                cell.imgStatus.image = UIImage.init(named: "ic_clock")
                cell.imgStatus.imageColor = AppConstants.Colors.kAppThemeRedColor
                cell.btnResend.isHidden = false
            }else if status == "Success"{
                cell.imgStatus.image = UIImage.init(named: "ic_selected_green")
                cell.imgStatus.imageColor = AppConstants.Colors.kAppThemeAquaColor
            }else{
                cell.imgStatus.image = UIImage.init(named: "ic_close")
                cell.imgStatus.imageColor = AppConstants.Colors.kAppThemeRedColor
            }
            return cell
        }
        if selectedPayment.type != .kStatement{
            let cell = tableView.dequeueReusableCell(withIdentifier: "TransactionListCellView", for: indexPath) as! TransactionListCellView
            cell.btnRefund.tag = indexPath.row
            cell.btnRefund.accessibilityIdentifier = "\(indexPath.section)"
            cell.btnReprint.tag = indexPath.row
            cell.btnReprint.accessibilityIdentifier = "\(indexPath.section)"
            cell.btnRefund.isEnabled = false
            cell.btnReprint.isEnabled = false
            if AppConstants.selectedPrinter != nil{
                cell.btnReprint.isEnabled = true
            }
            if let arr = dictTransaction["\(arrDates[indexPath.section])"], let model = arr[indexPath.row] as? TransactionModel{
                if model.type ?? "" == "refund"{
                    cell.lblPaymentType.text = "Refund"
                }else{
                    cell.lblPaymentType.text = (model.cardBrand ?? "").capitalized
                    if model.refunded ?? 0 == 0{
                        cell.btnRefund.isEnabled = true
                    }
                }
                if AppConstants.isAdminLogin{
                    if AppConstants.businessData?.adminPermissions?.refund ?? 0 == 0{
                        cell.btnRefund.isEnabled = false
                    }
                }else if AppConstants.isSupervisorLogin{
                    if AppConstants.businessData?.supervisorPermissions?.refund ?? 0 == 0{
                        cell.btnRefund.isEnabled = false
                    }
                }else{
                    cell.btnRefund.isEnabled = false
                }
                
                let amount = model.amount ?? 0
                var color = AppConstants.Colors.kAppThemeAquaColor
                var strAmount = String.init(format: "+ %@%.2f", AppConstants.currencySign,Double(amount)/100)
                if model.transactionDateTime ?? "" != ""{
                    cell.lblDate.text = (model.transactionDateTime ?? "").changeDateFormat(fromFormat: "yyyy-MM-dd HH:mm:ss", toFormat: "dd/MM/yy HH:mm") ?? ""
                }else{
                    cell.lblDate.text = Date.init(timeIntervalSince1970: Double(model.created ?? "") ?? 0).getDateInString(format: "dd/MM/yy HH:mm")
                }
                if amount < 0{
                    color = AppConstants.Colors.kAppThemeRedColor
                    strAmount = String.init(format: "- %@%.2f", AppConstants.currencySign,Double(-amount)/100)
                }
                let nsrange = NSRange(location: 0, length: 1)
                let attribetdStr = NSMutableAttributedString.init(string: strAmount, attributes: [NSAttributedString.Key.font: AppConstants.GlobalFontConstants.kMediumFont(size: 14),NSAttributedString.Key.foregroundColor: AppConstants.Colors.kAppThemeTextColor])
                attribetdStr.addAttribute(NSAttributedString.Key.foregroundColor, value: color, range: nsrange)
                cell.lblAmount.attributedText = attribetdStr
                if isTransactionSelected{
                    if arrSelectedMerchantTranscation.contains(model.id ?? 0){
                        cell.btnSelect.isSelected = true
                    }else{
                        cell.btnSelect.isSelected = false
                    }
                    cell.constlblTypeLeadingSpace.constant = 40
                    cell.btnSelect.isHidden = false
                }else{
                    cell.btnSelect.isHidden = true
                    cell.constlblTypeLeadingSpace.constant = 25
                }
            }else if let arr = dictTransaction["\(arrDates[indexPath.section])"], let model = arr[indexPath.row] as? WebOrderModel{
                cell.lblPaymentType.text = "\(model.orderStatus ?? "")\n\(model.orderType ?? "")"
                cell.btnRefund.isEnabled = false
                cell.btnReprint.isEnabled = false
                var amount = model.grandTotal ?? 0
                if (model.paymentMethod ?? "").lowercased() == "cod"{
                    amount = -(model.calculatedFees?.totalFee ?? 0)
                }
                var color = AppConstants.Colors.kAppThemeAquaColor
                let strNo = String.init(format: "#ORD%d", model.id ?? 0)
                var strAmount = String.init(format: "+ %@%.2f\n%@", AppConstants.currencySign,amount, strNo)
                if amount < 0{
                    color = AppConstants.Colors.kAppThemeRedColor
                    strAmount = String.init(format: "- %@%.2f", AppConstants.currencySign,Double(-amount)/100)
                }
                cell.lblDate.text = "\((model.orderDate ?? "").changeDateFormat(fromFormat: "yyyy-MM-dd HH:mm:ss", toFormat: "dd/MM/yy HH:mm") ?? "")"
                let nsrange = NSRange(location: 0, length: 1)
                let orderrange = NSString.init(string: strAmount).range(of: strNo)
                let attribetdStr = NSMutableAttributedString.init(string: strAmount, attributes: [NSAttributedString.Key.font: AppConstants.GlobalFontConstants.kMediumFont(size: 14),NSAttributedString.Key.foregroundColor: AppConstants.Colors.kAppThemeTextColor])
                attribetdStr.addAttribute(NSAttributedString.Key.foregroundColor, value: color, range: nsrange)
                attribetdStr.addAttribute(NSAttributedString.Key.font, value: AppConstants.GlobalFontConstants.kMediumFont(size: 12), range: orderrange)
                cell.lblAmount.attributedText = attribetdStr
                if isTransactionSelected{
                    if arrSelectedOrderTranscation.contains(model.id ?? 0){
                        cell.btnSelect.isSelected = true
                    }else{
                        cell.btnSelect.isSelected = false
                    }
                    cell.constlblTypeLeadingSpace.constant = 40
                    cell.btnSelect.isHidden = false
                }else{
                    cell.btnSelect.isHidden = true
                    cell.constlblTypeLeadingSpace.constant = 25
                }
            }else if let arr = dictTransaction["\(arrDates[indexPath.section])"], let model = arr[indexPath.row] as? PaypalTransactionModel{
                cell.lblPaymentType.text = (model.saleState ?? "").capitalized
                var amount = model.refundedAmount ?? 0
                if model.saleState ?? "" != "refunded"{
                    amount = model.transactionAmount ?? 0
                    cell.btnRefund.isEnabled = true
                }
                if AppConstants.isAdminLogin{
                    if AppConstants.businessData?.adminPermissions?.refund ?? 0 == 0{
                        cell.btnRefund.isEnabled = false
                    }
                }else if AppConstants.isSupervisorLogin{
                    if AppConstants.businessData?.supervisorPermissions?.refund ?? 0 == 0{
                        cell.btnRefund.isEnabled = false
                    }
                }else{
                    cell.btnRefund.isEnabled = false
                }
                cell.btnReprint.isEnabled = false
                
                var color = AppConstants.Colors.kAppThemeAquaColor
                var strAmount = String.init(format: "+ %@%.2f", AppConstants.currencySign,amount)
                let date = (model.saleCreatedAt ?? "").replacingOccurrences(of: "Z", with: "")
                cell.lblDate.text = date.changeDateFormat(fromFormat: "yyyy-MM-dd'T'HH:mm:ss", toFormat: "dd/MM/yy HH:mm") ?? ""
                if amount < 0{
                    color = AppConstants.Colors.kAppThemeRedColor
                    strAmount = String.init(format: "- %@%.2f", AppConstants.currencySign,-amount)
                }
                let nsrange = NSRange(location: 0, length: 1)
                let attribetdStr = NSMutableAttributedString.init(string: strAmount, attributes: [NSAttributedString.Key.font: AppConstants.GlobalFontConstants.kMediumFont(size: 14),NSAttributedString.Key.foregroundColor: AppConstants.Colors.kAppThemeTextColor])
                attribetdStr.addAttribute(NSAttributedString.Key.foregroundColor, value: color, range: nsrange)
                cell.lblAmount.attributedText = attribetdStr
                if isTransactionSelected{
                    if arrSelectedPaypalTranscation.contains(model.id ?? 0){
                        cell.btnSelect.isSelected = true
                    }else{
                        cell.btnSelect.isSelected = false
                    }
                    cell.constlblTypeLeadingSpace.constant = 40
                    cell.btnSelect.isHidden = false
                }else{
                    cell.btnSelect.isHidden = true
                    cell.constlblTypeLeadingSpace.constant = 25
                }
            }
            if !cell.btnRefund.isEnabled && !cell.btnReprint.isEnabled{
                cell.btnRefund.isHidden = true
                cell.btnReprint.isHidden = true
            }else{
                cell.btnRefund.isHidden = false
                cell.btnReprint.isHidden = false
            }
            return cell
        }else{
            let cell = tableView.dequeueReusableCell(withIdentifier: "StatementListCellView", for: indexPath) as! StatementListCellView
            let model = dictStatement[arrDates[indexPath.section]]![indexPath.row]
            cell.btnViewStatement.tag = indexPath.row
            cell.btnViewStatement.accessibilityIdentifier = "\(indexPath.section)"
            cell.btnDownload.tag = indexPath.row
            cell.btnDownload.accessibilityIdentifier = "\(indexPath.section)"
            cell.lblStatement.text = "Statement #\(model.id ?? 0)\n\((model.toDate ?? "").components(separatedBy: " ").first ?? "")"
            cell.lblType.text = model.transactionType ?? ""
            cell.lblPrice.text = String.init(format: "%@%.2f", AppConstants.currencySign, model.netTotal ?? 0)
            return cell
        }
    }
    
    func tableView(_ tableView: UITableView, didSelectRowAt indexPath: IndexPath) {
        if isTransactionSelected{
            if let arr = dictTransaction[arrDates[indexPath.section]]{
                if let model = arr[indexPath.row] as? WebOrderModel{
                    if arrSelectedOrderTranscation.contains(model.id ?? 0){
                        arrSelectedOrderTranscation.remove(at: arrSelectedOrderTranscation.firstIndex(of: model.id ?? 0)!)
                    }else{
                        arrSelectedOrderTranscation.append(model.id ?? 0)
                    }
                }else if let model = arr[indexPath.row] as? TransactionModel{
                    if arrSelectedMerchantTranscation.contains(model.id ?? 0){
                        arrSelectedMerchantTranscation.remove(at: arrSelectedMerchantTranscation.firstIndex(of: model.id ?? 0)!)
                    }else{
                        arrSelectedMerchantTranscation.append(model.id ?? 0)
                    }
                }else if let model = arr[indexPath.row] as? PaypalTransactionModel{
                    if arrSelectedPaypalTranscation.contains(model.id ?? 0){
                        arrSelectedPaypalTranscation.remove(at: arrSelectedPaypalTranscation.firstIndex(of: model.id ?? 0)!)
                    }else{
                        arrSelectedPaypalTranscation.append(model.id ?? 0)
                    }
                }
            }
            tableView.reloadData()
            lblTotalTransaction.text = "\(arrSelectedOrderTranscation.count + arrSelectedPaypalTranscation.count + arrSelectedMerchantTranscation.count) transactions selected"
        }
    }
}

//MARK: UITextFieldDelegate
extension TransactionVC:UITextFieldDelegate{
    func textFieldShouldBeginEditing(_ textField: UITextField) -> Bool {
        if textField == txtToDate{
            let datePicker = ActionSheetDatePicker(title: "Select Date", datePickerMode: UIDatePicker.Mode.date, selectedDate: toDate, doneBlock: {
                picker, value, index in
                self.toDate = (value as! Date)
                if self.fromDate > self.toDate{
                    self.fromDate = self.toDate
                }
                self.txtToDate.text = "To - \(self.toDate.getDateInString(format: "dd/MM/yyyy"))"
                self.txtFromDate.text = "From - \(self.fromDate.getDateInString(format: "dd/MM/yyyy"))"
                self.FetchTransactionData()
            }, cancel: { ActionStringCancelBlock in return }, origin: textField)
            datePicker?.minimumDate = self.fromDate
            datePicker?.show()
            return false
        }else{
            let datePicker = ActionSheetDatePicker(title: "Select Date", datePickerMode: UIDatePicker.Mode.date, selectedDate: fromDate, doneBlock: {
                picker, value, index in
                self.fromDate = (value as! Date)
                if self.toDate < self.fromDate{
                    self.toDate = self.fromDate
                }
                self.txtToDate.text = "To - \(self.toDate.getDateInString(format: "dd/MM/yyyy"))"
                self.txtFromDate.text = "From - \(self.fromDate.getDateInString(format: "dd/MM/yyyy"))"
                self.FetchTransactionData()
            }, cancel: { ActionStringCancelBlock in return }, origin: textField)
            datePicker?.maximumDate = self.toDate
            datePicker?.show()
            return false
        }
    }
}

//MARK: AlertControllerDelegate
extension TransactionVC:AlertControllerDelegate{
    func alertButtonAction(index: Int, data: alertViewData, type: AlertType) {
        if index == 1{
            if type == .kEnterAmount{
                refundedAmount = Double(data.value)
                var amount = 0.0
                if let model = selectedTransaction as? TransactionModel{
                    amount = Double(model.amount ?? 0)/100
                }
                if let model = selectedTransaction as? PaypalTransactionModel{
                    amount = model.transactionAmount ?? 0
                }
                if refundedAmount! > amount{
                    AppValidation().showAlertView(parentVC: self, withAlertTile: AppConstants.GlobalAlert.ALERT_TITLE, withAlertMsg: AppConstants.GlobalAlert.ALERT_REFUND_GREATER, withActionsTitle: [AppConstants.GlobalAlert.ALERT_BTN_OK]) { (index) in
                        
                    }
                    return
                }
                var setting = AlertSetting()
                setting.alertTitle = AppConstants.GlobalAlert.ALERT_ENTER_PASSWORD
                setting.alertMessage = AppConstants.GlobalAlert.ALERT_ENTER_PASSOWRD_REFUND_TRANSACTION
                setting.cancelBGColor = AppConstants.Colors.kAppMediumGrayColor
                setting.confirmBGColor = AppConstants.Colors.kAppDarkGrayColor
                setting.textPlcaeholder = "password"
                setting.textType = .default
                if AppConstants.isAdminLogin{
                    setting.type = .kEnterAdminPassword
                }
                if AppConstants.isSupervisorLogin{
                    setting.type = .kEnterSupervisorPassword
                }
                if let VC = AlertViewController.showPopup(parentVC: self.parentVC.parentVC, setting: setting){
                    VC.delegate = self
                }
            }else if type == .kNormal{
                ArchieveTransaction()
            }else{
                RefundTransaction()
            }
        }
    }
}
