//
//  ReportVC.swift
//  EPOS
//
//  Created by Apple on 29/05/21.
//

import UIKit

class ReportVC: UIViewController {

    //MARK: Instances
    var arrReports = [RerportCellData]()
    var parentVC:PaymentMainVC!
    var selectedReportType:RerportCellData!
    
    //MARK: ViewController LifeCycle
    override func viewDidLoad() {
        super.viewDidLoad()

        // Do any additional setup after loading the view.
        setReportData()
    }
    
    //MARK: Create ViewController Instance
    static func addToParentView(parentVC:PaymentMainVC)->ReportVC?{
        guard let VC = UIStoryboard.init(name: "Payments", bundle: nil).instantiateViewController(withIdentifier: "ReportVC") as? ReportVC else {
            return nil
        }
        VC.parentVC = parentVC
        parentVC.addChild(VC)
        parentVC.viewForContainer.addSubview(VC.view)
        VC.view.frame = CGRect.init(x: 0, y: 10, width: parentVC.viewForContainer.frame.width, height: parentVC.viewForContainer.frame.height-20)
        return VC
    }
    
    //MARK: General Methods
    func setReportData(){
        arrReports = [.init(title: "Full Report", type: RerportType.kFullReport), .init(title: "Full Report (Beta)", type: RerportType.FullReportBeta)]
        if AppConstants.userData?.permissions?.zReport?.actions?.list ?? 0 == 1{
            arrReports.append(.init(title: "Z Report", type: RerportType.ZReport))
        }
        if AppConstants.userData?.permissions?.archiveOrder?.actions?.list ?? 0 == 1{
            arrReports.append(.init(title: "Full Archived Report", type: RerportType.kFullArchivedReport))
        }
        if AppConstants.userData?.permissions?.orderPaymentWise?.actions?.list ?? 0 == 1{
            arrReports.append(.init(title: "Product Sales Report", type: RerportType.kProductSaleReport))
        }
        if AppConstants.userData?.permissions?.productCategoryWise?.actions?.list ?? 0 == 1{
            arrReports.append(.init(title: "Product Category Report", type: RerportType.kProductCategoryReport))
        }
        arrReports.append(.init(title: "Selected User Report", type: RerportType.kSelectedUserReport))
        if AppConstants.isAdminLogin{
            if AppConstants.businessData?.adminPermissions?.print ?? 0 == 1{
                arrReports.append(.init(title: "Merchant Transaction Report", type: RerportType.MerchantReport))
            }
        }else if AppConstants.isSupervisorLogin{
            if AppConstants.businessData?.adminPermissions?.print ?? 0 == 1{
                arrReports.append(.init(title: "Merchant Transaction Report", type: RerportType.MerchantReport))
            }
        }
        
        arrReports.append(.init(title: "Online Order Report", type: RerportType.kOnlineOrderReport))
    }
}

//MARK: UITableViewDataSource
extension ReportVC:UITableViewDataSource, UITableViewDelegate{
    func tableView(_ tableView: UITableView, numberOfRowsInSection section: Int) -> Int {
        return arrReports.count
    }
    
    func tableView(_ tableView: UITableView, cellForRowAt indexPath: IndexPath) -> UITableViewCell {
        let cell = tableView.dequeueReusableCell(withIdentifier: "ReportListViewCell", for: indexPath) as! ReportListViewCell
        cell.lblTitle.text = arrReports[indexPath.row].title
        return cell
    }
    
    func tableView(_ tableView: UITableView, didSelectRowAt indexPath: IndexPath) {
        if arrReports[indexPath.row].type == RerportType.kReportSettings{
            var setting = AlertSetting()
            setting.alertTitle = AppConstants.GlobalAlert.ALERT_ENTER_PASSWORD
            setting.alertMessage = AppConstants.GlobalAlert.ALERT_ENTER_PASSWORD_REPORTSETTING
            setting.cancelBGColor = AppConstants.Colors.kAppMediumGrayColor
            setting.confirmBGColor = AppConstants.Colors.kAppDarkGrayColor
            setting.textPlcaeholder = "password"
            setting.type = .kEnterUserPassword
            setting.textType = .default
            if let VC = AlertViewController.showPopup(parentVC: self.parentVC.parentVC, setting: setting){
                VC.delegate = self
            }
        }else{
            if AppCommonMethods.fetchSiteSettingValue(key: "report_password_enable") ?? "" == "true"{
                self.selectedReportType = arrReports[indexPath.row]
                var setting = AlertSetting()
                setting.alertTitle = AppConstants.GlobalAlert.ALERT_ENTER_PASSWORD
                setting.alertMessage = "Please enter your password to view report"
                setting.textPlcaeholder = "password"
                setting.type = .kEnterUserPassword
                setting.textType = .default
                if let VC = AlertViewController.showPopup(parentVC: self.parentVC.parentVC, setting: setting){
                    VC.delegate = self
                }
            }else{
                if arrReports[indexPath.row].type == RerportType.MerchantReport{
                    if let _ = PrintReportSelectionVC.showPopup(parentVC: self.parentVC.parentVC){
                        
                    }
                }else{
                    if let _ = FullReportVC.addToParentView(parentVC: self.parentVC, selectedReport: arrReports[indexPath.row]){
                        
                    }
                }
            }
        }
    }
}

//MARK: AlertControllerDelegate
extension ReportVC:AlertControllerDelegate{
    func alertButtonAction(index: Int, data: alertViewData, type: AlertType) {
        if index == 1{
            if self.selectedReportType.type == RerportType.MerchantReport{
                if let _ = PrintReportSelectionVC.showPopup(parentVC: self.parentVC.parentVC){
                    
                }
            }else{
                if let _ = FullReportVC.addToParentView(parentVC: self.parentVC, selectedReport: self.selectedReportType){
                    
                }
            }
        }
    }
}
