//
//  QRPaymentVC.swift
//  EPOS
//
//  Created by Tushar Premal on 12/05/25.
//

import UIKit

class QRPaymentVC: UIViewController {

    @IBOutlet weak var tblPaymentLink:UITableView!
    @IBOutlet weak var txtTipAmount:UITextField!
    @IBOutlet weak var txtAmount:UITextField!
    @IBOutlet weak var viewForQRCode:UIView!
    @IBOutlet weak var imgViewForQRCode:UIImageView!
    @IBOutlet weak var btnViewAll:UIButton!
    
    weak var parentVC:PaymentMainVC!
    var arrLinks = [PaymentLinkModel]()
    var selectedPayment:PaymentCellData!
    
    override func viewDidLoad() {
        super.viewDidLoad()

        // Do any additional setup after loading the view.
        if AppConstants.userData?.permissions?.paymentLinkHistory?.actions?.list ?? 0 == 1{
            getPaymentLinkList()
        }
        if AppConstants.businessData?.tip ?? 0 == 1{
            txtTipAmount.superview?.isHidden = false
        }
        self.txtAmount.text = "\(AppConstants.currencySign) 0.00"
        self.txtTipAmount.text = "\(AppConstants.currencySign) 0.00"
    }
    
    //MARK: Create ViewController Instance
    static func addToParentView(parentVC:PaymentMainVC, selectedPayment:PaymentCellData)->QRPaymentVC?{
        guard let VC = UIStoryboard.init(name: "Payments", bundle: nil).instantiateViewController(withIdentifier: "QRPaymentVC") as? QRPaymentVC else {
            return nil
        }
        VC.parentVC = parentVC
        VC.selectedPayment = selectedPayment
        parentVC.addChild(VC)
        parentVC.viewForContainer.addSubview(VC.view)
        VC.view.frame = CGRect.init(x: 0, y: 10, width: parentVC.viewForContainer.frame.width, height: parentVC.viewForContainer.frame.height-20)
        return VC
    }
    
    override func viewDidAppear(_ animated: Bool) {
        btnViewAll.isHidden =  (AppConstants.userData?.permissions?.paymentLinkHistory?.actions?.list ?? 0 == 0)
    }
    
    func checkValidation()->Bool{
        let strAmount = (txtAmount.text ?? "").replacingOccurrences(of: "\(AppConstants.currencySign) ", with: "")
    
        if strAmount.isEmpty{
            AppValidation().showAlertView(parentVC: self, withAlertTile: AppConstants.GlobalAlert.ALERT_TITLE, withAlertMsg: AppConstants.GlobalAlert.ALERT_ENTER_AMOUNT, withActionsTitle: [AppConstants.GlobalAlert.ALERT_BTN_OK]) { (index) in
                
            }
            return false
        }else if Double(strAmount) ?? 0 < 0.5{
            AppValidation().showAlertView(parentVC: self, withAlertTile: AppConstants.GlobalAlert.ALERT_TITLE, withAlertMsg: "Amount can not be less than 0.5", withActionsTitle: [AppConstants.GlobalAlert.ALERT_BTN_OK]) { (index) in
                
            }
            return false
        }
        return true
    }

    @IBAction func btnViewAllAction(_ sender:UIButton){
        self.view.endEditing(true)
        if let _ = TransactionVC.addToParentView(parentVC: self.parentVC, selectedPayment: selectedPayment){
            
        }
    }
    
    @IBAction func btnSendLinkAction(_ sender:UIButton){
        self.view.endEditing(true)
        if checkValidation(){
            let amount = (Double((txtAmount.text ?? "").replacingOccurrences(of: "\(AppConstants.currencySign) ", with: "")) ?? 0) + (Double((txtTipAmount.text ?? "").replacingOccurrences(of: "\(AppConstants.currencySign) ", with: "")) ?? 0)
            sendPaymentLinkList(amount: amount)
        }
    }
    
    @IBAction func btnClearAction(_ sender:UIButton){
        self.view.endEditing(true)
        self.txtAmount.text = "\(AppConstants.currencySign) 0.00"
        self.txtTipAmount.text = "\(AppConstants.currencySign) 0.00"
    }
    
    @IBAction func btnViewCodeAction(_ sender:UIButton){
        self.view.endEditing(true)
        let model = arrLinks[sender.tag]
        if let image = model.link.generateQRCode(){
            self.viewForQRCode.isHidden = false
            self.imgViewForQRCode.image = image
        }
    }
    
    func sendPaymentLinkList(amount:Double){
        var dictParam = [String:Any]()
        
        let strURL = AppConstants.APIURL.kPaymentMessage
        dictParam["amount"] = "\(amount)"
        dictParam["name"] = AppConstants.businessData?.name ?? ""
        dictParam["device_id"] = AppConstants.FCMToken ?? ""
        if AppConstants.businessData?.connectService ?? 0 == 1{
            dictParam["secretkey"] = AppConstants.businessData?.connectStripePrivateKey ?? ""
            dictParam["publishkey"] = AppConstants.businessData?.connectStripePublicKey ?? ""
        }else{
            if (AppConstants.businessData?.stripeMode ?? "").lowercased() == "live"{
                dictParam["secretkey"] = AppConstants.businessData?.stripePrivateKeyLive ?? ""
                dictParam["publishkey"] = AppConstants.businessData?.stripePublicKeyLive ?? ""
            }else{
                dictParam["secretkey"] = AppConstants.businessData?.stripePrivateKeyTest ?? ""
                dictParam["publishkey"] = AppConstants.businessData?.stripePublicKeyTest ?? ""
            }
        }
        dictParam["descriptor"] = AppConstants.businessData?.statementDescriptor ?? ""
        dictParam["description"] = AppConstants.businessData?.statementDescription ?? ""
        dictParam["qr"] = 1
        
        AppCommonMethods.startProgressBar()
        WebServiceManager().requestAPI(params: dictParam, urlString: strURL, method: "POST") { (message, response) in
            DispatchQueue.main.async {
                AppCommonMethods.stopProgressBar()
                if let result = response as? NSDictionary, let link = result["payment_link"] as? String{
                    if let image = link.generateQRCode(){
                        self.viewForQRCode.isHidden = false
                        self.imgViewForQRCode.image = image
                    }
                    self.txtAmount.text = "\(AppConstants.currencySign) 0.00"
                    self.txtTipAmount.text = "\(AppConstants.currencySign) 0.00"
                    self.getPaymentLinkList()
                }else{
                    AppValidation().showAlertView(parentVC: self, withAlertTile: AppConstants.GlobalAlert.ALERT_TITLE, withAlertMsg: message, withActionsTitle: [AppConstants.GlobalAlert.ALERT_BTN_OK]) { (index) in
                        
                    }
                }
            }
        }
    }
    
    func getPaymentLinkList(){
        var dictParam = [String:Any]()
        dictParam["restaurant_id"] = AppConstants.webResId ?? ""
        dictParam["per_page"] = "10"
        dictParam["qr"] = 1
        AppCommonMethods.startProgressBar()
        WebServiceManager().requestAPI(params: dictParam, urlString: AppConstants.APIURL.kPaymentMessage, method: "GET") { (message, response) in
            DispatchQueue.main.async {
                AppCommonMethods.stopProgressBar()
                let jsonDecoder = JSONDecoder()
                if let result = response as? NSDictionary, let arr = result["data"] as? [NSDictionary], let data = AppCommonMethods.convertToJson(object: arr), let aData = try? jsonDecoder.decode([PaymentLinkModel].self, from: data){
                    self.arrLinks = aData
                    self.tblPaymentLink.reloadData()
                }else{
                    AppValidation().showAlertView(parentVC: self, withAlertTile: AppConstants.GlobalAlert.ALERT_TITLE, withAlertMsg: message, withActionsTitle: [AppConstants.GlobalAlert.ALERT_BTN_OK]) { (index) in
                        
                    }
                }
            }
        }
    }
    
    func PaymentLinkSuccessAlert(paymentId:String, amount:Double){
        self.viewForQRCode.isHidden = true
        var settings = AlertSetting()
        settings.alertAnimation = "payment_successful"
        settings.confirmTitle = AppConstants.GlobalAlert.ALERT_BTN_OK
        settings.cancelTitle = ""
        if let _ = AlertViewController.showPopup(parentVC: self.parentVC.parentVC, setting: settings){
            
        }
        PrintManager.shared.cardBrand = ""
        PrintManager.shared.cardNumber = ""
        PrintManager.shared.isCustomerCopy = false
        PrintManager.shared.TID = paymentId
        PrintManager.shared.amount = amount
        PrintManager.shared.tipAmount = 0
        PrintManager.shared.status = "Approved"
        PrintManager.shared.entryMode = "QR Code"
        PrintManager.shared.isReprint = false
        PrintManager.shared.connectToPrinterWithPrint(model: AppConstants.businessData!, controller: self)
        getPaymentLinkList()
    }
}

extension QRPaymentVC:UITableViewDelegate,UITableViewDataSource{
    func tableView(_ tableView: UITableView, viewForHeaderInSection section: Int) -> UIView? {
        let cell = tableView.dequeueReusableCell(withIdentifier: "HeaderViewCell") as! ReservationHeaderCell
        return cell
    }
    
    func tableView(_ tableView: UITableView, heightForHeaderInSection section: Int) -> CGFloat {
        return (AppConstants.userData?.permissions?.paymentLinkHistory?.actions?.list ?? 0 == 0) ? 0 : 35
    }
    
    func tableView(_ tableView: UITableView, numberOfRowsInSection section: Int) -> Int {
        return (AppConstants.userData?.permissions?.paymentLinkHistory?.actions?.list ?? 0 == 0) ? 0 : arrLinks.count
    }
    
    func tableView(_ tableView: UITableView, cellForRowAt indexPath: IndexPath) -> UITableViewCell {
        let cell = tableView.dequeueReusableCell(withIdentifier: "PaymentLinkCell", for: indexPath) as! PaymentLinkCell
        let model = arrLinks[indexPath.row]
        cell.lblDate.text = ((model.created ?? "").components(separatedBy: ".").first ?? "").changeDateFormat(fromFormat: "yyyy-MM-dd'T'HH:mm:ss", toFormat: "dd MMM hh:mm a") ?? ""
        cell.lblAmount.text = String.init(format: "%@%.2f", AppConstants.currencySign,model.amount ?? 0)
        let status = model.status ?? ""
        cell.lblStatus.text = status
        cell.btnResend.tag = indexPath.row
        cell.btnResend.isHidden = true
        if status == "Pending"{
            cell.imgStatus.image = UIImage.init(named: "ic_clock")
            cell.imgStatus.imageColor = AppConstants.Colors.kAppThemeRedColor
            cell.btnResend.isHidden = false
        }else if status == "Success"{
            cell.imgStatus.image = UIImage.init(named: "ic_selected_green")
            cell.imgStatus.imageColor = AppConstants.Colors.kAppThemeAquaColor
        }else{
            cell.imgStatus.image = UIImage.init(named: "ic_close")
            cell.imgStatus.imageColor = AppConstants.Colors.kAppThemeRedColor
        }
        return cell
    }
}

extension QRPaymentVC: UITextFieldDelegate{
    func textField(_ textField: UITextField, shouldChangeCharactersIn range: NSRange, replacementString string: String) -> Bool {
        let allowedCharacters = CharacterSet(charactersIn:"0123456789.")
        let characterSet = CharacterSet(charactersIn: string)
        if allowedCharacters.isSuperset(of: characterSet){
            var strText = (textField.text!).replacingOccurrences(of: "\(AppConstants.currencySign) ", with: "").replacingOccurrences(of: ".", with: "")
            if string == ""{
                if strText != "000"{
                    if strText.count == 3{
                        strText.removeLast()
                        strText = "0\(strText)"
                    }else{
                        strText.removeLast()
                    }
                    strText.insert(".", at: strText.index(strText.endIndex, offsetBy: -2))
                    textField.text = "\(AppConstants.currencySign) \(strText)"
                }
            }else{
                if strText.first! == "0"{
                    strText.removeFirst()
                    strText = "\(strText)\(string)"
                }else{
                    strText = "\(strText)\(string)"
                }
                strText.insert(".", at: strText.index(strText.endIndex, offsetBy: -2))
                textField.text = "\(AppConstants.currencySign) \(strText)"
            }
        }
        return false
    }
}
