//
//  PaymentOverViewVC.swift
//  EPOS
//
//  Created by Apple on 29/05/21.
//

import UIKit
import Charts

class PaymentOverViewVC: UIViewController {
    
    //MARK: IBOutlet
    @IBOutlet weak var tblTransaction:UITableView!
    @IBOutlet weak var lblNoTranscation:UILabel!
    @IBOutlet weak var btnRecentPaymentThisMonth:UIButton!
    @IBOutlet weak var btnRecentPaymentLastMonth:UIButton!
    @IBOutlet weak var btnRecentPaymentThisYear:UIButton!
    @IBOutlet weak var paymentBarChart:BarChartView!
    @IBOutlet weak var viewForRecentPayment:UIView!
    @IBOutlet weak var viewForNewTransaction:UIView!
    @IBOutlet weak var viewForRecentTransaction:UIView!
    
    //MARK: Instances
    var currentPage = 0
    var selectedRecentPaymentIndex = 0
    var arrPaymentChartXData = [String]()
    var arrTransactions = [Any]()
    var arrStatements = [StatementModel]()
    var parentVC:PaymentMainVC!
    var selectedTransaction:Any!
    var refundedAmount:Double?
    
    //MARK: ViewController LifeCycle
    override func viewDidLoad() {
        super.viewDidLoad()
        
        // Do any additional setup after loading the view.
        viewForRecentPayment.isHidden = true
        viewForRecentTransaction.isHidden = true
        if AppConstants.isAdminLogin{
            if AppConstants.businessData?.adminPermissions?.recentList ?? 0 == 1{
                viewForRecentPayment.isHidden = false
                viewForRecentTransaction.isHidden = false
                FetchTransactionData()
                FetchStatementData(fromDate: Date().startOfWeek() ?? Date(), toDate: Date().endOfWeek() ?? Date())
            }
        }else if AppConstants.isSupervisorLogin{
            if AppConstants.businessData?.supervisorPermissions?.recentList ?? 0 == 1{
                viewForRecentPayment.isHidden = false
                viewForRecentTransaction.isHidden = false
                FetchTransactionData()
                FetchStatementData(fromDate: Date().startOfWeek() ?? Date(), toDate: Date().endOfWeek() ?? Date())
            }
        }
        
        setPaymentChartView()
    }
    
    override func viewWillAppear(_ animated: Bool) {
        viewForNewTransaction.isHidden = true
        if AppConstants.isAdminLogin{
            if AppConstants.businessData?.adminPermissions?.refundList ?? 0 == 1{
                viewForNewTransaction.isHidden = false
            }
        }else if AppConstants.isSupervisorLogin{
            if AppConstants.businessData?.supervisorPermissions?.refundList ?? 0 == 1{
                viewForNewTransaction.isHidden = false
            }
        }
    }
    
    //MARK: Create ViewController Instance
    static func addToParentView(parentVC:PaymentMainVC)->PaymentOverViewVC?{
        guard let VC = UIStoryboard.init(name: "Payments", bundle: nil).instantiateViewController(withIdentifier: "PaymentOverViewVC") as? PaymentOverViewVC else {
            return nil
        }
        VC.parentVC = parentVC
        parentVC.addChild(VC)
        parentVC.viewForContainer.addSubview(VC.view)
        VC.view.frame = CGRect.init(x: 0, y: 10, width: parentVC.viewForContainer.frame.width, height: parentVC.viewForContainer.frame.height-20)
        return VC
    }
    
    //MARK: Button Actions
    @IBAction func btnViewRecentPaymentAction(_ sender:UIButton){
        btnRecentPaymentThisYear.backgroundColor = AppConstants.Colors.kAppMediumGrayColor
        btnRecentPaymentThisMonth.backgroundColor = AppConstants.Colors.kAppMediumGrayColor
        btnRecentPaymentLastMonth.backgroundColor = AppConstants.Colors.kAppMediumGrayColor
        if sender.tag == 0{
            btnRecentPaymentThisMonth.backgroundColor = AppConstants.Colors.kAppDarkGrayColor
            FetchStatementData(fromDate: Date().startOfWeek() ?? Date(), toDate: Date().endOfWeek() ?? Date())
        }else if sender.tag == 1{
            btnRecentPaymentLastMonth.backgroundColor = AppConstants.Colors.kAppDarkGrayColor
            let date = Date().addingTimeInterval(-7*24*60*60)
            FetchStatementData(fromDate: date.startOfWeek() ?? date, toDate: date.endOfWeek() ?? date)
        }else{
            btnRecentPaymentThisYear.backgroundColor = AppConstants.Colors.kAppDarkGrayColor
            FetchStatementData(fromDate: Date().startOfYear() ?? Date(), toDate: Date().endOfYear() ?? Date())
        }
    }
    
    @IBAction func btnViewTransactionAction(_ sender:UIButton){
        self.parentVC.selectedPayment = .init(title: "Transactions", type: .kTransaction)
        if let _ = TransactionVC.addToParentView(parentVC: self.parentVC, selectedPayment: self.parentVC.selectedPayment){
            
        }
        self.parentVC.tblPaymentItem.reloadData()
    }
    
    @IBAction func btnRefundAction(_ sender:UIButton){
        selectedTransaction = arrTransactions[sender.tag]
        var setting = AlertSetting()
        setting.alertTitle = AppConstants.GlobalAlert.ALERT_ENTER_AMOUNT
        setting.alertMessage = AppConstants.GlobalAlert.ALERT_ENTER_REFUNDAMOUNT
        setting.cancelBGColor = AppConstants.Colors.kAppMediumGrayColor
        setting.confirmBGColor = AppConstants.Colors.kAppDarkGrayColor
        setting.type = .kEnterAmount
        setting.textPlcaeholder = "amount"
        if let model = selectedTransaction as? TransactionModel{
            setting.textTitle = String.init(format: "%@%.2f", AppConstants.currencySign,Double(model.amount ?? 0)/100)
        }else if let model = selectedTransaction as? PaypalTransactionModel{
            setting.textTitle = String.init(format: "%@%.2f", AppConstants.currencySign,model.transactionAmount ?? 0)
        }
        if let VC = AlertViewController.showPopup(parentVC: self.parentVC.parentVC, setting: setting){
            VC.delegate = self
        }
    }
    
    @IBAction func btnReprintAction(_ sender:UIButton){
        if let transaction = arrTransactions[sender.tag] as? TransactionModel{
            PrintManager.shared.cardBrand = transaction.cardBrand ?? ""
            PrintManager.shared.cardNumber = transaction.cardNumber ?? ""
            PrintManager.shared.isCustomerCopy = false
            PrintManager.shared.TID = transaction.txnId ?? ""
            PrintManager.shared.amount = Double(transaction.amount ?? 0)/100
            if transaction.type ?? "" == "refund"{
                PrintManager.shared.status = "Refunded"
            }else{
                PrintManager.shared.status = "Approved"
            }
            PrintManager.shared.tipAmount = 0
            PrintManager.shared.entryMode = "MOTO"
            PrintManager.shared.isReprint = true
            PrintManager.shared.connectToPrinterWithPrint(model: AppConstants.businessData!, controller: self)
        }
    }
    
    //MARK: General Methods
    func setPaymentChartData(){
        var arrXValue = [BarChartDataEntry]()
        arrPaymentChartXData.removeAll()
        var dictDate = [String:Double]()
        var arrDays = [String]()
        for i in 0..<arrStatements.count{
            let model = arrStatements[i]
            let endDate = ((model.toDate ?? "").components(separatedBy: " ").first ?? "").changeDateFormat(fromFormat: "yyyy-MM-dd", toFormat: "dd/MM/yy") ?? ""
            if var amount = dictDate[endDate]{
                amount += (model.netTotal ?? 0)
                dictDate[endDate] = amount
            }else{
                dictDate[endDate] = model.netTotal ?? 0
                arrDays.append(endDate)
            }
        }
        
        arrDays.sort { (str1, str2) -> Bool in
            return (str1.getDateFromString(format: "dd/MM/yy") ?? Date()) < (str2.getDateFromString(format: "dd/MM/yy") ?? Date())
        }
        
        for i in 0..<arrDays.count{
            let value = dictDate[arrDays[i]]!
            arrPaymentChartXData.append(arrDays[i])
            let chartData = BarChartDataEntry.init(x: Double(i), y: value)
            
            arrXValue.append(chartData)
        }
        
        paymentBarChart.xAxis.labelCount = arrPaymentChartXData.count
        let dataset = BarChartDataSet.init(entries: arrXValue, label: "")
        dataset.setColor(AppConstants.Colors.kAppThemeAquaColor)
        dataset.drawValuesEnabled = true
        
        
        let data = BarChartData(dataSet: dataset)
        
        
        paymentBarChart.data = data
    }
    
    func setPaymentChartView(){
        let xAxis = paymentBarChart.xAxis
        xAxis.labelPosition = .bottom
        xAxis.labelFont = AppConstants.GlobalFontConstants.kLightFont(size: 10)
        xAxis.granularity = 1
        xAxis.valueFormatter = self
        xAxis.drawAxisLineEnabled = false
        xAxis.drawGridLinesEnabled = false
        xAxis.centerAxisLabelsEnabled = false
        
        
        paymentBarChart.rightAxis.enabled = false
        paymentBarChart.leftAxis.enabled = false
        
        paymentBarChart.legend.enabled = false
        paymentBarChart.chartDescription.enabled = false
        
        paymentBarChart.dragEnabled = false
        paymentBarChart.setScaleEnabled(false)
        paymentBarChart.pinchZoomEnabled = false
    }
    
    //MARK: Webservice Methods
    func FetchTransactionData(){
        var dictParam = [String:Any]()
        dictParam["per_page"] = "10"
        AppCommonMethods.startProgressBar()
        WebServiceManager().requestAPI(params: dictParam, urlString: "\(AppConstants.APIURL.kMerchantBusiness)\(AppConstants.businessData?.id ?? 0)/all-transactions", method: "GET") { (message, response) in
            DispatchQueue.main.async {
                AppCommonMethods.stopProgressBar()
                self.arrTransactions.removeAll()
                if let result = response as? NSDictionary{
                    let jsonDecoder = JSONDecoder()
                    if let transaction = result["card_transactions"] as? NSDictionary,let arr = transaction["data"] as? [NSDictionary], let data = AppCommonMethods.convertToJson(object: arr), let aData = try? jsonDecoder.decode([TransactionModel].self, from: data){
                        self.arrTransactions = aData
                    }
                    if let transaction = result["paypal_transactions"] as? NSDictionary,let arr = transaction["data"] as? [NSDictionary], let data = AppCommonMethods.convertToJson(object: arr), let aData = try? jsonDecoder.decode([PaypalTransactionModel].self, from: data){
                        self.arrTransactions.append(contentsOf: aData)
                    }
                    if let transaction = result["order_transactions"] as? NSDictionary,let arr = transaction["data"] as? [NSDictionary], let data = AppCommonMethods.convertToJson(object: arr), let aData = try? jsonDecoder.decode([WebOrderModel].self, from: data){
                        let arr = aData.filter { model in
                            return (model.orderStatus ?? "").lowercased() != "failed"
                        }
                        self.arrTransactions.append(contentsOf: arr)
                    }
                    self.arrTransactions.sort { model1, model2 in
                        var date1 = Date()
                        var date2 = Date()
                        if let transaction = model1 as? TransactionModel{
                            if transaction.transactionDateTime ?? "" != ""{
                                date1 = (transaction.transactionDateTime ?? "").getDateFromString(format: "yyyy-MM-dd HH:mm:ss") ?? Date()
                            }else{
                                date1 = Date.init(timeIntervalSince1970: Double(transaction.created ?? "") ?? 0)
                            }
                        }else if let transaction = model1 as? PaypalTransactionModel{
                            let date = (transaction.saleCreatedAt ?? "").replacingOccurrences(of: "Z", with: "")
                            date1 = date.getDateFromString(format: "yyyy-MM-dd'T'HH:mm:ss") ?? Date()
                        }else if let transaction = model1 as? WebOrderModel{
                            date1 = (transaction.orderDate ?? "").getDateFromString(format: "yyyy-MM-dd HH:mm:ss") ?? Date()
                        }
                        
                        if let transaction = model2 as? TransactionModel{
                            if transaction.transactionDateTime ?? "" != ""{
                                date2 = (transaction.transactionDateTime ?? "").getDateFromString(format: "yyyy-MM-dd HH:mm:ss") ?? Date()
                            }else{
                                date2 = Date.init(timeIntervalSince1970: Double(transaction.created ?? "") ?? 0)
                            }
                        }else if let transaction = model2 as? PaypalTransactionModel{
                            let date = (transaction.saleCreatedAt ?? "").replacingOccurrences(of: "Z", with: "")
                            date1 = date.getDateFromString(format: "yyyy-MM-dd'T'HH:mm:ss") ?? Date()
                        }else if let transaction = model2 as? WebOrderModel{
                            date1 = (transaction.orderDate ?? "").getDateFromString(format: "yyyy-MM-dd HH:mm:ss") ?? Date()
                        }
                        return date2 < date1
                    }
                }else{
                    AppValidation().showAlertView(parentVC: self, withAlertTile: AppConstants.GlobalAlert.ALERT_TITLE, withAlertMsg: message, withActionsTitle: [AppConstants.GlobalAlert.ALERT_BTN_OK]) { (index) in
                        
                    }
                }
                self.tblTransaction.reloadData()
                if self.arrTransactions.count == 0{
                    self.lblNoTranscation.superview?.isHidden = false
                }else{
                    self.lblNoTranscation.superview?.isHidden = true
                }
                
            }
        }
    }
    
    func FetchStatementData(fromDate:Date,toDate:Date){
        var dictParam = [String:Any]()
        dictParam["from_date"] = fromDate.getDateInString(format: "yyyy-MM-dd")
        dictParam["to_date"] = toDate.getDateInString(format: "yyyy-MM-dd")
        dictParam["nopaginate"] = "1"
        AppCommonMethods.startProgressBar()
        WebServiceManager().requestAPI(params: dictParam, urlString: "\(AppConstants.APIURL.kMerchantBusiness)\(AppConstants.businessData?.id ?? 0)/statements", method: "GET") { (message, result) in
            DispatchQueue.main.async {
                AppCommonMethods.stopProgressBar()
                let jsonDecoder = JSONDecoder()
                self.arrStatements.removeAll()
                if let response = result as? [NSDictionary], let data = AppCommonMethods.convertToJson(object: response), let aData = try? jsonDecoder.decode([StatementModel].self, from: data){
                    self.arrStatements = aData
                }
                self.setPaymentChartData()
                
            }
        }
    }
    
    func RefundTransaction(){
        var dictParam = [String:Any]()
        dictParam["amount"] = RefundTransaction
        if AppConstants.isAdminLogin{
            dictParam["password"] = AppConstants.businessData?.adminPassword ?? ""
        }else if AppConstants.isSupervisorLogin{
            dictParam["password"] = AppConstants.businessData?.supervisorPassword ?? ""
        }else{
            return
        }
        var strURL = ""
        if let model = selectedTransaction as? TransactionModel{
            strURL = "\(AppConstants.APIURL.kMerchantBusiness)\(AppConstants.businessData?.id ?? 0)/card-transactions/\(model.id ?? 0)/refund"
        }else if let model = selectedTransaction as? PaypalTransactionModel{
            strURL = "\(AppConstants.APIURL.kMerchantBusiness)\(AppConstants.businessData?.id ?? 0)/paypal-transactions/\(model.id ?? 0)/refund"
        }
        AppCommonMethods.startProgressBar()
        WebServiceManager().requestAPI(params: dictParam, urlString: strURL, method: "POST") { (message, result) in
            DispatchQueue.main.async {
                AppCommonMethods.stopProgressBar()
                let jsonDecoder = JSONDecoder()
                if let response = result as? NSDictionary{
                    if let _ = self.selectedTransaction as? TransactionModel, let data = AppCommonMethods.convertToJson(object: response), let _ = try? jsonDecoder.decode(TransactionModel.self, from: data){
                        self.FetchTransactionData()
                        var setting = BottomAlertSettings()
                        setting.strMessage = "Transaction refunded sucessfully"
                        AppValidation().showBottomAlertView(settings: setting)
                        return
                    }else if let _ = self.selectedTransaction as? PaypalTransactionModel, let data = AppCommonMethods.convertToJson(object: response), let _ = try? jsonDecoder.decode(PaypalTransactionModel.self, from: data){
                        self.FetchTransactionData()
                        var setting = BottomAlertSettings()
                        setting.strMessage = "Transaction refunded sucessfully"
                        AppValidation().showBottomAlertView(settings: setting)
                        return
                    }
                }
                AppValidation().showAlertView(parentVC: self, withAlertTile: AppConstants.GlobalAlert.ALERT_TITLE, withAlertMsg: message, withActionsTitle: [AppConstants.GlobalAlert.ALERT_BTN_OK]) { (index) in
                    
                }
            }
        }
    }
}

//MARK: UITableViewDataSource
extension PaymentOverViewVC:UITableViewDelegate,UITableViewDataSource{
    func tableView(_ tableView: UITableView, numberOfRowsInSection section: Int) -> Int {
        return arrTransactions.count
    }
    
    func tableView(_ tableView: UITableView, cellForRowAt indexPath: IndexPath) -> UITableViewCell {
        let cell = tableView.dequeueReusableCell(withIdentifier: "TransactionListCellView", for: indexPath) as! TransactionListCellView
        cell.btnRefund.tag = indexPath.row
        cell.btnRefund.accessibilityIdentifier = "\(indexPath.section)"
        cell.btnReprint.tag = indexPath.row
        cell.btnReprint.accessibilityIdentifier = "\(indexPath.section)"
        cell.btnRefund.isEnabled = false
        cell.btnReprint.isEnabled = false
        if AppConstants.selectedPrinter != nil{
            cell.btnReprint.isEnabled = true
        }
        if let model = arrTransactions[indexPath.row] as? TransactionModel{
            if model.type ?? "" == "refund"{
                cell.lblPaymentType.text = "Refund"
            }else{
                cell.lblPaymentType.text = (model.cardBrand ?? "").capitalized
                if model.refunded ?? 0 == 0{
                    cell.btnRefund.isEnabled = true
                }
            }
            if AppConstants.isAdminLogin{
                if AppConstants.businessData?.adminPermissions?.refund ?? 0 == 0{
                    cell.btnRefund.isEnabled = false
                }
            }else if AppConstants.isSupervisorLogin{
                if AppConstants.businessData?.supervisorPermissions?.refund ?? 0 == 0{
                    cell.btnRefund.isEnabled = false
                }
            }else{
                cell.btnRefund.isEnabled = false
            }
            
            let amount = model.amount ?? 0
            var color = AppConstants.Colors.kAppThemeAquaColor
            var strAmount = String.init(format: "+ %@%.2f", AppConstants.currencySign,Double(amount)/100)
            if model.transactionDateTime ?? "" != ""{
                cell.lblDate.text = (model.transactionDateTime ?? "").changeDateFormat(fromFormat: "yyyy-MM-dd HH:mm:ss", toFormat: "dd/MM/yy HH:mm") ?? ""
            }else{
                cell.lblDate.text = Date.init(timeIntervalSince1970: Double(model.created ?? "") ?? 0).getDateInString(format: "dd/MM/yy HH:mm")
            }
            if amount < 0{
                color = AppConstants.Colors.kAppThemeRedColor
                strAmount = String.init(format: "- %@%.2f", AppConstants.currencySign,Double(-amount)/100)
            }
            let nsrange = NSRange(location: 0, length: 1)
            let attribetdStr = NSMutableAttributedString.init(string: strAmount, attributes: [NSAttributedString.Key.font: AppConstants.GlobalFontConstants.kMediumFont(size: 14),NSAttributedString.Key.foregroundColor: AppConstants.Colors.kAppThemeTextColor])
            attribetdStr.addAttribute(NSAttributedString.Key.foregroundColor, value: color, range: nsrange)
            cell.lblAmount.attributedText = attribetdStr
        }else if let model = arrTransactions[indexPath.row] as? WebOrderModel{
            cell.lblPaymentType.text = "\(model.orderStatus ?? "")\n\(model.orderType ?? "")"
            cell.btnRefund.isEnabled = false
            cell.btnReprint.isEnabled = false
            var amount = model.grandTotal ?? 0
            if (model.paymentMethod ?? "").lowercased() == "cod"{
                amount = -(model.calculatedFees?.totalFee ?? 0)
            }
            var color = AppConstants.Colors.kAppThemeAquaColor
            let strNo = String.init(format: "#ORD%d", model.id ?? 0)
            var strAmount = String.init(format: "+ %@%.2f\n%@", AppConstants.currencySign,amount, strNo)
            if amount < 0{
                color = AppConstants.Colors.kAppThemeRedColor
                strAmount = String.init(format: "- %@%.2f", AppConstants.currencySign,Double(-amount)/100)
            }
            cell.lblDate.text = "\((model.orderDate ?? "").changeDateFormat(fromFormat: "yyyy-MM-dd HH:mm:ss", toFormat: "dd/MM/yy HH:mm") ?? "")"
            let nsrange = NSRange(location: 0, length: 1)
            let orderrange = NSString.init(string: strAmount).range(of: strNo)
            let attribetdStr = NSMutableAttributedString.init(string: strAmount, attributes: [NSAttributedString.Key.font: AppConstants.GlobalFontConstants.kMediumFont(size: 14),NSAttributedString.Key.foregroundColor: AppConstants.Colors.kAppThemeTextColor])
            attribetdStr.addAttribute(NSAttributedString.Key.foregroundColor, value: color, range: nsrange)
            attribetdStr.addAttribute(NSAttributedString.Key.font, value: AppConstants.GlobalFontConstants.kMediumFont(size: 12), range: orderrange)
            cell.lblAmount.attributedText = attribetdStr
        }else if let model = arrTransactions[indexPath.row] as? PaypalTransactionModel{
            cell.lblPaymentType.text = (model.saleState ?? "").capitalized
            var amount = model.refundedAmount ?? 0
            if model.saleState ?? "" != "refunded"{
                amount = model.transactionAmount ?? 0
                cell.btnRefund.isEnabled = true
            }
            if AppConstants.isAdminLogin{
                if AppConstants.businessData?.adminPermissions?.refund ?? 0 == 0{
                    cell.btnRefund.isEnabled = false
                }
            }else if AppConstants.isSupervisorLogin{
                if AppConstants.businessData?.supervisorPermissions?.refund ?? 0 == 0{
                    cell.btnRefund.isEnabled = false
                }
            }else{
                cell.btnRefund.isEnabled = false
            }
            cell.btnReprint.isEnabled = false
            
            var color = AppConstants.Colors.kAppThemeAquaColor
            var strAmount = String.init(format: "+ %@%.2f", AppConstants.currencySign,amount)
            let date = (model.saleCreatedAt ?? "").replacingOccurrences(of: "Z", with: "")
            cell.lblDate.text = date.changeDateFormat(fromFormat: "yyyy-MM-dd'T'HH:mm:ss", toFormat: "dd/MM/yy HH:mm") ?? ""
            if amount < 0{
                color = AppConstants.Colors.kAppThemeRedColor
                strAmount = String.init(format: "- %@%.2f", AppConstants.currencySign,-amount)
            }
            let nsrange = NSRange(location: 0, length: 1)
            let attribetdStr = NSMutableAttributedString.init(string: strAmount, attributes: [NSAttributedString.Key.font: AppConstants.GlobalFontConstants.kMediumFont(size: 14),NSAttributedString.Key.foregroundColor: AppConstants.Colors.kAppThemeTextColor])
            attribetdStr.addAttribute(NSAttributedString.Key.foregroundColor, value: color, range: nsrange)
            cell.lblAmount.attributedText = attribetdStr
        }
        if !cell.btnRefund.isEnabled && !cell.btnReprint.isEnabled{
            cell.btnRefund.isHidden = true
            cell.btnReprint.isHidden = true
        }else{
            cell.btnRefund.isHidden = false
            cell.btnReprint.isHidden = false
        }
        return cell
    }
}

//MARK: IAxisValueFormatter
extension PaymentOverViewVC:AxisValueFormatter{
    func stringForValue(_ value: Double, axis: AxisBase?) -> String {
        if Int(value) >= 0 && Int(value) < arrPaymentChartXData.count{
            return arrPaymentChartXData[Int(value)]
        }
        return ""
    }
}

//MARK: AlertControllerDelegate
extension PaymentOverViewVC:AlertControllerDelegate{
    func alertButtonAction(index: Int, data: alertViewData, type: AlertType) {
        if index == 1{
            if type == .kEnterAmount{
                refundedAmount = Double(data.value)
                var amount = 0.0
                if let model = selectedTransaction as? TransactionModel{
                    amount = Double(model.amount ?? 0)/100
                }
                if let model = selectedTransaction as? PaypalTransactionModel{
                    amount = model.transactionAmount ?? 0
                }
                if refundedAmount! > amount{
                    AppValidation().showAlertView(parentVC: self, withAlertTile: AppConstants.GlobalAlert.ALERT_TITLE, withAlertMsg: AppConstants.GlobalAlert.ALERT_REFUND_GREATER, withActionsTitle: [AppConstants.GlobalAlert.ALERT_BTN_OK]) { (index) in
                        
                    }
                    return
                }
                var setting = AlertSetting()
                setting.alertTitle = AppConstants.GlobalAlert.ALERT_ENTER_PASSWORD
                setting.alertMessage = AppConstants.GlobalAlert.ALERT_ENTER_PASSOWRD_REFUND_TRANSACTION
                setting.cancelBGColor = AppConstants.Colors.kAppMediumGrayColor
                setting.confirmBGColor = AppConstants.Colors.kAppDarkGrayColor
                setting.textPlcaeholder = "password"
                setting.textType = .default
                if AppConstants.isAdminLogin{
                    setting.type = .kEnterAdminPassword
                }
                if AppConstants.isSupervisorLogin{
                    setting.type = .kEnterSupervisorPassword
                }
                if let VC = AlertViewController.showPopup(parentVC: self.parentVC.parentVC, setting: setting){
                    VC.delegate = self
                }
            }else{
                RefundTransaction()
            }
        }
    }
}
