//
//  PaymentSplitVC.swift
//  EPOS
//
//  Created by Apple on 29/05/21.
//

import UIKit

class PaymentMainVC: UIViewController {
    
    //MARK: IBOutlet
    @IBOutlet weak var tblPaymentItem:UITableView!
    @IBOutlet weak var viewForContainer:UIView!
    
    //MARK: Instances
    var arrPayments:[PaymentCellData] = [.init(title: "Overview", type: .kOverview),.init(title: "Moto payment", type: .kMotoPayment),.init(title: "Card reader payment", type: .kCardReaderPayment),.init(title: "Report", type: .kReport),.init(title: "Login", type: .kLogin)]
    var selectedPayment:PaymentCellData!
    var parentVC:SideMenuVC!
    
    //MARK: ViewController LifeCycle
    override func viewDidLoad() {
        super.viewDidLoad()
        
        // Do any additional setup after loading the view.
        
        selectedPayment = arrPayments.first!
        AddContainerView()
        SetMenuItems()
    }
    
    //MARK: Create ViewController Instance
    static func addToParentView(parentVC:SideMenuVC)->PaymentMainVC?{
        guard let VC = UIStoryboard.init(name: "Payments", bundle: nil).instantiateViewController(withIdentifier: "PaymentMainVC") as? PaymentMainVC else {
            return nil
        }
        VC.parentVC = parentVC
        parentVC.addChild(VC)
        parentVC.viewForContainer.addSubview(VC.view)
        VC.view.frame = CGRect.init(x: 0, y: 0, width: parentVC.viewForContainer.frame.width, height: parentVC.viewForContainer.frame.height)
        return VC
    }
    
    //MARK: General Methods
    func SetMenuItems(){
        arrPayments = [.init(title: "Overview", type: .kOverview),.init(title: "Payment Link", type: .kPaymentSMS),.init(title: "QR CODE", type: .QRCode),.init(title: "Report", type: .kReport),.init(title: "Login", type: .kLogin)]
        if AppConstants.businessData?.merchantService ?? 0 == 1{
            arrPayments.insert(.init(title: "Moto payment", type: .kMotoPayment), at: 1)
            arrPayments.insert(.init(title: "Card reader payment", type: .kCardReaderPayment), at: 2)
        }
        if AppConstants.isAdminLogin{
            arrPayments.removeLast()
            if AppConstants.businessData?.adminPermissions?.statement ?? 0 == 1{
                arrPayments.insert(.init(title: "Statement", type: .kStatement), at: 5)
            }
            if AppConstants.businessData?.adminPermissions?.transactionList ?? 0 == 1{
                arrPayments.insert(.init(title: "Transactions", type: .kTransaction), at: 5)
            }
            if AppConstants.businessData?.adminPermissions?.refundList ?? 0 == 1{
                arrPayments.insert(.init(title: "Refunded Transactions", type: .kRefundTransaction), at: 5)
            }
            if AppConstants.businessData?.adminPermissions?.archiveList ?? 0 == 1{
                arrPayments.insert(.init(title: "Archive", type: .kArchive), at: 3)
            }
            arrPayments.append(.init(title: "Logout", type: .kLogout))
        }else if AppConstants.isSupervisorLogin{
            arrPayments.removeLast()
            if AppConstants.businessData?.supervisorPermissions?.statement ?? 0 == 1{
                arrPayments.insert(.init(title: "Statement", type: .kStatement), at: 5)
            }
            if AppConstants.businessData?.supervisorPermissions?.transactionList ?? 0 == 1{
                arrPayments.insert(.init(title: "Transactions", type: .kTransaction), at: 5)
            }
            if AppConstants.businessData?.supervisorPermissions?.refundList ?? 0 == 1{
                arrPayments.insert(.init(title: "Refunded Transactions", type: .kRefundTransaction), at: 5)
            }
            if AppConstants.businessData?.supervisorPermissions?.archiveList ?? 0 == 1{
                arrPayments.insert(.init(title: "Archive", type: .kArchive), at: 3)
            }
            arrPayments.append(.init(title: "Logout", type: .kLogout))
        }
        self.tblPaymentItem.reloadData()
    }
    
    func AddContainerView(){
        for child in self.children{
            child.view.removeFromSuperview()
            child.removeFromParent()
        }
        switch selectedPayment.type {
        case .kOverview:
            if let _ = PaymentOverViewVC.addToParentView(parentVC: self){
                
            }
        case .kMotoPayment:
            if let _ = MotoPaymentVC.addToParentView(parentVC: self){
                
            }
        case .kCardReaderPayment:
            if let _ = CardReaderVC.addToParentView(parentVC: self){
                
            }
        case .kReport:
            if let _ = ReportVC.addToParentView(parentVC: self){
                
            }
        case .kPaymentSMS:
            if let _ = PaymentLinksVC.addToParentView(parentVC: self, selectedPayment: selectedPayment){
                
            }
        case .QRCode:
            if let _ = QRPaymentVC.addToParentView(parentVC: self, selectedPayment: selectedPayment){
                
            }
        default:
            if let _ = TransactionVC.addToParentView(parentVC: self, selectedPayment: selectedPayment){
                
            }
        }
    }
    
    //MARK: Button Actions
    @IBAction func btnBackAction(_ sender:UIButton){
        self.parentVC.AddContainerView(data: self.parentVC.arrSideMenu.first!)
    }
}

//MARK: UITableViewDataSource
extension PaymentMainVC:UITableViewDataSource,UITableViewDelegate{
    func tableView(_ tableView: UITableView, numberOfRowsInSection section: Int) -> Int {
        return arrPayments.count
    }
    
    func tableView(_ tableView: UITableView, cellForRowAt indexPath: IndexPath) -> UITableViewCell {
        let cell = tableView.dequeueReusableCell(withIdentifier: "PaymentDashboardCell", for: indexPath) as! PaymentDashboardCell
        let model = arrPayments[indexPath.row]
        cell.lblTitle.text = model.title
        if model.type == selectedPayment.type{
            cell.lblTitle.textColor = .white
            cell.viewForBG.backgroundColor = AppConstants.Colors.kAppThemeAquaColor
        }else{
            cell.lblTitle.textColor = AppConstants.Colors.kAppThemeTextColor
            cell.viewForBG.backgroundColor = .white
        }
        return cell
    }
    
    func tableView(_ tableView: UITableView, didSelectRowAt indexPath: IndexPath) {
        if arrPayments[indexPath.row].type == .kLogin{
            var setting = AlertSetting()
            setting.alertTitle = AppConstants.GlobalAlert.ALERT_ENTER_PASSWORD
            setting.alertMessage = AppConstants.GlobalAlert.ALERT_ENTER_ADMIN_PASSWORD
            setting.cancelBGColor = AppConstants.Colors.kAppMediumGrayColor
            setting.confirmBGColor = AppConstants.Colors.kAppDarkGrayColor
            setting.textPlcaeholder = "password"
            setting.type = .kEnterPassword
            setting.textType = .default
            if let VC = AlertViewController.showPopup(parentVC: self.parentVC, setting: setting){
                VC.delegate = self
            }
            return
        }
        if arrPayments[indexPath.row].type == .kLogout{
            var setting = AlertSetting()
            setting.alertMessage = AppConstants.isAdminLogin ? AppConstants.GlobalAlert.ALERT_LOGOUT_ADMIN : AppConstants.GlobalAlert.ALERT_LOGOUT_SUPERVISOR
            setting.alertTitle = AppConstants.GlobalAlert.ALERT_BTN_LOGOUT.capitalized
            setting.confirmTitle = AppConstants.GlobalAlert.ALERT_BTN_LOGOUT
            setting.cancelTitle = AppConstants.GlobalAlert.ALERT_BTN_CANCEL
            setting.confirmBGColor = AppConstants.Colors.kAppDarkGrayColor
            setting.cancelBGColor = AppConstants.Colors.kAppLightGrayColor
            if let VC = AlertViewController.showPopup(parentVC: self.parentVC, setting: setting){
                VC.delegate = self
            }
            return
        }
        if selectedPayment.type != arrPayments[indexPath.row].type{
            selectedPayment = arrPayments[indexPath.row]
            AddContainerView()
            self.tblPaymentItem.reloadData()
        }
    }
}

//MARK: AlertControllerDelegate
extension PaymentMainVC:AlertControllerDelegate{
    func alertButtonAction(index: Int, data: alertViewData, type: AlertType) {
        if index == 1{
            if type == .kNormal{
                AppConstants.isAdminLogin = false
                AppConstants.isSupervisorLogin = false
                selectedPayment = arrPayments.first!
            }else{
                if data.value == AppConstants.businessData?.adminPassword ?? ""{
                    AppConstants.isAdminLogin = true
                    AppConstants.isSupervisorLogin = false
                }else if data.value == AppConstants.businessData?.supervisorPassword ?? ""{
                    AppConstants.isSupervisorLogin = true
                    AppConstants.isAdminLogin = false
                }
            }
            NotificationCenter.default.post(name: AppConstants.notifications.kAdminLogin, object: nil)
            SetMenuItems()
            AddContainerView()
        }
    }
}
