//
//  ReservationListVC.swift
//  EPOS
//
//  Created by Apple on 25/05/21.
//

import UIKit
import ActionSheetPicker_3_0

class ReservationListVC: UIViewController {

    //MARK: IBOutlet
    @IBOutlet weak var lblTotalCustomer:UILabel!
    @IBOutlet weak var tblReservation:UITableView!
    @IBOutlet weak var lblToday:UILabel!
    @IBOutlet weak var lblTodayLine:UILabel!
    @IBOutlet weak var lblTomorrow:UILabel!
    @IBOutlet weak var lblTomorrowLine:UILabel!
    @IBOutlet weak var lblOvermorrow:UILabel!
    @IBOutlet weak var lblOvermorrowLine:UILabel!
    @IBOutlet weak var lblCustom:UILabel!
    @IBOutlet weak var lblCustomLine:UILabel!
    @IBOutlet weak var lblShowAll:UILabel!
    @IBOutlet weak var lblShowAllLine:UILabel!
    @IBOutlet weak var lblPending:UILabel!
    @IBOutlet weak var lblPendingLine:UILabel!
    @IBOutlet weak var viewForEditPopup:UIView!
    @IBOutlet weak var txtEditField:UITextField!
    @IBOutlet weak var bntClosePopup:UIButton!
    @IBOutlet weak var btnBulkDelete:UIButton!
    @IBOutlet weak var txtToDate:UITextField!
    @IBOutlet weak var txtFromDate:UITextField!
    
    //MARK: Instances
    var parentVC:SideMenuVC!
    var dictReservations = [String:[Any]]()
    var arrReservationDate = [String]()
    var isFromDineIn = false
    var refreshControl = UIRefreshControl()
    var arrReservations = [OnlineReservationModel]()
    var apiCount = 0
    var selectedRow = 0
    var selectedSection = 0
    var selectedViewIndex = 4
    var totalAPI = 2
    var fromDate = Date().startOfDate() ?? Date()
    var toDate = Date().endOfDate() ?? Date()
    var selectedDate = Date()
    var strReservation = "All Reservations"
    var editType = "name"
    var selectedReservation:ReservationModel?
    var arrNewReservation = [OnlineReservationModel]()
    var arrSelectedReservation = [ReservationModel]()
    var arrSelectedOnlineReservation = [OnlineReservationModel]()
    
    //MARK: ViewController LifeCycle
    override func viewDidLoad() {
        super.viewDidLoad()

        // Do any additional setup after loading the view.
        
        refreshControl.addTarget(self, action: #selector(StartAPICall), for: .valueChanged)
        self.tblReservation.addSubview(refreshControl)
        self.txtToDate.text = "To - \(self.toDate.getDateInString(format: "dd/MM/yyyy"))"
        self.txtFromDate.text = "From - \(self.fromDate.getDateInString(format: "dd/MM/yyyy"))"
    }
    
    override func viewWillAppear(_ animated: Bool) {
        StartAPICall()
    }
    
    //MARK: Create ViewController Instance
    static func addToParentView(parentVC:SideMenuVC)->ReservationListVC?{
        guard let VC = UIStoryboard.init(name: "Others", bundle: nil).instantiateViewController(withIdentifier: "ReservationListVC") as? ReservationListVC else {
            return nil
        }
        VC.parentVC = parentVC
        parentVC.addChild(VC)
        parentVC.viewForContainer.addSubview(VC.view)
        VC.view.frame = CGRect.init(x: 0, y: 0, width: parentVC.viewForContainer.frame.width, height: parentVC.viewForContainer.frame.height)
        return VC
    }
    
    //MARK: Button Actions
    @IBAction func btnBackAction(_ sender:UIButton){
        self.parentVC.AddContainerView(data: self.parentVC.arrSideMenu.first!)
    }
    
    @IBAction func btnViewReservationAction(_ sender:UIButton){
        var reservation:Any!
        if sender.accessibilityIdentifier ?? "" == "0"{
            reservation = arrNewReservation[sender.tag]
        }else{
            if let model = dictReservations[arrReservationDate[(Int(sender.accessibilityIdentifier ?? "") ?? 0)-1]]?[sender.tag] as? ReservationModel{
                reservation = model
            }
            if let model = dictReservations[arrReservationDate[(Int(sender.accessibilityIdentifier ?? "") ?? 0)-1]]?[sender.tag] as? OnlineReservationModel{
                reservation = model
            }
        }
        if let model = reservation as? ReservationModel{
            if let VC = NewReservationVC.addToParentView(parentVC: self.parentVC, reservation: model){
                VC.delegate = self
            }
        }else if let model = reservation as? OnlineReservationModel{
            selectedSection = Int(sender.accessibilityIdentifier ?? "") ?? 0
            selectedRow = sender.tag
            if let VC = ReservationDetailVC.instance(model: model){
                if let controller = VC.childViewController as? ReservationDetailVC{
                    controller.delegate = self
                }
                self.present(VC, animated: true, completion: nil)
            }
        }
    }
    
    @IBAction func btnPrintReservationAction(_ sender:UIButton){
        var reservation:Any!
        if sender.accessibilityIdentifier ?? "" == "0"{
            reservation = arrNewReservation[sender.tag]
        }else{
            if let model = dictReservations[arrReservationDate[(Int(sender.accessibilityIdentifier ?? "") ?? 0)-1]]?[sender.tag] as? ReservationModel{
                reservation = model
            }
            if let model = dictReservations[arrReservationDate[(Int(sender.accessibilityIdentifier ?? "") ?? 0)-1]]?[sender.tag] as? OnlineReservationModel{
                reservation = model
            }
        }
        if let model = reservation as? ReservationModel{
            PrintManager.shared.connectToPrinterWithPrint(model: model, controller: self)
        }else if let model = reservation as? OnlineReservationModel{
            selectedSection = Int(sender.accessibilityIdentifier ?? "") ?? 0
            selectedRow = sender.tag
            if model.status ?? "" == "Cancel" || model.status ?? "" == "Approved"{
                PrintManager.shared.connectToPrinterWithPrint(model: model, controller: self)
            }else{
                var setting = AlertSetting()
                setting.alertMessage = AppConstants.GlobalAlert.ALERT_CONFIRM_RESERVATION
                setting.alertTitle = AppConstants.GlobalAlert.ALERT_ACCEPT_RESERVATION_TITLE
                if let VC = AlertViewController.showPopup(parentVC: self.parentVC, setting: setting){
                    VC.delegate = self
                }
            }
        }
    }
    
    @IBAction func btnCancelReservationAction(_ sender:UIButton){
        selectedRow = sender.tag
        selectedSection = Int(sender.accessibilityIdentifier ?? "") ?? 0
        var reservation:Any!
        if sender.accessibilityIdentifier ?? "" == "0"{
            reservation = arrNewReservation[sender.tag]
        }else{
            if let model = dictReservations[arrReservationDate[(Int(sender.accessibilityIdentifier ?? "") ?? 0)-1]]?[sender.tag] as? ReservationModel{
                reservation = model
            }
            if let model = dictReservations[arrReservationDate[(Int(sender.accessibilityIdentifier ?? "") ?? 0)-1]]?[sender.tag] as? OnlineReservationModel{
                reservation = model
            }
        }
        if let _ = reservation as? ReservationModel{
            var setting = AlertSetting()
            setting.alertMessage = AppConstants.GlobalAlert.ALERT_CANCEL_RESERVATION
            setting.alertTitle = AppConstants.GlobalAlert.ALERT_CANCEL_RESERVATION_TITLE
            if let VC = AlertViewController.showPopup(parentVC: self.parentVC, setting: setting){
                VC.delegate = self
            }
        }else if let _ = reservation as? OnlineReservationModel{
            if let VC = CancelReasonVC.showPopup(parentVC: self.parentVC, viewType: .kReservation){
                VC.delegate = self
            }
            return
        }
        
    }
    
    @IBAction func btnBulkDeleteAction(_ sender:UIButton){
        if self.arrSelectedReservation.count > 0{
            let arr = self.arrSelectedReservation.map { $0.id ?? 0 }
            CoreDataHelper.shared.DeleteBulkReservation(ids: arr)
            BGAPIExecution.shared.fetchReservationAndCallAPI()
        }
        if self.arrSelectedOnlineReservation.count > 0{
            DeleteReservationList()
        }
    }
    
    @IBAction func btnViewInstructionAction(_ sender:UIButton){
        var reservation:Any!
        if sender.accessibilityIdentifier ?? "" == "0"{
            reservation = arrNewReservation[sender.tag]
        }else{
            if let model = dictReservations[arrReservationDate[(Int(sender.accessibilityIdentifier ?? "") ?? 0)-1]]?[sender.tag] as? ReservationModel{
                reservation = model
            }
            if let model = dictReservations[arrReservationDate[(Int(sender.accessibilityIdentifier ?? "") ?? 0)-1]]?[sender.tag] as? OnlineReservationModel{
                reservation = model
            }
        }
        var setting = AlertSetting()
        setting.alertTitle = AppConstants.GlobalAlert.ALERT_INSTRUCTION_TITLE
        if let model = reservation as? ReservationModel{
            selectedReservation = model
            setting.alertMessage = model.specialInstruction ?? ""
            if model.specialInstruction ?? "" == ""{
                if let VC = AddCommentVC.showPopup(parentVC: self.parentVC, comment: ""){
                    VC.delegate = self
                }
                return
            }
        }else if let model = reservation as? OnlineReservationModel{
            setting.alertMessage = model.bookingInstruction ?? ""
        }
        setting.confirmTitle = ""
        setting.cancelTitle = AppConstants.GlobalAlert.ALERT_BTN_OK
        setting.cancelBGColor = AppConstants.Colors.kAppDarkGreenColor
        if let _ = AlertViewController.showPopup(parentVC: self.parentVC, setting: setting){
        }
    }
    
    @IBAction func btnNewReservationAction(_ sender:UIButton){
        if let VC = NewReservationVC.addToParentView(parentVC: self.parentVC){
            VC.delegate = self
        }
    }
    
    @IBAction func btnSeatOnTableAction(_ sender:UIButton){
        selectedSection = Int(sender.accessibilityIdentifier ?? "") ?? 0
        selectedRow = sender.tag
        if let model = dictReservations[arrReservationDate[(Int(sender.accessibilityIdentifier ?? "") ?? 0)-1]]?[sender.tag] as? ReservationModel{
            if model.tableId ?? 0 != 0, let table = SQLiteManage.fetchTableDataFromId(id: model.tableId ?? 0){
                if (table.tableStatus?.status ?? "").lowercased() == "vacant"{
                    if model.offline == 1{
                        CoreDataHelper.shared.DeleteReservation(uniquId: model.uniqueId, isFromAPI: true)
                        self.createOrderAction(model: model, table: table)
                    }else{
                        CoreDataHelper.shared.DeleteReservation(uniquId: model.uniqueId, isFromAPI: false)
                        if Reachabilities.shared.isConnectedToNetwork(){
                            self.DeleteReservationAPI(model: model, table: table)
                        }else{
                            self.createOrderAction(model: model, table: table)
                        }
                    }
                }else{
                    editType = ""
                    if let VC = SwapTableVC.showPopup(parentVC: self.parentVC, table: table, isFromSeatTable: true){
                        VC.delegate = self
                    }
                }
            }else{
                editType = ""
                if let VC = SwapTableVC.showPopup(parentVC: self.parentVC, isFromSeatTable: true){
                    VC.delegate = self
                }
            }
        }
    }
    
    @IBAction func btnPrintReservationListAction(_ sender:UIButton){
        var arrR = [Any]()
        arrR.append(arrNewReservation)
        for key in arrReservationDate{
            if let arr = dictReservations[key]{
                arrR.append(contentsOf: arr)
            }
        }
        if arrR.count > 0{
            PrintManager.shared.arrReservationDay = arrReservationDate
            PrintManager.shared.strHeaderDate = strReservation
            PrintManager.shared.connectToPrinterWithPrint(model: dictReservations, controller: self)
        }
    }
    
    @IBAction func btnReservationTabChangedAction(_ sender:UIButton){
        if sender.tag != selectedViewIndex{
            selectedViewIndex = sender.tag
            FetchReservationFromDB()
        }
    }
    
    @IBAction func btnSelectDateAction(_ sender:UIButton){
        let datePicker = ActionSheetDatePicker(title: "Select Date", datePickerMode: UIDatePicker.Mode.date, selectedDate: selectedDate, doneBlock: {
            picker, value, index in
            self.selectedDate = (value as! Date)
            self.dictReservations.removeAll()
            self.arrReservationDate.removeAll()
            let startDate = self.selectedDate.startOfDate() ?? self.selectedDate
            let endDate = self.selectedDate.endOfDate() ?? self.selectedDate
            self.strReservation = self.selectedDate.getDateInString(format: "dd MMMM yyyy")
            let arr = CoreDataHelper.shared.fetchReservationData(fromDate: startDate, toDate: endDate)
            let arrO = self.arrReservations.filter { (model) -> Bool in
                let date = (model.bookingDate ?? "").getDateFromString(format: "yyyy-MM-dd", locale: nil) ?? (model.bookingDate ?? "").getDateFromString(format: "dd-MM-yyyy", locale: nil) ?? Date()
                return date >= startDate && date < endDate && (model.status ?? "").lowercased() != "pending"
            }
            self.arrNewReservation = self.arrReservations.filter { (model) -> Bool in
                let date = (model.bookingDate ?? "").getDateFromString(format: "yyyy-MM-dd", locale: nil) ?? (model.bookingDate ?? "").getDateFromString(format: "dd-MM-yyyy", locale: nil) ?? Date()
                return date >= startDate && date < endDate && (model.status ?? "").lowercased() == "pending"
            }
            self.arrNewReservation = self.sortReservaationArray(arr: self.arrNewReservation) as! [OnlineReservationModel]
            let totalCount = arr.count + arrO.count
            if totalCount > 0{
                var newArr = [Any]()
                newArr.append(contentsOf: arr)
                newArr.append(contentsOf: arrO)
                self.dictReservations[self.strReservation] = self.sortReservaationArray(arr: newArr)
                self.arrReservationDate.append(self.strReservation)
            }
            self.lblTotalCustomer.text = "\(self.strReservation)\nTotal reservations: \(totalCount)"
            self.tblReservation.reloadData()
        }, cancel: { ActionStringCancelBlock in return }, origin: sender)
        datePicker?.show()
    }
    
    @IBAction func btnSaveReservationAction(_ sender:UIButton){
        if (txtEditField.text ?? "").trimmingCharacters(in: .whitespacesAndNewlines).isEmpty{
            var strMessage = AppConstants.GlobalAlert.ALERT_ENTER_NAME
            if editType == "diners"{
                strMessage = AppConstants.GlobalAlert.ALERT_ENTER_DINERS
            }else if editType == "contact_no"{
                strMessage = AppConstants.GlobalAlert.ALERT_ENTER_MOBILENO
            }
            AppValidation().showAlertView(parentVC: self, withAlertTile: AppConstants.GlobalAlert.ALERT_TITLE, withAlertMsg:  strMessage, withActionsTitle: [AppConstants.GlobalAlert.ALERT_BTN_OK]) { (index) in
                _ = self.txtEditField.becomeFirstResponder()
            }
            return
        }
        if editType == "diners"{
            if Int(txtEditField.text ?? "") ?? 0 == 0{
                AppValidation().showAlertView(parentVC: self, withAlertTile: AppConstants.GlobalAlert.ALERT_TITLE, withAlertMsg:  AppConstants.GlobalAlert.ALERT_ZERO_DINERS, withActionsTitle: [AppConstants.GlobalAlert.ALERT_BTN_OK]) { (index) in
                    _ = self.txtEditField.becomeFirstResponder()
                }
                return
            }
            self.SaveReservation(diners: Int(txtEditField.text ?? ""))
        }else if editType == "contact_no"{
            if (txtEditField.text ?? "").trimmingCharacters(in: .whitespaces).count < 10 || (txtEditField.text ?? "").trimmingCharacters(in: .whitespaces).count > 11{
                AppValidation().showAlertView(parentVC: self, withAlertTile: AppConstants.GlobalAlert.ALERT_TITLE, withAlertMsg: AppConstants.GlobalAlert.ALERT_MOBILE_10_DIGIT, withActionsTitle: [AppConstants.GlobalAlert.ALERT_BTN_OK]) { (index) in
                    _ = self.txtEditField.becomeFirstResponder()
                }
                return
            }
            self.SaveReservation(contactNo: txtEditField.text ?? "")
        }else{
            self.SaveReservation(name: txtEditField.text ?? "")
        }
        
        self.btnCloseReservationEditAction(UIButton())
    }
    
    @IBAction func btnCloseReservationEditAction(_ sender:UIButton){
        self.viewForEditPopup.removeFromSuperview()
        self.view.endEditing(true)
        self.bntClosePopup.isHidden = true
    }
    
    @IBAction func btnReservationNameAction(_ sender:UIButton){
        var reservation:Any!
        if sender.accessibilityIdentifier ?? "" == "0"{
            reservation = arrNewReservation[sender.tag]
        }else{
            if let model = dictReservations[arrReservationDate[(Int(sender.accessibilityIdentifier ?? "") ?? 0)-1]]?[sender.tag] as? ReservationModel{
                reservation = model
            }
            if let model = dictReservations[arrReservationDate[(Int(sender.accessibilityIdentifier ?? "") ?? 0)-1]]?[sender.tag] as? OnlineReservationModel{
                reservation = model
            }
        }
        if let model = reservation as? ReservationModel{
            self.selectedReservation = model
            if let frame = sender.superview?.convert(sender.frame, to: self.view){
                editType = "name"
                self.txtEditField.text = model.customer?.name ?? ""
                self.txtEditField.becomeFirstResponder()
                self.viewForEditPopup.frame = CGRect.init(x: frame.origin.x+20, y: frame.origin.y-80, width: 200, height: 100)
                self.view.addSubview(self.viewForEditPopup)
                self.bntClosePopup.isHidden = false
            }
        }
    }
    
    @IBAction func btnReservationDateAction(_ sender:UIButton){
//        if let model = dictReservations[arrReservationDate[Int(sender.accessibilityIdentifier ?? "") ?? 0]]?[sender.tag] as? ReservationModel{
//
//        }
    }
    
    @IBAction func btnReservationDinerAction(_ sender:UIButton){
        let section = Int(sender.accessibilityIdentifier ?? "") ?? 0
        if section != 0{
            if let model = dictReservations[arrReservationDate[section-1]]?[sender.tag] as? ReservationModel{
            self.selectedReservation = model
            if let frame = sender.superview?.convert(sender.frame, to: self.view){
                editType = "diners"
                self.txtEditField.keyboardType = .numberPad
                self.txtEditField.becomeFirstResponder()
                self.txtEditField.text = "\(model.diners ?? 0)"
                self.viewForEditPopup.frame = CGRect.init(x: frame.origin.x+20, y: frame.origin.y-80, width: 200, height: 100)
                self.view.addSubview(self.viewForEditPopup)
                self.bntClosePopup.isHidden = false
            }
        }
        }
    }
    
    @IBAction func btnSelectReservationAction(_ sender:UIButton){
        let row = sender.tag
        let section = Int(sender.accessibilityIdentifier!)!
        if section != 0{
            if let model = dictReservations[arrReservationDate[section-1]]?[row] as? ReservationModel{
                if let cell = self.tblReservation.cellForRow(at: IndexPath.init(row: row, section: section)) as? ReservationItemCell{
                    if let index = arrSelectedReservation.firstIndex(where: { reservation in
                        return reservation.id ?? 0 == model.id ?? 0
                    }){
                        cell.btnSelect.isSelected = false
                        arrSelectedReservation.remove(at: index)
                    }else{
                        cell.btnSelect.isSelected = true
                        arrSelectedReservation.append(model)
                    }
                }
            }else if let model = dictReservations[arrReservationDate[section-1]]?[row] as? OnlineReservationModel{
                if let cell = self.tblReservation.cellForRow(at: IndexPath.init(row: row, section: section)) as? ReservationItemCell{
                    if let index = arrSelectedOnlineReservation.firstIndex(where: { reservation in
                        return reservation.id ?? 0 == model.id ?? 0
                    }){
                        cell.btnSelect.isSelected = false
                        arrSelectedOnlineReservation.remove(at: index)
                    }else{
                        cell.btnSelect.isSelected = true
                        arrSelectedOnlineReservation.append(model)
                    }
                }
            }
        }else{
            let model = arrNewReservation[row]
            if let cell = self.tblReservation.cellForRow(at: IndexPath.init(row: row, section: section)) as? ReservationItemCell{
                if let index = arrSelectedOnlineReservation.firstIndex(where: { reservation in
                    return reservation.id ?? 0 == model.id ?? 0
                }){
                    cell.btnSelect.isSelected = false
                    arrSelectedOnlineReservation.remove(at: index)
                }else{
                    cell.btnSelect.isSelected = true
                    arrSelectedOnlineReservation.append(model)
                }
            }
        }
        if self.arrSelectedReservation.count + self.arrSelectedOnlineReservation.count == 0{
            self.btnBulkDelete.superview?.isHidden = true
        }else{
            self.btnBulkDelete.superview?.isHidden = false
        }
    }
    
    @IBAction func btnReservationContactNoAction(_ sender:UIButton){
        let section = Int(sender.accessibilityIdentifier ?? "") ?? 0
        if section != 0{
            if let model = dictReservations[arrReservationDate[section-1]]?[sender.tag] as? ReservationModel{
                self.selectedReservation = model
                if let frame = sender.superview?.convert(sender.frame, to: self.view){
                    editType = "contact_no"
                    self.txtEditField.keyboardType = .phonePad
                    self.txtEditField.becomeFirstResponder()
                    self.txtEditField.text = model.customer?.mobile ?? ""
                    self.viewForEditPopup.frame = CGRect.init(x: frame.origin.x+20, y: frame.origin.y-80, width: 200, height: 100)
                    self.view.addSubview(self.viewForEditPopup)
                    self.bntClosePopup.isHidden = false
                }
            }
        }
    }
    
    @IBAction func btnReservationTableNoAction(_ sender:UIButton){
        let section = Int(sender.accessibilityIdentifier ?? "") ?? 0
        if section != 0{
            if let model = dictReservations[arrReservationDate[section-1]]?[sender.tag] as? ReservationModel{
            self.selectedReservation = model
            editType = "tables"
            let selectedTable = SQLiteManage.fetchTableDataFromId(id: model.tableId ?? 0)
            if let VC = SwapTableVC.showPopup(parentVC: self.parentVC, table: selectedTable){
                VC.delegate = self
            }
        }
        }
    }
    
    //MARK: General Methods
    func createOrderAction(model:ReservationModel, table:TableModel){
        if let VC = CreateOrderVC.instance(){
            let index = AppConstants.arrOrderTypes.firstIndex { (model) -> Bool in
                return model.id ?? 0 == 1
            }
            if index != nil{
                VC.orderType = AppConstants.arrOrderTypes[index!]
                VC.selectedCustomer = model.customer
                VC.selectedTable = table
                VC.noOfGuest = model.diners ?? 0
                self.parentVC.navigationController?.pushViewController(VC, animated: true)
            }
        }
    }
    
    func sortReservaationArray(arr:[Any])->[Any]{
        let newArr = arr.sorted { (model1, model2) -> Bool in
            var reservationDate1 = Date()
            var reservationDate2 = Date()
            if let model = model1 as? ReservationModel{
                reservationDate1 = (model.reservationDateTime ?? "").getDateFromString(format: "yyyy-MM-dd HH:mm:ss") ?? (model.reservationDateTime ?? "").getDateFromString(format: "yyyy-MM-dd EEE HH:mm:ss") ?? Date()
            }else if let model = model1 as? OnlineReservationModel{
                if let date = "\(model.bookingDate ?? "") \(model.bookingTime ?? "")".getDateFromString(format: "yyyy-MM-dd hh:mm a"){
                    reservationDate1 = date
                }else if let date = "\(model.bookingDate ?? "") \(model.bookingTime ?? "")".getDateFromString(format: "dd-MM-yyyy hh:mm a"){
                    reservationDate1 = date
                }
            }
            if let model = model2 as? ReservationModel{
                reservationDate2 = (model.reservationDateTime ?? "").getDateFromString(format: "yyyy-MM-dd HH:mm:ss") ?? (model.reservationDateTime ?? "").getDateFromString(format: "yyyy-MM-dd EEE HH:mm:ss") ?? Date()
            }else if let model = model2 as? OnlineReservationModel{
                if let date = "\(model.bookingDate ?? "") \(model.bookingTime ?? "")".getDateFromString(format: "yyyy-MM-dd hh:mm a"){
                    reservationDate2 = date
                }else if let date = "\(model.bookingDate ?? "") \(model.bookingTime ?? "")".getDateFromString(format: "dd-MM-yyyy hh:mm a"){
                    reservationDate2 = date
                }
            }
            return reservationDate1 > reservationDate2
        }
        return newArr
    }
    
    func FetchReservationFromDB(){
        var startDate:Date?
        var endDate:Date?
        strReservation = "All Reservations"
        self.dictReservations.removeAll()
        self.arrReservationDate.removeAll()
        lblToday.textColor = AppConstants.Colors.kAppLightGrayColor
        lblTodayLine.backgroundColor = AppConstants.Colors.kAppLightGrayColor
        lblTomorrow.textColor = AppConstants.Colors.kAppLightGrayColor
        lblTomorrowLine.backgroundColor = AppConstants.Colors.kAppLightGrayColor
        lblOvermorrow.textColor = AppConstants.Colors.kAppLightGrayColor
        lblOvermorrowLine.backgroundColor = AppConstants.Colors.kAppLightGrayColor
        lblShowAll.textColor = AppConstants.Colors.kAppLightGrayColor
        lblShowAllLine.backgroundColor = AppConstants.Colors.kAppLightGrayColor
        lblPending.textColor = AppConstants.Colors.kAppLightGrayColor
        lblPendingLine.backgroundColor = AppConstants.Colors.kAppLightGrayColor
        lblCustom.textColor = AppConstants.Colors.kAppLightGrayColor
        lblCustomLine.backgroundColor = AppConstants.Colors.kAppLightGrayColor
        var totalCount = 0
        self.txtToDate.superview?.isHidden = true
        if selectedViewIndex == 0{
            lblToday.textColor = AppConstants.Colors.kAppThemeTextColor
            lblTodayLine.backgroundColor = AppConstants.Colors.kAppThemeAquaColor
            startDate = Date().startOfDate() ?? Date()
            endDate = Date().endOfDate() ?? Date()
            strReservation = Date().getDateInString(format: "dd MMMM yyyy")
            let arr = CoreDataHelper.shared.fetchReservationData(fromDate: startDate, toDate: endDate)
            self.arrNewReservation = self.arrReservations.filter { (model) -> Bool in
                let date = (model.bookingDate ?? "").getDateFromString(format: "yyyy-MM-dd", locale: nil) ?? (model.bookingDate ?? "").getDateFromString(format: "dd-MM-yyyy", locale: nil) ?? Date()
                return date >= startDate! && date < endDate! && (model.status ?? "").lowercased() == "pending"
            }
            let arrO = self.arrReservations.filter { (model) -> Bool in
                let date = (model.bookingDate ?? "").getDateFromString(format: "yyyy-MM-dd", locale: nil) ?? (model.bookingDate ?? "").getDateFromString(format: "dd-MM-yyyy", locale: nil) ?? Date()
                return date >= startDate! && date < endDate! && (model.status ?? "").lowercased() != "pending"
            }
            self.arrNewReservation = self.sortReservaationArray(arr: self.arrNewReservation) as! [OnlineReservationModel]
            if arr.count > 0 || arrO.count > 0{
                totalCount = arr.count + arrO.count
                var newArr = [Any]()
                newArr.append(contentsOf: arr)
                newArr.append(contentsOf: arrO)
                self.dictReservations[strReservation] = self.sortReservaationArray(arr: newArr)
                self.arrReservationDate.append(strReservation)
            }
        } else if selectedViewIndex == 1{
            lblTomorrow.textColor = AppConstants.Colors.kAppThemeTextColor
            lblTomorrowLine.backgroundColor = AppConstants.Colors.kAppThemeAquaColor
            let tomorrow = Date().addingTimeInterval(24*60*60)
            startDate = tomorrow.startOfDate() ?? tomorrow
            endDate = tomorrow.endOfDate() ?? tomorrow
            strReservation = tomorrow.getDateInString(format: "dd MMMM yyyy")
            let arr = CoreDataHelper.shared.fetchReservationData(fromDate: startDate, toDate: endDate)
            self.arrNewReservation = self.arrReservations.filter { (model) -> Bool in
                let date = (model.bookingDate ?? "").getDateFromString(format: "yyyy-MM-dd", locale: nil)  ?? (model.bookingDate ?? "").getDateFromString(format: "dd-MM-yyyy", locale: nil) ?? tomorrow
                return date >= startDate! && date < endDate! && (model.status ?? "").lowercased() == "pending"
            }
            self.arrNewReservation = self.sortReservaationArray(arr: self.arrNewReservation) as! [OnlineReservationModel]
            let arrO = self.arrReservations.filter { (model) -> Bool in
                let date = (model.bookingDate ?? "").getDateFromString(format: "yyyy-MM-dd", locale: nil) ?? (model.bookingDate ?? "").getDateFromString(format: "dd-MM-yyyy", locale: nil) ?? tomorrow
                return date >= startDate! && date < endDate! && (model.status ?? "").lowercased() != "pending"
            }
            if arr.count > 0 || arrO.count > 0{
                totalCount = arr.count + arrO.count
                var newArr = [Any]()
                newArr.append(contentsOf: arr)
                newArr.append(contentsOf: arrO)
                self.dictReservations[strReservation] = self.sortReservaationArray(arr: newArr)
                self.arrReservationDate.append(strReservation)
            }
        }else if selectedViewIndex == 2{
            lblOvermorrow.textColor = AppConstants.Colors.kAppThemeTextColor
            lblOvermorrowLine.backgroundColor = AppConstants.Colors.kAppThemeAquaColor
            let tomorrow = Date().addingTimeInterval(2*24*60*60)
            startDate = tomorrow.startOfDate() ?? tomorrow
            endDate = tomorrow.endOfDate() ?? tomorrow
            strReservation = tomorrow.getDateInString(format: "dd MMMM yyyy")
            let arr = CoreDataHelper.shared.fetchReservationData(fromDate: startDate, toDate: endDate)
            self.arrNewReservation = self.arrReservations.filter { (model) -> Bool in
                let date = (model.bookingDate ?? "").getDateFromString(format: "yyyy-MM-dd", locale: nil) ?? (model.bookingDate ?? "").getDateFromString(format: "dd-MM-yyyy", locale: nil) ?? tomorrow
                return date >= startDate! && date < endDate! && (model.status ?? "").lowercased() == "pending"
            }
            self.arrNewReservation = self.sortReservaationArray(arr: self.arrNewReservation) as! [OnlineReservationModel]
            let arrO = self.arrReservations.filter { (model) -> Bool in
                let date = (model.bookingDate ?? "").getDateFromString(format: "yyyy-MM-dd", locale: nil) ?? (model.bookingDate ?? "").getDateFromString(format: "dd-MM-yyyy", locale: nil) ?? tomorrow
                return date >= startDate! && date < endDate! && (model.status ?? "").lowercased() != "pending"
            }
            if arr.count > 0 || arrO.count > 0{
                totalCount = arr.count + arrO.count
                var newArr = [Any]()
                newArr.append(contentsOf: arr)
                newArr.append(contentsOf: arrO)
                self.dictReservations[strReservation] = self.sortReservaationArray(arr: newArr)
                self.arrReservationDate.append(strReservation)
            }
        }else if selectedViewIndex == 3{
            lblShowAll.textColor = AppConstants.Colors.kAppThemeTextColor
            lblShowAllLine.backgroundColor = AppConstants.Colors.kAppThemeAquaColor
            let arr = CoreDataHelper.shared.fetchReservationData()
            totalCount = (arr.count + arrReservations.count)
            arr.forEach { model in
                let date = (model.reservationDateTime ?? "").changeDateFormat(fromFormat: "yyyy-MM-dd HH:mm:ss", toFormat: "MMMM yyyy") ?? (model.reservationDateTime ?? "").changeDateFormat(fromFormat: "yyyy-MM-dd EEE HH:mm:ss", toFormat: "MMMM yyyy") ?? ""
                if var arr = dictReservations[date]{
                    arr.append(model)
                    dictReservations[date] = self.sortReservaationArray(arr: arr)
                }else{
                    dictReservations[date] = [model]
                    arrReservationDate.append(date)
                }
            }
            self.arrNewReservation = self.arrReservations.filter { (model) -> Bool in
                return (model.status ?? "").lowercased() == "pending"
            }
            self.arrNewReservation = self.sortReservaationArray(arr: self.arrNewReservation) as! [OnlineReservationModel]
            let arrO = self.arrReservations.filter { (model) -> Bool in
                return (model.status ?? "").lowercased() != "pending"
            }
            arrO.forEach { (model) in
                let date = (model.bookingDate ?? "").changeDateFormat(fromFormat: "yyyy-MM-dd", toFormat: "MMMM yyyy") ?? (model.bookingDate ?? "").changeDateFormat(fromFormat: "dd-MM-yyyy", toFormat: "MMMM yyyy") ?? ""
                if var arr = dictReservations[date]{
                    arr.append(model)
                    dictReservations[date] = self.sortReservaationArray(arr: arr)
                }else{
                    dictReservations[date] = [model]
                    arrReservationDate.append(date)
                }
            }
            arrReservationDate.sort { str1, str2 in
                let date1 = str1.getDateFromString(format: "MMMM yyyy") ?? Date()
                let date2 = str2.getDateFromString(format: "MMMM yyyy") ?? Date()
                return date1 > date2
            }
        }else if selectedViewIndex == 4{
            lblPending.textColor = AppConstants.Colors.kAppThemeTextColor
            lblPendingLine.backgroundColor = AppConstants.Colors.kAppThemeAquaColor
            
            self.arrNewReservation = self.arrReservations.filter { (model) -> Bool in
                return (model.status ?? "").lowercased() == "pending"
            }
            self.arrNewReservation = self.sortReservaationArray(arr: self.arrNewReservation) as! [OnlineReservationModel]
            strReservation = "Pending Reservations"
            totalCount = self.arrNewReservation.count
        }else{
            self.txtToDate.superview?.isHidden = false
            lblCustom.textColor = AppConstants.Colors.kAppThemeTextColor
            lblCustomLine.backgroundColor = AppConstants.Colors.kAppThemeAquaColor
            let arr = CoreDataHelper.shared.fetchReservationData(fromDate: self.fromDate, toDate: self.toDate)
            totalCount = (arr.count + arrReservations.count)
            strReservation = "\(fromDate.getDateInString(format: "dd MMMM yyyy")) - \(toDate.getDateInString(format: "dd MMMM yyyy"))"
            arr.forEach { model in
                let date = (model.reservationDateTime ?? "").changeDateFormat(fromFormat: "yyyy-MM-dd HH:mm:ss", toFormat: "MMMM yyyy") ?? (model.reservationDateTime ?? "").changeDateFormat(fromFormat: "yyyy-MM-dd EEE HH:mm:ss", toFormat: "MMMM yyyy") ?? ""
                if var arr = dictReservations[date]{
                    arr.append(model)
                    dictReservations[date] = self.sortReservaationArray(arr: arr)
                }else{
                    dictReservations[date] = [model]
                    arrReservationDate.append(date)
                }
            }
            self.arrNewReservation = self.arrReservations.filter { (model) -> Bool in
                if let date = (model.bookingDate ?? "").getDateFromString(format: "yyyy-MM-dd", locale: nil) ?? (model.bookingDate ?? "").getDateFromString(format: "dd-MM-yyyy", locale: nil){
                    return date >= fromDate && date < toDate && (model.status ?? "").lowercased() == "pending"
                }
                return false
            }
            self.arrNewReservation = self.sortReservaationArray(arr: self.arrNewReservation) as! [OnlineReservationModel]
            let arrO = self.arrReservations.filter { (model) -> Bool in
                if let date = (model.bookingDate ?? "").getDateFromString(format: "yyyy-MM-dd", locale: nil) ?? (model.bookingDate ?? "").getDateFromString(format: "dd-MM-yyyy", locale: nil){
                    return date >= fromDate && date < toDate && (model.status ?? "").lowercased() != "pending"
                }
                return false
            }
            arrO.forEach { (model) in
                let date = (model.bookingDate ?? "").changeDateFormat(fromFormat: "yyyy-MM-dd", toFormat: "MMMM yyyy") ?? (model.bookingDate ?? "").changeDateFormat(fromFormat: "dd-MM-yyyy", toFormat: "MMMM yyyy") ?? ""
                if var arr = dictReservations[date]{
                    arr.append(model)
                    dictReservations[date] = self.sortReservaationArray(arr: arr)
                }else{
                    dictReservations[date] = [model]
                    arrReservationDate.append(date)
                }
            }
            arrReservationDate.sort { str1, str2 in
                let date1 = str1.getDateFromString(format: "MMMM yyyy") ?? Date()
                let date2 = str2.getDateFromString(format: "MMMM yyyy") ?? Date()
                return date1 > date2
            }
        }
        
        self.lblTotalCustomer.text = "\(strReservation)\nTotal reservations: \(totalCount)"
        self.tblReservation.reloadData()
    }
    
    @objc func StartAPICall(){
        apiCount = 0
        totalAPI = 2
        FetchReservationList()
        CallGetReservationListAPI()
    }
    
    func stopLoader(){
        apiCount += 1
        if apiCount == totalAPI{
            self.refreshControl.endRefreshing()
            AppCommonMethods.stopProgressBar()
            FetchReservationFromDB()
        }
    }
    
    func getAttributedString(label:UILabel)->NSAttributedString?{
        return NSAttributedString.init(string: label.text ?? "", attributes: [NSAttributedString.Key.font: label.font!,NSAttributedString.Key.foregroundColor: AppConstants.Colors.kAppThemeAquaColor,NSAttributedString.Key.underlineStyle:NSUnderlineStyle.single.rawValue])
    }
    
    //MARK: WebService Mthods
    func DeleteReservationAPI(model:ReservationModel, table:TableModel){
        let dictParam = [String:Any]()
        AppCommonMethods.startProgressBar()
        WebServiceManager().requestAPI(params: dictParam, urlString: "\(AppConstants.APIURL.kReservations)/\(model.id ?? 0)", method: "DELETE") { (message, result) in
            DispatchQueue.main.async {
                AppCommonMethods.stopProgressBar()
                if let response = result as? NSDictionary{
                    let jsonDecoder = JSONDecoder()
                    if let data = AppCommonMethods.convertToJson(object: response), let reservation = try? jsonDecoder.decode(ReservationModel.self, from: data){
                        if reservation.id ?? 0 != 0{
                            CoreDataHelper.shared.DeleteReservation(uniquId: reservation.uniqueId, isFromAPI: true)
                            self.createOrderAction(model: model, table: table)
                            return
                        }
                    }
                }
                AppValidation().showAlertView(parentVC: self, withAlertTile: AppConstants.GlobalAlert.ALERT_TITLE, withAlertMsg: message, withActionsTitle: [AppConstants.GlobalAlert.ALERT_BTN_OK]) { (index) in
                    
                }
            }
        }
    }
    
    func FetchReservationList(){
        if Reachabilities.shared.isConnectedToNetwork(){
            var dictParam = [String:String]()
            dictParam["nopaginate"] = "1"
            AppCommonMethods.startProgressBar()
            WebServiceManager().requestAPI(params: dictParam, urlString: AppConstants.APIURL.kReservations, method: "GET") { (message, result) in
                DispatchQueue.main.async {
                    if let response = result as? [NSDictionary]{
                        let jsonDecoder = JSONDecoder()
                        if let data = AppCommonMethods.convertToJson(object: response), let aData = try? jsonDecoder.decode([ReservationModel].self, from: data){
                            CoreDataHelper.shared.SaveReservationToDatabase(arrData: aData)
                            self.FetchReservationFromDB()
                        }
                    }
                    self.stopLoader()
                }
            }
        }else{
            self.stopLoader()
        }
    }
    
    func DeleteReservationList(){
        if Reachabilities.shared.isConnectedToNetwork(){
            var dictParam = [String:String]()
            dictParam["ids"] = AppCommonMethods.convertJsontoString(json: self.arrSelectedOnlineReservation.map { ($0.id ?? 0).description })
            AppCommonMethods.startProgressBar()
            WebServiceManager().requestAPI(params: dictParam, urlString: AppConstants.APIURL.kBulkDelete, method: "POST") { (message, result) in
                DispatchQueue.main.async {
                    AppCommonMethods.stopProgressBar()
                    if let response = result as? NSDictionary, let ids = response["ids"] as? [String]{
                        for id in ids{
                            if let index = self.arrReservations.firstIndex(where: { model in
                                return Int(id) ?? 0 == model.id ?? 0
                            }){
                                self.arrReservations.remove(at: index)
                            }
                        }
                        self.arrSelectedOnlineReservation.removeAll()
                        self.tblReservation.reloadData()
                    }
                }
            }
        }
    }
    
    func CallGetReservationListAPI(){
        var dictParam = [String:String]()
        dictParam["nopaginate"] = "1"
        AppCommonMethods.startProgressBar()
        WebServiceManager().requestAPI(params: dictParam, urlString: AppConstants.APIURL.kOnlineReservation, method: "GET", isRestaurantAPI: true) { (message, result) in
            DispatchQueue.main.async {
                if let response = result as? [NSDictionary]{
                    let jsonDecoder = JSONDecoder()
                    if let data = AppCommonMethods.convertToJson(object: response), let aData = try? jsonDecoder.decode([OnlineReservationModel].self, from: data){
                        self.arrReservations = aData
                    }
                }
                self.stopLoader()
            }
        }
    }
    
    func CancelReservation(reservation:ReservationModel){
        var dictParam = [String:Any]()
        let dictCustomer = NSMutableDictionary()
        if reservation.customer?.offline ?? 1 == 0{
            dictCustomer["id"] = reservation.customer?.id ?? 0
            dictParam["customer_id"] = reservation.customer?.id ?? 0
        }else{
            dictParam["customer_id"] = ""
            dictCustomer["id"] = ""
        }
        dictCustomer["name"] = reservation.customer?.name ?? ""
        dictCustomer["mobile"] = reservation.customer?.mobile ?? ""
        dictCustomer["email"] = reservation.customer?.email ?? ""

        dictParam["customer"] = AppCommonMethods.convertJsontoString(json: dictCustomer)

        if reservation.tableId ?? 0 != 0{
            dictParam["table_id"] = reservation.tableId ?? 0
        }

        dictParam["telephone"] = reservation.customer?.mobile ?? ""
        dictParam["reservation_status_id"] = 2
        dictParam["updater_id"] = AppConstants.userData?.id ?? 0
        if reservation.depositTypeId ?? 0 != 0{
            dictParam["deposit_type_id"] = reservation.depositTypeId ?? 0
        }
        if reservation.depositAmount ?? 0 != 0{
            dictParam["deposit_amount"] = reservation.depositAmount ?? 0
        }
        dictParam["updater_id"] = AppConstants.userData?.id ?? 0
        dictParam["diners"] = reservation.diners ?? 0
        dictParam["special_instruction"] = reservation.specialInstruction ?? ""
        dictParam["reservation_date_time"] = reservation.reservationDateTime ?? ""
        
        dictParam["unique_id"] = reservation.uniqueId
        var strURL = AppConstants.APIURL.kReservations
        if reservation.offline == 0{
            strURL = "\(AppConstants.APIURL.kReservations)/\(reservation.id ?? 0)"
        }
        let oldId = reservation.id ?? 0
        
        reservation.reservationStatusId = 2
        
        self.tblReservation.reloadData()
        CoreDataHelper.shared.SaveReservationToDatabase(reservation: reservation, update: 1, oldId: oldId)
        AppCommonMethods.showToastAlert(message: AppConstants.GlobalAlert.ALERT_CANCELLED_RESERVATION)
        if Reachabilities.shared.isConnectedToNetwork(){
            AppCommonMethods.startProgressBar()
            WebServiceManager().requestAPI(params: dictParam, urlString: strURL, method: "POST") { (message, result) in
                DispatchQueue.main.async {
                    AppCommonMethods.stopProgressBar()
                    if let response = result as? NSDictionary{
                        let jsonDecoder = JSONDecoder()
                        if let data = AppCommonMethods.convertToJson(object: response), let aData = try? jsonDecoder.decode(ReservationModel.self, from: data){
                            aData.offline = 0
                            CoreDataHelper.shared.SaveReservationToDatabase(reservation: aData, oldCustomerId: reservation.customer?.id, update: 0, oldId: oldId)
                            return
                        }
                    }
                }
            }
        }
    }
    
    func CallSetBookingStatusAPI(status:String, cancelReason:String = ""){
        var dictParam = [String:Any]()
        var reservation:OnlineReservationModel!
        if selectedSection == 0{
            reservation = arrNewReservation[selectedRow]
        }else{
            if let model = dictReservations[arrReservationDate[selectedSection-1]]?[selectedRow] as? OnlineReservationModel{
                reservation = model
            }
        }
        dictParam["status"] = status
        dictParam["cancel_reason"] = cancelReason
        AppCommonMethods.startProgressBar()
        WebServiceManager().requestAPI(params: dictParam, urlString: "\(AppConstants.APIURL.kOnlineReservation)\(reservation.id ?? 0)/change-status", method: "POST", isRestaurantAPI: true) { (message, result) in
            DispatchQueue.main.async {
                AppCommonMethods.stopProgressBar()
                if let response = result as? NSDictionary{
                    let jsonDecoder = JSONDecoder()
                    if let data = AppCommonMethods.convertToJson(object: response), let aData = try? jsonDecoder.decode(OnlineReservationModel.self, from: data){
                        self.apiCount = 0
                        self.totalAPI = 1
                        self.CallGetReservationListAPI()
                        var setting = BottomAlertSettings()
                        if status == "Cancel"{
                            setting.isClickable = true
                            setting.strMessage = AppConstants.GlobalAlert.RESERVATION_REJECTED
                            setting.reservationModel = aData
                            setting.bgColor = AppConstants.Colors.kAppThemeRedColor
                            setting.type = .kReservation
                        }else if status == "Approved"{
                            setting.isClickable = true
                            setting.bgColor = AppConstants.Colors.kAppDarkGreenColor
                            setting.reservationModel = aData
                            setting.strMessage = AppConstants.GlobalAlert.RESERVATION_ACCEPETD
                            setting.type = .kReservation
                        }
                        AppValidation().showBottomAlertView(settings: setting)
                    }
                    BadgeManager.shared?.stopLastAPICall()
                }else{
                    AppValidation().showAlertView(parentVC: self, withAlertTile: AppConstants.GlobalAlert.ALERT_TITLE, withAlertMsg: message, withActionsTitle: [AppConstants.GlobalAlert.ALERT_BTN_OK]) { (index) in
                        
                    }
                }
            }
        }
    }
    
    func SaveReservation(name:String? = nil, diners:Int? = nil, contactNo:String? = nil, comment:String? = nil, selectedTable:TableModel? = nil){
        
        if name != nil{
            selectedReservation?.customer?.name = name
        }
        
        if contactNo != nil{
            selectedReservation?.customer?.mobile = contactNo
        }
        
        if selectedTable != nil{
            selectedReservation?.tableId = selectedTable?.id
            selectedReservation?.tableNumber = selectedTable?.number
        }
        
        if diners != nil{
            selectedReservation?.diners = diners ?? 0
        }
        
        if comment != nil{
            selectedReservation?.specialInstruction = comment ?? ""
        }
        
        CoreDataHelper.shared.SaveReservationToDatabase(reservation: selectedReservation!, update: 1)
        
        
        self.tblReservation.reloadData()
        if Reachabilities.shared.isConnectedToNetwork(){
            var dictParam = [String:Any]()
            let dictCustomer = NSMutableDictionary()
            if selectedReservation?.customer?.offline ?? 0 == 1{
                dictParam["customer_id"] = ""
                dictCustomer["id"] = ""
            }else{
                dictCustomer["id"] = selectedReservation?.customer?.id ?? 0
                dictParam["customer_id"] = selectedReservation?.customer?.id ?? 0
            }
            
            if name != nil{
                dictCustomer["name"] = name ?? ""
            }
            
            if contactNo != nil{
                dictCustomer["mobile"] = contactNo ?? ""
                dictParam["telephone"] = contactNo ?? ""
            }
            
            dictParam["customer"] = dictCustomer
            
            if selectedTable != nil{
                dictParam["table_id"] = selectedTable?.id ?? 0
            }
            
            dictParam["updater_id"] = AppConstants.userData?.id ?? 0
            
            if diners != nil{
                dictParam["diners"] = diners ?? 0
            }
            
            if comment != nil{
                dictParam["special_instruction"] = comment ?? ""
            }
            
            dictParam["unique_id"] = selectedReservation!.uniqueId
            var strURL = AppConstants.APIURL.kReservations
            if selectedReservation?.offline ?? 0 == 0{
                strURL = "\(AppConstants.APIURL.kReservations)/\(selectedReservation?.id ?? 0)"
            }
            
//            dictParam["reservation_date_time"] = selectedReservation?.reservationDateTime
            dictParam["customer"] = AppCommonMethods.convertJsontoString(json: dictCustomer)
            
            
           // AppCommonMethods.startProgressBar()
            WebServiceManager().requestAPI(params: dictParam, urlString: strURL, method: "POST") { (message, result) in
                DispatchQueue.main.async {
                    //AppCommonMethods.stopProgressBar()
                    if let response = result as? NSDictionary{
                        let jsonDecoder = JSONDecoder()
                        if let data = AppCommonMethods.convertToJson(object: response), let aData = try? jsonDecoder.decode(ReservationModel.self, from: data){
                            aData.offline = 0
                            CoreDataHelper.shared.SaveReservationToDatabase(reservation: aData, oldCustomerId: self.selectedReservation?.customer?.id, update: 0, oldId: self.selectedReservation?.id)
                            self.selectedReservation?.id = aData.id
                            self.selectedReservation?.offline = 0
                            self.selectedReservation?.customer?.id = aData.customerId
                            self.selectedReservation?.customerId = aData.customerId
                            self.selectedReservation?.customer?.offline = 0
                            self.tblReservation.reloadData()
                            return
                        }
                    }
                }
            }
        }
    }
}

//MARK: UITableViewDataSource
extension ReservationListVC:UITableViewDataSource, UITableViewDelegate{
    func numberOfSections(in tableView: UITableView) -> Int {
        return arrReservationDate.count+1
    }
    
    func tableView(_ tableView: UITableView, cellForRowAt indexPath: IndexPath) -> UITableViewCell {
        let cell = tableView.dequeueReusableCell(withIdentifier: "ReservationItemCell", for: indexPath) as! ReservationItemCell
        cell.btnView.tag = indexPath.row
        cell.btnPrint.tag = indexPath.row
        cell.btnCancel.tag = indexPath.row
        cell.btnInstruction.tag = indexPath.row
        cell.btnSeatOnTable.tag = indexPath.row
        cell.btnName.tag = indexPath.row
        cell.btnName.accessibilityIdentifier = "\(indexPath.section)"
        cell.btnDate.tag = indexPath.row
        cell.btnDate.accessibilityIdentifier = "\(indexPath.section)"
        cell.btnSelect.tag = indexPath.row
        cell.btnSelect.accessibilityIdentifier = "\(indexPath.section)"
        cell.btnDiners.tag = indexPath.row
        cell.btnDiners.accessibilityIdentifier = "\(indexPath.section)"
        cell.btnTableNo.tag = indexPath.row
        cell.btnTableNo.accessibilityIdentifier = "\(indexPath.section)"
        cell.btnContactNo.tag = indexPath.row
        cell.btnContactNo.accessibilityIdentifier = "\(indexPath.section)"
        cell.btnSeatOnTable.accessibilityIdentifier = "\(indexPath.section)"
        cell.btnView.accessibilityIdentifier = "\(indexPath.section)"
        cell.btnPrint.accessibilityIdentifier = "\(indexPath.section)"
        cell.btnCancel.accessibilityIdentifier = "\(indexPath.section)"
        cell.btnInstruction.accessibilityIdentifier = "\(indexPath.section)"
        cell.btnCancel.setTitleColor(AppConstants.Colors.kAppThemeRedColor, for: .normal)
        cell.btnInstruction.isHidden = false
        cell.lblNoInstruction.isHidden = true
        cell.lblName.attributedText = nil
        cell.lblDate.attributedText = nil
        cell.lblDiners.attributedText = nil
        cell.lblTableNo.attributedText = nil
        cell.lblContactNo.attributedText = nil
        cell.viewForBG.backgroundColor = AppConstants.Colors.kAppThemeBGColor
        cell.lblName.textColor = AppConstants.Colors.kAppDarkGrayColor
        cell.lblDate.textColor = AppConstants.Colors.kAppDarkGrayColor
        cell.lblDiners.textColor = AppConstants.Colors.kAppDarkGrayColor
        cell.lblTableNo.textColor = AppConstants.Colors.kAppDarkGrayColor
        cell.lblContactNo.textColor = AppConstants.Colors.kAppDarkGrayColor
        cell.btnSelect.tintColor = AppConstants.Colors.kAppDarkGrayColor
        cell.btnPrint.setTitleColor(AppConstants.Colors.kAppMediumGreenColor, for: .normal)
        cell.btnView.setTitleColor(AppConstants.Colors.kAppThemeAquaColor, for: .normal)
        cell.lblNoInstruction.textColor = AppConstants.Colors.kAppDarkGrayColor
        cell.lblDate.text = "-"
        if indexPath.section == 0{
            let model = arrNewReservation[indexPath.row]
            cell.btnSeatOnTable.isHidden = true
            cell.lblName.text = model.customerName ?? ""
            cell.lblDate.text = "\(model.bookingDate ?? "") \(model.bookingTime ?? "")"
            cell.lblDiners.text = "\(model.guestCount ?? 0)"
            cell.lblTableNo.text = "-"
            cell.lblContactNo.text = model.bookingPhone ?? ""
            if model.bookingInstruction ?? "" == ""{
                cell.btnInstruction.isHidden = true
                cell.lblNoInstruction.isHidden = false
            }
            cell.btnCancel.setTitle("Cancel", for: .normal)
            cell.btnCancel.isUserInteractionEnabled = true
            cell.btnPrint.setTitle("Approve", for: .normal)
            cell.viewForBG.backgroundColor = AppConstants.Colors.kAppMediumGreenColor
            cell.lblName.textColor = .white
            cell.lblDate.textColor = .white
            cell.lblDiners.textColor = .white
            cell.btnSelect.tintColor = .white
            cell.lblTableNo.textColor = .white
            cell.lblContactNo.textColor = .white
            cell.lblNoInstruction.textColor = .white
            cell.btnCancel.setTitleColor(.white, for: .normal)
            cell.btnPrint.setTitleColor(.white, for: .normal)
            cell.btnView.setTitleColor(.white, for: .normal)
            let Instruction = NSAttributedString.init(string: "Click to view", attributes: [NSAttributedString.Key.font: cell.lblContactNo.font!,NSAttributedString.Key.foregroundColor: UIColor.white,NSAttributedString.Key.underlineStyle:NSUnderlineStyle.single.rawValue])
            cell.btnInstruction.setAttributedTitle(Instruction, for: .normal)
            if let _ = arrSelectedOnlineReservation.firstIndex(where: { reservation in
                return reservation.id ?? 0 == model.id ?? 0
            }){
                cell.btnSelect.isSelected = true
            }else{
                cell.btnSelect.isSelected = false
            }
            return cell
        }
        if let model = dictReservations[arrReservationDate[indexPath.section-1]]?[indexPath.row] as? ReservationModel{
            cell.btnSeatOnTable.isHidden = false
            cell.lblName.text = model.customer?.name ?? ""
            cell.lblName.attributedText = self.getAttributedString(label: cell.lblName)
            cell.lblDate.text = (model.reservationDateTime ?? "").changeDateFormat(fromFormat: "yyyy-MM-dd HH:mm:ss", toFormat: "yyyy-MM-dd HH:mm") ?? ""
            cell.lblDate.attributedText = self.getAttributedString(label: cell.lblDate)
            cell.lblDiners.text = "\(model.diners ?? 0)"
            cell.lblDiners.attributedText = self.getAttributedString(label: cell.lblDiners)
            cell.lblTableNo.text = model.tableNumber ?? ""
            cell.lblTableNo.attributedText = self.getAttributedString(label: cell.lblTableNo)
            cell.lblContactNo.text = model.customer?.mobile ?? ""
            cell.lblContactNo.attributedText = self.getAttributedString(label: cell.lblContactNo)
            var strInst = "Add"
            var color = AppConstants.Colors.kAppThemeAquaColor
            if model.specialInstruction ?? "" != ""{
                strInst = "Click to view"
                color = AppConstants.Colors.kAppThemeBlueColor
            }
            let Instruction = NSAttributedString.init(string: strInst, attributes: [NSAttributedString.Key.font: cell.lblContactNo.font!,NSAttributedString.Key.foregroundColor: color,NSAttributedString.Key.underlineStyle:NSUnderlineStyle.single.rawValue])
            cell.btnInstruction.setAttributedTitle(Instruction, for: .normal)
            if model.reservationStatusId ?? 0 == 2{
                cell.btnCancel.isUserInteractionEnabled = false
                cell.btnCancel.setTitle("Cancelled", for: .normal)
            }else{
                cell.btnCancel.setTitle("Cancel", for: .normal)
                cell.btnCancel.isUserInteractionEnabled = true
            }
            if let _ = arrSelectedReservation.firstIndex(where: { reservation in
                return reservation.id ?? 0 == model.id ?? 0
            }){
                cell.btnSelect.isSelected = true
            }else{
                cell.btnSelect.isSelected = false
            }
            cell.btnPrint.setTitle("Print", for: .normal)
        }else if let model = dictReservations[arrReservationDate[indexPath.section-1]]?[indexPath.row] as? OnlineReservationModel{
            cell.btnSeatOnTable.isHidden = true
            cell.lblName.text = model.customerName ?? ""
            cell.lblDate.text = "\(model.bookingDate ?? "") \(model.bookingTime ?? "")"
            cell.lblDiners.text = "\(model.guestCount ?? 0)"
            cell.lblTableNo.text = "-"
            cell.lblContactNo.text = model.bookingPhone ?? ""
            if model.bookingInstruction ?? "" == ""{
                cell.btnInstruction.isHidden = true
                cell.lblNoInstruction.isHidden = false
            }
            if model.status ?? "" == "Cancel"{
                cell.btnCancel.isUserInteractionEnabled = false
                cell.btnCancel.setTitle("Cancelled", for: .normal)
                cell.btnPrint.setTitle("Print", for: .normal)
            }else if model.status ?? "" == "Approved"{
                cell.btnCancel.isUserInteractionEnabled = false
                cell.btnCancel.setTitleColor(AppConstants.Colors.kAppMediumGreenColor, for: .normal)
                cell.btnCancel.setTitle("Completed", for: .normal)
                cell.btnPrint.setTitle("Print", for: .normal)
            }else{
                cell.btnCancel.setTitle("Cancel", for: .normal)
                cell.btnCancel.isUserInteractionEnabled = true
                cell.btnPrint.setTitle("Approve", for: .normal)
            }
            if let _ = arrSelectedOnlineReservation.firstIndex(where: { reservation in
                return reservation.id ?? 0 == model.id ?? 0
            }){
                cell.btnSelect.isSelected = true
            }else{
                cell.btnSelect.isSelected = false
            }
            let Instruction = NSAttributedString.init(string: "Click to view", attributes: [NSAttributedString.Key.font: cell.lblContactNo.font!,NSAttributedString.Key.foregroundColor: AppConstants.Colors.kAppThemeBlueColor,NSAttributedString.Key.underlineStyle:NSUnderlineStyle.single.rawValue])
            cell.btnInstruction.setAttributedTitle(Instruction, for: .normal)
        }
        return cell
    }
    
    func tableView(_ tableView: UITableView, heightForHeaderInSection section: Int) -> CGFloat {
        if section == 0 && arrNewReservation.count == 0{
            return 0
        }
        return 40
    }
    
    func tableView(_ tableView: UITableView, numberOfRowsInSection section: Int) -> Int {
        if section == 0{
            return arrNewReservation.count
        }
        return dictReservations[arrReservationDate[section-1]]?.count ?? 0
    }
    
    func tableView(_ tableView: UITableView, viewForHeaderInSection section: Int) -> UIView? {
        let cell = tableView.dequeueReusableCell(withIdentifier: "ReservationHeaderCell") as! ReservationHeaderCell
        if section == 0{
            cell.lblTitle.text = "New Online Reservations (\(arrNewReservation.count))"
        }else{
            cell.lblTitle.text = arrReservationDate[section-1]
        }
        return cell
    }
}

//MARK: AlertControllerDelegate
extension ReservationListVC:AlertControllerDelegate{
    func alertButtonAction(index: Int, data: alertViewData, type: AlertType) {
        if index == 1{
            var reservation:Any!
            if selectedSection == 0{
                reservation = arrNewReservation[selectedRow]
            }else{
                if let model = dictReservations[arrReservationDate[selectedSection-1]]?[selectedRow] as? ReservationModel{
                    reservation = model
                }
                if let model = dictReservations[arrReservationDate[selectedSection-1]]?[selectedRow] as? OnlineReservationModel{
                    reservation = model
                }
            }
            if type == .kNormal{
                if let model = reservation as? ReservationModel{
                    self.CancelReservation(reservation: model)
                }else{
                    CallSetBookingStatusAPI(status: "Approved", cancelReason: "")
                }
            }else if type == .kRejectOrder{
                CallSetBookingStatusAPI(status: "Cancel", cancelReason: data.value)
            }
        }
    }
}

//MARK: ReservationDelegate
extension ReservationListVC:ReservationDelegate{
    func cancelReservation() {
        if let VC = CancelReasonVC.showPopup(parentVC: self.parentVC, viewType: .kReservation){
            VC.delegate = self
        }
    }
    
    func AcceptReservation() {
        var setting = AlertSetting()
        setting.alertMessage = AppConstants.GlobalAlert.ALERT_CONFIRM_RESERVATION
        setting.alertTitle = AppConstants.GlobalAlert.ALERT_ACCEPT_RESERVATION_TITLE
        if let VC = AlertViewController.showPopup(parentVC: self.parentVC, setting: setting){
            VC.delegate = self
        }
    }
}

//MARK: SwapTableDelegate
extension ReservationListVC:SwapTableDelegate{
    func tableSelected(table:TableModel, orderType:OrderTypesModel?, isMergedTable:Bool){
        if let model = self.dictReservations[self.arrReservationDate[selectedSection-1]]?[selectedRow] as? ReservationModel{
            if editType == ""{
                if model.offline == 1{
                    CoreDataHelper.shared.DeleteReservation(uniquId: model.uniqueId, isFromAPI: true)
                    self.createOrderAction(model: model, table: table)
                }else{
                    CoreDataHelper.shared.DeleteReservation(uniquId: model.uniqueId, isFromAPI: false)
                    if Reachabilities.shared.isConnectedToNetwork(){
                        self.DeleteReservationAPI(model: model, table: table)
                    }else{
                        self.createOrderAction(model: model, table: table)
                    }
                }
            }else{
                self.SaveReservation(selectedTable: table)
            }
        }
    }
}

extension ReservationListVC:pageRefreshDelegate{
    func pageNeedToRefresh() {
        StartAPICall()
    }
}

extension ReservationListVC:UITextFieldDelegate{
    func textField(_ textField: UITextField, shouldChangeCharactersIn range: NSRange, replacementString string: String) -> Bool {
        let allowedCharacters = CharacterSet(charactersIn:"0123456789")
        let characterSet = CharacterSet(charactersIn: string)
        if editType == "diners" || editType == "contact_no"{
            return allowedCharacters.isSuperset(of: characterSet)
        }
        return true
    }
    
    func textFieldShouldBeginEditing(_ textField: UITextField) -> Bool {
        if textField == txtToDate{
            let datePicker = ActionSheetDatePicker(title: "Select Date", datePickerMode: UIDatePicker.Mode.date, selectedDate: toDate, doneBlock: {
                picker, value, index in
                self.toDate = (value as! Date)
                if self.fromDate > self.toDate{
                    self.fromDate = self.toDate
                }
                self.txtToDate.text = "To - \(self.toDate.getDateInString(format: "dd/MM/yyyy"))"
                self.txtFromDate.text = "From - \(self.fromDate.getDateInString(format: "dd/MM/yyyy"))"
                self.FetchReservationFromDB()
            }, cancel: { ActionStringCancelBlock in return }, origin: textField)
            datePicker?.minimumDate = self.fromDate
            datePicker?.show()
            return false
        }else if textField == txtFromDate{
            let datePicker = ActionSheetDatePicker(title: "Select Date", datePickerMode: UIDatePicker.Mode.date, selectedDate: fromDate, doneBlock: {
                picker, value, index in
                self.fromDate = (value as! Date)
                if self.toDate < self.fromDate{
                    self.toDate = self.fromDate
                }
                self.txtToDate.text = "To - \(self.toDate.getDateInString(format: "dd/MM/yyyy"))"
                self.txtFromDate.text = "From - \(self.fromDate.getDateInString(format: "dd/MM/yyyy"))"
                self.FetchReservationFromDB()
            }, cancel: { ActionStringCancelBlock in return }, origin: textField)
            datePicker?.maximumDate = self.toDate
            datePicker?.show()
            return false
        }
        return true
    }
}

extension ReservationListVC:CommentDelegate{
    func cancelClicked() {
        
    }
    
    func commentAdded(comment: String) {
        self.SaveReservation(comment: comment)
    }
}
