//
//  CreateVoucherVC.swift
//  EPOS
//
//  Created by Apple on 10/06/21.
//

import UIKit
import DropDown
import ActionSheetPicker_3_0
import CoreData

class CreateVoucherVC: UIViewController {

    //MARK: IBOutlet
    @IBOutlet weak var txtCustomerName:UITextField!
    @IBOutlet weak var txtContactNo:UITextField!
    @IBOutlet weak var lblViewTitle:UILabel!
    @IBOutlet weak var lblVoucherNo:UILabel!
    @IBOutlet weak var txtEmailId:UITextField!
    @IBOutlet weak var txtSearchCustomer:UITextField!
    @IBOutlet weak var txtAmount:UITextField!
    @IBOutlet weak var lblNoExpiry:UILabel!
    @IBOutlet weak var imgNoExpiry:UIImageView!
    @IBOutlet weak var txtFromDate:UITextField!
    @IBOutlet weak var txtToDate:UITextField!
    @IBOutlet weak var txtMinimumAmount:UITextField!
    @IBOutlet weak var tblDays:UITableView!
    @IBOutlet weak var tblOrderType:UITableView!
    @IBOutlet weak var btnBack:UIButton!
    @IBOutlet weak var btnVoucherHistory:UIButton!
    @IBOutlet weak var btnCancel:UIButton!
    
    //MARK: Instances
    var arrCustomer = [CustomerModel]()
    var selectedCutomer:CustomerModel?
    var startDate:Date?
    var isNoExpiry = false
    var endDate:Date?
    var arrDays = ["Sunday","Monday","Tuesday","Wednesday","Thursday","Friday","Saturday"]
    var arrSelectedDays = [Int]()
    var arrAmounts:[Double] = [0,5,10,15,20,25,30]
    var arrOrderTypes = [OrderTypesModel]()
    var arrSelectedOrderTypes = [OrderTypesModel]()
    var selectedAmount:Double?
    var customAmount:Double?
    var selectedVoucher:VoucherModel?
    var parentVC:SideMenuVC!
    weak var delegate:pageRefreshDelegate?
    let customerDropDown = DropDown()
    
    //MARK: ViewController LifeCycle
    override func viewDidLoad() {
        super.viewDidLoad()

        // Do any additional setup after loading the view.
        
        arrOrderTypes = AppConstants.arrOrderTypes
        setVOucherData()
        customerDropDown.dismissMode = .automatic
        customerDropDown.anchorView = txtSearchCustomer
        customerDropDown.bottomOffset = CGPoint(x: 0, y: txtSearchCustomer.bounds.height)
        // Action triggered on selection
        customerDropDown.selectionAction = { [weak self] (index, item) in
            self?.selectedCutomer = self?.arrCustomer[index]
            self?.view.endEditing(true)
            self?.setCustomerData()
        }
        
    }

    //MARK: Create ViewController Instance
    static func addToParentView(parentVC:SideMenuVC, voucher:VoucherModel? = nil)->CreateVoucherVC?{
        guard let VC = UIStoryboard.init(name: "Others", bundle: nil).instantiateViewController(withIdentifier: "CreateVoucherVC") as? CreateVoucherVC else {
            return nil
        }
        VC.selectedVoucher = voucher
        VC.parentVC = parentVC
        parentVC.addChild(VC)
        parentVC.viewForContainer.addSubview(VC.view)
        VC.view.frame = CGRect.init(x: 0, y: 0, width: parentVC.viewForContainer.frame.width, height: parentVC.viewForContainer.frame.height)
        return VC
    }
    
    //MARK: General Methods
    func setVOucherData(){
        btnBack.isHidden = false
        if selectedVoucher != nil{
            btnCancel.isHidden = false
            lblViewTitle.text = "Update Voucher"
            btnVoucherHistory.isHidden = true
            let customer = CustomerModel()
            customer.name = selectedVoucher?.customer?.name
            customer.id = selectedVoucher?.customerId
            customer.email = selectedVoucher?.customer?.email
            customer.mobile = selectedVoucher?.customer?.mobile
            self.selectedCutomer = customer
            setCustomerData()
            
            self.txtAmount.text = String.init(format: "%@%.2f", AppConstants.currencySign,selectedVoucher?.voucherAmount ?? 0)
            self.txtMinimumAmount.text = String.init(format: "%@%.2f", AppConstants.currencySign,selectedVoucher?.minimumOrderValue ?? 0)
            self.startDate = (selectedVoucher?.startDate ?? "").getDateFromString(format: "yyyy-MM-dd HH:mm:ss")
            
            if selectedVoucher?.endDate ?? "" == "" || selectedVoucher?.endDate ?? "" == "0000-00-00 00:00:00"{
                isNoExpiry = true
                lblNoExpiry.textColor = AppConstants.Colors.kAppThemeAquaColor
                imgNoExpiry.superview?.backgroundColor = AppConstants.Colors.kAppThemeAquaColor
                imgNoExpiry.image = UIImage.init(named: "ic_selected_green")?.withTintColor(.white)
                txtToDate.isUserInteractionEnabled = false
            }else{
                self.endDate = (selectedVoucher?.endDate ?? "").getDateFromString(format: "yyyy-MM-dd HH:mm:ss")
                self.txtToDate.text = "To - \(endDate?.getDateInString(format: "dd/MM/yyyy") ?? "")"
            }
            
            self.txtFromDate.text = "From - \(startDate?.getDateInString(format: "dd/MM/yyyy") ?? "")"
            if let min = selectedVoucher?.minimumOrderValue{
                if arrAmounts.contains(min){
                    self.selectedAmount = min
                }else{
                    self.customAmount = min
                }
            }
            let arrTypesId = (selectedVoucher?.orderTypeId ?? "").components(separatedBy: ",")
            for id in arrTypesId{
                let arr = arrOrderTypes.filter { (model) -> Bool in
                    return model.id ?? 0 == Int(id) ?? 0
                }
                if arr.count > 0{
                    arrSelectedOrderTypes.append(arr[0])
                }
            }
            self.lblVoucherNo.text = self.selectedVoucher?.voucherCode ?? ""
            
            if self.selectedVoucher?.weekDay ?? "" != ""{
                let arr = (self.selectedVoucher?.weekDay ?? "").components(separatedBy: ",")
                
                arr.forEach { (day) in
                    self.arrSelectedDays.append(Int(day) ?? 0)
                }
            }
            
            self.tblDays.reloadData()
            self.tblOrderType.reloadData()
        }else{
            lblVoucherNo.text = randomString(length: Int(AppCommonMethods.fetchSiteSettingValue(key: "offer_code_length") ?? "") ?? 0)
        }
    }
    
    func randomString(length: Int) -> String {
      let letters = "ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789"
      return String((0..<length).map{ _ in letters.randomElement()! })
    }
    
    func setCustomerData(){
        txtCustomerName.text = selectedCutomer?.name ?? ""
        txtContactNo.text = selectedCutomer?.mobile ?? ""
        txtSearchCustomer.text = ""
        txtEmailId.text = selectedCutomer?.email ?? ""
    }
    
    func checkValidation()->Bool{
        if !(txtContactNo.text ?? "").trimmingCharacters(in: .whitespacesAndNewlines).isEmpty{
            if (txtContactNo.text ?? "").trimmingCharacters(in: .whitespaces).count < 10 || (txtContactNo.text ?? "").trimmingCharacters(in: .whitespaces).count > 11{
                AppValidation().showAlertView(parentVC: self, withAlertTile: AppConstants.GlobalAlert.ALERT_TITLE, withAlertMsg: AppConstants.GlobalAlert.ALERT_MOBILE_10_DIGIT, withActionsTitle: [AppConstants.GlobalAlert.ALERT_BTN_OK]) { (index) in
                    _ = self.txtContactNo.becomeFirstResponder()
                }
                return false
            }
        }
        if !(txtEmailId.text ?? "").trimmingCharacters(in: .whitespacesAndNewlines).isEmpty{
            if !AppValidation().isValidRegEx(txtEmailId.text ?? "", RegEx.email){
                AppValidation().showAlertView(parentVC: self, withAlertTile: AppConstants.GlobalAlert.ALERT_TITLE, withAlertMsg:  AppConstants.GlobalAlert.ALERT_ENTER_VALID_EMAIL, withActionsTitle: [AppConstants.GlobalAlert.ALERT_BTN_OK]) { (index) in
                    _ = self.txtEmailId.becomeFirstResponder()
                }
                return false
            }
        }
        if startDate == nil{
            AppValidation().showAlertView(parentVC: self, withAlertTile: AppConstants.GlobalAlert.ALERT_TITLE, withAlertMsg:  AppConstants.GlobalAlert.kVoucherFromDate, withActionsTitle: [AppConstants.GlobalAlert.ALERT_BTN_OK]) { (index) in
            }
            return false
        }
        if !isNoExpiry && endDate == nil{
            AppValidation().showAlertView(parentVC: self, withAlertTile: AppConstants.GlobalAlert.ALERT_TITLE, withAlertMsg:  AppConstants.GlobalAlert.kVoucherToDate, withActionsTitle: [AppConstants.GlobalAlert.ALERT_BTN_OK]) { (index) in
            }
            return false
        }
        let amount = Double((txtAmount.text ?? "").replacingOccurrences(of: AppConstants.currencySign, with: "")) ?? 0
        if amount == 0{
            AppValidation().showAlertView(parentVC: self, withAlertTile: AppConstants.GlobalAlert.ALERT_TITLE, withAlertMsg:  AppConstants.GlobalAlert.ALERT_ZERO_AMOUNT, withActionsTitle: [AppConstants.GlobalAlert.ALERT_BTN_OK]) { (index) in
                _ = self.txtAmount.becomeFirstResponder()
            }
            return false
        }
        return true
    }
    
    @objc func fetchCustomerOffline(){
        arrCustomer = CoreDataHelper.shared.fetchCustomerData(name: txtSearchCustomer.text ?? "")
        var arrCustomerName = [String]()
        self.arrCustomer.forEach { (model) in
            if model.mobile ?? "" != ""{
                arrCustomerName.append("\(model.name ?? "") (\(model.mobile ?? ""))")
            }else{
                arrCustomerName.append(model.name ?? "")
            }
        }
        customerDropDown.dataSource = arrCustomerName
        customerDropDown.show()
    }
    
    //MARK: Button Actions
    @IBAction func btnConfirmAction(_ sender:UIButton){
        self.view.endEditing(true)
        if checkValidation(){
            CallCreateVoucher(shouldPrint: sender.tag == 1)
        }
    }
    
    @IBAction func btnCancelAction(_ sender:UIButton){
        AppValidation().showAlertView(parentVC: self, withAlertTile: nil, withAlertMsg: "Do you wish to cancel voucher?", withActionsTitle: [AppConstants.GlobalAlert.ALERT_BTN_NO,AppConstants.GlobalAlert.ALERT_BTN_YES]) { (index) in
            if index == 1{
                self.CallDeleteVoucher()
            }
        }
    }
    
    @IBAction func btnVoucherHistoryAction(_ sender:UIButton){
        self.view.endEditing(true)
        self.btnBackAction(self.btnBack)
    }
    
    @IBAction func btnNoExpiryAction(_ sender:UIButton){
        self.view.endEditing(true)
        isNoExpiry = !isNoExpiry
        txtToDate.text = ""
        if isNoExpiry{
            lblNoExpiry.textColor = AppConstants.Colors.kAppThemeAquaColor
            imgNoExpiry.superview?.backgroundColor = AppConstants.Colors.kAppThemeAquaColor
            imgNoExpiry.image = UIImage.init(named: "ic_selected_green")?.withTintColor(.white)
            txtToDate.isUserInteractionEnabled = false
            endDate = Date().addingTimeInterval(10*365*24*60*60)
        }else{
            endDate = nil
            txtToDate.isUserInteractionEnabled = true
            imgNoExpiry.superview?.backgroundColor = .white
            lblNoExpiry.textColor = AppConstants.Colors.kAppLightGrayColor
            imgNoExpiry.image = nil
        }
    }
    
    @IBAction func btnBackAction(_ sender:UIButton){
//        if self.selectedVoucher != nil{
            if self.delegate != nil{
                self.delegate?.pageNeedToRefresh()
            }
            self.view.removeFromSuperview()
            self.removeFromParent()
//        }else{
//            self.parentVC.AddContainerView(data: self.parentVC.arrSideMenu.first!)
//        }
        
    }
    
    @IBAction func txtSearchCustomerAction(_ sender:UITextField){
        if sender.text?.count ?? 0 > 2{
            NSObject.cancelPreviousPerformRequests(withTarget: self, selector: #selector(fetchCustomerOffline), object: nil)
            self.perform(#selector(fetchCustomerOffline), with: nil, afterDelay: 0.1)
        }else{
            self.customerDropDown.hide()
        }
    }
    
    //MARK: WebService Methods
    func CallCreateVoucher(shouldPrint:Bool){
        var dictParam = [String:Any]()
        let dictCustomer = NSMutableDictionary()
        if selectedCutomer == nil{
            dictParam["customer_id"] = ""
            dictCustomer["id"] = ""
        }else{
            if selectedCutomer?.offline ?? 1 == 0{
                dictCustomer["id"] = selectedCutomer?.id ?? 0
                dictParam["customer_id"] = selectedCutomer?.id ?? 0
            }else{
                dictParam["customer_id"] = ""
                dictCustomer["id"] = ""
            }
        }
        
        dictCustomer["name"] = txtCustomerName.text ?? ""
        dictCustomer["mobile"] = txtContactNo.text ?? ""
        dictCustomer["email"] = txtEmailId.text ?? ""
        
        dictParam["customer"] = AppCommonMethods.convertJsontoString(json: dictCustomer)
        
        var strDays = ""
        arrSelectedDays.forEach { (day) in
            if strDays == ""{
                strDays = "\(day)"
            }else{
                strDays = "\(strDays),\(day)"
            }
        }
        dictParam["week_day"] = strDays
        var strTypes = ""
        arrSelectedOrderTypes.forEach { (model) in
            if strTypes == ""{
                strTypes = "\(model.id ?? 0)"
            }else{
                strTypes = "\(strTypes),\(model.id ?? 0)"
            }
        }
        dictParam["order_type_id"] = strTypes
        dictParam["voucher_code"] = lblVoucherNo.text ?? ""
        dictParam["voucher_amount"] = Double((txtAmount.text ?? "").replacingOccurrences(of: AppConstants.currencySign, with: "")) ?? 0
        dictParam["minimum_order_value"] = Double((txtMinimumAmount.text ?? "").replacingOccurrences(of: AppConstants.currencySign, with: "")) ?? 0
        dictParam["start_date"] = self.startDate!.getDateInString(format: "yyyy-MM-dd")
        if isNoExpiry{
            dictParam["end_date"] = nil
        }else{
            dictParam["end_date"] = self.endDate!.getDateInString(format: "yyyy-MM-dd")
        }
        let uniqueId = Int(Date().timeIntervalSinceReferenceDate).description
        dictParam["unique_id"] = uniqueId
        let jsonDecoder = JSONDecoder()
        if let data = AppCommonMethods.convertToJson(object: dictParam), let voucher = try? jsonDecoder.decode(VoucherModel.self, from: data){
            voucher.id = Int(Date().timeIntervalSinceReferenceDate)
            if self.selectedVoucher?.id ?? 0 != 0{
                voucher.id = self.selectedVoucher!.id!
            }
            SQLiteManage.insertVouchers(arrVouchers: [voucher])
            if shouldPrint{
                PrintManager.shared.connectToPrinterWithPrint(model: voucher, controller: self)
            }
            AppCommonMethods.showToastAlert(message: AppConstants.GlobalAlert.ALERT_VOUCHER_UPDATED)
        }
        ManageCustomer.shared.fetchOfflineCustoemr()
    }
    
    func CallDeleteVoucher(){
        let dictParam = [String:String]()
        let id = self.selectedVoucher!.id ?? 0
        if self.selectedVoucher?.offline ?? 0 == 0{
            AppCommonMethods.startProgressBar()
            WebServiceManager().requestAPI(params: dictParam, urlString: "\(AppConstants.APIURL.kVoucher)\(id)", method: "DELETE") { (message, result) in
                DispatchQueue.main.async {
                    AppCommonMethods.stopProgressBar()
                    if let response = result as? NSDictionary{
                        let jsonDecoder = JSONDecoder()
                        if let data = AppCommonMethods.convertToJson(object: response), let voucher = try? jsonDecoder.decode(VoucherModel.self, from: data){
                            if voucher.id ?? 0 != 0{
                                _ = SQLiteManage.ExecuteQuery("DELETE FROM Vouchers WHERE id = \(voucher.id ?? 0)")
                                self.btnBackAction(self.btnBack)
                                return
                            }
                        }
                    }
                    AppValidation().showAlertView(parentVC: self, withAlertTile: AppConstants.GlobalAlert.ALERT_TITLE, withAlertMsg: message, withActionsTitle: [AppConstants.GlobalAlert.ALERT_BTN_OK]) { (index) in
                        
                    }
                }
            }
        }else{
            _ = SQLiteManage.ExecuteQuery("DELETE FROM Vouchers WHERE id = \(self.selectedVoucher?.id ?? 0)")
            self.btnBackAction(self.btnBack)
        }
    }
}

//MARK: UITableViewDataSource
extension CreateVoucherVC:UITableViewDelegate,UITableViewDataSource{
    func tableView(_ tableView: UITableView, numberOfRowsInSection section: Int) -> Int {
        if tableView == tblDays{
            return arrDays.count
        }else if tableView == tblOrderType{
            return arrOrderTypes.count
        }
        return arrAmounts.count+1
    }
    
    func tableView(_ tableView: UITableView, cellForRowAt indexPath: IndexPath) -> UITableViewCell {
        let cell = tableView.dequeueReusableCell(withIdentifier: "ExclusionsViewCell", for: indexPath) as! ExclusionsViewCell
        if tableView == tblDays{
            cell.lblName.text = arrDays[indexPath.row]
            if arrSelectedDays.contains(indexPath.row){
                cell.lblName.textColor = AppConstants.Colors.kAppThemeAquaColor
                cell.viewForSelect.backgroundColor = AppConstants.Colors.kAppThemeAquaColor
                cell.imgSelect.image = UIImage.init(named: "ic_selected_green")?.withTintColor(.white)
                cell.viewForSelect.borderWidth = 0
            }else{
                cell.viewForSelect.borderWidth = 1
                cell.viewForSelect.backgroundColor = .white
                cell.lblName.textColor = AppConstants.Colors.kAppDarkGrayColor
                cell.imgSelect.image = nil
            }
        }else if tableView == tblOrderType{
            let oType = arrOrderTypes[indexPath.row]
            if oType.id ?? 0 == 6{
                cell.lblName.text = "Online"
            }else{
                cell.lblName.text = oType.type ?? ""
            }
            
            let isContain = arrSelectedOrderTypes.contains { (model) -> Bool in
                return model.id ?? 0 == oType.id ?? 0
            }
            if isContain{
                cell.lblName.textColor = AppConstants.Colors.kAppThemeAquaColor
                cell.viewForSelect.backgroundColor = AppConstants.Colors.kAppThemeAquaColor
                cell.imgSelect.image = UIImage.init(named: "ic_selected_green")?.withTintColor(.white)
                cell.viewForSelect.borderWidth = 0
            }else{
                cell.viewForSelect.borderWidth = 1
                cell.viewForSelect.backgroundColor = .white
                cell.lblName.textColor = AppConstants.Colors.kAppDarkGrayColor
                cell.imgSelect.image = nil
            }
        }else{
            if indexPath.row == arrAmounts.count{
                if customAmount != nil{
                    cell.lblName.text = String.init(format: "%@%.2f", AppConstants.currencySign,customAmount!)
                    cell.lblName.textColor = AppConstants.Colors.kAppThemeAquaColor
                    cell.viewForSelect.backgroundColor = AppConstants.Colors.kAppThemeAquaColor
                    cell.imgSelect.image = UIImage.init(named: "ic_selected_green")?.withTintColor(.white)
                    cell.viewForSelect.borderWidth = 0
                }else{
                    cell.viewForSelect.borderWidth = 1
                    cell.viewForSelect.backgroundColor = .white
                    cell.lblName.textColor = AppConstants.Colors.kAppDarkGrayColor
                    cell.imgSelect.image = nil
                    cell.lblName.text = "Custom"
                }
            }else{
                let amount = arrAmounts[indexPath.row]
                if amount == 0{
                    cell.lblName.text = "None"
                }else{
                    cell.lblName.text = String.init(format: "%@%.0f", AppConstants.currencySign,amount)
                }
                cell.viewForSelect.backgroundColor = .white
                cell.lblName.textColor = AppConstants.Colors.kAppDarkGrayColor
                cell.viewForSelect.borderWidth = 1
                cell.imgSelect.image = nil
                if selectedAmount != nil{
                    if selectedAmount! == amount{
                        cell.viewForSelect.borderWidth = 0
                        cell.lblName.textColor = AppConstants.Colors.kAppThemeAquaColor
                        cell.viewForSelect.backgroundColor = AppConstants.Colors.kAppThemeAquaColor
                        cell.imgSelect.image = UIImage.init(named: "ic_selected_green")?.withTintColor(.white)
                    }
                }
            }
        }
        return cell
    }
    
    func tableView(_ tableView: UITableView, didSelectRowAt indexPath: IndexPath) {
        if tblDays == tableView{
            if arrSelectedDays.contains(indexPath.row){
                arrSelectedDays.remove(at: arrSelectedDays.firstIndex(of: indexPath.row)!)
            }else{
                arrSelectedDays.append(indexPath.row)
            }
        }else if tblOrderType == tableView{
            let index = arrSelectedOrderTypes.firstIndex { (model) -> Bool in
                return model.id ?? 0 == arrOrderTypes[indexPath.row].id ?? 0
            }
            if index != nil{
                arrSelectedOrderTypes.remove(at: index!)
            }else{
                arrSelectedOrderTypes.append(arrOrderTypes[indexPath.row])
            }
        }
        tableView.reloadData()
    }
}

//MARK: UITextFieldDelegate
extension CreateVoucherVC:UITextFieldDelegate{
    func textField(_ textField: UITextField, shouldChangeCharactersIn range: NSRange, replacementString string: String) -> Bool {
        let allowedCharacters = CharacterSet(charactersIn:"0123456789")
        let characterSet = CharacterSet(charactersIn: string)
        if txtAmount == textField || txtMinimumAmount == textField{
            if textField.text ?? "" == ""{
                textField.text = "\(AppConstants.currencySign)0.00"
            }
            if allowedCharacters.isSuperset(of: characterSet){
                var strText = (textField.text!).replacingOccurrences(of: AppConstants.currencySign, with: "").replacingOccurrences(of: ".", with: "")
                if string == ""{
                    if strText != "000"{
                        if strText.count == 3{
                            strText.removeLast()
                            strText = "0\(strText)"
                        }else{
                            strText.removeLast()
                        }
                        strText.insert(".", at: strText.index(strText.endIndex, offsetBy: -2))
                        textField.text = "\(AppConstants.currencySign)\(strText)"
                    }
                }else{
                    if strText.first! == "0"{
                        strText.removeFirst()
                        strText = "\(strText)\(string)"
                    }else{
                        strText = "\(strText)\(string)"
                    }
                    strText.insert(".", at: strText.index(strText.endIndex, offsetBy: -2))
                    textField.text = "\(AppConstants.currencySign)\(strText)"
                }
            }
            return false
        }else if textField == txtContactNo{
            return allowedCharacters.isSuperset(of: characterSet)
        }
        return true
    }
    
    
    func textFieldShouldReturn(_ textField: UITextField) -> Bool {
        if textField == txtSearchCustomer{
            if !(textField.text ?? "").trimmingCharacters(in: .whitespacesAndNewlines).isEmpty{
                fetchCustomerOffline()
            }
        }
        return textField.resignFirstResponder()
    }
    
    func textFieldShouldBeginEditing(_ textField: UITextField) -> Bool {
        if textField == txtFromDate{
            self.view.endEditing(true)
            let date = startDate ?? Date()
            let datePicker = ActionSheetDatePicker(title: "Select date", datePickerMode: UIDatePicker.Mode.date, selectedDate: date, doneBlock: {
                picker, value, index in
                self.startDate = (value as! Date)
                if self.endDate != nil{
                    if self.endDate! < self.startDate!{
                        self.endDate = self.startDate
                    }
                    self.txtToDate.text = "To - \(self.endDate!.getDateInString(format: "dd/MM/yyyy"))"
                }
                self.txtFromDate.text = "From - \(self.startDate!.getDateInString(format: "dd/MM/yyyy"))"
                
            }, cancel: { ActionStringCancelBlock in return }, origin: textField)
            datePicker?.minimumDate = Date()
            datePicker?.maximumDate = self.endDate
            datePicker?.show()
            return false
        }else if textField == txtToDate{
            self.view.endEditing(true)
            let date = endDate ?? Date()
            let datePicker = ActionSheetDatePicker(title: "Select time", datePickerMode: UIDatePicker.Mode.date, selectedDate: date, doneBlock: {
                picker, value, index in
                self.endDate = (value as! Date)
                if self.startDate != nil{
                    if self.startDate! > self.endDate!{
                        self.startDate = self.endDate
                    }
                    self.txtFromDate.text = "From - \(self.startDate!.getDateInString(format: "dd/MM/yyyy"))"
                }
                self.txtToDate.text = "To - \(self.endDate!.getDateInString(format: "dd/MM/yyyy"))"
            }, cancel: { ActionStringCancelBlock in return }, origin: textField)
            datePicker?.minimumDate = self.startDate
            datePicker?.show()
            return false
        }
        return true
    }
}

//MARK: AlertControllerDelegate
extension CreateVoucherVC:AlertControllerDelegate{
    func alertButtonAction(index: Int, data: alertViewData, type: AlertType) {
        if index == 1{
            selectedAmount = nil
            customAmount = Double(data.value) ?? 0
        }
    }
}
