//
//  ChatVC.swift
//  TiffinTom
//
//  Created by Tushar Premal on 02/09/20.
//  Copyright © 2020 8Dots. All rights reserved.
//

import UIKit
import SummerSlider
import SDWebImage
import iRecordView
import AVFoundation
import GrowingTextView

class ChatVC: UIViewController {

    //MARK: IBOutlet
    @IBOutlet weak var btnMic:RecordButton!
    @IBOutlet weak var btnSend:UIButton!
    @IBOutlet weak var tblChat:UITableView!
    @IBOutlet weak var viewForRecord:RecordView!
    @IBOutlet weak var txtMessage:GrowingTextView!
    @IBOutlet weak var viewForNewCount:UIView!
    @IBOutlet weak var lblNewMessageCount:UILabel!
    @IBOutlet weak var lblChatTitle:UILabel!
    @IBOutlet weak var lblImgTag:UILabel!
    @IBOutlet weak var imgUserProfile:UIImageView!
    
    //MARK: instances
    var orderDetail:WebOrderModel?
    var arrMessages = [MessagesCellData]()
    var arrNewMessages = [MessagesCellData]()
    var restaurantImage = ""
    var chatTimer:Timer?
    var playAudioTimer:Timer?
    var isSendApiRunning = false
    var isRecordingCancel = false
    var isMAnuallyPause = false
    var isRecordingAllow = false
    var isFromNotificatioon = false
    var recordingSession: AVAudioSession?
    var audioRecorder: AVAudioRecorder?
    var audioPlayer:AVAudioPlayer?
    var playingAudioData:Data?
    var selectedAudioIndex:Int?
    var selectedAudioSection:Int?
    var sliderValue:Double = 0
    var lastMessageId:Int?
    var arrChatDate = [String]()
    var dictChatList = NSMutableDictionary()
    var parentVC:ChatListVC!
    var helpOrder:orderChatModel?
    
    //MARK: ViewController LifeCycle
    override func viewDidLoad() {
        super.viewDidLoad()

        // Do any additional setup after loading the view.
        callGetMesaagesAPI(isFromLoad: true)
        txtMessage.layer.cornerRadius = 5
        viewForRecord.isHidden = true
        viewForRecord.delegate = self
        viewForRecord.durationTimerColor = .white
        viewForRecord.slideToCancelTextColor = .white
        btnMic.recordView = viewForRecord
        setupView()
        
        if orderDetail != nil{
            let cName = orderDetail?.customerName ?? ""
            self.lblImgTag.text = cName.getFirstCharOfEachString()
            lblChatTitle.text = cName
            self.imgUserProfile.isHidden = true
            if orderDetail?.customerImage ?? "" != "", let url = URL.init(string: orderDetail?.customerImage ?? ""){
                self.imgUserProfile.isHidden = false
                self.lblImgTag.text = ""
                self.imgUserProfile.sd_setImage(with: url, placeholderImage: UIImage.init(named: "profile_placeholder"), options: .avoidDecodeImage) { image, error, type, url in
                    if image == nil{
                        self.lblImgTag.text = cName.getFirstCharOfEachString()
                    }
                }
            }
        }else{
            let cName = "\(helpOrder?.user?.firstName ?? "") \(helpOrder?.user?.lastName ?? "")"
            self.lblImgTag.text = cName.getFirstCharOfEachString()
            lblChatTitle.text = cName
            self.imgUserProfile.isHidden = true
            if helpOrder?.user?.imageUrl ?? "" != "", let url = URL.init(string: helpOrder?.user?.imageUrl ?? ""){
                self.imgUserProfile.isHidden = false
                self.lblImgTag.text = ""
                self.imgUserProfile.sd_setImage(with: url, placeholderImage: UIImage.init(named: "profile_placeholder"), options: .avoidDecodeImage) { image, error, type, url in
                    if image == nil{
                        self.lblImgTag.text = cName.getFirstCharOfEachString()
                    }
                }
            }
            
        }
    }
    
    override func viewWillAppear(_ animated: Bool) {
        AppEnterinForeGround()
        NotificationCenter.default.addObserver(self, selector: #selector(AppEnterinForeGround), name: UIApplication.willEnterForegroundNotification, object: nil)
        NotificationCenter.default.addObserver(self, selector: #selector(AppEnterinBackGround), name: UIApplication.didEnterBackgroundNotification, object: nil)
        NotificationCenter.default.addObserver(self, selector:#selector(self.playerDidFinishPlaying),name: NSNotification.Name.AVPlayerItemDidPlayToEndTime, object: nil)
    }
    
    override func viewWillDisappear(_ animated: Bool) {
        AppEnterinBackGround()
        if self.playAudioTimer != nil{
            self.playAudioTimer!.invalidate()
            self.playAudioTimer = nil
        }
        if selectedAudioIndex != nil && playingAudioData != nil && selectedAudioSection != nil{
            playingAudioData = nil
            selectedAudioIndex = nil
            selectedAudioSection = nil
            if self.audioPlayer != nil{
                self.audioPlayer!.stop()
            }
        }
        NotificationCenter.default.removeObserver(self)
    }
    
    //MARK: create viewcontroller instance
    static func addToParentView(parentVC:ChatListVC,dateil:orderChatModel? = nil, order:WebOrderModel? = nil)->ChatVC?{
        guard let VC = UIStoryboard.init(name: "Others", bundle: nil).instantiateViewController(withIdentifier: "ChatVC") as? ChatVC else {
            return nil
        }
        for VC in parentVC.viewForContainer.subviews{
            VC.removeFromSuperview()
        }
        VC.orderDetail = order
        VC.parentVC = parentVC
        VC.helpOrder = dateil
        parentVC.addChild(VC)
        parentVC.viewForContainer.addSubview(VC.view)
        VC.view.frame = CGRect.init(x: 0, y: 20, width: parentVC.viewForContainer.frame.width, height: parentVC.viewForContainer.frame.height-20)
        return VC
    }
    
    //MARK: AVFoundation methods
    func setupView() {
        recordingSession = AVAudioSession.sharedInstance()
        do {
            try recordingSession!.setCategory(.playAndRecord, mode: .default)
            try recordingSession!.overrideOutputAudioPort(AVAudioSession.PortOverride.speaker)
            try recordingSession!.setActive(true)
            recordingSession!.requestRecordPermission() { [unowned self] allowed in
                DispatchQueue.main.async {
                    if allowed {
                        self.btnMic.isUserInteractionEnabled = true
                        self.btnMic.isEnabled = true
                        self.isRecordingAllow = true
                    } else {
                        self.btnMic.isUserInteractionEnabled = false
                        self.btnMic.isEnabled = false
                        self.isRecordingAllow = false
                        // failed to record
                    }
                    
                }
                
            }
        } catch let error {
            print(error.localizedDescription)
            self.btnMic.isUserInteractionEnabled = false
            self.btnMic.isEnabled = false
            isRecordingAllow = false
        }
    }
    
    func startRecording() {
        let settings = [
            AVFormatIDKey: Int(kAudioFormatMPEG4AAC),
            AVSampleRateKey: 12000,
            AVNumberOfChannelsKey: 1,
            AVEncoderAudioQualityKey: AVAudioQuality.max.rawValue
        ]
        
        do {
            let audioFilename = getDocumentsDirectory().appendingPathComponent("recording.m4a")

            audioRecorder = try AVAudioRecorder(url: audioFilename, settings: settings)
            audioRecorder!.delegate = self
            audioRecorder!.record()
            
        } catch let error{
            print(error.localizedDescription)
            finishRecording(success: false)
        }
    }
    
    @objc func playerDidFinishPlaying(){
        print("Video Finished")
        if self.playAudioTimer != nil{
            self.playAudioTimer!.invalidate()
            self.playAudioTimer = nil
        }
        selectedAudioIndex = nil
        selectedAudioSection = nil
        tblChat.reloadData()
    }
    
    func getDocumentsDirectory() -> URL {
        let paths = FileManager.default.urls(for: .documentDirectory, in: .userDomainMask)
        return paths[0]
    }
    
    func preparePlayer() {
        if playingAudioData != nil{
            do {
                audioPlayer = try AVAudioPlayer.init(data: playingAudioData!)
                audioPlayer!.delegate = self
                audioPlayer!.prepareToPlay()
                audioPlayer!.volume = 3.0
                self.audioPlayer!.rate = 1.0
            } catch let error as NSError {
                print("AVAudioPlayer error: \(error.localizedDescription)")
                audioPlayer = nil
            }
        }
    }
    
    func finishRecording(success: Bool) {
        if success{
            let audioFilename = getDocumentsDirectory().appendingPathComponent("recording.m4a")
            do{
                let data = try Data.init(contentsOf: audioFilename)
                let message = MessagesCellData()
                message.id = Int(Date().timeIntervalSinceReferenceDate)
                message.audioFile = data
                message.date = Date().getDateInString(format: "hh:mm a")
                message.created = Date().getDateInString(format: "dd-MM-yyyy")
                arrMessages.append(message)
                self.addNewMessage(message: message)
                let date = Date().getDateInString(format: "dd-MM-yyyy")
                var subIndex = 0
                if let arr = dictChatList["\(date)"] as? [MessagesCellData]{
                    subIndex = arr.count-1
                }
                self.tblChat.reloadData()
                self.callSendMesaageAPI(message: "", attachment: data, isAttach: 2, mainIndex: self.arrMessages.count-1, subIndex: subIndex)
            }catch let error{
                print(error.localizedDescription)
            }
        }else{
            if audioRecorder != nil{
                audioRecorder!.stop()
                audioRecorder = nil
            }
        }
    }
    
    //MARK: General Methods
    @objc func updateSliderProgress(){
        if let item = audioPlayer,selectedAudioIndex != nil,selectedAudioSection != nil{
            sliderValue = item.currentTime * 100 / item.duration
            let indexPath = IndexPath.init(row: selectedAudioIndex!, section: selectedAudioSection!)
            if let cell = tblChat.cellForRow(at: indexPath) as? ChatViewCell{
                cell.viewForSlider.setValue(Float(sliderValue), animated: false)
                var stratSecond = Int(item.currentTime)
                var startMin = 0
                if stratSecond > 59{
                    stratSecond = 0
                    startMin += 1
                }
                cell.lblStartTime.text = String.init(format: "%02d:%02d", startMin,stratSecond)
                var endSecond = Int(item.duration)
                var endMin = 0
                if endSecond > 59{
                    endSecond = 0
                    endMin += 1
                }
                cell.lblEndTime.text = String.init(format: "%02d:%02d", endMin,endSecond)
            }
        }
    }
    
    func addNewMessage(message: MessagesCellData){
        let date = Date().getDateInString(format: "dd-MM-yyyy")
        if var arr = dictChatList["\(date)"] as? [MessagesCellData]{
            arr.append(message)
            dictChatList["\(date)"] = arr
        }else{
            dictChatList["\(date)"] = [message]
            self.arrChatDate.append(date)
        }
    }
    
    func filterMessagePerDate(){
        self.arrChatDate.removeAll()
        self.dictChatList.removeAllObjects()
        for message in arrMessages{
            let date = message.created
            if var arr = dictChatList["\(date)"] as? [MessagesCellData]{
                arr.append(message)
                dictChatList["\(date)"] = arr
            }else{
                dictChatList["\(date)"] = [message]
                self.arrChatDate.append(date)
            }
        }
        self.arrChatDate = self.arrChatDate.sorted(by: { (str1, str2) -> Bool in
            return str1.getDateFromString(format: "dd-MM-yyyy", locale: nil)! < str2.getDateFromString(format: "dd-MM-yyyy", locale: nil)!
        })
        self.tblChat.reloadData()
    }
    
    @IBAction func AppEnterinForeGround(){
        if chatTimer == nil{
            self.chatTimer = Timer.scheduledTimer(timeInterval: 10, target: self, selector: #selector(CallAPIAfterInterval), userInfo: nil, repeats: true)
        }
    }
    
    @IBAction func AppEnterinBackGround(){
        if chatTimer != nil{
            self.chatTimer!.invalidate()
            self.chatTimer = nil
        }
    }
    
    @IBAction func CallAPIAfterInterval(){
        if !isSendApiRunning{
            callGetMesaagesAPI(isFromLoad: false)
        }
    }
    
    //MARK: Button Action
    @IBAction func btnFailedAction(_ sender:UIButton){
        AppValidation().showAlertView(parentVC: self, withAlertTile: AppConstants.GlobalAlert.ALERT_TITLE, withAlertMsg: AppConstants.GlobalAlert.FailedChat, withActionsTitle: [AppConstants.GlobalAlert.ALERT_BTN_NO,AppConstants.GlobalAlert.ALERT_BTN_YES]) { (index) in
            if index == 1{
                if let arr = self.dictChatList["\(self.arrChatDate[Int(sender.accessibilityIdentifier ?? "") ?? 0])"] as? [MessagesCellData]{
                    var data = arr[sender.tag].audioFile
                    if let img = arr[sender.tag].imgMessage{
                        data = img.jpegData(compressionQuality: 0.7)
                    }
                    let firstIndex = self.arrMessages.firstIndex { (model) -> Bool in
                        return model.id == arr[sender.tag].id
                    }
                    arr[sender.tag].isFailed = false
                    self.callSendMesaageAPI(message: arr[sender.tag].strMessage, attachment: data, isAttach: arr[sender.tag].isAttach,mainIndex: firstIndex, subIndex:sender.tag)
                }
                
            }
            
        }
    }
    
    @IBAction func btnSendMessageAction(_ sender:UIButton){
        let message = MessagesCellData()
        message.strMessage = txtMessage.text ?? ""
        message.date = Date().getDateInString(format: "hh:mm a")
        message.created = Date().getDateInString(format: "dd-MM-yyyy")
        message.id = Int(Date().timeIntervalSinceReferenceDate)
        arrMessages.append(message)
        self.addNewMessage(message: message)
        let date = Date().getDateInString(format: "dd-MM-yyyy")
        var subIndex = 0
        if let arr = dictChatList["\(date)"] as? [MessagesCellData]{
            subIndex = arr.count-1
        }
        callSendMesaageAPI(message: txtMessage.text ?? "", attachment: nil, isAttach: 0, mainIndex: arrMessages.count-1, subIndex: subIndex)
        txtMessage.text = ""
        btnSend.isEnabled = false
        tblChat.reloadData()
    }
    
    @IBAction func btnImageMessageAction(_ sender:UIButton){
        self.view.endEditing(true)
        var type = UIImagePickerController.SourceType.photoLibrary
        if sender.tag == 1{
            type = UIImagePickerController.SourceType.camera
            guard UIImagePickerController.isSourceTypeAvailable(type) else {
                AppCommonMethods.showToastAlert(message: AppConstants.GlobalAlert.ALERT_CAMERA_SUPPORT)
                return
            }
        }
        let pickerController = UIImagePickerController()
        pickerController.sourceType = type
        pickerController.delegate = self
        pickerController.allowsEditing = true
        pickerController.mediaTypes = ["public.image"]
        self.present(pickerController, animated: true)
    }
    
    @IBAction func btnAudioMessageAction(_ sender:UIButton){
        if !isRecordingAllow{
            AppValidation().showAlertView(parentVC: self, withAlertTile: AppConstants.GlobalAlert.ALERT_TITLE, withAlertMsg: AppConstants.GlobalAlert.ALERT_ALLOW_AUDIO, withActionsTitle: [AppConstants.GlobalAlert.ALERT_BTN_OK]) { (index) in
                
            }
        }
    }
    
    @IBAction func btnUserInfoAction(_ sender:UIButton){
        if let _ = ChatCustomerInfoVC.showPopup(parentVC: self.parentVC.parentVC, chat: self.helpOrder, order: self.orderDetail){
            
        }
    }
    
    @IBAction func btnPlayAudioAction(_ sender:UIButton){
        var arrM = [MessagesCellData]()
        if let arr = self.dictChatList["\(self.arrChatDate[Int(sender.accessibilityIdentifier ?? "") ?? 0])"] as? [MessagesCellData]{
            arrM = arr
        }
        if self.selectedAudioIndex != nil && self.selectedAudioSection != nil{
            if self.selectedAudioIndex! != sender.tag && self.selectedAudioIndex! != Int(sender.accessibilityIdentifier!)!{
                if self.audioPlayer != nil{
                    self.audioPlayer!.stop()
                    self.audioPlayer = nil
                }
                if self.playAudioTimer != nil{
                    self.playAudioTimer!.invalidate()
                    self.playAudioTimer = nil
                }
                self.playingAudioData = nil
                if let arr = self.dictChatList["\(self.arrChatDate[self.selectedAudioSection!])"] as? [MessagesCellData]{
                    arr[self.selectedAudioIndex!].isPlaying = false
                }
                self.selectedAudioIndex = nil
                self.selectedAudioSection = nil
                isMAnuallyPause = false
                if let arr = self.dictChatList["\(self.arrChatDate[Int(sender.accessibilityIdentifier ?? "") ?? 0])"] as? [MessagesCellData]{
                    arr[sender.tag].isPlaying = false
                }
            }
        }
        if arrM[sender.tag].isPlaying{
            if self.playAudioTimer != nil{
                self.playAudioTimer!.invalidate()
                self.playAudioTimer = nil
            }
            if self.audioPlayer != nil{
                self.audioPlayer!.pause()
            }
            isMAnuallyPause = true
            if let arr = self.dictChatList["\(self.arrChatDate[Int(sender.accessibilityIdentifier ?? "") ?? 0])"] as? [MessagesCellData]{
                arr[sender.tag].isPlaying = false
            }
        }else{
            self.playingAudioData = arrM[sender.tag].audioFile
            if self.playingAudioData == nil{
                let path = arrM[sender.tag].messageURL
                DispatchQueue.main.async {
                    AppCommonMethods.startProgressBar()
                    DispatchQueue.global().async {
                        DispatchQueue.main.async {
                            do{
                                self.playingAudioData = try Data.init(contentsOf: URL.init(string: path)!)
                                if let arr = self.dictChatList["\(self.arrChatDate[Int(sender.accessibilityIdentifier ?? "") ?? 0])"] as? [MessagesCellData]{
                                    arr[sender.tag].audioFile = self.playingAudioData
                                    arr[sender.tag].isPlaying = true
                                }
                                self.preparePlayer()
                                self.selectedAudioIndex = sender.tag
                                self.selectedAudioSection = Int(sender.accessibilityIdentifier ?? "0")
                                AppCommonMethods.stopProgressBar()
                                if self.audioPlayer != nil{
                                    self.audioPlayer!.play()
                                    self.playAudioTimer = Timer.scheduledTimer(timeInterval: 0.1, target: self, selector: #selector(self.updateSliderProgress), userInfo: nil, repeats: true)
                                    self.tblChat.reloadData()
                                }
                            }catch let error{
                                AppCommonMethods.stopProgressBar()
                                print(error.localizedDescription)
                            }
                        }
                    }
                }
            }else{
                if !isMAnuallyPause{
                    self.preparePlayer()
                }
                isMAnuallyPause = false
                if let arr = self.dictChatList["\(self.arrChatDate[Int(sender.accessibilityIdentifier ?? "") ?? 0])"] as? [MessagesCellData]{
                    arr[sender.tag].isPlaying = true
                }
                if self.audioPlayer != nil{
                    self.audioPlayer!.play()
                }
                self.playAudioTimer = Timer.scheduledTimer(timeInterval: 0.1, target: self, selector: #selector(self.updateSliderProgress), userInfo: nil, repeats: true)
                self.selectedAudioIndex = sender.tag
                self.selectedAudioSection = Int(sender.accessibilityIdentifier ?? "0")
            }
        }
        tblChat.reloadData()
    }
    
    @IBAction func btnNewMessageAction(_ sender:UIButton){
        self.arrNewMessages.removeAll()
        viewForNewCount.isHidden = true
        if let date = self.arrChatDate.last, let arr = self.dictChatList["\(date)"] as? [MessagesCellData]{
            self.tblChat.scrollToRow(at: IndexPath.init(row: arr.count-1, section: self.arrChatDate.count-1), at: .bottom, animated: false)
        }
    }
    
    @IBAction func btnCallAction(_ sender:UIButton){
        var number = helpOrder?.user?.phoneNumber ?? ""
        if orderDetail != nil{
            number = orderDetail?.phone ?? ""
        }
        if let url = URL(string: "tel://\(number)") {
            if UIApplication.shared.canOpenURL(url){
                UIApplication.shared.open(url, options: [:], completionHandler: nil)
            }else{
                AppValidation().showAlertView(parentVC: self.parentVC.parentVC, withAlertTile: AppConstants.GlobalAlert.ALERT_TITLE, withAlertMsg: AppConstants.GlobalAlert.FailedCall, withActionsTitle: [AppConstants.GlobalAlert.ALERT_BTN_OK]) { (index) in

                }
            }
        }else{
            AppValidation().showAlertView(parentVC: self.parentVC.parentVC, withAlertTile: AppConstants.GlobalAlert.ALERT_TITLE, withAlertMsg: AppConstants.GlobalAlert.FailedCall, withActionsTitle: [AppConstants.GlobalAlert.ALERT_BTN_OK]) { (index) in

            }
        }
    }
    
    //MARK: WebService Methods
    func callSendMesaageAPI(message:String, attachment:Data?,isAttach:Int,mainIndex:Int?,subIndex:Int){
        var dictParam = [String:Any]()
        dictParam["restaurant_id"] = AppConstants.webResId ?? ""
        dictParam["message"] = message
        if orderDetail != nil{
            dictParam["customer_id"] = "\(orderDetail?.customerId ?? 0)"
            dictParam["order_id"] = "\(orderDetail?.id ?? 0)"
        }else{
            dictParam["customer_id"] = "\(helpOrder?.user?.id ?? 0)"
            dictParam["order_id"] = "\(helpOrder?.orderId ?? 0)"
        }
        dictParam["admin"] = 1
        dictParam["is_attach"] = "\(isAttach)"
        
        var dictFileParam:NSMutableDictionary?
        if attachment != nil{
            dictFileParam = NSMutableDictionary()
            if isAttach == 1{
                dictFileParam!["names"] = ["image\(Int(Date().timeIntervalSinceReferenceDate)).jpeg"]
            }else{
                dictFileParam!["names"] = ["audio\(Int(Date().timeIntervalSinceReferenceDate)).mp3"]
            }
            dictFileParam!["keys"] = ["attach"]
            dictFileParam!["files"] = [attachment!]
            isSendApiRunning = true
            AppCommonMethods.startProgressBar()
        }
        if AppConstants.isInDevlopmentMode{
            print("Send Message Parameter: ",dictParam)
        }
        
        WebServiceManager().requestAPI(params: dictParam, fileParam: dictFileParam, urlString: AppConstants.APIURL.kOrderHelp, method: "POST") { (message, response) in
            DispatchQueue.main.async {
                self.isSendApiRunning = false
                AppCommonMethods.stopProgressBar()
                if let data = response as? NSDictionary{
                    if AppConstants.isInDevlopmentMode{
                        print("Send Message Response: ",data)
                    }
                    let message = MessagesCellData()
                    message.id = data.getIntValue("id") ?? 0
                    message.strMessage = data.getStringValue("message") ?? ""
                    message.messageURL = data.getStringValue("image_url") ?? ""
                    message.isAdmin = data.getIntValue("admin") ?? 0
                    message.isAttach =  data.getIntValue("is_attach") ?? 0
                    if let date = ((data.getStringValue("created") ?? "").components(separatedBy: ".").first ?? "").getDateFromString(format: "yyyy-MM-dd'T'HH:mm:ss", locale: nil){
                        message.created = date.getDateInString(format: "dd-MM-yyyy")
                        message.date = date.getDateInString(format: "hh:mm a")
                    }
                    if isAttach == 2{
                        message.audioFile = attachment
                    }
                    if let index = mainIndex{
                        if index < self.arrMessages.count{
                            if index < 0{
                                self.arrMessages.append(message)
                                self.addNewMessage(message: message)
                            }else{
                                self.arrMessages[index] = message
                                if let date = self.arrChatDate.last ,var arr = self.dictChatList[date] as? [MessagesCellData]{
                                    arr[subIndex] = message
                                    self.dictChatList[date] = arr
                                }else{
                                    self.arrChatDate.append(Date().getDateInString(format: "dd-MM-yyyy"))
                                    self.dictChatList[Date().getDateInString(format: "dd-MM-yyyy")] = [message]
                                }
                            }
                        }
                    }else{
                        self.arrMessages.append(message)
                        self.addNewMessage(message: message)
                    }
                    self.lastMessageId = data.getIntValue("id") ?? 0
                    self.tblChat.reloadData()
                    if let date = self.arrChatDate.last, let arr = self.dictChatList["\(date)"] as? [MessagesCellData]{
                        self.tblChat.scrollToRow(at: IndexPath.init(row: arr.count-1, section: self.arrChatDate.count-1), at: .bottom, animated: false)
                    }
                    return
                }
                
                if let index = mainIndex, index >= 0{
                    self.arrMessages[index].isFailed = true
                    if let date = self.arrChatDate.last ,let arr = self.dictChatList[date] as? [MessagesCellData]{
                        arr[subIndex].isFailed = true
                    }
                }
                self.tblChat.reloadData()
                if let date = self.arrChatDate.last, let arr = self.dictChatList["\(date)"] as? [MessagesCellData]{
                    self.tblChat.scrollToRow(at: IndexPath.init(row: arr.count-1, section: self.arrChatDate.count-1), at: .bottom, animated: false)
                }
            }
        }
    }
    
    
    @IBAction func callGetMesaagesAPI(isFromLoad:Bool){
        var dictParam = [String:Any]()
        dictParam["restaurant_id"] = AppConstants.webResId ?? ""
        if orderDetail != nil{
            dictParam["user_id"] = "\(orderDetail?.customerId ?? 0)"
        }else{
            dictParam["user_id"] = "\(helpOrder?.user?.id ?? 0)"
        }
        
        if self.lastMessageId != nil{
            dictParam["last_id"] = self.lastMessageId!
        }
        dictParam["nopaginate"] = "1"
        if isFromLoad{
            AppCommonMethods.startProgressBar()
        }
        WebServiceManager().requestAPI(params: dictParam, urlString: AppConstants.APIURL.kOrderHelp, method: "GET") { (message, response) in
            DispatchQueue.main.async {
                AppCommonMethods.stopProgressBar()
                if isFromLoad{
                    BadgeManager.shared?.stopLastAPICall()
                    self.parentVC.CallGetChatListAPI()
                }
                if response != nil{
                    if AppConstants.isInDevlopmentMode{
                        print("Chat List Response: ",response!)
                    }
                    if let arrM = response as? [NSDictionary]{
                        for i in 0..<arrM.count{
                            let dictM = arrM[i]
                            let message = MessagesCellData()
                            message.id = dictM.getIntValue("id") ?? 0
                            message.strMessage = dictM.getStringValue("message") ?? ""
                            message.messageURL = dictM.getStringValue("image_url") ?? ""
                            message.isAdmin = dictM.getIntValue("admin") ?? 0
                            message.isAttach = dictM.getIntValue("is_attach") ?? 0
                            if let date = ((dictM.getStringValue("created") ?? "").components(separatedBy: ".").first ?? "").getDateFromString(format: "yyyy-MM-dd'T'HH:mm:ss", locale: nil){
                                message.created = date.getDateInString(format: "dd-MM-yyyy")
                                message.date = date.getDateInString(format: "hh:mm a")
                            }
                            self.arrMessages.append(message)
                            self.arrNewMessages.append(message)
                            if i == arrM.count-1{
                                self.lastMessageId = dictM.getIntValue("id") ?? 0
                            }
                        }
                        self.filterMessagePerDate()
                        if isFromLoad{
                            if let date = self.arrChatDate.last, let arr = self.dictChatList["\(date)"] as? [MessagesCellData]{
                                self.tblChat.scrollToRow(at: IndexPath.init(row: arr.count-1, section: self.arrChatDate.count-1), at: .bottom, animated: false)
                            }
                            
                        }else{
                            if self.tblChat.contentOffset.y >= (self.tblChat.contentSize.height - self.tblChat.frame.size.height) {
                                if let date = self.arrChatDate.last, let arr = self.dictChatList["\(date)"] as? [MessagesCellData]{
                                    self.tblChat.scrollToRow(at: IndexPath.init(row: arr.count-1, section: self.arrChatDate.count-1), at: .bottom, animated: false)
                                }
                            }else{
                                if self.arrNewMessages.count != 0{
                                    self.lblNewMessageCount.text = "\(self.arrNewMessages.count)"
                                    self.viewForNewCount.isHidden = false
                                }
                            }
                        }
                        return
                    }
                }
                self.tblChat.reloadData()
            }
        }
    }
    
}

//MARK: UITableViewDataSource
extension ChatVC:UITableViewDataSource,UITableViewDelegate{
    func scrollViewDidScroll(_ scrollView: UIScrollView) {
        if self.tblChat.contentOffset.y >= (self.tblChat.contentSize.height - self.tblChat.frame.size.height-50) {
            self.arrNewMessages.removeAll()
            self.viewForNewCount.isHidden = true
        }
    }
    
    func tableView(_ tableView: UITableView, heightForHeaderInSection section: Int) -> CGFloat {
        return 25
    }
    
    func tableView(_ tableView: UITableView, viewForHeaderInSection section: Int) -> UIView? {
        let cell = tableView.dequeueReusableCell(withIdentifier: "ChatHeaderViewCell") as! ChatHeaderViewCell
        if let date = arrChatDate[section].getDateFromString(format: "dd-MM-yyyy", locale: nil){
            cell.lblDate.text = date.getDateInString(format: "EEEE d'\(date.getDateSuffix())' MMMM")
        }
        return cell
    }
    
    func numberOfSections(in tableView: UITableView) -> Int {
        return arrChatDate.count
    }
    
    func tableView(_ tableView: UITableView, numberOfRowsInSection section: Int) -> Int {
        if let arr = dictChatList["\(arrChatDate[section])"] as? [MessagesCellData]{
            return arr.count
        }
        return 0
    }
    
    func tableView(_ tableView: UITableView, cellForRowAt indexPath: IndexPath) -> UITableViewCell {
        if let arr = dictChatList["\(arrChatDate[indexPath.section])"] as? [MessagesCellData]{
            let message = arr[indexPath.row]
            if message.imgMessage != nil || message.isAttach == 1{
                if message.isAdmin != 0{
                    let cell = tableView.dequeueReusableCell(withIdentifier: "SenderImageCell", for: indexPath) as! ChatViewCell
                    if message.imgMessage != nil{
                        cell.imgMessage.image = message.imgMessage!
                    }else{
                        cell.imgMessage.sd_setImage(with: URL(string: message.messageURL), placeholderImage:UIImage(named: "placeholder"), options: .avoidDecodeImage)
                    }
                    if message.isFailed{
                        cell.constFailedWidth.constant = 35
                        cell.btnFailed.superview?.isHidden = false
                        cell.btnFailed.tag = indexPath.row
                        cell.btnFailed.accessibilityIdentifier = "\(indexPath.section)"
                    }else{
                        cell.constFailedWidth.constant = 10
                        cell.btnFailed.superview?.isHidden = true
                    }
                    cell.lblDate.text = message.date
                    return cell
                }else{
                    let cell = tableView.dequeueReusableCell(withIdentifier: "ReceiverImageCell", for: indexPath) as! ChatViewCell
                    cell.imgMessage.sd_setImage(with: URL(string: message.messageURL), placeholderImage:UIImage(named: "placeholder"), options: .avoidDecodeImage)
                    cell.lblDate.text = message.date
                    return cell
                }
                
            }else if message.audioFile != nil || message.isAttach == 2{
                if message.isAdmin != 0{
                    let cell = tableView.dequeueReusableCell(withIdentifier: "SenderAudioCell", for: indexPath) as! ChatViewCell
                    cell.lblDate.text = message.date
                    if message.isFailed{
                        cell.constFailedWidth.constant = 35
                        cell.btnFailed.superview?.isHidden = false
                        cell.btnFailed.tag = indexPath.row
                        cell.btnFailed.accessibilityIdentifier = "\(indexPath.section)"
                    }else{
                        cell.constFailedWidth.constant = 10
                        cell.btnFailed.superview?.isHidden = true
                    }
                    if let item = audioPlayer,let index = selectedAudioIndex, index == indexPath.row, let section = selectedAudioSection, section == indexPath.section{
                        let progress = item.currentTime * 100 / item.duration
                        var stratSecond = Int(item.currentTime)
                        var startMin = 0
                        if stratSecond > 59{
                            stratSecond = 0
                            startMin += 1
                        }
                        cell.lblStartTime.text = String.init(format: "%02d:%02d", startMin,stratSecond)
                        var endSecond = Int(item.duration)
                        var endMin = 0
                        if endSecond > 59{
                            endSecond = 0
                            endMin += 1
                        }
                        cell.viewForSlider.setValue(Float(progress), animated: false)
                        cell.lblEndTime.text = String.init(format: "%02d:%02d", endMin,endSecond)
                    }else{
                        cell.viewForSlider.value = 0
                        cell.lblStartTime.text = ""
                        cell.lblEndTime.text = ""
                    }
                    if message.isPlaying{
                        cell.btnPlay.isSelected = true
                    }else{
                        cell.btnPlay.isSelected = false
                    }
                    cell.btnPlay.setImage(UIImage.init(named: "pause")?.sd_tintedImage(with: .white), for: .selected)
                    cell.btnPlay.tag = indexPath.row
                    cell.btnPlay.accessibilityIdentifier = "\(indexPath.section)"
                    return cell
                }else{
                    let cell = tableView.dequeueReusableCell(withIdentifier: "RecieverAudioCell", for: indexPath) as! ChatViewCell
                    cell.lblDate.text = message.date
                    cell.btnPlay.setImage(UIImage.init(named: "pause_brown"), for: .selected)
                    if let item = audioPlayer,let index = selectedAudioIndex, index == indexPath.row, let section = selectedAudioSection, section == indexPath.section{
                        let progress = item.currentTime * 100 / item.duration
                        var stratSecond = Int(item.currentTime)
                        var startMin = 0
                        if stratSecond > 59{
                            stratSecond = 0
                            startMin += 1
                        }
                        cell.lblStartTime.text = String.init(format: "%02d:%02d", startMin,stratSecond)
                        var endSecond = Int(item.duration)
                        var endMin = 0
                        if endSecond > 59{
                            endSecond = 0
                            endMin += 1
                        }
                        cell.viewForSlider.setValue(Float(progress), animated: false)
                        cell.lblEndTime.text = String.init(format: "%02d:%02d", endMin,endSecond)
                    }else{
                        cell.viewForSlider.value = 0
                        cell.lblStartTime.text = ""
                        cell.lblEndTime.text = ""
                    }
                    if message.isPlaying{
                        cell.btnPlay.isSelected = true
                    }else{
                        cell.btnPlay.isSelected = false
                    }
                    cell.btnPlay.tag = indexPath.row
                    cell.btnPlay.accessibilityIdentifier = "\(indexPath.section)"
                    return cell
                }
            }else{
                if message.isAdmin != 0{
                    let cell = tableView.dequeueReusableCell(withIdentifier: "SenderTextCell", for: indexPath) as! ChatViewCell
                    cell.lblMessage.text = message.strMessage
                    cell.lblDate.text = message.date
                    if message.isFailed{
                        cell.constFailedWidth.constant = 35
                        cell.btnFailed.superview?.isHidden = false
                        cell.btnFailed.tag = indexPath.row
                        cell.btnFailed.accessibilityIdentifier = "\(indexPath.section)"
                    }else{
                        cell.constFailedWidth.constant = 10
                        cell.btnFailed.superview?.isHidden = true
                    }
                    return cell
                }else{
                    let cell = tableView.dequeueReusableCell(withIdentifier: "ReceiverTextCell", for: indexPath) as! ChatViewCell
                    cell.lblMessage.text = message.strMessage
                    cell.lblDate.text = message.date
                    return cell
                }
            }
        }
        return UITableViewCell()
    }
}

//MARK: RecordViewDelegate
extension ChatVC:RecordViewDelegate{
    func onStart() {
        print("onStart")
        if isRecordingAllow{
            viewForRecord.isHidden = false
            startRecording()
        }
        
    }
    
    func onCancel() {
        print("onCancel")
        isRecordingCancel = true
        finishRecording(success: false)
    }
    
    func onFinished(duration: CGFloat) {
        print("onFinished \(duration)")
        if duration > 1{
            isRecordingCancel = false
            finishRecording(success: false)
        }
        viewForRecord.isHidden = true
    }
    
    func onAnimationEnd() {
        print("onAnimationEnd")
        viewForRecord.isHidden = true
    }
}

//MARK: AVAudioPlayerDelegate
extension ChatVC:AVAudioRecorderDelegate, AVAudioPlayerDelegate{
    func audioRecorderDidFinishRecording(_ recorder: AVAudioRecorder, successfully flag: Bool) {
        if !isRecordingCancel{
            finishRecording(success: flag)
        }
    }
    
    func audioRecorderEncodeErrorDidOccur(_ recorder: AVAudioRecorder, error: Error?) {
        finishRecording(success: false)
        print("Error while recording audio \(error!.localizedDescription)")
    }
    
    func audioPlayerDidFinishPlaying(_ player: AVAudioPlayer, successfully flag: Bool) {
        if self.playAudioTimer != nil{
            self.playAudioTimer!.invalidate()
            self.playAudioTimer = nil
        }
        if let arr = self.dictChatList["\(self.arrChatDate[selectedAudioSection!])"] as? [MessagesCellData]{
            arr[selectedAudioIndex!].isPlaying = false
        }
        self.sliderValue = 0
        playingAudioData = nil
        selectedAudioIndex = nil
        selectedAudioSection = nil
        tblChat.reloadData()
    }
    
    func audioPlayerDecodeErrorDidOccur(_ player: AVAudioPlayer, error: Error?) {
        if self.playAudioTimer != nil{
            self.playAudioTimer!.invalidate()
            self.playAudioTimer = nil
        }
        if let arr = self.dictChatList["\(self.arrChatDate[selectedAudioSection!])"] as? [MessagesCellData]{
            arr[selectedAudioIndex!].isPlaying = false
        }
        self.sliderValue = 0
        playingAudioData = nil
        selectedAudioIndex = nil
        selectedAudioSection = nil
        tblChat.reloadData()
        print("Error while playing audio \(error!.localizedDescription)")
    }
}

//MARK: UITextViewDelegate
extension ChatVC:UITextViewDelegate{
    func textViewDidChange(_ textView: UITextView) {
        if textView.text ?? "" == ""{
            btnSend.isEnabled = false
        }else{
            btnSend.isEnabled = true
        }
    }
}

//MARK: UIImagePickerControllerDelegate
extension ChatVC: UIImagePickerControllerDelegate,UINavigationControllerDelegate {
    public func imagePickerControllerDidCancel(_ picker: UIImagePickerController) {
        picker.dismiss(animated: true, completion: nil)
    }
    
    public func imagePickerController(_ picker: UIImagePickerController, didFinishPickingMediaWithInfo info: [UIImagePickerController.InfoKey: Any]) {
        guard var image = info[.editedImage] as? UIImage else {
            AppCommonMethods.showToastAlert(message: AppConstants.GlobalAlert.ALERT_NO_IMAGE)
            return
        }
        image = image.sd_resizedImage(with: CGSize.init(width: 300, height: 300), scaleMode: SDImageScaleMode.aspectFill) ?? image
        let data = image.jpegData(compressionQuality: 0.7)
        let message = MessagesCellData()
        message.id = Int(Date().timeIntervalSinceReferenceDate)
        message.imgMessage = image
        message.date = Date().getDateInString(format: "hh:mm a")
        message.created = Date().getDateInString(format: "dd-MM-yyyy")
        arrMessages.append(message)
        self.addNewMessage(message: message)
        let date = Date().getDateInString(format: "dd-MM-yyyy")
        var subIndex = 0
        if let arr = dictChatList["\(date)"] as? [MessagesCellData]{
            subIndex = arr.count-1
        }
        self.tblChat.reloadData()
        callSendMesaageAPI(message: "", attachment: data, isAttach: 1, mainIndex: arrMessages.count-1, subIndex: subIndex)
        picker.dismiss(animated: true, completion: nil)
    }
}
