//
//  ChatListVC.swift
//  TiffinTomPartner
//
//  Created by Tushar Premal on 23/10/20.
//

import UIKit
import SDWebImage

class ChatListVC: UIViewController {
    
    //MARK: IBOutlet
    @IBOutlet weak var tblChatList:UITableView!
    @IBOutlet weak var txtSearch:UITextField!
    @IBOutlet weak var viewForContainer:UIView!
    @IBOutlet weak var constSearchLeadingSpace:NSLayoutConstraint!
    
    //MARK: Instances
    var customHeaderView:HeaderView?
    var arrChatList = [orderChatModel]()
    var arrSearchChatList = [orderChatModel]()
    var isSearchEnable = false
    var refreshControl = UIRefreshControl()
    var parentVC:SideMenuVC!
    var selectedChat:orderChatModel?
    
    //MARK: ViewController LifeCycle
    override func viewDidLoad() {
        super.viewDidLoad()

        // Do any additional setup after loading the view.
        CallGetChatListAPI()
        
        refreshControl.addTarget(self, action: #selector(CallGetChatListAPI), for: .valueChanged)
        self.tblChatList.addSubview(refreshControl)
    }
    
    //MARK: Create Viewcontrllor instance
    static func addToParentView(parentVC:SideMenuVC)->ChatListVC?{
        guard let VC = UIStoryboard.init(name: "Others", bundle: nil).instantiateViewController(withIdentifier: "ChatListVC") as? ChatListVC else {
            return nil
        }
        VC.parentVC = parentVC
        parentVC.addChild(VC)
        parentVC.viewForContainer.addSubview(VC.view)
        VC.view.frame = CGRect.init(x: 0, y: 0, width: parentVC.viewForContainer.frame.width, height: parentVC.viewForContainer.frame.height)
        return VC
    }
    
    //MARK: Button Actions
    @IBAction func txtSearchChangedAction(_ sender:UITextField){
        if txtSearch.text ?? "" == ""{
            isSearchEnable = false
        }else{
            isSearchEnable = true
            arrSearchChatList = arrChatList.filter({ (model) -> Bool in
                return "\(model.user?.firstName ?? "") \(model.user?.lastName ?? "")".lowercased().contains((txtSearch.text ?? "").lowercased())
            })
        }
        tblChatList.reloadData()
    }
    
    @IBAction func btnComposeMsgAction(_ sender:UIButton){
        self.view.endEditing(true)
        if let VC = SelectOrderVC.showPopup(parentVC: self.parentVC){
            VC.delegate = self
        }
    }
    
    @IBAction func btnBackAction(_ sender:UIButton){
        self.parentVC.AddContainerView(data: self.parentVC.arrSideMenu.first!)
    }
    
    @IBAction func btnSearchAction(_ sender:UIButton){
        self.view.endEditing(true)
        self.constSearchLeadingSpace.constant = 0
        UIView.animate(withDuration: 0.25) {
            self.view.layoutIfNeeded()
        }
    }
    
    @IBAction func btnSearchCancelAction(_ sender:UIButton){
        self.view.endEditing(true)
        isSearchEnable = false
        self.tblChatList.reloadData()
        self.constSearchLeadingSpace.constant = -340
        UIView.animate(withDuration: 0.25) {
            self.view.layoutIfNeeded()
        } completion: { status in
            self.constSearchLeadingSpace.constant = 340
        }
    }
    
    //MARK: WebService Methods
    @objc func CallGetChatListAPI(){
        var dictParam = [String:String]()
        dictParam["user_group"] = "1"
        dictParam["nopaginate"] = "1"
        dictParam["restaurant_id"] = AppConstants.webResId ?? ""
        AppCommonMethods.startProgressBar()
        WebServiceManager().requestAPI(params: dictParam, urlString: AppConstants.APIURL.kOrderHelp, method: "GET",isRestaurantAPI: true) { (message, response) in
            DispatchQueue.main.async {
                AppCommonMethods.stopProgressBar()
                self.refreshControl.endRefreshing()
                let jsonDecoder = JSONDecoder()
                if let arrO = response as? [NSDictionary], let data = AppCommonMethods.convertToJson(object: arrO), let aData = try? jsonDecoder.decode([orderChatModel].self, from: data){
                    self.arrChatList = aData
                    self.tblChatList.reloadData()
                }else{
                    AppValidation().showAlertView(parentVC: self, withAlertTile: AppConstants.GlobalAlert.ALERT_TITLE, withAlertMsg: message, withActionsTitle: [AppConstants.GlobalAlert.ALERT_BTN_OK]) { (index) in

                    }
                }
            }
        }
    }
}

//MARK: UITableViewDataSource
extension ChatListVC:UITableViewDataSource,UITableViewDelegate{
    func tableView(_ tableView: UITableView, numberOfRowsInSection section: Int) -> Int {
        return isSearchEnable ? arrSearchChatList.count : arrChatList.count
    }
    
    func tableView(_ tableView: UITableView, cellForRowAt indexPath: IndexPath) -> UITableViewCell {
        let cell = tableView.dequeueReusableCell(withIdentifier: "ChatListViewCell", for: indexPath) as! ChatListViewCell
        let model = isSearchEnable ? arrSearchChatList[indexPath.row] : arrChatList[indexPath.row]
        let cName = "\(model.user?.firstName ?? "") \(model.user?.lastName ?? "")"
        cell.lblUserName.text = cName
        cell.imgProfile.isHidden = true
        cell.lblImgTag.text = cName.getFirstCharOfEachString()
        if model.user?.imageUrl ?? "" != "", let url = URL.init(string: model.user?.imageUrl ?? ""){
            cell.imgProfile.isHidden = false
            cell.lblImgTag.text = ""
            cell.imgProfile.sd_setImage(with: url, placeholderImage: UIImage.init(named: "profile_placeholder"), options: .avoidDecodeImage) { image, error, type, url in
                if image == nil{
                    cell.lblImgTag.text = cName.getFirstCharOfEachString()
                }
            }
        }
        let count = model.unreadCount ?? 0
        if count == 0{
            cell.lblUnreadCount.isHidden = true
        }else{
            cell.lblUnreadCount.isHidden = false
            cell.lblUnreadCount.text = "\(count)"
        }
        cell.lblDate.text = ""
        if let date = ((model.modified ?? "").components(separatedBy: ".").first ?? "").getDateFromString(format: "yyyy-MM-dd'T'HH:mm:ss", locale: nil){
            let difference = Int(Date().timeIntervalSince(date))
            if difference < 60{
                cell.lblDate.text = "Just now"
            }else if difference < 60*60{
                cell.lblDate.text = "\(difference/60) mins ago"
            }else if difference < 24*60*60{
                cell.lblDate.text = "\(difference/(60*60)) hours ago"
            }else if difference < 7*24*60*60{
                cell.lblDate.text = "\(difference/(24*60*60)) days ago"
            }else{
                cell.lblDate.text = date.getDateInString(format: "dd/MM/yyyy")
            }
        }
        cell.lblLastMessage.text = model.message ?? ""
        
        if selectedChat?.id ?? 0 == model.id ?? 0{
            cell.lblLastMessage.textColor = .white
            cell.lblDate.textColor = .white
            cell.lblUserName.textColor = .white
            cell.lblLastMessage.superview?.superview?.backgroundColor = AppConstants.Colors.kAppThemeAquaColor
        }else{
            cell.lblLastMessage.textColor = AppConstants.Colors.kAppMediumGrayColor
            cell.lblDate.textColor = AppConstants.Colors.kAppMediumGrayColor
            cell.lblUserName.textColor = AppConstants.Colors.kAppThemeTextColor
            cell.lblLastMessage.superview?.superview?.backgroundColor = .white
        }
        return cell
    }
    
    func tableView(_ tableView: UITableView, didSelectRowAt indexPath: IndexPath) {
        self.view.endEditing(true)
        self.selectedChat = isSearchEnable ? arrSearchChatList[indexPath.row] : arrChatList[indexPath.row]
        if let _ = ChatVC.addToParentView(parentVC: self,dateil: self.selectedChat!){
        }
        self.tblChatList.reloadData()
    }
}

//MARK: SelectOrderDelegate
extension ChatListVC:SelectOrderDelegate{
    func orderSelected(order: WebOrderModel) {
        self.CallGetChatListAPI()
        if let _ = ChatVC.addToParentView(parentVC: self,order: order){
        }
    }
}
