//
//  SplitOrderVC.swift
//  EPOS
//
//  Created by Apple on 05/05/21.
//

import UIKit
import CoreData

class SplitOrderVC: UIViewController {

    //MARK: IBOutlets
    @IBOutlet weak var tblSplitedItem:UITableView!
    @IBOutlet weak var tblUnSplitedItem:UITableView!
    @IBOutlet weak var collectionGroups:UICollectionView!
    @IBOutlet weak var txtSplitPerson:UITextField!
    @IBOutlet weak var lblTotal:UILabel!
    @IBOutlet weak var lblSubTotal:UILabel!
    @IBOutlet weak var lblGruopTitle:UILabel!
    @IBOutlet weak var lblBalanceAmount:UILabel!
    @IBOutlet weak var lblEachPerson:UILabel!
    @IBOutlet weak var lblBetweenPeople:UILabel!
    @IBOutlet weak var lblEachPersonLine:UILabel!
    @IBOutlet weak var lblBetweenPeopleLine:UILabel!
    @IBOutlet weak var lblGratuity:UILabel!
    @IBOutlet weak var lblServiceCharge:UILabel!
    @IBOutlet weak var lblDiscount:UILabel!
    @IBOutlet weak var btnPay:UIButton!
    @IBOutlet weak var btnPrint:UIButton!
    @IBOutlet weak var btnSplit:UIButton!
    @IBOutlet weak var btnPrintAll:UIButton!
    @IBOutlet weak var btnOrderType:UIButton!
    @IBOutlet weak var viewForByPerson:UIView!
    @IBOutlet weak var viewForByItem:UIView!
    @IBOutlet weak var viewForServiceCharge:UIView!
    @IBOutlet weak var viewForDiscount:UIView!
    @IBOutlet weak var viewForGratuity:UIView!
    @IBOutlet weak var viewForRemoveServiceCharge:UIView!
    @IBOutlet weak var viewForRemoveDiscount:UIView!
    @IBOutlet weak var viewForRemoveGratuity:UIView!
    
    //MARK: Instances
    var arrUnSplitedProducts = [OrderProductModel]()
    var arrSplitedProducts = [OrderProductModel]()
    var arrOrderGroup = [OrderGroupModel]()
    var noOfPerson = 0
    var isSplitByItem = true
    var orderData:OrderModel!
    var selectedGroup:OrderGroupModel?
    var selectedTable:TableModel?
    var arrProducts = [OrderProductModel]()
    var orderType:OrderTypesModel!
    var selectedGroupIndex:Int? = 0
    var noOfGroups = 2
    var isGroupModified = false
    var selectedPayment:PaymentViewType?
    var amountType = GratityViewType.kGratuity
    
    //MARK: ViewController LifeCycle
    override func viewDidLoad() {
        super.viewDidLoad()

        // Do any additional setup after loading the view.
        if let data = SQLiteManage.fetchOrderDataByUniqueId(orderId: orderData.uniqueId){
            orderData = data
        }
        txtSplitPerson.text = "2"
        lblGruopTitle.text = ""
        arrProducts = AppCommonMethods.Copy(of: orderData.arrProducts) ?? orderData.arrProducts
        arrUnSplitedProducts = arrProducts.filter({ model in
            return model.orderSplitId ?? 0 == 0
        })
        PrintManager.shared.printingStoped = { [weak self] in
            DispatchQueue.main.async {
                AppCommonMethods.stopProgressBar()
                PrintManager.shared.printingStoped = nil
                self?.navigationController?.popToRootViewController(animated: true)
                BGAPIExecution.shared.orderSaved = { orderId,message in
                    print("Order \(orderId) Saved To Server")
                    DispatchQueue.main.async {
                        if message == nil{
                            NotificationCenter.default.post(name: AppConstants.notifications.kDatabasePushed, object: ["order_id":orderId,"old_id":self?.orderData.id ?? 0])
                        }else{
                            AppCommonMethods.showToastAlert(message: message!)
                        }
                    }
                }
                BGAPIExecution.shared.AddOrderToQueue(order: self!.orderData!)
            }
        }
        self.arrOrderGroup = SQLiteManage.fetchOrderGroupData(orderId: self.orderData.id ?? 0)
        selectedGroup = self.arrOrderGroup.first
        lblGruopTitle.text = "Bill For Person \(selectedGroupIndex!+1)"
        btnOrderType.setTitle(" \(orderType.type ?? "") ", for: .normal)
        checkPayValidation()
    }
    
    override func viewWillAppear(_ animated: Bool) {
        self.orderData = SQLiteManage.fetchOrderDataById(orderId:self.orderData?.id ?? 0)
        self.arrOrderGroup = SQLiteManage.fetchOrderGroupData(orderId: self.orderData.id ?? 0)
        noOfGroups = max(2, self.arrOrderGroup.count)
        collectionGroups.reloadData()
        checkSplitType()
    }
    
    //MARK: Create ViewController Instance
    static func instance()->SplitOrderVC?{
        return UIStoryboard.init(name: "Orders", bundle: nil).instantiateViewController(withIdentifier: "SplitOrderVC") as? SplitOrderVC
    }
    
    //MARK:  General Methods
    func checkIfOrderSplited()->Bool{
        if arrOrderGroup.count > 0 || orderData.splitCount ?? 0 > 0{
            return true
        }
        return false
    }
    
    func fetchWillPayProduct(){
        if selectedGroup == nil{
            arrSplitedProducts.removeAll()
        }else{
            arrSplitedProducts = arrProducts.filter({ model in
                return model.groupUniqueId == selectedGroup?.uniqueId ?? ""
            })
        }
        self.tblSplitedItem.reloadData()
    }
    
    func setSplitType(){
        if isSplitByItem{
            lblEachPerson.textColor = AppConstants.Colors.kAppThemeTextColor
            lblEachPersonLine.backgroundColor = AppConstants.Colors.kAppThemeAquaColor
            lblBetweenPeople.textColor = AppConstants.Colors.kAppLightGrayColor
            lblBetweenPeopleLine.backgroundColor = AppConstants.Colors.kAppLightGrayColor
            viewForByItem.isHidden = false
            viewForByPerson.isHidden = true
            self.fetchWillPayProduct()
        }else{
            viewForByItem.isHidden = true
            viewForByPerson.isHidden = false
            lblEachPerson.textColor = AppConstants.Colors.kAppLightGrayColor
            lblEachPersonLine.backgroundColor = AppConstants.Colors.kAppLightGrayColor
            lblBetweenPeople.textColor = AppConstants.Colors.kAppThemeTextColor
            lblBetweenPeopleLine.backgroundColor = AppConstants.Colors.kAppThemeAquaColor
            self.lblSubTotal.text = String.init(format: "%@%.2f", AppConstants.currencySign, selectedGroup?.total ?? 0)
            self.lblTotal.text = String.init(format: "%@%.2f", AppConstants.currencySign, selectedGroup?.total ?? 0)
            lblBalanceAmount.text = String.init(format: "Balance Remaining: %@%.2f", AppConstants.currencySign,(selectedGroup?.total ?? 0) - (selectedGroup?.paidAmount ?? 0))
        }
        calculateSelectedmount()
    }
    
    func checkSplitType(){
        if orderData.splitCount ?? 0 > 0{
            lblEachPerson.superview?.isHidden = true
            viewForByItem.isHidden = true
            viewForByPerson.isHidden = false
            isSplitByItem = false
            noOfPerson = orderData.splitCount ?? 0
            txtSplitPerson.text = "\(noOfPerson)"
        }else if checkIfOrderSplitRemaining(){
            lblBetweenPeople.superview?.isHidden = true
            viewForByPerson.isHidden = true
        }
        setSplitType()
    }
    
    func checkIfOrderSplitRemaining()->Bool{
        var isSplited = false
        if orderData!.arrOrderSplit.count > 0{
            isSplited = true
        }
        for model in orderData!.arrProducts{
            if model.orderSplitId ?? 0 != 0{
                isSplited = true
                break
            }
        }
        return isSplited
    }
    
    func calculateSelectedmount(){
        if !checkIfOrderSplited(){
            self.lblSubTotal.text = String.init(format: "%@%.2f", AppConstants.currencySign,orderData.subTotal ?? 0)
            if orderData.serviceCharge ?? 0 > 0{
                viewForRemoveServiceCharge.isHidden = false
                lblServiceCharge.text = String.init(format: "%@%.2f", AppConstants.currencySign, orderData.serviceCharge ?? 0)
            }else{
                viewForRemoveServiceCharge.isHidden = true
            }
            if orderData.discount ?? 0 > 0{
                viewForRemoveDiscount.isHidden = false
                lblDiscount.text = String.init(format: "%@%.2f", AppConstants.currencySign, orderData.discount ?? 0)
            }else{
                viewForRemoveDiscount.isHidden = true
            }
            if orderData.gratuity ?? 0 > 0{
                viewForRemoveGratuity.isHidden = false
                lblGratuity.text = String.init(format: "%@%.2f", AppConstants.currencySign, orderData.gratuity ?? 0)
            }else{
                viewForRemoveGratuity.isHidden = true
            }
            let amount = (orderData.subTotal ?? 0) + (orderData.serviceCharge ?? 0)
            orderData.total = amount + (orderData.gratuity ?? 0) - (orderData.discount ?? 0)
            self.lblTotal.text = String.init(format: "%@%.2f", AppConstants.currencySign, orderData.total ?? 0)
            lblBalanceAmount.text = String.init(format: "Balance Remaining: %@%.2f", AppConstants.currencySign, (orderData.total ?? 0) - (orderData.totalPaid ?? 0))
        }else{
            var amount = 0.0
            if isSplitByItem{
                arrSplitedProducts.forEach { (model) in
                    if !model.isDelete{
                        model.subTotal = (model.price ?? 0) * (Double(model.quantity ?? 0))
                        
                        model.addonPrice = 0
                        
                        model.arrAddons.forEach({ (addon) in
                            model.addonPrice = (model.addonPrice ?? 0) + ((addon.price ?? 0) * Double(addon.quantity)) * (Double(model.quantity ?? 0))
                        })
                        
                        model.ingredientsPrice = 0
                        
                        model.arrIngriedent.forEach({ (ingrident) in
                            model.ingredientsPrice = (model.ingredientsPrice ?? 0) + ((ingrident.price ?? 0) * Double(ingrident.quantity ?? 0)) * (Double(model.quantity ?? 0))
                        })
                        
                        let instructionPrice = ((model.instructionPrice ?? 0) * Double(model.quantity ?? 0))
                        model.total = (model.subTotal ?? 0) + (model.addonPrice ?? 0) + (model.ingredientsPrice ?? 0) + instructionPrice
                        
                        amount += (model.total ?? 0)
                    }
                }
            }else{
                amount = self.selectedGroup?.subTotal ?? 0
            }
            lblSubTotal.text = String.init(format: "%@%.2f", AppConstants.currencySign, amount)
            var grandTotal = amount
            if selectedGroup?.serviceCharge ?? 0 > 0{
                viewForRemoveServiceCharge.isHidden = false
                lblServiceCharge.text = String.init(format: "%@%.2f", AppConstants.currencySign, selectedGroup?.serviceCharge ?? 0)
                grandTotal += (selectedGroup?.serviceCharge ?? 0)
            }else{
                viewForRemoveServiceCharge.isHidden = true
            }
            if selectedGroup?.discount ?? 0 > 0{
                viewForRemoveDiscount.isHidden = false
                lblDiscount.text = String.init(format: "%@%.2f", AppConstants.currencySign, selectedGroup?.discount ?? 0)
                grandTotal -= (selectedGroup?.discount ?? 0)
            }else{
                viewForRemoveDiscount.isHidden = true
            }
            if selectedGroup?.gratuity ?? 0 > 0{
                viewForRemoveGratuity.isHidden = false
                lblGratuity.text = String.init(format: "%@%.2f", AppConstants.currencySign, selectedGroup?.gratuity ?? 0)
                grandTotal += (selectedGroup?.gratuity ?? 0)
            }else{
                viewForRemoveGratuity.isHidden = true
            }
            self.viewForServiceCharge.isHidden = true
            self.viewForDiscount.isHidden = true
            self.viewForGratuity.isHidden = true
            if self.arrOrderGroup.count > 0{
                let serviceCharge = self.arrOrderGroup.reduce(0) { $0 + $1.serviceCharge }
                let discount = self.arrOrderGroup.reduce(0) { $0 + $1.discount }
                let gratuity = self.arrOrderGroup.reduce(0) { $0 + $1.gratuity }
                if serviceCharge < self.orderData.serviceCharge ?? 0 && self.orderData.serviceCharge ?? 0 > 0{
                    self.viewForServiceCharge.isHidden = false
                }
                if discount < self.orderData.discount ?? 0 && self.orderData.discount ?? 0 > 0{
                    self.viewForDiscount.isHidden = false
                }
                if gratuity < self.orderData.gratuity ?? 0 && self.orderData.gratuity ?? 0 > 0{
                    self.viewForGratuity.isHidden = false
                }
            }
            lblTotal.text = String.init(format: "%@%.2f", AppConstants.currencySign, grandTotal)
            lblBalanceAmount.text = String.init(format: "Balance Remaining: %@%.2f", AppConstants.currencySign, grandTotal - (selectedGroup?.paidAmount ?? 0))
        }
    }
    
    func checkPayValidation(){
        var isValidSplit = true
        if selectedGroup == nil{
            isValidSplit = false
        }
        if isValidSplit{
            btnPrint.isEnabled = true
            btnPrint.backgroundColor = AppConstants.Colors.kAppThemeAquaColor
            btnPay.isEnabled = true
            btnPay.backgroundColor = AppConstants.Colors.kAppMediumGreenColor
        }else{
            btnPrint.isEnabled = false
            btnPrint.backgroundColor = AppConstants.Colors.kAppThemeBGColor
            btnPay.isEnabled = false
            btnPay.backgroundColor = AppConstants.Colors.kAppThemeBGColor
        }
        if self.orderData.splitCount ?? 0 > 0{
            self.txtSplitPerson.isUserInteractionEnabled = false
            btnSplit.isEnabled = false
            btnSplit.backgroundColor = AppConstants.Colors.kAppThemeBGColor
        }else{
            if Int(txtSplitPerson.text ?? "") ?? 0 >= 2{
                btnSplit.isEnabled = true
                btnSplit.backgroundColor = AppConstants.Colors.kAppThemeAquaColor
            }else{
                btnSplit.isEnabled = false
                btnSplit.backgroundColor = AppConstants.Colors.kAppThemeBGColor
            }
            if arrSplitedProducts.count > 0{
                btnPrint.isEnabled = true
                btnPrint.backgroundColor = AppConstants.Colors.kAppThemeAquaColor
            }
        }
        if arrOrderGroup.count > 0{
            btnPrintAll.isEnabled = true
            btnPrintAll.backgroundColor = AppConstants.Colors.kAppThemeAquaColor
        }else{
            btnPrintAll.isEnabled = false
            btnPrintAll.backgroundColor = AppConstants.Colors.kAppThemeBGColor
        }
    }
    
    func CreatOrderGroupOffline(action:Int = 0){
        if !self.isSplitByItem{
            if orderData.splitCount ?? 0 == 0{
                noOfPerson = Int(txtSplitPerson.text ?? "") ?? 0
                let subTotal = ((orderData.subTotal ?? 0)/Double(noOfPerson)).getFloorFigure()
                let serviceCharge = ((orderData.serviceCharge ?? 0)/Double(noOfPerson)).getFloorFigure()
                let gratuity = ((orderData.gratuity ?? 0)/Double(noOfPerson)).getFloorFigure()
                let discount = ((orderData.discount ?? 0)/Double(noOfPerson)).getFloorFigure()
                
                for i in 1...noOfPerson{
                    let group = OrderGroupModel()
                    group.groupName = "Person \(i)"
                    group.id = Int("\(Date().millisecondsSince1970)\(i)") ?? 0
                    group.uniqueId = "\(Int(Date().timeIntervalSinceReferenceDate))\(AppConstants.businessData?.id ?? 0)\(AppConstants.DeviceId)\(i)"
                    if i == noOfPerson{
//                        let diffSubTotal = (orderData.subTotal ?? 0) - (subTotal*Double(noOfPerson))
//                        let diffServiceCharge = (orderData.serviceCharge ?? 0) - (serviceCharge*Double(noOfPerson))
//                        let diffGratuity = (orderData.gratuity ?? 0) - (gratuity*Double(noOfPerson))
//                        let diffDiscount = (orderData.discount ?? 0) - (discount*Double(noOfPerson))
                        group.subTotal = ((orderData.subTotal ?? 0) - (subTotal*Double(noOfPerson-1))).getFloorFigure()
                        group.serviceCharge = ((orderData.serviceCharge ?? 0) - (serviceCharge*Double(noOfPerson-1))).getFloorFigure()
                        group.gratuity = ((orderData.gratuity ?? 0) - (gratuity*Double(noOfPerson-1))).getFloorFigure()
                        group.discount = ((orderData.discount ?? 0) - (discount*Double(noOfPerson-1))).getFloorFigure()
                    }else{
                        group.subTotal = subTotal
                        group.serviceCharge = serviceCharge
                        group.gratuity = gratuity
                        group.discount = discount
                    }
                    group.total = group.subTotal + group.serviceCharge + group.gratuity - group.discount
                    arrOrderGroup.append(group)
                }
                SQLiteManage.insertOrderGroups(orderId: orderData.id ?? 0, arrGroups: arrOrderGroup, database: nil, updated: 1, offline: 1)
                orderData.splitCount = noOfPerson
                self.collectionGroups.reloadData()
            }
        }else{
            var orderGroup = OrderGroupModel()
            if selectedGroup != nil{
                orderGroup = selectedGroup!
            }else{
                orderGroup.uniqueId = "\(Int(Date().timeIntervalSinceReferenceDate))\(AppConstants.businessData?.id ?? 0)\(AppConstants.DeviceId)"
                orderGroup.id = Date().millisecondsSince1970
                orderGroup.groupName = "Person \(arrOrderGroup.count+1)"
            }
            var subTotal = 0.0
            for model in arrSplitedProducts{
                if !model.isDelete{
                    subTotal += (model.total ?? 0)
                }
                model.orderSplitId = orderGroup.id
                model.groupUniqueId = orderGroup.uniqueId
                model.groupOffline = orderGroup.offline
            }
            var total = subTotal
            orderGroup.subTotal = subTotal
            if !orderGroup.autoDiscountRemove{
                orderGroup.discount = (self.orderData.discount ?? 0) * subTotal / (self.orderData?.subTotal ?? 0)
                total -= orderGroup.discount
            }
            if !orderGroup.autoGratuityRemove{
                orderGroup.gratuity = (self.orderData.gratuity ?? 0) * subTotal / (self.orderData?.subTotal ?? 0)
                total += orderGroup.gratuity
            }
            if !orderGroup.autoServiceChargeRemove{
                orderGroup.serviceCharge = (self.orderData.serviceCharge ?? 0) * subTotal / (self.orderData?.subTotal ?? 0)
                total += orderGroup.serviceCharge
            }
            orderGroup.total = total
            if selectedGroup == nil{
                arrOrderGroup.append(orderGroup)
            }
            SQLiteManage.insertOrderGroups(orderId: orderData.id ?? 0, arrGroups: [orderGroup], database: nil, updated: 1, offline:  orderGroup.offline)
            
            arrUnSplitedProducts.forEach { model in
                model.groupUniqueId = ""
                model.orderSplitId = nil
            }
            orderData.arrProducts = arrUnSplitedProducts
            orderData.arrProducts.append(contentsOf: arrSplitedProducts)
        }
        if self.orderData?.orderStatusId ?? 0 <= 2{
            self.orderData.orderStatusId = 2
        }
        self.orderData.arrOrderSplit = arrOrderGroup
        if self.selectedTable?.id ?? 0 != 0{
            SQLiteManage.updateTableStatus(tableId: self.selectedTable?.id ?? 0, lastOrderId: self.orderData.id ?? 0, lastOrderTotal: self.orderData?.total, lastOrderTime: self.orderData?.deliveryDate, offline: 1)
        }
        SQLiteManage.SaveOrderIntoDatabase(order: self.orderData!, updated: 1)
        self.orderData = SQLiteManage.fetchOrderDataById(orderId:self.orderData?.id ?? 0)
        self.arrOrderGroup = SQLiteManage.fetchOrderGroupData(orderId: self.orderData.id ?? 0)
        if action == 1 || action == 2{
            PrintManager.shared.isPrintingBill = true
            if action == 2{
                PrintManager.shared.arrGroups = self.arrOrderGroup
            }else{
                if self.isSplitByItem{
                    PrintManager.shared.isSplitBillCopy = false
                    PrintManager.shared.splitGroup = self.selectedGroup
                }else{
                    PrintManager.shared.isSplitBillCopy = true
                }
            }
            PrintManager.shared.connectToPrinterWithPrint(model: self.orderData!, controller: self)
        }else if action == 0{
            if self.isSplitByItem{
                if self.selectedGroupIndex! < arrOrderGroup.count{
                    selectedGroup = arrOrderGroup[self.selectedGroupIndex!]
                }else{
                    selectedGroup = nil
                }
                arrProducts = AppCommonMethods.Copy(of: orderData.arrProducts) ?? orderData.arrProducts
                self.arrUnSplitedProducts = self.arrProducts.filter({ model in
                    return model.orderSplitId ?? 0 == 0
                })
                lblGruopTitle.text = "Bill For Person \(selectedGroupIndex!+1)"
                tblSplitedItem.reloadData()
                tblUnSplitedItem.reloadData()
            }else{
                self.selectedGroup = self.arrOrderGroup.first
            }
            self.checkSplitType()
            checkPayValidation()
        }else{
            if let VC = OrderReviewVC.instance(){
                VC.selectedPayment = self.selectedPayment
                VC.selectedTable = selectedTable
                VC.orderData = AppCommonMethods.Copy(of: orderData!) ?? orderData!
                VC.orderGroup = selectedGroup!
                VC.orderType = orderType
                self.navigationController?.pushViewController(VC, animated: true)
            }
        }
        collectionGroups.reloadDataWithoutScroll()
    }
    
    //MARK:  Button Actions
    @IBAction func btnSplitAndPrintAction(_ sender:UIButton){
        self.view.endEditing(true)
        CreatOrderGroupOffline()
    }
    
    @IBAction func txtPersonChanged(_ sender:UITextField){
        checkPayValidation()
    }
    
    @IBAction func btnBackAction(_ sender:UIButton){
        self.navigationController?.popViewController(animated: true)
    }
    
    @IBAction func btnPayBillAction(_ sender:UIButton){
        CreatOrderGroupOffline(action: 3)
    }
    
    @IBAction func btnPrintAllAction(_ sender:UIButton){
        CreatOrderGroupOffline(action: 2)
    }
    
    @IBAction func btnPrintAction(_ sender:UIButton){
        CreatOrderGroupOffline(action: 1)
    }
    
    @IBAction func btnSplitTypeChanged(_ sender:UIButton){
        self.view.endEditing(true)
        if sender.tag == 0{
            isSplitByItem = true
        }else{
            isSplitByItem = false
        }
        selectedGroupIndex = 0
        selectedGroup = arrOrderGroup.first
        checkPayValidation()
        setSplitType()
        tblSplitedItem.reloadData()
        collectionGroups.reloadData()
    }
    
    @IBAction func btnGroupAction(_ sender:UIButton){
        self.view.endEditing(true)
        selectedGroupIndex = sender.tag
        if isGroupModified{
            CreatOrderGroupOffline()
            isGroupModified = false
        }else{
            if sender.tag < arrOrderGroup.count{
                selectedGroup = arrOrderGroup[sender.tag]
            }else{
                selectedGroup = nil
            }
            if isSplitByItem{
                fetchWillPayProduct()
            }else{
                self.lblSubTotal.text = String.init(format: "%@%.2f", AppConstants.currencySign, selectedGroup?.total ?? 0)
                self.lblTotal.text = String.init(format: "%@%.2f", AppConstants.currencySign, selectedGroup?.total ?? 0)
                lblBalanceAmount.text = String.init(format: "Balance Remaining: %@%.2f", AppConstants.currencySign,(selectedGroup?.total ?? 0) - (selectedGroup?.paidAmount ?? 0))
            }
            calculateSelectedmount()
            checkPayValidation()
            lblGruopTitle.text = "Bill For Person \(selectedGroupIndex!+1)"
            tblSplitedItem.reloadData()
            tblUnSplitedItem.reloadData()
            collectionGroups.reloadDataWithoutScroll()
        }
    }
    
    @IBAction func btnAddGoupAction(_ sender:UIButton){
        noOfGroups += 1
        collectionGroups.reloadDataWithoutScroll()
    }
    
    @IBAction func btnViewMoreProductAction(_ sender:UIButton){
        self.view.endEditing(true)
        let model = ((sender.accessibilityIdentifier ?? "") == "101") ? arrUnSplitedProducts[sender.tag] : arrSplitedProducts[sender.tag]
        if let _ = OrderProductDetailVC.showPopup(parentVC: self, product: model){
            
        }
    }
    
    @IBAction func btnDiscountAction(_ sender:UIButton){
        var settings = AlertSetting()
        settings.alertTitle = "Add Discount"
        settings.type = .kEnterAmount
        settings.textPlcaeholder = "discount"
        amountType = GratityViewType.kDiscount
        settings.titleColor = AppConstants.Colors.kAppLightGrayColor
        let discount = self.arrOrderGroup.reduce(0) { $0 + $1.discount }
        settings.maxAmount = (self.orderData.discount ?? 0) - discount
        settings.textTitle = String.init(format: "%@%.2f", AppConstants.currencySign, settings.maxAmount!)
        if let VC = AlertViewController.showPopup(parentVC: self, setting: settings){
            VC.delegate = self
        }
    }
    
    @IBAction func btnServiceChargeAction(_ sender:UIButton){
        var settings = AlertSetting()
        settings.alertTitle = "Add Service Charge"
        settings.type = .kEnterAmount
        settings.textPlcaeholder = "service charge"
        amountType = GratityViewType.kServiceCharge
        settings.titleColor = AppConstants.Colors.kAppLightGrayColor
        let serviceCharge = self.arrOrderGroup.reduce(0) { $0 + $1.serviceCharge }
        settings.maxAmount = (self.orderData.serviceCharge ?? 0) - serviceCharge
        settings.textTitle = String.init(format: "%@%.2f", AppConstants.currencySign, settings.maxAmount!)
        if let VC = AlertViewController.showPopup(parentVC: self, setting: settings){
            VC.delegate = self
        }
    }
    
    @IBAction func btnGratuityAction(_ sender:UIButton){
        var settings = AlertSetting()
        settings.alertTitle = "Add Gratuity"
        settings.type = .kEnterAmount
        settings.textPlcaeholder = "gratuity"
        amountType = GratityViewType.kGratuity
        settings.titleColor = AppConstants.Colors.kAppLightGrayColor
        let gratuity = self.arrOrderGroup.reduce(0) { $0 + $1.gratuity }
        settings.maxAmount = (self.orderData.gratuity ?? 0) - gratuity
        settings.textTitle = String.init(format: "%@%.2f", AppConstants.currencySign, settings.maxAmount!)
        if let VC = AlertViewController.showPopup(parentVC: self, setting: settings){
            VC.delegate = self
        }
    }
    
    @IBAction func btnRemoveGratuityAction(_ sender:UIButton){
        if !checkIfOrderSplited(){
            self.orderData.gratuity = 0
            calculateSelectedmount()
            CreatOrderGroupOffline()
        }else{
            if let selectedGroup{
                selectedGroup.autoGratuityRemove = true
                selectedGroup.gratuity = 0
                selectedGroup.total = selectedGroup.subTotal + selectedGroup.serviceCharge - selectedGroup.discount
                calculateSelectedmount()
                CreatOrderGroupOffline()
            }
        }
    }
    
    @IBAction func btnRemoveDiscountAction(_ sender:UIButton){
        if !checkIfOrderSplited(){
            self.orderData.discount = 0
            calculateSelectedmount()
            CreatOrderGroupOffline()
        }else{
            if let selectedGroup{
                selectedGroup.autoDiscountRemove = true
                selectedGroup.discount = 0
                selectedGroup.total = selectedGroup.subTotal + selectedGroup.gratuity + selectedGroup.serviceCharge
                calculateSelectedmount()
                CreatOrderGroupOffline()
            }
        }
    }
    
    @IBAction func btnRemoveServiceChargeAction(_ sender:UIButton){
        if !checkIfOrderSplited(){
            self.orderData.serviceCharge = 0
            calculateSelectedmount()
            CreatOrderGroupOffline()
        }else{
            if let selectedGroup{
                selectedGroup.autoServiceChargeRemove = true
                selectedGroup.serviceCharge = 0
                selectedGroup.total = selectedGroup.subTotal + selectedGroup.gratuity - selectedGroup.discount
                calculateSelectedmount()
                CreatOrderGroupOffline()
            }
        }
    }
}

//MARK:  UICollectionViewDataSource
extension SplitOrderVC:UICollectionViewDataSource, UICollectionViewDelegate{
    func collectionView(_ collectionView: UICollectionView, numberOfItemsInSection section: Int) -> Int {
        if isSplitByItem{
            return noOfGroups + 1
        }else{
            return arrOrderGroup.count
        }
    }
    
    func collectionView(_ collectionView: UICollectionView, cellForItemAt indexPath: IndexPath) -> UICollectionViewCell {
        if indexPath.row == (noOfGroups) && isSplitByItem{
            let cell = collectionView.dequeueReusableCell(withReuseIdentifier: "GroupsAddCell", for: indexPath) as! GroupsListCell
            return cell
        }else{
            let cell = collectionView.dequeueReusableCell(withReuseIdentifier: "GroupsListCell", for: indexPath) as! GroupsListCell
            cell.btnGroup.tag = indexPath.row
            cell.btnGroup.setTitle("Person \(indexPath.row+1)", for: .normal)
            cell.btnGroup.backgroundColor  = AppConstants.Colors.kAppThemeBGColor
            cell.btnGroup.setTitleColor(AppConstants.Colors.kAppDarkGrayColor, for: .normal)
            if selectedGroupIndex != nil{
                if selectedGroupIndex! == indexPath.row{
                    cell.btnGroup.backgroundColor  = AppConstants.Colors.kAppThemeAquaColor
                    cell.btnGroup.setTitleColor(.white, for: .normal)
                }
            }
            return cell
        }
    }
}

//MARK:  UITableViewDataSource
extension SplitOrderVC:UITableViewDataSource,UITableViewDelegate{
    func tableView(_ tableView: UITableView, numberOfRowsInSection section: Int) -> Int {
        if tableView == tblUnSplitedItem{
            return arrUnSplitedProducts.count
        }else{
            return arrSplitedProducts.count
        }
    }
    
    func tableView(_ tableView: UITableView, cellForRowAt indexPath: IndexPath) -> UITableViewCell {
        if indexPath.row < ((tblUnSplitedItem == tableView) ? arrUnSplitedProducts.count : arrSplitedProducts.count){
            let cell = tableView.dequeueReusableCell(withIdentifier: "ProductsListCell", for: indexPath) as! ProductsListCell
            let model = (tblUnSplitedItem == tableView) ? arrUnSplitedProducts[indexPath.row] : arrSplitedProducts[indexPath.row]
            if model.isDelete{
                cell.lblName.text = ""
                cell.lblName.attributedText = (model.productName ?? "").strikeThoughText
            }else{
                cell.lblName.attributedText = nil
                cell.lblName.text = model.productName ?? ""
            }
            cell.lblQuantity.text = "\(model.quantity ?? 0)x"
            cell.lblName.text = model.productName ?? ""
            cell.lblPrice.text = String.init(format: "%@%.2f", AppConstants.currencySign,model.price ?? 0)
            cell.lblDescription.isHidden = true
            cell.btnViewMore.isHidden = true
            if tblUnSplitedItem == tableView{
                cell.btnViewMore.accessibilityIdentifier = "101"
            }else{
                cell.btnViewMore.accessibilityIdentifier = "102"
            }
            cell.btnViewMore.tag = indexPath.row
            if model.arrAddons.count > 0 || model.arrIngriedent.count > 0 || model.specialInstruction ?? "" != ""{
                cell.lblDescription.isHidden = false
                var strDesc = ""
                model.arrIngriedent.forEach({ (ingrident) in
                    var strIngrident = ""
                    if ingrident.with ?? 0 == 1{
                        if ingrident.price ?? 0 == 0{
                            strIngrident = String.init(format: "(%dx %@ - Free)", ingrident.quantity ?? 0, ingrident.name ?? "")
                        }else{
                            strIngrident = String.init(format: "(%dx %@ - %@%.2f)", ingrident.quantity ?? 0, ingrident.name ?? "", AppConstants.currencySign, ingrident.price ?? 0)
                        }
                    }else{
                        if ingrident.price ?? 0 == 0{
                            strIngrident = String.init(format: "(No %@ - Free)", ingrident.name ?? "")
                        }else{
                            strIngrident = String.init(format: "(No %@ - %@%.2f)", ingrident.name ?? "", AppConstants.currencySign, ingrident.price ?? 0)
                        }
                    }
                    if strDesc == ""{
                        strDesc = strIngrident
                    }else{
                        strDesc = "\(strDesc)\n\(strIngrident)"
                    }
                })
                model.arrAddons.forEach({ (addon) in
                    let strAddon = String.init(format: "(%dx %@)", addon.quantity ,addon.name ?? "")
                    if strDesc == ""{
                        strDesc = strAddon
                    }else{
                        strDesc = "\(strDesc)\n\(strAddon)"
                    }
                })
                if model.specialInstruction ?? "" != ""{
                    if strDesc == ""{
                        strDesc = "Special Instruction: \(model.specialInstruction ?? "")"
                    }else{
                        strDesc = "\(strDesc)\nSpecial Instruction: \(model.specialInstruction ?? "")"
                    }
                    if model.instructionPrice ?? 0 != 0{
                        strDesc.append(String.init(format: " - %.2f", model.instructionPrice ?? 0))
                    }
                }
                if model.isDelete{
                    cell.lblDescription.text = ""
                    cell.lblDescription.attributedText = strDesc.strikeThoughText
                }else{
                    cell.lblDescription.attributedText = nil
                    cell.lblDescription.text = strDesc
                }
                let height = strDesc.getHeightFromString(font: AppConstants.GlobalFontConstants.kBoldFont(size: 14), width: cell.lblDescription.frame.width)
                if height > 60{
                    cell.btnViewMore.isHidden = false
                }
            }
            return cell
        }
        return UITableViewCell()
    }
    
    func tableView(_ tableView: UITableView, heightForRowAt indexPath: IndexPath) -> CGFloat {
        var product:OrderProductModel!
        if tableView == tblUnSplitedItem{
            product = arrUnSplitedProducts[indexPath.row]
        }else{
            product = arrSplitedProducts[indexPath.row]
        }
        if AppCommonMethods.fetchSiteSettingValue(key: "delete_item_visible") ?? "" == "false" && product.isDelete{
            return 0
        }
        return UITableView.automaticDimension
    }
    
    func tableView(_ tableView: UITableView, didSelectRowAt indexPath: IndexPath) {
        if tableView == tblSplitedItem{
            let model = AppCommonMethods.Copy(of: arrSplitedProducts[indexPath.row]) ?? arrSplitedProducts[indexPath.row]
            if model.isDelete{
                return
            }
            if selectedGroup?.paidAmount ?? 0 > 0{
                AppCommonMethods.showToastAlert(message: AppConstants.GlobalAlert.ALERT_GROUP_MODIFIED_AFTER_PAYMENT)
                return
            }
            isGroupModified = true
            if model.quantity == 1{
                arrSplitedProducts.remove(at: indexPath.row)
                SQLiteManage.deleteOrderItem(productId: model.id ?? 0, orderId: 0)
            }else{
                arrSplitedProducts[indexPath.row].quantity = (arrSplitedProducts[indexPath.row].quantity ?? 0) - 1
            }
            let index = arrUnSplitedProducts.firstIndex { (product) -> Bool in
                if product.prodcutId ?? 0 != model.prodcutId ?? 0 || !product.isDelete{
                    return false
                }else{
                    var isContain = true
                    if model.specialInstruction ?? "" != product.specialInstruction ?? ""{
                        isContain = false
                    }
                    if model.arrIngriedent.count > 0 && product.arrIngriedent.count == 0{
                        isContain = false
                    }else if model.arrIngriedent.count == 0 && product.arrIngriedent.count > 0{
                        isContain = false
                    }else{
                        for ingrident in model.arrIngriedent{
                            let arr = product.arrIngriedent.filter { ingrident2 in
                                return (ingrident.productIngredientId ?? 0 == ingrident2.productIngredientId ?? 0)
                            }
                            if arr.count > 0{
                                if arr[0].quantity ?? 0 != ingrident.quantity ?? 0{
                                    isContain = false
                                }
                            }else{
                                isContain = false
                            }
                        }
                    }
                    if model.arrAddons.count > 0 && product.arrAddons.count == 0{
                        isContain = false
                    }else if model.arrAddons.count == 0 && product.arrAddons.count > 0{
                        isContain = false
                    }else{
                        for addon in model.arrAddons{
                            let arr = product.arrAddons.filter { addon2 in
                                return (addon2.AddonId ?? 0 == addon.AddonId ?? 0)
                            }
                            if arr.count == 0{
                                isContain = false
                            }
                        }
                    }
                    return isContain
                }
            }
            if index != nil{
                arrUnSplitedProducts[index!].groupUniqueId = ""
                arrUnSplitedProducts[index!].orderSplitId = nil
                arrUnSplitedProducts[index!].quantity = (arrUnSplitedProducts[index!].quantity ?? 0) + 1
                arrUnSplitedProducts[index!].isItemUpdated = 1
            }else{
                model.id = Date().millisecondsSince1970
                model.uniqueId = Date().millisecondsInString
                model.isItemUpdated = 1
                for j in 0..<model.arrIngriedent.count{
                    let addon = model.arrIngriedent[j]
                    addon.id = Int("\(Date().millisecondsSince1970)\(j)") ?? 0
                    addon.isNewOrder = 1
                }
                for j in 0..<model.arrAddons.count{
                    let addon = model.arrAddons[j]
                    addon.id = Int("\(Date().millisecondsSince1970)\(j)") ?? 0
                    addon.isNewOrder = 1
                }
                model.orderSplitId = nil
                model.groupUniqueId = ""
                model.quantity = 1
                arrUnSplitedProducts.append(model)
            }
        }else{
            let model = AppCommonMethods.Copy(of: arrUnSplitedProducts[indexPath.row]) ?? arrUnSplitedProducts[indexPath.row]
            if model.isDelete{
                return
            }
            if selectedGroupIndex == nil{
                AppCommonMethods.showToastAlert(message: AppConstants.GlobalAlert.ALERT_SELECT_GROUP)
                return
            }
            for i in 0..<selectedGroupIndex!{
                if i >= arrOrderGroup.count{
                    AppCommonMethods.showToastAlert(message: "Please add item in Person \(i+1) and split")
                    return
                }
            }
            isGroupModified = true
            var isRemoved = false
            if model.quantity == 1{
                isRemoved = true
                arrUnSplitedProducts.remove(at: indexPath.row)
                SQLiteManage.deleteOrderItem(productId: model.id ?? 0, orderId: 0)
            }else{
                arrUnSplitedProducts[indexPath.row].quantity = (arrUnSplitedProducts[indexPath.row].quantity ?? 0) - 1
            }
            let index = arrSplitedProducts.firstIndex { (product) -> Bool in
                if product.prodcutId ?? 0 != model.prodcutId ?? 0 || product.isDelete{
                    return false
                }else{
                    var isContain = true
                    if model.specialInstruction ?? "" != product.specialInstruction ?? ""{
                        isContain = false
                    }
                    if model.arrIngriedent.count > 0 && product.arrIngriedent.count == 0{
                        isContain = false
                    }else if model.arrIngriedent.count == 0 && product.arrIngriedent.count > 0{
                        isContain = false
                    }else{
                        for ingrident in model.arrIngriedent{
                            let arr = product.arrIngriedent.filter { ingrident2 in
                                return (ingrident.productIngredientId ?? 0 == ingrident2.productIngredientId ?? 0)
                            }
                            if arr.count > 0{
                                if arr[0].quantity ?? 0 != ingrident.quantity ?? 0{
                                    isContain = false
                                }
                            }else{
                                isContain = false
                            }
                        }
                    }
                    if model.arrAddons.count > 0 && product.arrAddons.count == 0{
                        isContain = false
                    }else if model.arrAddons.count == 0 && product.arrAddons.count > 0{
                        isContain = false
                    }else{
                        for addon in model.arrAddons{
                            let arr = product.arrAddons.filter { addon2 in
                                return (addon2.AddonId ?? 0 == addon.AddonId ?? 0)
                            }
                            if arr.count == 0{
                                isContain = false
                            }
                        }
                    }
                    return isContain
                }
            }
            if index != nil{
                arrSplitedProducts[index!].quantity = (arrSplitedProducts[index!].quantity ?? 0) + 1
                arrSplitedProducts[index!].isItemUpdated = 1
            }else{
                if !isRemoved{
                    arrUnSplitedProducts[indexPath.row].id = Date().millisecondsSince1970
                    arrUnSplitedProducts[indexPath.row].uniqueId = Date().millisecondsInString
                    arrUnSplitedProducts[indexPath.row].isItemUpdated = 1
                    for j in 0..<arrUnSplitedProducts[indexPath.row].arrIngriedent.count{
                        let addon = arrUnSplitedProducts[indexPath.row].arrIngriedent[j]
                        addon.id = Int("\(Date().millisecondsSince1970)\(j)") ?? 0
                        addon.isNewOrder = 1
                    }
                    for j in 0..<arrUnSplitedProducts[indexPath.row].arrAddons.count{
                        let addon = arrUnSplitedProducts[indexPath.row].arrAddons[j]
                        addon.id = Int("\(Date().millisecondsSince1970)\(j)") ?? 0
                        addon.isNewOrder = 1
                    }
                }
                model.quantity = 1
                arrSplitedProducts.append(model)
            }
        }
        checkPayValidation()
        calculateSelectedmount()
        CreatOrderGroupOffline()
    }
}

//MARK:  UITextFieldDelegate
extension SplitOrderVC:UITextFieldDelegate{
    func textFieldShouldReturn(_ textField: UITextField) -> Bool {
        return textField.resignFirstResponder()
    }
    
    func textField(_ textField: UITextField, shouldChangeCharactersIn range: NSRange, replacementString string: String) -> Bool {
        let allowedCharacters = CharacterSet(charactersIn:"0123456789")
        let characterSet = CharacterSet(charactersIn: string)
        return allowedCharacters.isSuperset(of: characterSet)
    }
}

extension SplitOrderVC:AlertControllerDelegate{
    func alertButtonAction(index: Int, data: alertViewData, type: AlertType) {
        if let value = Double(data.value){
            if amountType == .kDiscount{
                selectedGroup?.autoDiscountRemove = true
                self.selectedGroup?.discount += value
            }else if amountType == .kServiceCharge{
                selectedGroup?.autoServiceChargeRemove = true
                self.selectedGroup?.serviceCharge += value
            }else if amountType == .kGratuity{
                selectedGroup?.autoGratuityRemove = true
                self.selectedGroup?.gratuity += value
            }
            calculateSelectedmount()
            self.CreatOrderGroupOffline()
        }
    }
}
