//
//  OrderHistoryVC.swift
//  EPOS
//
//  Created by Apple on 04/06/21.
//

import UIKit
import BetterSegmentedControl
import ActionSheetPicker_3_0
import CoreData
import DropDown

class OrderHistoryVC: UIViewController {
    
    //MARK: IBOutlets
    @IBOutlet weak var collectionOrders:UICollectionView!
    @IBOutlet weak var viewForCustomDate:UIView!
    @IBOutlet weak var lblViewTitle:UILabel!
    @IBOutlet weak var imgFromDate:UIImageViewX!
    @IBOutlet weak var imgToDate:UIImageViewX!
    @IBOutlet weak var txtFromDate:UITextField!
    @IBOutlet weak var txtToDate:UITextField!
    @IBOutlet weak var segementOrderTime:BetterSegmentedControl!
    @IBOutlet weak var btnSelect:UIButton!
    @IBOutlet weak var btnArchieveOrders:UIButton!
    @IBOutlet weak var lblSelectedOrders:UILabel!
    @IBOutlet weak var lblTableNo:UILabel!
    @IBOutlet weak var viewForArchieved:UIView!
    @IBOutlet weak var txtSearch:UITextField!
    
    //MARK: Instances
    var dictOrders = [String:[Any]]()
    var dictSearchOrders = [String:[Any]]()
    var arrOrders = [WebOrderModel]()
    var arrOrderDate = [String]()
    var fromDate = Date()
    var toDate = Date()
    var refreshOrderControl = UIRefreshControl()
    var isWebOrder = false
    var isArchived = 0
    var arrSelectedOrders = [OrderModel]()
    var isArchievedSelected = false
    var parentVC:SideMenuVC!
    var isFromOrders = false
    var isSearchEnabled = false
    var selectedTable:TableModel?
    
    //MARK: ViewController LifeCycle
    override func viewDidLoad() {
        super.viewDidLoad()
        
        // Do any additional setup after loading the view.
        
        viewForCustomDate.isHidden = true
        self.reloadPageData()
        refreshOrderControl.addTarget(self, action: #selector(reloadPageData), for: .valueChanged)
        self.collectionOrders.addSubview(refreshOrderControl)
        
        if isWebOrder{
            btnSelect.isHidden = true
            lblTableNo.superview?.isHidden = true
        }else{
            if isArchived == 1{
                lblViewTitle.text = "Archived Orders"
                btnArchieveOrders.setTitle("Unarchive", for: .normal)
            }else{
                btnArchieveOrders.setTitle("Archive", for: .normal)
            }
        }
        
        self.segementOrderTime.segments = LabelSegment.segments(withTitles: ["Today","This week","This month","Custom"], normalBackgroundColor: .white, normalFont: AppConstants.GlobalFontConstants.kBoldFont(size: 20), normalTextColor: AppConstants.Colors.kAppDarkGrayColor, selectedBackgroundColor: AppConstants.Colors.kAppThemeAquaColor , selectedFont: AppConstants.GlobalFontConstants.kBoldFont(size: 20), selectedTextColor: .white)
    }
    
    override func viewWillAppear(_ animated: Bool) {
        self.txtSearch.text = ""
        self.isSearchEnabled = false
        if !self.isWebOrder{
            self.SortOrderData()
        }
        NotificationCenter.default.addObserver(self, selector: #selector(reloadPageData), name: AppConstants.notifications.kDatabasePushed, object: nil)
    }
    
    override func viewWillDisappear(_ animated: Bool) {
        NotificationCenter.default.removeObserver(self, name: AppConstants.notifications.kDatabasePushed, object: nil)
    }
    
    override func viewDidLayoutSubviews() {
        DispatchQueue.main.asyncAfter(deadline: .now()+0.1) {
            self.collectionOrders.reloadData()
        }
    }
    
    //MARK: Create ViewController Instance
    static func addToParentView(parentVC:SideMenuVC, isWebOrder:Bool = false, isArchived:Int = 0, isFromOrders:Bool = false)->OrderHistoryVC?{
        guard let VC = UIStoryboard.init(name: "Orders", bundle: nil).instantiateViewController(withIdentifier: "OrderHistoryVC") as? OrderHistoryVC else {
            return nil
        }
        VC.isArchived = isArchived
        VC.parentVC = parentVC
        VC.isFromOrders = isFromOrders
        VC.isWebOrder = isWebOrder
        parentVC.addChild(VC)
        parentVC.viewForContainer.addSubview(VC.view)
        VC.view.frame = CGRect.init(x: 0, y: 0, width: parentVC.viewForContainer.frame.width, height: parentVC.viewForContainer.frame.height)
        return VC
    }
    
    //MARK: General Methods
    @objc func reloadPageData(){
        DispatchQueue.main.async {
            self.txtSearch.text = ""
            self.isSearchEnabled = false
            if self.isWebOrder{
                self.GetOnlineOrders()
            }else{
//                if Reachabilities.shared.isConnectedToNetwork() && AppConstants.DataSyncMode == "Auto"{
//                    self.FetchOrdersList()
//                }else{
                    self.SortOrderData()
                    self.refreshOrderControl.endRefreshing()
//                }
            }
        }
    }
    
    func checkOrderSplite(orderData:OrderModel)->Bool{
        var isSplited = false
        for model in orderData.arrProducts{
            if model.orderSplitId ?? 0 != 0{
                isSplited = true
                break
            }
        }
        return isSplited
    }
    
    func SortOrderData(){
        self.dictOrders.removeAll()
        self.arrOrderDate.removeAll()
        if segementOrderTime.index == 0{
            fromDate = Date().startOfDate() ?? Date()
            toDate = Date().endOfDate() ?? Date()
            if isWebOrder{
                dictOrders[Date().getDateInString(format: "d'\(Date().getDateSuffix())' MMMM yyyy")] = arrOrders
            }else{
                dictOrders[Date().getDateInString(format: "d'\(Date().getDateSuffix())' MMMM yyyy")] = SQLiteManage.fetchOrdersDataFromDates(startDate: fromDate, endDate: toDate, isArchive: self.isArchived, table: self.selectedTable)
            }
            arrOrderDate.append(Date().getDateInString(format: "d'\(Date().getDateSuffix())' MMMM yyyy"))
        } else if segementOrderTime.index == 1{
            fromDate = Date().startOfWeek() ?? Date()
            toDate = Date().endOfWeek() ?? Date()
            if isWebOrder{
                arrOrders.forEach { model in
                    var date = Date()
                    if (model.orderType ?? "").lowercased() == "dine in"{
                        date = ((model.created ?? "").components(separatedBy: ".").first ?? "").getDateFromString(format: "yyyy-MM-dd'T'HH:mm:ss") ?? Date()
                    }else{
                        date = (model.deliveryDate ?? "").getDateFromString(format: "yyyy-MM-dd") ?? Date()
                    }
                    let strDate = date.getDateInString(format: "d'\(date.getDateSuffix())' MMMM yyyy")
                    if var arr = dictOrders[strDate] as? [WebOrderModel]{
                        arr.append(model)
                        dictOrders[strDate] = arr
                    }else{
                        arrOrderDate.append(strDate)
                        dictOrders[strDate] = [model]
                    }
                }
            }else{
                let arrDate = Date.dates(from: fromDate, to: toDate)
                arrDate.forEach { date in
                    let date2 = date.addingTimeInterval(24*60*59)
                    let arr = SQLiteManage.fetchOrdersDataFromDates(startDate: date, endDate: date2, isArchive: self.isArchived, table: self.selectedTable)
                    if arr.count > 0{
                        self.dictOrders[date.getDateInString(format: "d'\(date.getDateSuffix())' MMMM yyyy")] = arr
                        self.arrOrderDate.append(date.getDateInString(format: "d'\(date.getDateSuffix())' MMMM yyyy"))
                    }
                }
            }
        }else if segementOrderTime.index == 2{
            fromDate = Date().startOfMonth()
            toDate = Date().endOfMonth()
            let arrDate = Date.datesAtInterVal(fromDate: fromDate, toDate: toDate, duration: 7)
            arrDate.forEach { date in
                var date2 = date.addingTimeInterval(604799)
                if date2 > toDate{
                    date2 = toDate
                }
                if self.isWebOrder{
                    let arrO = arrOrders.filter { (model) -> Bool in
                        var orderDdate:Date?
                        if (model.orderType ?? "").lowercased() == "dine in"{
                            orderDdate = ((model.created ?? "").components(separatedBy: ".").first ?? "").getDateFromString(format: "yyyy-MM-dd'T'HH:mm:ss")
                        }else{
                            orderDdate = "\((model.deliveryDate ?? "").components(separatedBy: "T").first ?? "") \(model.deliveryTime ?? "")".getDateFromString(format: "yyyy-MM-dd hh:mm a")
                        }
                        if orderDdate != nil{
                            if orderDdate! >= date && orderDdate! < date2{
                                return true
                            }
                        }
                        return false
                    }
                    dictOrders["\(date.getDateInString(format: "d'\(date.getDateSuffix())' MMMM yyyy")) - \(date2.getDateInString(format: "d'\(date2.getDateSuffix())' MMMM yyyy"))"] = arrO
                }else{
                    let arr = SQLiteManage.fetchOrdersDataFromDates(startDate: date, endDate: date2, isArchive: self.isArchived, table: self.selectedTable)
                    dictOrders["\(date.getDateInString(format: "d'\(date.getDateSuffix())' MMMM yyyy")) - \(date2.getDateInString(format: "d'\(date2.getDateSuffix())' MMMM yyyy"))"] = arr
                    
                }
                self.arrOrderDate.append("\(date.getDateInString(format: "d'\(date.getDateSuffix())' MMMM yyyy")) - \(date2.getDateInString(format: "d'\(date2.getDateSuffix())' MMMM yyyy"))")
            }
        }else{
            if !isWebOrder{
                let arr = SQLiteManage.fetchOrdersDataFromDates(startDate: fromDate.startOfDate(), endDate: toDate.endOfDate(),isArchive: self.isArchived, table: self.selectedTable)
                arr.forEach { (model) in
                    let date = (model.deliveryDate ?? "").getDateFromString(format: "yyyy-MM-dd HH:mm:ss") ?? Date()
                    let strDate = date.getDateInString(format: "d'\(date.getDateSuffix())' MMMM yyyy")
                    if var arr = dictOrders[strDate]{
                        arr.append(model)
                        dictOrders[strDate] = arr
                    }else{
                        dictOrders[strDate] = [model]
                        arrOrderDate.append(strDate)
                    }
                }
            }else{
                arrOrders.forEach { model in
                    var date = Date()
                    if (model.orderType ?? "").lowercased() == "dine in"{
                        date = ((model.created ?? "").components(separatedBy: ".").first ?? "").getDateFromString(format: "yyyy-MM-dd'T'HH:mm:ss") ?? Date()
                    }else{
                        date = (model.deliveryDate ?? "").getDateFromString(format: "yyyy-MM-dd") ?? Date()
                    }
                    let strDate = date.getDateInString(format: "d'\(date.getDateSuffix())' MMMM yyyy")
                    if var arr = dictOrders[strDate]{
                        arr.append(model)
                        dictOrders[strDate] = arr
                    }else{
                        arrOrderDate.append(strDate)
                        dictOrders[strDate] = [model]
                    }
                }
            }
            
        }
        if segementOrderTime.index != 2{
            arrOrderDate.sort { (str1, str2) -> Bool in
                let strDate1 = str1
                let strDate2 = str2
                let date1 = strDate1.removeDateSuffix().getDateFromString(format: "d MMMM yyyy") ?? Date()
                let date2 = strDate2.removeDateSuffix().getDateFromString(format: "d MMMM yyyy") ?? Date()
                return date2 < date1
            }
        }else{
            arrOrderDate.sort { (str1, str2) -> Bool in
                let strDate1 = str1
                let strDate2 = str2
                let date1 = (strDate1.components(separatedBy: " - ").first ?? "").removeDateSuffix().getDateFromString(format: "d MMMM yyyy") ?? Date()
                let date2 = (strDate2.components(separatedBy: " - ").first ?? "").removeDateSuffix().getDateFromString(format: "d MMMM yyyy") ?? Date()
                return date2 < date1
            }
        }
        self.collectionOrders.reloadData()
    }
    
    //MARK: Button Actions
    @IBAction func btnSelectAction(_ sender:UIButton){
        self.view.endEditing(true)
        isArchievedSelected = true
        viewForArchieved.isHidden = false
        collectionOrders.reloadData()
    }
    
    @IBAction func btnArchieveAction(_ sender:UIButton){
        self.view.endEditing(true)
        if arrSelectedOrders.count == 0{
            AppValidation().showAlertView(parentVC: self, withAlertTile: AppConstants.GlobalAlert.ALERT_TITLE, withAlertMsg: AppConstants.GlobalAlert.kSelectOneOrder, withActionsTitle: [AppConstants.GlobalAlert.ALERT_BTN_OK]) { (index) in
                
            }
        }else{
            var settings = AlertSetting()
            if isArchived == 1{
                settings.alertMessage = AppConstants.GlobalAlert.ALERT_ENTER_PASSWORD_UNARCHIVEORDER
            }else{
                settings.alertMessage = AppConstants.GlobalAlert.ALERT_ENTER_PASSWORD_ARCHIVEORDER
            }
            settings.alertTitle = AppConstants.GlobalAlert.ALERT_ENTER_PASSWORD
            settings.type = .kEnterUserPassword
            settings.textPlcaeholder = "password"
            settings.titleColor = AppConstants.Colors.kAppLightGrayColor
            if let VC = AlertViewController.showPopup(parentVC: self.parentVC, setting: settings){
                VC.delegate = self
            }
        }
        
    }
    
    @IBAction func btnBackAction(_ sender:UIButton){
        if isFromOrders{
            self.view.removeFromSuperview()
            self.removeFromParent()
        }else{
            self.parentVC.AddContainerView(data: self.parentVC.arrSideMenu.first!)
        }
    }
    
    @IBAction func btnCancelArchieveAction(_ sender:UIButton){
        self.view.endEditing(true)
        isArchievedSelected = false
        arrSelectedOrders.removeAll()
        viewForArchieved.isHidden = true
        collectionOrders.reloadData()
        lblSelectedOrders.text = "0 orders selected"
    }
    
    @IBAction func btnOrderStatusChangeAction(_ sender:UIButton){
        self.view.endEditing(true)
        let model = (isSearchEnabled ? dictSearchOrders : dictOrders)[arrOrderDate[Int(sender.accessibilityIdentifier ?? "") ?? 0]]![sender.tag] as! OrderModel
        if model.table?.locked ?? false{
            AppCommonMethods.showToastAlert(message: AppConstants.GlobalAlert.ALERT_TABLE_BUSY)
            return
        }
        if model.totalPaid ?? 0 >= (model.total ?? 0) && model.total ?? 0 > 0{
            if model.orderTypeId ?? 0 == 5 || model.orderTypeId ?? 0 == 1{
                model.orderStatusId = 5
                if model.table?.id ?? 0 != 0{
                    if let status = CoreDataHelper.shared.fetchTableStatusData(name: "vacant").first{
                        AppCommonMethods.SaveTable(table: model.table!, statusId: status.id)
                        model.table?.tableStatusId = status.id
                        SQLiteManage.updateTableStatus(tableId: model.table?.id ?? 0, statusId: status.id, lastOrderId: 0, lastOrderTotal: 0, lastOrderTime: "", offline: 1)
                    }else{
                        AppCommonMethods.showToastAlert(message: AppConstants.GlobalAlert.ALERT_NO_TABLESTATUS)
                    }
                }
            }else if model.orderTypeId ?? 0 == 2{
                if model.orderStatusId ?? 0 != 6 && AppCommonMethods.fetchSiteSettingValue(key: "is_ready_to_collect") ?? "" == "true"{
                    model.orderStatusId = 6
                }else{
                    model.orderStatusId = 5
                }
            }else{
                if model.orderStatusId ?? 0 != 6 && AppCommonMethods.fetchSiteSettingValue(key: "is_on_the_way") ?? "" == "true"{
                    model.orderStatusId = 6
                }else{
                    model.orderStatusId = 5
                }
            }
            if Reachabilities.shared.isConnectedToNetwork() && AppConstants.DataSyncMode == "Auto"{
                AppCommonMethods.startProgressBar()
                BGAPIExecution.shared.orderSaved = { orderId, message in
                    DispatchQueue.main.async {
                        AppCommonMethods.stopProgressBar()
                        print("Order \(orderId) Saved To Server")
                        self.SortOrderData()
                    }
                }
                BGAPIExecution.shared.AddOrderToQueue(order: model)
            }else{
                SQLiteManage.SaveOrderIntoDatabase(order: model, updated: 1)
                SortOrderData()
            }
        }else{
            if model.splitCount ?? 0 > 0 || self.checkOrderSplite(orderData: model){
                if let VC = SplitOrderVC.instance(){
                    let orderType = OrderTypesModel.init()
                    orderType.id = model.orderTypeId
                    orderType.type = model.orderType
                    VC.orderType = orderType
                    VC.orderData = AppCommonMethods.Copy(of: model) ?? model
                    self.navigationController?.pushViewController(VC, animated: true)
                }
            }else{
                if let VC = OrderReviewVC.instance(){
                    let orderType = OrderTypesModel.init()
                    orderType.id = model.orderTypeId
                    orderType.type = model.orderType
                    VC.selectedTable = model.table
                    VC.orderType = orderType
                    VC.orderData = AppCommonMethods.Copy(of: model) ?? model
                    self.navigationController?.pushViewController(VC, animated: true)
                }
            }
        }
    }
    
    @IBAction func segmentOrderChanged(_ sender:Any){
        self.view.endEditing(true)
        self.txtSearch.text = ""
        self.isSearchEnabled = false
        viewForCustomDate.backgroundColor = AppConstants.Colors.kAppThemeBGColor
        txtToDate.text = ""
        txtFromDate.text = ""
        imgFromDate.imageColor = AppConstants.Colors.kAppLightGrayColor
        imgToDate.imageColor = AppConstants.Colors.kAppLightGrayColor
        txtToDate.backgroundColor = .white
        txtFromDate.backgroundColor = .white
        viewForCustomDate.isHidden = true
        if segementOrderTime.index == 0{
            self.toDate = Date()
            self.fromDate = Date()
        }else if segementOrderTime.index == 1{
            fromDate = Date().startOfWeek() ?? Date()
            toDate = Date().endOfWeek() ?? Date()
        }else if segementOrderTime.index == 2{
            fromDate = Date().startOfMonth()
            toDate = Date().endOfMonth()
        }else{
            viewForCustomDate.isHidden = false
            txtToDate.text = "To - \(self.toDate.getDateInString(format: "dd/MM/yyyy"))"
            txtFromDate.text = "From - \(self.fromDate.getDateInString(format: "dd/MM/yyyy"))"
            imgFromDate.imageColor = AppConstants.Colors.kAppThemeAquaColor
            imgToDate.imageColor = AppConstants.Colors.kAppThemeRedColor
            txtToDate.backgroundColor = AppConstants.Colors.kAppThemeBGColor
            txtFromDate.backgroundColor = AppConstants.Colors.kAppThemeBGColor
            viewForCustomDate.backgroundColor = .white
        }
        if self.isWebOrder{
            self.GetOnlineOrders()
        }else{
            self.SortOrderData()
        }
    }
    
    @IBAction func txtSearchChanged(_ sender:UITextField){
        if (sender.text ?? "").replacingOccurrences(of: " ", with: "").isEmpty{
            self.isSearchEnabled = false
        }else{
            self.isSearchEnabled = true
            for key in self.arrOrderDate{
                if let arr = self.dictOrders[key] as? [OrderModel]{
                    self.dictSearchOrders[key] = arr.filter({ model in
                        return (model.customer?.name?.lowercased().contains(sender.text!.lowercased()) ?? false) || (model.id?.description.contains(sender.text!) ?? false)
                    })
                }
                if let arr = self.dictOrders[key] as? [WebOrderModel]{
                    self.dictSearchOrders[key] = arr.filter({ model in
                        return (model.customerName?.lowercased().contains(sender.text!.lowercased()) ?? false) || (model.id?.description.contains(sender.text!) ?? false)
                    })
                }
            }
        }
        self.collectionOrders.reloadData()
    }
    
    @IBAction func btnTableNoAction(_ sender:UIButton){
        self.view.endEditing(true)
        let tableDropDown = DropDown()
        tableDropDown.dismissMode = .automatic
        tableDropDown.anchorView = sender
        tableDropDown.bottomOffset = CGPoint(x: 0, y: sender.bounds.height)
        // Action triggered on selection
        let arrTable = SQLiteManage.FetchTables("SELECT * FROM Tables WHERE disabled = 0 ORDER BY sequence")
        tableDropDown.selectionAction = { [weak self] (index, item) in
            if index == 0{
                self?.selectedTable = nil
            }else{
                self?.selectedTable = arrTable[index-1]
            }
            self?.lblTableNo.text = item
            self?.txtSearch.text = ""
            self?.isSearchEnabled = false
            self?.isArchievedSelected = false
            self?.arrSelectedOrders.removeAll()
            self?.viewForArchieved.isHidden = true
            self?.SortOrderData()
        }
        var arrTableName = arrTable.compactMap{ $0.number }
        arrTableName.insert("Select Table", at: 0)
        tableDropDown.dataSource = arrTableName
        tableDropDown.show()
    }
    
    //MARK: WebService Methods
    
    func GetOnlineOrders(){
        var dictParam = [String:String]()
        if isWebOrder{
            dictParam["from_date"] = fromDate.getDateInString(format: "yyyy-MM-dd")
            dictParam["to_date"] = toDate.getDateInString(format: "yyyy-MM-dd")
        }else{
            dictParam["from_date"] = fromDate.getDateInString(format: "dd-MM-yyyy")
            dictParam["to_date"] = toDate.getDateInString(format: "dd-MM-yyyy")
        }
        
        dictParam["nopaginate"] = "1"
        
        if AppConstants.isInDevlopmentMode{
            print("Order List Param:",dictParam)
        }
        AppCommonMethods.startProgressBar()
        WebServiceManager().requestAPI(params: dictParam,  urlString: AppConstants.APIURL.kOnlineAllOrder, method: "GET",isRestaurantAPI: true) { (message, result) in
            DispatchQueue.main.async {
                AppCommonMethods.stopProgressBar()
                self.refreshOrderControl.endRefreshing()
                let jsonDecoder = JSONDecoder()
                self.arrOrders.removeAll()
                if let response = result as? NSDictionary{
                    if let arrO = response["normal_orders"] as? [NSDictionary], let data = AppCommonMethods.convertToJson(object: arrO), let aData = try? jsonDecoder.decode([WebOrderModel].self, from: data){
                        self.arrOrders = aData
                    }
                    if let arrO = response["dinein_orders"] as? [NSDictionary], let data = AppCommonMethods.convertToJson(object: arrO), let aData = try? jsonDecoder.decode([WebOrderModel].self, from: data){
                        aData.forEach { model in
                            model.orderType = "dine in"
                        }
                        self.arrOrders.append(contentsOf: aData)
                    }
                }else{
                    AppValidation().showAlertView(parentVC: self, withAlertTile: AppConstants.GlobalAlert.ALERT_TITLE, withAlertMsg: message, withActionsTitle: [AppConstants.GlobalAlert.ALERT_BTN_OK]) { (index) in
                        
                    }
                }
                self.SortOrderData()
                self.collectionOrders.reloadData()
            }
        }
    }
    
    func ArchieveOrders()  {
        AppCommonMethods.startProgressBar()
        var dictParam = [String:String]()
        var arrIds = [String]()
        var arrOfflineOrder = [OrderModel]()
        for model in arrSelectedOrders{
            if model.isNewOrder == 1{
                if isArchived == 1{
                    model.isArchived = false
                }else{
                    model.isArchived = true
                }
                arrOfflineOrder.append(model)
            }else{
                arrIds.append("\(model.id ?? 0)")
            }
        }
        if arrIds.count > 0{
            dictParam["ids"] = AppCommonMethods.convertJsontoString(json: arrIds)
            WebServiceManager().requestAPI(params: dictParam, urlString: (isArchived == 1) ? AppConstants.APIURL.kUnrchiveOrders : AppConstants.APIURL.kArchiveOrders, method: "POST") { (message, result) in
                DispatchQueue.main.async {
                    if let response = result as? [NSDictionary]{
                        let jsonDecoder = JSONDecoder()
                        if let data = AppCommonMethods.convertToJson(object: response), let _ = try? jsonDecoder.decode([OrderModel].self, from: data){
                            for id in arrIds{
                                _ = SQLiteManage.ExecuteQuery("UPDATE Orders SET is_update = 0 WHERE id = \(id)")
                            }
                        }
                    }
                    if arrOfflineOrder.count > 0{
                        BGAPIExecution.shared.allDataPushed = {
                            DispatchQueue.main.async {
                                AppCommonMethods.stopProgressBar()
                                self.SortOrderData()
                                self.isArchievedSelected = false
                                self.arrSelectedOrders.removeAll()
                                self.viewForArchieved.isHidden = true
                            }
                        }
                        BGAPIExecution.shared.AddOrdersToQueue(arr: arrOfflineOrder)
                    }else{
                        AppCommonMethods.stopProgressBar()
                        self.SortOrderData()
                        self.isArchievedSelected = false
                        self.arrSelectedOrders.removeAll()
                        self.viewForArchieved.isHidden = true
                    }
                    self.arrSelectedOrders.removeAll()
                }
            }
        }
    }
}

//MARK:  UICollectionViewDataSource
extension OrderHistoryVC: UICollectionViewDelegate, UICollectionViewDataSource, UICollectionViewDelegateFlowLayout{
    func numberOfSections(in collectionView: UICollectionView) -> Int {
        return arrOrderDate.count
    }
    
    func collectionView(_ collectionView: UICollectionView, numberOfItemsInSection section: Int) -> Int {
        if let arr = (isSearchEnabled ? dictSearchOrders : dictOrders)[arrOrderDate[section]]{
            if arr.count > 0{
                return arr.count+1
            }
        }
        return 0
    }
    
    func collectionView(_ collectionView: UICollectionView, cellForItemAt indexPath: IndexPath) -> UICollectionViewCell {
        if indexPath.row == 0{
            let cell = collectionView.dequeueReusableCell(withReuseIdentifier: "ProductHeaderCollectionCell", for: indexPath) as! ProductHeaderCollectionCell
            cell.lblTitle.text = arrOrderDate[indexPath.section]
            return cell
        }
        if let arr = (isSearchEnabled ? dictSearchOrders : dictOrders)[arrOrderDate[indexPath.section]] as? [OrderModel]{
            let model = arr[indexPath.row-1]
            let isContain = arrSelectedOrders.contains { (order) -> Bool in
                return model.id ?? 0 == order.id ?? 0
            }
            if model.orderStatusId ?? 0 == 1 || model.orderStatusId ?? 0 == 2 || model.orderStatusId ?? 0 == 12 || model.orderStatusId ?? 0 == 13 || model.orderStatusId ?? 0 == 14 || model.orderStatusId ?? 0 == 4 || model.orderStatusId ?? 0 == 7 || model.orderStatusId ?? 0 == 6{
                let cell = collectionView.dequeueReusableCell(withReuseIdentifier: "OrderViewCell", for: indexPath) as! OrderViewCell
                cell.lblMainStatus.numberOfLines = 2
                cell.lblUserName.text = model.customer?.name ?? ""
                cell.lblMainStatus.text = "#\(model.displayOrderId)\n\(model.orderType ?? "")"
                if let date = model.createdDate{
                    cell.startTimer(createdDate: date, theme: "theme2")
                }
                cell.constOrderStatusHeight.constant = 46
                if isArchievedSelected{
                    cell.constOrderTopSpace.constant = 40
                    cell.btnSelect.isHidden = false
                    if isContain{
                        cell.btnSelect.isSelected = true
                    }else{
                        cell.btnSelect.isSelected = false
                    }
                }else{
                    cell.btnSelect.isHidden = true
                    cell.constOrderTopSpace.constant = 10
                }
                var strAction = "Pay order"
                if model.totalPaid ?? 0 >= (model.total ?? 0) && model.total ?? 0 > 0{
                    if model.orderTypeId ?? 0 == 3{
                        if model.orderStatusId ?? 0 != 6 && AppCommonMethods.fetchSiteSettingValue(key: "is_on_the_way") ?? "" == "true"{
                            strAction = "On the way"
                        }else{
                            strAction = "Mark as delivered"
                        }
                    }else if model.orderTypeId ?? 0 == 2{
                        if model.orderStatusId ?? 0 != 6 && AppCommonMethods.fetchSiteSettingValue(key: "is_ready_to_collect") ?? "" == "true"{
                            strAction = "Ready to collect"
                        }else{
                            strAction = "Mark as collected"
                        }
                    }else{
                        strAction = "Mark as served"
                    }
                    cell.lblPaid.text = "Paid"
                    cell.lblPaid.textColor = AppConstants.Colors.kAppMediumGreenColor
                }else if model.totalPaid ?? 0 > 0{
                    cell.lblPaid.text = "Partial Paid"
                    cell.lblPaid.textColor = AppConstants.Colors.kAppThemeRedColor
                }else{
                    cell.lblPaid.text = "Unpaid"
                    cell.lblPaid.textColor = AppConstants.Colors.kAppThemeRedColor
                }
                if let status = model.orderStatus{
                    cell.viewForBG.backgroundColor = UIColor.hexStr(hexStr: status.topColor ?? "", alpha: 1.0)
                }else{
                    cell.viewForBG.backgroundColor = AppConstants.Colors.kAppMediumGreenColor
                }
                cell.lblMainStatus.textColor = .white
                cell.lblUserName.textColor = .white
                cell.lblStatus.superview?.isHidden = true
                cell.btnView.accessibilityIdentifier = "\(indexPath.section)"
                cell.btnView.tag = indexPath.row-1
                cell.btnView.setTitle(strAction, for: .normal)
                cell.lblPaid.transform = CGAffineTransform(rotationAngle: CGFloat.pi / 2)
                return cell
            }else{
                let cell = collectionView.dequeueReusableCell(withReuseIdentifier: "CompletedOrderViewCell", for: indexPath) as! OrderViewCell
                cell.lblUserName.text = model.customer?.name ?? ""
                cell.lblMainStatus.numberOfLines = 2
                cell.lblMainStatus.text = "#\(model.displayOrderId)\n\(model.orderType ?? "")"
                cell.constOrderStatusHeight.constant = 46
                if isArchievedSelected{
                    cell.constOrderTopSpace.constant = 40
                    cell.btnSelect.isHidden = false
                    if isContain{
                        cell.btnSelect.isSelected = true
                    }else{
                        cell.btnSelect.isSelected = false
                    }
                }else{
                    cell.btnSelect.isHidden = true
                    cell.constOrderTopSpace.constant = 10
                }
                if model.orderStatusId ?? 0 == 10{
                    cell.lblStatus.text = "Cancelled"
                    cell.lblStatus.textColor = AppConstants.Colors.kAppThemeRedColor
                    cell.imgStatus.image = UIImage.init(named: "ic_close_red")
                }else{
                    cell.lblStatus.textColor = AppConstants.Colors.kAppMediumGreenColor
                    if model.orderTypeId ?? 0 == 3{
                        cell.lblStatus.text = "Delivered"
                    }else if model.orderTypeId ?? 0 == 2{
                        cell.lblStatus.text = "Collected"
                    }else{
                        cell.lblStatus.text = "Served"
                    }
                    cell.imgStatus.image = UIImage.init(named: "ic_selected_green")
                }
                if let status = model.orderStatus{
                    cell.viewForBG.backgroundColor = UIColor.hexStr(hexStr: status.topColor ?? "", alpha: 1.0)
                    cell.imgStatus.imageColor = .white
                    cell.lblStatus.textColor = .white
                    cell.imgStatus.imageColor = .white
                    cell.lblMainStatus.textColor = .white
                    cell.lblUserName.textColor = .white
                }else{
                    cell.viewForBG.backgroundColor = AppConstants.Colors.kAppThemeBGColor
                }
                return cell
            }
        }
        if let arr = (isSearchEnabled ? dictSearchOrders : dictOrders)[arrOrderDate[indexPath.section]] as? [WebOrderModel]{
            let model = arr[indexPath.row-1]
            var isDelayed = false
            if model.status ?? "" == "Accpeted"{
                if let time = model.preparation, let preparation = time.getDateFromString(format: "hh:mm a"){
                    let current = Date().getDateInString(format: "hh:mm a").getDateFromString(format: "hh:mm a") ?? Date()
                    if preparation <= current{
                        isDelayed = true
                    }
                }
            }
            let cell = collectionView.dequeueReusableCell(withReuseIdentifier: isDelayed ? "DelayedOrderViewCell" : "OrderViewCell", for: indexPath) as! OrderViewCell
            cell.btnView.tag = indexPath.row-1
            cell.btnView.accessibilityIdentifier = "\(indexPath.section)"
            cell.lblTime?.isHidden = true
            cell.lblUserName.text = model.customerName ?? ""
            if model.paymentStatus ?? "" == "P"{
                cell.lblPaid.text = "Paid"
                cell.lblPaid.textColor = AppConstants.Colors.kAppMediumGreenColor
            }else{
                cell.lblPaid.text = "Unpaid"
                cell.lblPaid.textColor = AppConstants.Colors.kAppThemeRedColor
            }
            cell.lblPaid.transform = CGAffineTransform(rotationAngle: CGFloat.pi / 2)
            cell.lblMainStatus.text = model.displayOrderType
            var strStatus = "Tap to view"
            cell.btnView.isHidden = false
            if !isDelayed{
                cell.lblStatus.superview?.isHidden = true
                cell.viewForBG.backgroundColor = AppConstants.Colors.kAppThemeBGColor
                cell.lblMainStatus.textColor = AppConstants.Colors.kAppThemeTextColor
                cell.lblUserName.textColor = AppConstants.Colors.kAppThemeTextColor
            }
            if model.status ?? "" == "Pending"{
                if (model.orderType ?? "").lowercased() == "delivery"{
                    cell.viewForBG.backgroundColor = AppConstants.Colors.kAppDarkGreenColor
                }else if (model.orderType ?? "").lowercased() == "pickup"{
                    cell.viewForBG.backgroundColor = AppConstants.Colors.kAppThemeBlueColor
                }else if (model.orderType ?? "").lowercased() == "dine in"{
                    cell.viewForBG.backgroundColor = AppConstants.Colors.kAppThemeYellowColor
                }
                var cDate = ""
                if (model.orderType ?? "").lowercased() == "dine in"{
                    cDate = ((model.created ?? "").components(separatedBy: ".").first ?? "").changeDateFormat(fromFormat: "yyyy-MM-dd'T'HH:mm:ss", toFormat: "yyyy-MM-dd") ?? ""
                }else{
                    cDate = (model.deliveryDate ?? "").components(separatedBy: "T").first ?? ""
                }
                if let date = cDate.getDateFromString(format: "yyyy-MM-dd", locale: nil){
                    let currentDate = Date().getDateInString(format: "yyyy-MM-dd").getDateFromString(format: "yyyy-MM-dd", locale: nil)!
                    if date > currentDate{
                        cell.viewForBG.backgroundColor = AppConstants.Colors.kAppThemeMediumRedColor
                        cell.lblMainStatus.text = "Preorder - \(model.displayOrderType)"
                    }
                }
                cell.lblMainStatus.textColor = .white
                cell.lblUserName.textColor = .white
            }else if model.status ?? "" == "Accpeted"{
                if isDelayed{
                    cell.lblUserName.textColor = .white
                    cell.lblMainStatus.textColor = .white
                }
                if (model.orderType ?? "").lowercased() == "delivery"{
                    strStatus = "Mark as delivered"
                }else if (model.orderType ?? "").lowercased() == "pickup"{
                    strStatus = "Mark as collected"
                }else if (model.orderType ?? "").lowercased() == "dine in"{
                    strStatus = "Ready to serve"
                }
            }else{
                cell.lblStatus.superview?.isHidden = false
                cell.imgStatus.image  = UIImage.init(named: (model.status ?? "" == "Delivered") ? "ic_selected_green" : "ic_close_red")
                cell.lblStatus.textColor = (model.status ?? "" == "Delivered") ? AppConstants.Colors.kAppDarkGreenColor : AppConstants.Colors.kAppThemeRedColor
                cell.imgStatus.imageColor = (model.status ?? "" == "Delivered") ? AppConstants.Colors.kAppDarkGreenColor : AppConstants.Colors.kAppThemeRedColor
                if (model.orderType ?? "").lowercased() == "delivery"{
                    cell.lblStatus.text = (model.status ?? "" == "Delivered") ? "Delivered" : "Rejected"
                }else if (model.orderType ?? "").lowercased() == "pickup"{
                    cell.lblStatus.text = (model.status ?? "" == "Delivered") ? "Collected" : "Rejected"
                }else if (model.orderType ?? "").lowercased() == "dine in"{
                    cell.lblStatus.text = (model.status ?? "" == "Delivered") ? "Served" : "Rejected"
                }else{
                    cell.lblStatus.text = ""
                }
                cell.btnView.isHidden = true
                
                cell.viewForBG.backgroundColor = AppConstants.Colors.kAppThemeBGColor
                cell.lblMainStatus.textColor = AppConstants.Colors.kAppThemeTextColor
                cell.lblUserName.textColor = AppConstants.Colors.kAppThemeTextColor
                cell.btnView.isHidden = true
            }
            cell.btnView.setTitle(strStatus, for: .normal)
            return cell
        }
        
        return UICollectionViewCell()
    }
    
    func collectionView(_ collectionView: UICollectionView, didSelectItemAt indexPath: IndexPath) {
        if indexPath.row == 0{
            return
        }
        self.view.endEditing(true)
        if isWebOrder{
            if let arr = (isSearchEnabled ? dictSearchOrders : dictOrders)[arrOrderDate[indexPath.section]] as? [WebOrderModel]{
                let model = arr[indexPath.row-1]
                if let VC = OrderDetailVC.addToParentView(parentVC: self.parentVC, orderId: model.id ?? 0, orderType: model.orderType ?? ""){
                    VC.delegate = self
                }
            }
        }else{
            if isArchived == 1{
                if isArchievedSelected{
                    let order = (isSearchEnabled ? dictSearchOrders : dictOrders)[arrOrderDate[indexPath.section]]![indexPath.row-1] as! OrderModel
                    let index = arrSelectedOrders.firstIndex(where: { (model) -> Bool in
                        return model.id ?? 0 == order.id ?? 0
                    })
                    if index != nil{
                        arrSelectedOrders.remove(at: index!)
                    }else{
                        arrSelectedOrders.append(order)
                    }
                    collectionOrders.reloadData()
                    lblSelectedOrders.text = "\(arrSelectedOrders.count) orders selected"
                }
            }else{
                if isArchievedSelected{
                    if isArchievedSelected{
                        let order = (isSearchEnabled ? dictSearchOrders : dictOrders)[arrOrderDate[indexPath.section]]![indexPath.row-1] as! OrderModel
                        let index = arrSelectedOrders.firstIndex(where: { (model) -> Bool in
                            return model.id ?? 0 == order.id ?? 0
                        })
                        if index != nil{
                            arrSelectedOrders.remove(at: index!)
                        }else{
                            arrSelectedOrders.append(order)
                        }
                        collectionOrders.reloadData()
                        lblSelectedOrders.text = "\(arrSelectedOrders.count) orders selected"
                    }
                }else{
                    if let arr = (isSearchEnabled ? dictSearchOrders : dictOrders)[arrOrderDate[indexPath.section]] as? [OrderModel]{
                        let aData = arr[indexPath.row-1]
                        if aData.orderStatusId ?? 0 == 10 || aData.orderStatusId ?? 0 == 5{
                            if let VC = OrderDetailVC.addToParentView(parentVC: self.parentVC, orderId: aData.id ?? 0, orderType: "", orderData: aData){
                                VC.delegate = self
                            }
                        }else{
                            if aData.table?.locked ?? false{
                                AppCommonMethods.showToastAlert(message: AppConstants.GlobalAlert.ALERT_TABLE_BUSY)
                                return
                            }
                            if let VC = CreateOrderVC.instance(){
                                VC.orderId = aData.id ?? 0
                                let orderType = OrderTypesModel.init()
                                orderType.id = aData.orderTypeId
                                orderType.type = aData.orderType
                                VC.orderData = aData
                                VC.orderType = orderType
                                self.navigationController?.pushViewController(VC, animated: true)
                            }
                        }
                    }
                }
            }
        }
    }
    
    func collectionView(_ collectionView: UICollectionView, layout collectionViewLayout: UICollectionViewLayout, sizeForItemAt indexPath: IndexPath) -> CGSize {
        if indexPath.row == 0{
            return CGSize.init(width: self.view.frame.width-28, height: 40)
        }
        if isArchievedSelected{
            return CGSize.init(width: equalCellWidth(), height: isWebOrder ? 175 : 205)
        }else{
            return CGSize.init(width: equalCellWidth(), height: isWebOrder ? 145 : 175)
        }
    }
    
    func equalCellWidth()->CGFloat{
        let width = self.view.frame.width-28
        let cellWidth = width/round(width/250)
        return floor(cellWidth)
    }
}

//MARK:  AlertControllerDelegate
extension OrderHistoryVC:AlertControllerDelegate{
    func alertButtonAction(index: Int, data: alertViewData, type: AlertType) {
        if index == 1{
            for model in arrSelectedOrders{
                _ = SQLiteManage.ExecuteQuery("UPDATE Orders SET is_archived = \((isArchived  == 0) ? 1 : 0), is_update = 1 WHERE id = \(model.id ?? 0)")
            }
            if Reachabilities.shared.isConnectedToNetwork() && AppConstants.DataSyncMode == "Auto"{
                ArchieveOrders()
            }else{
                isArchievedSelected = false
                arrSelectedOrders.removeAll()
                viewForArchieved.isHidden = true
                SortOrderData()
            }
        }
    }
}

//MARK:  UITextFieldDelegate
extension OrderHistoryVC:UITextFieldDelegate{
    func textFieldShouldBeginEditing(_ textField: UITextField) -> Bool {
        if textField == txtToDate{
            let datePicker = ActionSheetDatePicker(title: "Select Date", datePickerMode: UIDatePicker.Mode.date, selectedDate: toDate, doneBlock: {
                picker, value, index in
                self.toDate = (value as! Date)
                if self.fromDate > self.toDate{
                    self.fromDate = self.toDate
                }
                self.txtToDate.text = "To - \(self.toDate.getDateInString(format: "dd/MM/yyyy"))"
                self.txtFromDate.text = "From - \(self.fromDate.getDateInString(format: "dd/MM/yyyy"))"
                if self.isWebOrder{
                    self.GetOnlineOrders()
                }else{
                    self.SortOrderData()
                }
            }, cancel: { ActionStringCancelBlock in return }, origin: textField)
            datePicker?.minimumDate = self.fromDate
            datePicker?.show()
            return false
        }else{
            let datePicker = ActionSheetDatePicker(title: "Select Date", datePickerMode: UIDatePicker.Mode.date, selectedDate: fromDate, doneBlock: {
                picker, value, index in
                self.fromDate = (value as! Date)
                if self.toDate < self.fromDate{
                    self.toDate = self.fromDate
                }
                self.txtToDate.text = "To - \(self.toDate.getDateInString(format: "dd/MM/yyyy"))"
                self.txtFromDate.text = "From - \(self.fromDate.getDateInString(format: "dd/MM/yyyy"))"
                if self.isWebOrder{
                    self.GetOnlineOrders()
                }else{
                    self.SortOrderData()
                }
            }, cancel: { ActionStringCancelBlock in return }, origin: textField)
            datePicker?.maximumDate = self.toDate
            datePicker?.show()
            return false
        }
    }
}

extension OrderHistoryVC:pageRefreshDelegate{
    func pageNeedToRefresh() {
        if isWebOrder{
            self.GetOnlineOrders()
        }else{
            self.SortOrderData()
        }
    }
}
