//
//  OrderDetailVC.swift
//  TiffinTomPartner
//
//  Created by Tushar Premal on 29/10/20.
//

import UIKit

class SurchargeCell: UITableViewCell {
    
    @IBOutlet weak var lblName:UILabel!
    @IBOutlet weak var lblPrice:UILabel!
    
}

class OrderDetailVC: UIViewController {
    
    //MARK: IBOutlet
    @IBOutlet weak var txtPersonalDetail:UITextView!
    @IBOutlet weak var txtInstruction:UITextView!
    @IBOutlet weak var lblOrderTime:UILabel!
    @IBOutlet weak var lblOrderType:UILabel!
    @IBOutlet weak var lblDistance:UILabel!
    @IBOutlet weak var viewForDistance:UIView!
    @IBOutlet weak var tblCarts:UITableView!
    @IBOutlet weak var viewForOrderInstructions:UIView!
    @IBOutlet weak var btnAccept:UIButton!
    @IBOutlet weak var lblRejectReason:UILabel!
    @IBOutlet weak var btnReject:UIButton!
    @IBOutlet weak var btnStatus:UIButton!
    @IBOutlet weak var btnDelayOrder:UIButton!
    @IBOutlet weak var btnReadyToCollect:UIButton!
    @IBOutlet weak var btnSetReminder:UIButton!
    @IBOutlet weak var btnPrint:UIButton!
    @IBOutlet weak var btnCancelOrder:UIButton!
    @IBOutlet weak var btnDeleteOrder:UIButton!
    @IBOutlet weak var constPersonalDetailHegiht:NSLayoutConstraint!
    
    //MARK: Instances
    var isOrderShowMoreSelected = false
    var isDeliveryShowMoreSelected = false
    var orderDetails:Any!
    var arrCarts = [Any]()
    var preOrderDate:String?
    var orderId = 0
    var isFromNotification = false
    var orderType = ""
    var parentVC:SideMenuVC!
    weak var delegate:pageRefreshDelegate?
    var isForOrderDelete = false
    
    //MARK: ViewController LifeCycle
    override func viewDidLoad() {
        super.viewDidLoad()
        
        // Do any additional setup after loading the view.
        if let _ = orderDetails as? OrderModel{
            self.setOrderDataFromDetails()
        }else{
            CallGetOrderDetailAPI()
        }
        NotificationCenter.default.addObserver(self, selector: #selector(orderPushedToSocket), name: AppConstants.notifications.kDatabasePushed, object: nil)
    }
    
    override func viewDidLayoutSubviews() {
        DispatchQueue.main.async{
            self.constPersonalDetailHegiht.constant = self.txtPersonalDetail.contentSize.height
        }
    }
    
    //MARK: create viewcontroller instance
    static func addToParentView(parentVC:SideMenuVC,orderId:Int,orderType:String,orderData:OrderModel? = nil)->OrderDetailVC?{
        guard let VC = UIStoryboard.init(name: "Orders", bundle: nil).instantiateViewController(withIdentifier: "OrderDetailVC") as? OrderDetailVC else {
            return nil
        }
        VC.orderId = orderId
        VC.orderType = orderType
        VC.parentVC = parentVC
        VC.orderDetails = orderData
        parentVC.addChild(VC)
        parentVC.viewForContainer.addSubview(VC.view)
        VC.view.frame = CGRect.init(x: 0, y: 0, width: parentVC.viewForContainer.frame.width, height: parentVC.viewForContainer.frame.height)
        return VC
    }
    
    //MARK: General Methods
    @objc func orderPushedToSocket(){
        if let detail = self.orderDetails as? OrderModel{
            if let order = SQLiteManage.fetchOrderDataByUniqueId(orderId: detail.uniqueId){
                self.orderDetails = order
                self.setOrderDataFromDetails()
            }
        }
    }
    
    func setOrderDataFromDetails(){
        viewForDistance.isHidden = true
        btnStatus.isHidden = true
        btnAccept.isHidden = true
        btnReject.isHidden = true
        btnReject.isHidden = true
        btnDeleteOrder.isHidden = true
        btnDelayOrder.isHidden = true
        btnReadyToCollect.superview?.isHidden = true
        
        if let detail = orderDetails as? WebOrderModel{
            var strPersonalDetail = ""
            var strTiming = ""
            strPersonalDetail = "Name: \(detail.customerName ?? "")"
            strPersonalDetail = "\(strPersonalDetail)\nMobile: \(detail.phone ?? "")"
            if (detail.orderType ?? "").lowercased() == "delivery"{
                if detail.distance ?? "" != ""{
                    viewForDistance.isHidden = false
                    lblDistance.text = "\(detail.distance ?? "") Away"
                }
                strPersonalDetail = "\(strPersonalDetail)\nDelivery address: \(detail.address ?? "")"
            }
            let created = (detail.created ?? "").components(separatedBy: ".").first ?? ""
            if let date = created.changeDateFormat(fromFormat: "yyyy-MM-dd'T'HH:mm:ss", toFormat: "HH:mm, dd-MM-yyyy"){
                strTiming = "Ordered at: \(date)"
            }
            if (detail.orderType ?? "").lowercased() == "dine in"{
                strPersonalDetail = "\(strPersonalDetail)\nGuests: \(detail.guestCount ?? 0)"
                strPersonalDetail = "\(strPersonalDetail)\nTable number: \(detail.tableNo ?? "")"
                strTiming = "\(strTiming)\nServe by: ASAP"
            }
            
            self.txtPersonalDetail.text = strPersonalDetail
            
            DispatchQueue.main.asyncAfter(deadline: .now()+0.1) {
                self.constPersonalDetailHegiht.constant = self.txtPersonalDetail.contentSize.height
            }
            
            let strPaid = (detail.paymentType ?? "" == "P") ? "Paid" : "Unpaid"
            self.lblOrderType.text = "\(detail.displayOrderType) - \(strPaid)"
            
            var cDate = ""
            if (detail.orderType ?? "").lowercased() == "dine in"{
                cDate = ((detail.created ?? "").components(separatedBy: ".").first ?? "").changeDateFormat(fromFormat: "yyyy-MM-dd'T'HH:mm:ss", toFormat: "yyyy-MM-dd hh:mm a") ?? ""
            }else{
                cDate = "\((detail.deliveryDate ?? "").components(separatedBy: "T").first ?? "") \(detail.deliveryTime ?? "")"
            }
            if let date = cDate.getDateFromString(format: "yyyy-MM-dd hh:mm a", locale: nil), detail.status ?? "" != "Delivered"{
                var strDate = "ASAP"
                if (detail.assoonas ?? "" != "now"){
                    strDate = date.getDateInString(format: "hh:mm a, dd-MM-yyyy")
                }
                
                if let time = detail.preparation, time != "", let preparation = "\(cDate) \(time)".getDateFromString(format: "hh:mm a"){
                    if preparation < Date(){
                        lblOrderTime.textColor = AppConstants.Colors.kAppThemeRedColor
                        if orderType.lowercased() == "delivery"{
                            strTiming = "\(strTiming)\nDelayed - Deliver by: \(strDate)"
                        }else if orderType.lowercased() == "pickup"{
                            strTiming = "\(strTiming)\nDelayed - Collect by: \(strDate)"
                        }
                    }else{
                        if orderType.lowercased() == "delivery"{
                            strTiming = "\(strTiming)\nDeliver by: \(strDate)"
                        }else if orderType.lowercased() == "collection"{
                            strTiming = "\(strTiming)\nCollect by: \(strDate)"
                        }
                    }
                }else{
                    if orderType.lowercased() == "delivery"{
                        strTiming = "\(strTiming)\nDeliver by: \(strDate)"
                    }else if orderType.lowercased() == "collection"{
                        strTiming = "\(strTiming)\nCollect by: \(strDate)"
                    }
                }
            }
            
            if (detail.orderType ?? "").lowercased() == "delivery"{
                self.lblOrderType.textColor = AppConstants.Colors.kAppDarkGreenColor
            }else if (detail.orderType ?? "").lowercased() == "pickup"{
                self.lblOrderType.textColor = AppConstants.Colors.kAppThemeBlueColor
            }else if (detail.orderType ?? "").lowercased() == "dine in"{
                self.lblOrderType.textColor = AppConstants.Colors.kAppThemeYellowColor
            }
            
            if detail.preparation ?? "" != ""{
                if detail.status ?? "" == "Accepted"{
                    strTiming = "\(strTiming)\nPreparation time: \((detail.preparation ?? "").changeDateFormat(fromFormat: "hh:mm a", toFormat: "HH:mm") ?? "")"
                }else{
                    if orderType.lowercased() == "delivery"{
                        strTiming = "\(strTiming)\nDelivered at: \((detail.preparation ?? "").changeDateFormat(fromFormat: "hh:mm a", toFormat: "HH:mm") ?? "")"
                    }else if orderType.lowercased() == "collection"{
                        strTiming = "\(strTiming)\nCollected at: \((detail.preparation ?? "").changeDateFormat(fromFormat: "hh:mm a", toFormat: "HH:mm") ?? "")"
                    }else{
                        strTiming = "\(strTiming)\nServed at: \((detail.preparation ?? "").changeDateFormat(fromFormat: "hh:mm a", toFormat: "HH:mm") ?? "")"
                    }
                }
            }
            
            if AppConstants.selectedPrinter == nil || (detail.status ?? "") == "Pending"{
                self.btnPrint.isHidden = true
            }else{
                self.btnPrint.isHidden = false
            }
            
            if detail.status ?? "" == "Pending"{
                btnAccept.isHidden = false
                btnReject.isHidden = false
                if let strDate = detail.deliveryDate{
                    let cDate = strDate.components(separatedBy: "T").first ?? ""
                    if let date = cDate.getDateFromString(format: "yyyy-MM-dd", locale: nil){
                        let currentDate = Date().getDateInString(format: "yyyy-MM-dd").getDateFromString(format: "yyyy-MM-dd", locale: nil)!
                        if date > currentDate{
                            self.preOrderDate = date.getDateInString(format: "dd/MM/yy")
                            self.lblOrderType.text = "Preorder for \(date.getDateInString(format: "dd/MM/yyyy")) - \(orderType)\n\(strPaid)"
                            self.lblOrderType.textColor = AppConstants.Colors.kAppThemeRedColor
                            btnSetReminder.isHidden = false
                            if let arrReminder = AppCommonMethods.readObjfromUserDefault(withKey: AppConstants.userDefaultKey.kReminderData) as? [NSDictionary]{
                                let dictReminder = arrReminder.first { (dict) -> Bool in
                                    return dict.getIntValue("orderId") ?? 0 == detail.id ?? 0
                                }
                                if dictReminder != nil{
                                    strTiming = "\(strTiming)\nReminder: \(dictReminder?.getStringValue("date") ?? "")"
                                }
                            }
                        }
                    }
                }
            }else if detail.status ?? "" == "Accepted"{
                btnStatus.isHidden = false
                if orderType.lowercased() == "dine in"{
                    btnStatus.setTitle("Ready to serve", for: .normal)
                }else{
                    btnDelayOrder.isHidden = false
                    if (detail.orderType ?? "").lowercased() == "delivery"{
                        btnStatus.setTitle("Mark as delivered", for: .normal)
                        btnReadyToCollect.setTitle("On the way", for: .normal)
                        if AppCommonMethods.fetchSiteSettingValue(key: "is_on_the_way") ?? "" == "true"{
                            btnReadyToCollect.superview?.isHidden = false
                        }
                    }else if (detail.orderType ?? "").lowercased() == "pickup"{
                        btnStatus.setTitle("Mark as collected", for: .normal)
                        btnReadyToCollect.setTitle("Ready to collect", for: .normal)
                        if AppCommonMethods.fetchSiteSettingValue(key: "is_ready_to_collect") ?? "" == "true"{
                            btnReadyToCollect.superview?.isHidden = false
                        }
                    }
                }
            }
            
            self.lblOrderTime.text = strTiming
            if detail.failedReason ?? "" != ""{
                self.lblRejectReason.isHidden = false
                self.lblRejectReason.text = "Reason for rejection: \(detail.failedReason ?? "")"
            }else{
                self.lblRejectReason.isHidden = true
            }
            
            if detail.orderInstruction ?? "" != ""{
                viewForOrderInstructions.isHidden = false
                txtInstruction.text = detail.orderInstruction ?? ""
            }
        }else if let detail = orderDetails as? OrderModel{
            if (AppCommonMethods.fetchSiteSettingValue(key: "is_printbill") ?? "" == "true" && AppConstants.userData?.permissions?.printBill?.actions?.list ?? 0 == 1) || (AppCommonMethods.fetchSiteSettingValue(key: "is_printall") ?? "" == "true" && AppConstants.userData?.permissions?.printAll?.actions?.list ?? 0 == 1){
                btnPrint.isHidden = false
            }else{
                btnPrint.isHidden = true
            }
            lblOrderType.text = "Order #\(detail.displayOrderId)\n\(detail.orderStatus?.status ?? "")"
            var customer = ""
            if detail.customer?.name ?? "" != ""{
                customer = "Name: \(detail.customer?.name ?? "")"
            }
            if detail.customer?.email ?? "" != ""{
                if customer != ""{
                    customer = "\(customer)\nEmail: \(detail.customer?.email ?? "")"
                }else{
                    customer = "Email: \(detail.customer?.email ?? "")"
                }
            }
            if detail.customer?.mobile ?? "" != ""{
                if customer != ""{
                    customer = "\(customer)\nMobile: \(detail.customer?.mobile ?? "")"
                }else{
                    customer = "Mobile: \(detail.customer?.mobile ?? "")"
                }
            }
            if detail.orderTypeId ?? 0 == 3{
                var strCustomerInfo = detail.customer?.houseNo ?? ""
                if strCustomerInfo == ""{
                    strCustomerInfo = detail.customer?.street ?? ""
                }else{
                    strCustomerInfo = "\(strCustomerInfo), \(detail.customer?.street ?? "")"
                }
                if strCustomerInfo == ""{
                    strCustomerInfo = detail.customer?.postcode ?? ""
                }else{
                    strCustomerInfo = "\(strCustomerInfo), \(detail.customer?.postcode ?? "")"
                }
                if strCustomerInfo == ""{
                    strCustomerInfo = detail.customer?.city ?? ""
                }else{
                    strCustomerInfo = "\(strCustomerInfo), \(detail.customer?.city ?? "")"
                }
                if strCustomerInfo != ""{
                    if customer != ""{
                        customer = "\(customer)\nAddress: \(strCustomerInfo)"
                    }else{
                        customer = "Address: \(strCustomerInfo)"
                    }
                }
            }
            self.txtPersonalDetail.text = customer
            self.lblOrderTime.text = "Ordered at: \(detail.deliveryDate ?? "")"
            btnCancelOrder.isHidden = false
            if detail.orderStatusId ?? 0 == 10{
                btnCancelOrder.isHidden = true
            }
            if AppConstants.userData?.permissions?.deleteOrder?.actions?.list ?? 0 == 1{
                btnDeleteOrder.isHidden = false
            }
            if AppConstants.userData?.permissions?.cancelOrderAfterPayment?.actions?.list ?? 0 == 0{
                btnCancelOrder.isHidden = true
            }
            self.arrCarts = detail.arrProducts
            self.tblCarts.reloadData()
        }
        
    }
    
    func printBillAction(){
        var payBillAction = "pay_bill_action"
        if let order = orderDetails as? OrderModel{
            if order.orderTypeId ?? 0 == 2{
                payBillAction = "pickup_pay_bill_action"
            }else if order.orderTypeId ?? 0 == 5{
                payBillAction = "waiting_pay_bill_action"
            }else if order.orderTypeId ?? 0 == 3{
                payBillAction = "delivery_pay_bill_action"
            }
        }
        if AppCommonMethods.fetchSiteSettingValue(key: payBillAction) ?? "" == "prep_ticket"{
            if AppCommonMethods.fetchSiteSettingValue(key: "kitchen_copy_type") ?? "" == "manual"{
                AppValidation().showAlertView(parentVC: self, withAlertTile: nil, withAlertMsg: AppConstants.GlobalAlert.ALERT_KITCHEN_COPY, withActionsTitle: [AppConstants.GlobalAlert.ALERT_BTN_NO,AppConstants.GlobalAlert.ALERT_BTN_YES]) { (index) in
                    if index == 1{
                        PrintManager.shared.connectToPrinterWithPrintOrder(order: self.orderDetails as! OrderModel, controller: self)
                    }
                }
            }else{
                PrintManager.shared.connectToPrinterWithPrintOrder(order: self.orderDetails as! OrderModel, controller: self)
            }
        }else if AppCommonMethods.fetchSiteSettingValue(key: payBillAction) ?? "" == "both"{
            printAllAction()
        }else if AppCommonMethods.fetchSiteSettingValue(key: payBillAction) ?? "" == "bill"{
            if AppCommonMethods.fetchSiteSettingValue(key: "pay_bill_action_type") ?? "" == "manual"{
                AppValidation().showAlertView(parentVC: self, withAlertTile: nil, withAlertMsg: AppConstants.GlobalAlert.ALERT_ORDER_BILL, withActionsTitle: [AppConstants.GlobalAlert.ALERT_BTN_NO,AppConstants.GlobalAlert.ALERT_BTN_YES]) { (index) in
                    if index == 1{
                        PrintManager.shared.isSplitBillCopy = false
                        PrintManager.shared.isPrintingBill = true
                        PrintManager.shared.connectToPrinterWithPrint(model: self.orderDetails as! OrderModel, controller: self)
                    }
                }
            }else{
                PrintManager.shared.isSplitBillCopy = false
                PrintManager.shared.isPrintingBill = true
                PrintManager.shared.connectToPrinterWithPrint(model: self.orderDetails as! OrderModel, controller: self)
            }
        }
    }
    
    func printAllAction(){
        if AppCommonMethods.fetchSiteSettingValue(key: "pay_bill_action_type") ?? "" == "manual"{
            AppValidation().showAlertView(parentVC: self, withAlertTile: nil, withAlertMsg: AppConstants.GlobalAlert.ALERT_ORDER_BILL, withActionsTitle: [AppConstants.GlobalAlert.ALERT_BTN_NO,AppConstants.GlobalAlert.ALERT_BTN_YES]) { (index) in
                var isBill = false
                if index == 1{
                    isBill = true
                }
                AppValidation().showAlertView(parentVC: self, withAlertTile: nil, withAlertMsg: AppConstants.GlobalAlert.ALERT_KITCHEN_COPY, withActionsTitle: [AppConstants.GlobalAlert.ALERT_BTN_NO,AppConstants.GlobalAlert.ALERT_BTN_YES]) { (index2) in
                    if index2 == 1{
                        if isBill{
                            PrintManager.shared.connectToPrinterWithPrintOrder(order: self.orderDetails as! OrderModel, controller: self, isPrintAll: true)
                        }else{
                            PrintManager.shared.connectToPrinterWithPrintOrder(order: self.orderDetails as! OrderModel, controller: self)
                        }
                    }else{
                        if isBill{
                            PrintManager.shared.isSplitBillCopy = false
                            PrintManager.shared.isPrintingBill = true
                            PrintManager.shared.connectToPrinterWithPrint(model: self.orderDetails as! OrderModel, controller: self)
                        }
                    }
                }
            }
        }else{
            if AppCommonMethods.fetchSiteSettingValue(key: "kitchen_copy_type") ?? "" == "manual"{
                AppValidation().showAlertView(parentVC: self, withAlertTile: nil, withAlertMsg: AppConstants.GlobalAlert.ALERT_KITCHEN_COPY, withActionsTitle: [AppConstants.GlobalAlert.ALERT_BTN_NO,AppConstants.GlobalAlert.ALERT_BTN_YES]) { (index) in
                    if index == 1{
                        PrintManager.shared.connectToPrinterWithPrintOrder(order: self.orderDetails as! OrderModel, controller: self)
                    }
                }
            }else{
                PrintManager.shared.connectToPrinterWithPrintOrder(order: self.orderDetails as! OrderModel, controller: self, isPrintAll: true)
            }
        }
    }
    
    //MARK: Button Actions
    @IBAction func btnBackAction(_ sender:UIButton){
        if self.delegate != nil{
            self.delegate?.pageNeedToRefresh()
        }
        self.view.removeFromSuperview()
        self.removeFromParent()
    }
    
    @IBAction func btnPrintAction(_ sender:UIButton){
        if let _ = orderDetails as? OrderModel{
            self.printBillAction()
        }else{
            if AppCommonMethods.fetchSiteSettingValue(key: "kitchen_copy_type") ?? "" == "auto"{
                PrintManager.shared.shouldPrintKitchenCopy = true
                PrintManager.shared.orderType = (self.orderDetails as! WebOrderModel).orderType ?? ""
                PrintManager.shared.connectToPrinterWithPrint(model: self.orderDetails!, controller: self)
            }else{
                AppValidation().showAlertView(parentVC: self, withAlertTile: nil, withAlertMsg: AppConstants.GlobalAlert.ALERT_KITCHEN_COPY, withActionsTitle: [AppConstants.GlobalAlert.ALERT_BTN_NO,AppConstants.GlobalAlert.ALERT_BTN_YES]) { (index) in
                    if index == 1{
                        PrintManager.shared.shouldPrintKitchenCopy = true
                    }else{
                        PrintManager.shared.shouldPrintKitchenCopy = false
                    }
                    PrintManager.shared.orderType = (self.orderDetails as! WebOrderModel).orderType ?? ""
                    PrintManager.shared.connectToPrinterWithPrint(model: self.orderDetails!, controller: self)
                }
            }
        }
    }
    
    @IBAction func btnSetReminderAction(_ sender:UIButton){
        if let VC = SetReminderVC.instance(orderDetail: self.orderDetails as! WebOrderModel, parentVC: self.parentVC){
            VC.delegate = self
        }
    }
    
    @IBAction func btnAcceptAction(_ sender:UIButton){
        let date = ((orderDetails as! WebOrderModel).created ?? "").components(separatedBy: "T").first ?? ""
        if ((orderDetails as! WebOrderModel).orderType ?? "").lowercased() == "delivery"{
            CallGetTimeSlotAPI(isPickupSlot: false, deliveryDate: date.changeDateFormat(fromFormat: "yyyy-MM-dd", toFormat: "dd-MM-yyyy") ?? Date().getDateInString(format: "dd-MM-yyyy"), isDelayTime: false)
        }else if ((orderDetails as! WebOrderModel).orderType ?? "").lowercased() == "pickup"{
            CallGetTimeSlotAPI(isPickupSlot: true, deliveryDate: date.changeDateFormat(fromFormat: "yyyy-MM-dd", toFormat: "dd-MM-yyyy") ?? Date().getDateInString(format: "dd-MM-yyyy"), isDelayTime: false)
        }else{
            CallSetOrderStatusAPI(status: "Accepted")
        }
    }
    
    @IBAction func btnDelayOrderAction(_ sender:UIButton){
        let date = ((orderDetails as! WebOrderModel).created ?? "").components(separatedBy: "T").first ?? ""
        if ((orderDetails as! WebOrderModel).orderType ?? "").lowercased() == "delivery"{
            CallGetTimeSlotAPI(isPickupSlot: false, deliveryDate: date.changeDateFormat(fromFormat: "yyyy-MM-dd", toFormat: "dd-MM-yyyy") ?? Date().getDateInString(format: "dd-MM-yyyy"), isDelayTime: true)
        }else if ((orderDetails as! WebOrderModel).orderType ?? "").lowercased() == "pickup"{
            CallGetTimeSlotAPI(isPickupSlot: true, deliveryDate: date.changeDateFormat(fromFormat: "yyyy-MM-dd", toFormat: "dd-MM-yyyy") ?? Date().getDateInString(format: "dd-MM-yyyy"), isDelayTime: true)
        }
    }
    
    @IBAction func btnDeliverAction(_ sender:UIButton){
        var settings = AlertSetting()
        if ((orderDetails as! WebOrderModel).orderType ?? "").lowercased() == "delivery"{
            settings.alertMessage = AppConstants.GlobalAlert.ALERT_MARK_ORDER_DELIVERED
            settings.alertTitle =  AppConstants.GlobalAlert.ALERT_DELIVERED_TITLE
        }else if ((orderDetails as! WebOrderModel).orderType ?? "").lowercased() == "pickup"{
            settings.alertMessage = AppConstants.GlobalAlert.ALERT_MARK_ORDER_COLLECTED
            settings.alertTitle =  AppConstants.GlobalAlert.ALERT_COLLECTED_TITLE
        }else{
            settings.alertMessage = AppConstants.GlobalAlert.ALERT_MARK_ORDER_RTS
            settings.alertTitle =  AppConstants.GlobalAlert.ALERT_RTS_TITLE
        }
        settings.type = .kDeliverOrder
        if let VC = AlertViewController.showPopup(parentVC: self.parentVC, setting: settings){
            VC.delegate = self
        }
    }
    
    @IBAction func btnRejectAction(_ sender:UIButton){
        if let VC = CancelReasonVC.showPopup(parentVC: self.parentVC){
            VC.delegate = self
        }
    }
    
    @IBAction func btnReadyToCollectAction(_ sender:UIButton){
        CallMarkAsReadyToCollectAPI()
    }
    
    @IBAction func btnCancelOrderAction(_ sender:UIButton){
        isForOrderDelete = false
        if AppCommonMethods.fetchSiteSettingValue(key: "cancel_order_password_enable") ?? "" == "true"{
            var setting = AlertSetting()
            setting.alertTitle = AppConstants.GlobalAlert.ALERT_ENTER_PASSWORD
            setting.alertMessage = AppConstants.GlobalAlert.ALERT_ENTER_PASSWORD_CANCELORDER
            setting.textPlcaeholder = "password"
            setting.type = .kEnterUserPassword
            setting.textType = .default
            if let VC = AlertViewController.showPopup(parentVC: self.parentVC, setting: setting){
                VC.delegate = self
            }
        }else{
            CallCreateOrderAPI(orderStatusId: 10)
        }
    }
    
    @IBAction func btnDeleteOrderAction(_ sender:UIButton){
        isForOrderDelete = true
        var setting = AlertSetting()
        setting.alertTitle = AppConstants.GlobalAlert.ALERT_ENTER_PASSWORD
        setting.alertMessage = AppConstants.GlobalAlert.ALERT_ENTER_PASSWORD_DELETEORDER
        setting.textPlcaeholder = "password"
        setting.type = .kEnterUserPassword
        setting.textType = .default
        if let VC = AlertViewController.showPopup(parentVC: self.parentVC, setting: setting){
            VC.delegate = self
        }
    }
    
    @IBAction func btnRefundPaymentAction(_ sender:UIButton){
        AppValidation().showAlertView(parentVC: self, withAlertTile: "Refund", withAlertMsg: "Are you sure want to refund this payment?", withActionsTitle: [AppConstants.GlobalAlert.ALERT_BTN_CANCEL,AppConstants.GlobalAlert.ALERT_CONFIRM_TITLE]) { (index) in
            if index == 1{
                if let detail = self.orderDetails as? OrderModel{
                    let payment = detail.arrOrderPayments[sender.tag]
                    if payment.paymentMethodId ?? 0 == 10 || payment.paymentMethodId ?? 0 == 9{
                        self.callRefundPament(index: sender.tag)
                    }else{
                        payment.isRefunded = 1
                        self.CallCreateOrderAPI(payments: detail.arrOrderPayments)
                    }
                }
            }
        }
    }
    
    //MARK: Webservice Methods
    func CallGetOrderDetailAPI(){
        let dictParam = [String:String]()
        var strURL = AppConstants.APIURL.kOnlineOrder
        if self.orderType.lowercased() == "dine in"{
            strURL = AppConstants.APIURL.kOnlineDineinOrder
        }
        AppCommonMethods.startProgressBar()
        WebServiceManager().requestAPI(params: dictParam,  urlString: "\(strURL)\(self.orderId)", method: "GET",isRestaurantAPI: true) { (message, result) in
            DispatchQueue.main.async {
                AppCommonMethods.stopProgressBar()
                let jsonDecoder = JSONDecoder()
                if let arrO = result as? NSDictionary, let data = AppCommonMethods.convertToJson(object: arrO), let aData = try? jsonDecoder.decode(WebOrderModel.self, from: data){
                    if self.orderType.lowercased() == "dine in"{
                        aData.orderType = "dine in"
                    }
                    self.orderDetails = aData
                    self.arrCarts = aData.arrProducts ?? [WebProductDetailModel]()
                    self.setOrderDataFromDetails()
                    self.tblCarts.reloadData()
                }else{
                    AppValidation().showAlertView(parentVC: self, withAlertTile: AppConstants.GlobalAlert.ALERT_TITLE, withAlertMsg: message, withActionsTitle: [AppConstants.GlobalAlert.ALERT_BTN_OK]) { (index) in
                        
                    }
                }
            }
        }
    }
    
    func CallGetTimeSlotAPI(isPickupSlot:Bool,deliveryDate:String,isDelayTime:Bool){
        var dictParam = [String:String]()
        dictParam["date"] = deliveryDate
        AppCommonMethods.startProgressBar()
        WebServiceManager().requestAPI(params: dictParam,  urlString: "\(AppConstants.APIURL.kOnlineOrder)\(orderId)/time-slots", method: "GET",isRestaurantAPI: true) { (message, result) in
            DispatchQueue.main.async {
                AppCommonMethods.stopProgressBar()
                if var arrSlot = result as? [String]{
                    if ((self.orderDetails as! WebOrderModel).assoonas ?? "" == "now"){
                        let cDate = ((self.orderDetails as! WebOrderModel).deliveryDate ?? "").components(separatedBy: "T").first ?? ""
                        if let date = cDate.getDateFromString(format: "yyyy-MM-dd", locale: nil){
                            let today = Date().getDateInString(format: "dd/MM/yyyy").getDateFromString(format: "dd/MM/yyyy", locale: nil)!
                            if date == today{
                                arrSlot.insert("ASAP", at: 0)
                            }
                        }
                    }
                    if let VC = SelectTimeSlotVC.show(order: self.orderDetails as! WebOrderModel,isDelayTime: isDelayTime, arrTimeSlot: arrSlot, parentVC: self.parentVC){
                        VC.delegate = self
                    }
                }
            }
        }
    }
    
    func CallSetOrderStatusAPI(status:String, cancelReason:String = "",timeSlot:String? = nil,isDelayOrder:Bool = false){
        var dictParam = [String:Any]()
        if cancelReason != ""{
            dictParam["failed_reason"] = cancelReason
        }
        if timeSlot != nil{
            if timeSlot! == "ASAP"{
                dictParam["preparation"] = Date().getDateInString(format: "hh:mm a")
            }else{
                dictParam["preparation"] = timeSlot!
            }
        }
        var strURL = "\(AppConstants.APIURL.kOnlineOrder)\(self.orderId)/change-status"
        if self.orderType.lowercased() == "dine in"{
            strURL = "\(AppConstants.APIURL.kOnlineDineinOrder)\(self.orderId)/change-status"
        }
        if isDelayOrder{
            strURL = "\(AppConstants.APIURL.kOnlineOrder)\(self.orderId)/time-extend"
        }else{
            dictParam["status"] = status
        }
        AppCommonMethods.startProgressBar()
        WebServiceManager().requestAPI(params: dictParam,  urlString: strURL, method: "POST",isRestaurantAPI: true) { (message, result) in
            DispatchQueue.main.async {
                AppCommonMethods.stopProgressBar()
                let jsonDecoder = JSONDecoder()
                if let arrO = result as? NSDictionary, let data = AppCommonMethods.convertToJson(object: arrO), let aData = try? jsonDecoder.decode(WebOrderModel.self, from: data){
                    var setting = BottomAlertSettings()
                    setting.isClickable = true
                    setting.id = self.orderId
                    if status == "Failed"{
                        setting.bgColor = AppConstants.Colors.kAppThemeRedColor
                        setting.strMessage = AppConstants.GlobalAlert.ORDER_REJECTED
                    }else if status == "Accepted" && !isDelayOrder{
                        setting.bgColor = AppConstants.Colors.kAppDarkGreenColor
                        setting.strMessage = AppConstants.GlobalAlert.ORDER_ACCPETED
                    }else if status == "Delivered"{
                        setting.bgColor = AppConstants.Colors.kAppDarkGreenColor
                        setting.strMessage = AppConstants.GlobalAlert.ORDER_COMPLETED
                    }else{
                        setting.strMessage = AppConstants.GlobalAlert.ORDER_DELAYED
                        setting.bgColor = AppConstants.Colors.kAppThemeMediumRedColor
                    }
                    if self.orderType.lowercased() == "dine in"{
                        aData.orderType = "dine in"
                    }
                    BadgeManager.shared?.stopLastAPICall()
                    self.orderDetails = aData
                    setting.orderType = aData.orderType ?? ""
                    self.setOrderDataFromDetails()
                    self.tblCarts.reloadData()
                    AppValidation().showBottomAlertView(settings: setting)
                }else{
                    AppValidation().showAlertView(parentVC: self, withAlertTile: AppConstants.GlobalAlert.ALERT_TITLE, withAlertMsg: message, withActionsTitle: [AppConstants.GlobalAlert.ALERT_BTN_OK]) { (index) in
                        
                    }
                }
            }
        }
    }
    
    func CallMarkAsReadyToCollectAPI(){
        let dictParam = [String:Any]()
        AppCommonMethods.startProgressBar()
        WebServiceManager().requestAPI(params: dictParam, urlString: "\(AppConstants.APIURL.kOnlineOrder)\(self.orderId)/rtc", method: "POST", isRestaurantAPI: true) { (message, response) in
            DispatchQueue.main.async {
                AppCommonMethods.stopProgressBar()
                if let _ = response as? NSDictionary{
                    var setting = BottomAlertSettings()
                    setting.strMessage = "Order is ready to collect"
                    if let detail = self.orderDetails as? WebOrderModel{
                        if (detail.orderType ?? "").lowercased() == "delivery"{
                            setting.strMessage = "Order is on the way"
                        }
                    }
                    AppValidation().showBottomAlertView(settings: setting)
                }else{
                    AppValidation().showAlertView(parentVC: self, withAlertTile: AppConstants.GlobalAlert.ALERT_TITLE, withAlertMsg: message, withActionsTitle: [AppConstants.GlobalAlert.ALERT_BTN_OK]) { (index) in
                        
                    }
                }
            }
        }
    }
    
    func callRefundPament(index:Int){
        if let detail = self.orderDetails as? OrderModel{
            let payment = detail.arrOrderPayments[index]
            var dictParam = [String:Any]()
            dictParam["amount"] = payment.amount ?? 0
            dictParam["payment_intent_id"] = payment.txnId ?? ""
            AppCommonMethods.startProgressBar()
            WebServiceManager().requestAPI(params: dictParam,  urlString: AppConstants.APIURL.kOrderRefund, method: "POST") { (message, result) in
                DispatchQueue.main.async {
                    AppCommonMethods.stopProgressBar()
                    //let jsonDecoder = JSONDecoder()
                    if let _ = result as? NSDictionary{
                        payment.isRefunded = 1
                        self.CallCreateOrderAPI(payments: detail.arrOrderPayments)
                    }else{
                        AppValidation().showAlertView(parentVC: self, withAlertTile: AppConstants.GlobalAlert.ALERT_TITLE, withAlertMsg: message, withActionsTitle: [AppConstants.GlobalAlert.ALERT_BTN_OK]) { (index) in
                            
                        }
                    }
                }
            }
        }
    }
    
    func CallCreateOrderAPI(orderStatusId:Int? = nil, payments:[PaymentOrderModel]? = nil){
        if let detail = self.orderDetails as? OrderModel{
            if orderStatusId != nil{
                detail.orderStatusId = orderStatusId!
                let arr = AppConstants.arrOrderStatuses.filter { model in
                    return model.id ?? 0 == orderStatusId!
                }
                detail.orderStatus = arr.first
                SQLiteManage.SaveOrderIntoDatabase(order: detail, updated: 1)
                self.setOrderDataFromDetails()
            }else if payments != nil{
                detail.arrOrderPayments = payments!
                SQLiteManage.SaveOrderIntoDatabase(order: detail, updated: 1)
                self.setOrderDataFromDetails()
            }else{
                detail.isDeleted = 1
                if detail.isNewOrder == 1{
                    SQLiteManage.deleteOrder(orderId: detail.id ?? 0, isFromAPI: true)
                }else{
                    SQLiteManage.SaveOrderIntoDatabase(order: detail, updated: 1, isDeleted: 1)
                }
                self.btnBackAction(UIButton())
            }
            if Reachabilities.shared.isConnectedToNetwork() && AppConstants.DataSyncMode == "Auto"{
                BGAPIExecution.shared.AddOrderToQueue(order: detail, isDeleteFromRunningOrder: false)
            }else{
                if payments != nil || orderStatusId != nil{
                    self.setOrderDataFromDetails()
                }else{
                    self.btnBackAction(UIButton())
                }
            }
        }
    }
    
}

//MARK: UITableViewDataSource
extension OrderDetailVC:UITableViewDataSource,UITableViewDelegate{
    func tableView(_ tableView: UITableView, numberOfRowsInSection section: Int) -> Int {
        if orderDetails == nil{
            return 0
        }
        return arrCarts.count+1
    }
    
    func tableView(_ tableView: UITableView, heightForRowAt indexPath: IndexPath) -> CGFloat {
        if indexPath.row != arrCarts.count{
            if let product = arrCarts[indexPath.row] as? OrderProductModel{
                if AppCommonMethods.fetchSiteSettingValue(key: "delete_item_visible") ?? "" == "false" && product.isDelete{
                    return 0
                }
            }
        }
        return UITableView.automaticDimension
    }
    
    func tableView(_ tableView: UITableView, cellForRowAt indexPath: IndexPath) -> UITableViewCell {
        if indexPath.row == arrCarts.count{
            let cell = tableView.dequeueReusableCell(withIdentifier: "OrderPriceInfoCell", for: indexPath) as! OrderPriceInfoCell
            if let detail = self.orderDetails as? WebOrderModel{
                let method = detail.paymentMethod ?? ""
                cell.lblPaymentMode.superview?.isHidden = false
                cell.lblPaymentMode.textColor = AppConstants.Colors.kAppDarkGreenColor
                cell.arrSurcharge = detail.surcharges
                cell.tblSurcharge.reloadData()
                cell.constSurchargeHeight.constant = CGFloat(detail.surcharges.count) * 30
                if method.lowercased() == "stripe"{
                    cell.lblPaymentMode.text = "Paid via Credit/Debit card"
                }else if method.lowercased() == "cod"{
                    var orderType = (detail.orderType ?? "").capitalized
                    if orderType == "Pickup"{
                        orderType = "Collection"
                    }
                    cell.lblPaymentMode.textColor = AppConstants.Colors.kAppThemeRedColor
                    if (detail.orderType ?? "").lowercased() == "pickup"{
                        cell.lblPaymentMode.text = "Cash on collection"
                    }else if (detail.orderType ?? "").lowercased() == "delivery"{
                        cell.lblPaymentMode.text = "Cash on delivery"
                    }else{
                        cell.lblPaymentMode.text = "Cash payment"
                    }
                }else if method.lowercased() == "wallet"{
                    cell.lblPaymentMode.text = "Paid via TiffinTom Credit"
                }else{
                    cell.lblPaymentMode.text = "Paid via \(method.capitalized)"
                }
                let walletAmt = detail.walletAmount ?? 0
                if walletAmt != 0{
                    cell.lblWalletAmount.superview?.isHidden = false
                    cell.lblWalletAmount.text = String.init(format: "%@%.2f", AppConstants.currencySign,walletAmt)
                    if method.lowercased() == "cod" && ((detail.orderType ?? "").lowercased() == "dine in"){
                        cell.lblPaymentMode.text = "TiffinTom Credit + \(cell.lblPaymentMode.text ?? "")"
                    }else{
                        cell.lblPaymentMode.text = "\(cell.lblPaymentMode.text ?? "") + TiffinTom Credit"
                    }
                }else{
                    cell.lblWalletAmount.superview?.isHidden = true
                }
                cell.lblSubTotal.text = String.init(format: "%@%.2f", AppConstants.currencySign,detail.subTotal ?? 0)
                if detail.driverTip ?? 0 == 0{
                    cell.lblDriverTip.superview!.isHidden = true
                }else{
                    cell.lblDriverTip.superview!.isHidden = false
                    cell.lblDriverTip.text = String.init(format: "%@%.2f", AppConstants.currencySign,detail.driverTip ?? 0)
                }
                if detail.serviceCharge ?? 0 == 0{
                    cell.lblServiceFee.superview!.isHidden = true
                }else{
                    cell.lblServiceFee.superview!.isHidden = false
                    cell.lblServiceFee.text = String.init(format: "%@%.2f", AppConstants.currencySign,detail.serviceCharge ?? 0)
                }
                if detail.deliveryFee ?? 0 == 0{
                    cell.lblDeliveryFee.superview!.isHidden = true
                }else{
                    cell.lblDeliveryFee.superview!.isHidden = false
                    cell.lblDeliveryFee.text = String.init(format: "%@%.2f", AppConstants.currencySign,detail.deliveryFee ?? 0)
                }
                if detail.offerPrice ?? 0 == 0 && detail.voucherAmount ?? 0 == 0{
                    cell.lblDiscount.superview!.isHidden = true
                }else{
                    if detail.offerPrice ?? 0 != 0{
                        if let pcerntage = detail.offerPercentage, pcerntage != 0{
                            cell.lblDiscountTitle.text = String.init(format: "Offer Applied (%.0f%@ Off)", pcerntage, "%")
                        }
                        cell.lblDiscount.text = String.init(format: "-%@%.2f", AppConstants.currencySign,detail.offerPrice ?? 0)
                        
                    }else if detail.voucherAmount ?? 0 != 0{
                        cell.lblDiscount.text = String.init(format: "-%@%.2f", AppConstants.currencySign,detail.voucherAmount ?? 0)
                    }
                    cell.lblDiscount.superview!.isHidden = false
                }
                let reward = detail.rewardOffer ?? 0
                if reward != 0{
                    cell.lblRewardDiscount.text = String.init(format: "-%@%.2f", AppConstants.currencySign,reward)
                    cell.lblRewardDiscount.superview?.isHidden = false
                }else{
                    cell.lblRewardDiscount.superview?.isHidden = true
                }
                let charity = detail.charity ?? 0
                if charity != 0{
                    cell.lblCharity.text = String.init(format: "%@%.2f", AppConstants.currencySign,charity)
                    cell.lblCharity.superview?.isHidden = false
                }else{
                    cell.lblCharity.superview?.isHidden = true
                }
                if detail.cardView?.cardNo ?? "" != ""{
                    cell.lblCardNo.text = "**** \(detail.cardView?.cardNo ?? "")"
                }
                cell.lblTotalPrice.text = String.init(format: "%@%.2f", AppConstants.currencySign, (detail.orderGrandTotal ?? 0) + charity)
                let tax = detail.taxAmount ?? 0
                if tax != 0{
                    cell.lblRestaurantTax.text = String.init(format: "%@%.2f", AppConstants.currencySign,tax)
                    cell.lblRestaurantTax.superview?.isHidden = false
                }else{
                    cell.lblRestaurantTax.superview?.isHidden = true
                }
            }else if let detail = orderDetails as? OrderModel{
                cell.arrPayments = detail.arrOrderPayments
                cell.constPaymentHeight.constant = 42 * CGFloat(detail.arrOrderPayments.count)
                if detail.discount ?? 0 == 0{
                    cell.lblDiscount.superview!.isHidden = true
                }else{
                    cell.lblDiscount.text = String.init(format: "-%@%.2f", AppConstants.currencySign,detail.discount ?? 0)
                    cell.lblDiscount.superview!.isHidden = false
                }
                if detail.deliveryCharge ?? 0 == 0{
                    cell.lblDeliveryFee.superview!.isHidden = true
                }else{
                    cell.lblDeliveryFee.superview!.isHidden = false
                    cell.lblDeliveryFee.text = String.init(format: "%@%.2f", AppConstants.currencySign, detail.deliveryCharge ?? 0)
                }
                cell.lblSubTotal.text = String.init(format: "%@%.2f", AppConstants.currencySign,detail.subTotal ?? 0)
                cell.lblTotalPrice.text = String.init(format: "%@%.2f", AppConstants.currencySign, detail.total ?? 0)
                if detail.gratuity ?? 0 == 0{
                    cell.lblDriverTip.superview!.isHidden = true
                }else{
                    cell.lblDriverTip.superview!.isHidden = false
                    cell.lblDriverTipTitle.text = "Gratuity"
                    cell.lblDriverTip.text = String.init(format: "%@%.2f", AppConstants.currencySign,detail.gratuity ?? 0)
                }
                if detail.serviceCharge ?? 0 == 0{
                    cell.lblServiceFee.superview!.isHidden = true
                }else{
                    cell.lblServiceFee.superview!.isHidden = false
                    cell.lblServiceFee.text = String.init(format: "%@%.2f", AppConstants.currencySign,detail.serviceCharge ?? 0)
                }
                
                cell.tblPayments.reloadData()
            }
            return cell
        }
        let cell = tableView.dequeueReusableCell(withIdentifier: "CartViewCell", for: indexPath) as! CartViewCell
        if let cart = arrCarts[indexPath.row] as? WebProductDetailModel{
            cell.lblItemName.text = cart.menuName ?? ""
            let price = cart.totalPrice ?? 0
            if price == 0{
                cell.lblItemPrice.text = "Free"
            }else{
                cell.lblItemPrice.text = String.init(format: "%@%.2f", AppConstants.currencySign,price)
            }
            cell.lblItemQuantity.text = "\(cart.quantity ?? 0)x"
            cell.lblAddons.text = cart.subAddonsName ?? ""
        }else if let model = arrCarts[indexPath.row] as? OrderProductModel{
            let price = model.total ?? 0
            if model.isDelete{
                cell.lblItemName.text = ""
                cell.lblItemName.attributedText = (model.productName ?? "").strikeThoughText
                cell.lblItemPrice.text = ""
                cell.lblItemPrice.attributedText = String.init(format: "%@%.2f", AppConstants.currencySign,price).strikeThoughText
            }else{
                cell.lblItemName.attributedText = nil
                cell.lblItemName.text = model.productName ?? ""
                cell.lblItemPrice.attributedText = nil
                cell.lblItemPrice.text = String.init(format: "%@%.2f", AppConstants.currencySign,price)
            }
            cell.lblItemQuantity.text = "\(model.quantity ?? 0)x"
            cell.lblAddons.text = ""
            if model.arrAddons.count > 0 || model.arrIngriedent.count > 0 || model.specialInstruction ?? "" != ""{
                var strDesc = ""
                model.arrIngriedent.forEach({ (ingrident) in
                    var strIngrident = ""
                    if ingrident.with ?? 0 == 1{
                        if ingrident.price ?? 0 == 0{
                            strIngrident = String.init(format: "(%dx %@ - Free)", ingrident.quantity ?? 0, ingrident.name ?? "")
                        }else{
                            strIngrident = String.init(format: "(%dx %@ - %@%.2f)", ingrident.quantity ?? 0, ingrident.name ?? "", AppConstants.currencySign, ingrident.price ?? 0)
                        }
                    }else{
                        if ingrident.price ?? 0 == 0{
                            strIngrident = String.init(format: "(No %@ - Free)", ingrident.name ?? "")
                        }else{
                            strIngrident = String.init(format: "(No %@ - %@%.2f)", ingrident.name ?? "", AppConstants.currencySign, ingrident.price ?? 0)
                        }
                    }
                    if strDesc == ""{
                        strDesc = strIngrident
                    }else{
                        strDesc = "\(strDesc)\n\(strIngrident)"
                    }
                })
                model.arrAddons.forEach({ (addon) in
                    let strAddon = String.init(format: "(%dx %@)", addon.quantity ,addon.name ?? "")
                    if strDesc == ""{
                        strDesc = strAddon
                    }else{
                        strDesc = "\(strDesc)\n\(strAddon)"
                    }
                })
                if model.specialInstruction ?? "" != ""{
                    if strDesc == ""{
                        strDesc = "Special Instruction: \(model.specialInstruction ?? "")"
                    }else{
                        strDesc = "\(strDesc)\nSpecial Instruction: \(model.specialInstruction ?? "")"
                    }
                    if model.instructionPrice ?? 0 != 0{
                        strDesc.append(String.init(format: " - %.2f", model.instructionPrice ?? 0))
                    }
                }
                if model.isDelete{
                    cell.lblAddons.text = ""
                    cell.lblAddons.attributedText = strDesc.strikeThoughText
                }else{
                    cell.lblAddons.attributedText = nil
                    cell.lblAddons.text = strDesc
                }
            }
        }
        
        return cell
    }
}

//MARK: AlertControllerDelegate
extension OrderDetailVC:AlertControllerDelegate{
    func alertButtonAction(index: Int, data:alertViewData,type:AlertType) {
        if index == 1{
            if type == .kDeliverOrder{
                CallSetOrderStatusAPI(status: "Delivered")
            }else if type == .kRejectOrder{
                CallSetOrderStatusAPI(status: "Failed", cancelReason: data.value)
            }else if type == .kEnterUserPassword{
                if isForOrderDelete{
                    CallCreateOrderAPI()
                }else{
                    CallCreateOrderAPI(orderStatusId: 10)
                }
            }else{
                if let _ = orderDetails as? OrderModel{
                    self.printBillAction()
                }else{
                    if AppCommonMethods.fetchSiteSettingValue(key: "kitchen_copy_type") ?? "" == "auto"{
                        PrintManager.shared.shouldPrintKitchenCopy = true
                        PrintManager.shared.orderType = (self.orderDetails as! WebOrderModel).orderType ?? ""
                        PrintManager.shared.connectToPrinterWithPrint(model: self.orderDetails!, controller: self)
                    }else{
                        AppValidation().showAlertView(parentVC: self, withAlertTile: nil, withAlertMsg: AppConstants.GlobalAlert.ALERT_KITCHEN_COPY, withActionsTitle: [AppConstants.GlobalAlert.ALERT_BTN_NO,AppConstants.GlobalAlert.ALERT_BTN_YES]) { (index) in
                            if index == 1{
                                PrintManager.shared.shouldPrintKitchenCopy = true
                            }else{
                                PrintManager.shared.shouldPrintKitchenCopy = false
                            }
                            PrintManager.shared.orderType = (self.orderDetails as! WebOrderModel).orderType ?? ""
                            PrintManager.shared.connectToPrinterWithPrint(model: self.orderDetails!, controller: self)
                        }
                    }
                }
            }
        }
    }
}

//MARK: OrderActionDelegate
extension OrderDetailVC:OrderActionDelegate{
    func timeSlotSelected(strTimeslot: String?, isDelayTime: Bool) {
        if isDelayTime{
            CallSetOrderStatusAPI(status: "timeextended", timeSlot: strTimeslot, isDelayOrder: isDelayTime)
        }else{
            if AppCommonMethods.fetchSiteSettingValue(key: "kitchen_copy_type") ?? "" == "auto"{
                PrintManager.shared.shouldPrintKitchenCopy = true
                PrintManager.shared.orderType = (self.orderDetails as! WebOrderModel).orderType ?? ""
                PrintManager.shared.connectToPrinterWithPrint(model: self.orderDetails!, controller: self)
            }else{
                AppValidation().showAlertView(parentVC: self, withAlertTile: nil, withAlertMsg: AppConstants.GlobalAlert.ALERT_KITCHEN_COPY, withActionsTitle: [AppConstants.GlobalAlert.ALERT_BTN_NO,AppConstants.GlobalAlert.ALERT_BTN_YES]) { (index) in
                    if index == 1{
                        PrintManager.shared.shouldPrintKitchenCopy = true
                    }else{
                        PrintManager.shared.shouldPrintKitchenCopy = false
                    }
                    PrintManager.shared.orderType = (self.orderDetails as! WebOrderModel).orderType ?? ""
                    PrintManager.shared.connectToPrinterWithPrint(model: self.orderDetails!, controller: self)
                }
            }
            self.CallSetOrderStatusAPI(status: "Accepted", timeSlot: strTimeslot, isDelayOrder: isDelayTime)
        }
    }
    
    func reminderDateSet() {
        setOrderDataFromDetails()
    }
}

extension OrderDetailVC:SendOrderDelegate{
    func sendOrder(index: Int) {
        if index == 6{
            self.printAllAction()
        }else{
            self.printBillAction()
        }
    }
}
