//
//  ProductsVC.swift
//  TiffinTomPartner
//
//  Created by Apple on 31/03/21.
//

import UIKit


class ProductsVC: UIViewController {
    
    //MARK: IBOutlet Instances
    @IBOutlet weak var tblProducts:UITableView!
    @IBOutlet weak var lblTitle:UILabel!
    @IBOutlet weak var btnSearch:UIButton!
    @IBOutlet weak var viewForSearch:UIView!
    @IBOutlet weak var txtSearch:UITextField!
    
    //MARK: Other Instances
    var selectedRow = -1
    var arrProducts = [OnlineProductModel]()
    var arrSearchProducts = [OnlineProductModel]()
    var arrAddOns = [MainAddOnModel]()
    var arrSearchAddOns = [MainAddOnModel]()
    var isProductView = true
    var isSearchEnabled = false
    var parentVC:SideMenuVC!
    
    override func viewDidLoad() {
        super.viewDidLoad()
        
        // Do any additional setup after loading the view.
        CallGetProducts()
        if !isProductView{
            lblTitle.text = "Addons"
        }
    }
    
    //MARK: Create Viewcontrlloer instance
    static func addToParentView(parentVC:SideMenuVC)->ProductsVC?{
        guard let VC = UIStoryboard.init(name: "Menus", bundle: nil).instantiateViewController(withIdentifier: "ProductsVC") as? ProductsVC else {
            return nil
        }
        VC.parentVC = parentVC
        parentVC.addChild(VC)
        parentVC.viewForContainer.addSubview(VC.view)
        VC.view.frame = CGRect.init(x: 0, y: 0, width: parentVC.viewForContainer.frame.width, height: parentVC.viewForContainer.frame.height)
        return VC
    }
    
    @IBAction func btnSearchAction(_ sender:UIButton){
        self.view.endEditing(true)
        UIView.animate(withDuration: 0.25) {
            self.viewForSearch.alpha = 1
        }
    }
    
    @IBAction func btnCancelSearchAction(_ sender:UIButton){
        isSearchEnabled = false
        txtSearch.text = ""
        self.view.endEditing(true)
        UIView.animate(withDuration: 0.25) {
            self.viewForSearch.alpha = 0
        }
        tblProducts.reloadData()
    }
    
    @IBAction func txtSearchChanged(_ sender:UITextField){
        if txtSearch.text ?? "" == ""{
            isSearchEnabled = false
        }else{
            isSearchEnabled = true
            if isProductView{
                arrSearchProducts = arrProducts.filter({ (model) -> Bool in
                    return (model.menuName ?? "").lowercased().contains((txtSearch.text ?? "").lowercased())
                })
            }else{
                arrSearchAddOns = arrAddOns.filter({ (model) -> Bool in
                    return (model.mainAddonsName ?? "").lowercased().contains((txtSearch.text ?? "").lowercased())
                })
            }
            
        }
        tblProducts.reloadData()
    }
    
    @IBAction func btnAddMoreAction(_ sender:UIButton){
        selectedRow = -1
        if isProductView{
            //            if let VC = AddProductVC.instance(){
            //                if let controller = (VC.childViewController as! UINavigationController).viewControllers.first as? AddProductVC{
            //                    controller.delegate = self
            //                }
            //                self.present(VC, animated: true, completion: nil)
            //            }
        }else{
            //            if let VC = AddOnVC.instance(){
            //                if let controller = (VC.childViewController as! UINavigationController).viewControllers.first as? AddOnVC{
            //                    controller.delegate = self
            //                }
            //                self.present(VC, animated: true, completion: nil)
            //            }
        }
    }
    
    @IBAction func switchEnableChangedAction(_ sender:UISwitch){
        var strURL = ""
        if isProductView{
            let model = isSearchEnabled ? arrSearchProducts[sender.tag] : arrProducts[sender.tag]
            if isSearchEnabled{
                if let index = arrProducts.firstIndex(where: { addon in
                    return addon.id ?? 0 == model.id ?? 0
                }){
                    arrProducts[index].status = sender.isOn ? 1 : 0
                }
            }
            strURL = "\(AppConstants.APIURL.kTiffinTomMenus)\(model.id ?? 0)/disable"
            if sender.isOn{
                strURL = "\(AppConstants.APIURL.kTiffinTomMenus)\(model.id ?? 0)/enable"
            }
            model.status = sender.isOn ? 1 : 0
        }else{
            let model = isSearchEnabled ? arrSearchAddOns[sender.tag] : arrAddOns[sender.tag]
            if isSearchEnabled{
                if let index = arrAddOns.firstIndex(where: { addon in
                    return addon.id ?? 0 == model.id ?? 0
                }){
                    arrAddOns[index].status = sender.isOn ? 1 : 0
                }
            }
            strURL = "\(AppConstants.APIURL.kTiffinTomAddons)\(model.id ?? 0)/disable"
            if sender.isOn{
                strURL = "\(AppConstants.APIURL.kTiffinTomAddons)\(model.id ?? 0)/enable"
            }
            model.status = sender.isOn ? 1 : 0
        }
        self.tblProducts.reloadData()
        
        let dictParam = [String:Any]()
        WebServiceManager().requestAPI(params: dictParam, urlString: strURL, method: "POST", isRestaurantAPI: true) { (message, response) in
            
        }
    }
    
    func CallGetProducts(){
        var dictParam = [String:Any]()
        dictParam["restaurant_id"] = AppConstants.webResId ?? ""
        dictParam["nopaginate"] = "1"
        
        AppCommonMethods.startProgressBar()
        WebServiceManager().requestAPI(params: dictParam, urlString: self.isProductView ? AppConstants.APIURL.kTiffinTomMenus : AppConstants.APIURL.kTiffinTomAddons, method: "GET", isRestaurantAPI: true) { (message, response) in
            DispatchQueue.main.async {
                AppCommonMethods.stopProgressBar()
                if let result = response as? [NSDictionary]{
                    let jsonDecoder = JSONDecoder()
                    if self.isProductView{
                        if let data = AppCommonMethods.convertToJson(object: result),let aData = try? jsonDecoder.decode([OnlineProductModel].self, from: data){
                            self.arrProducts = aData
                            self.tblProducts.reloadData()
                        }
                    }else{
                        if let data = AppCommonMethods.convertToJson(object: result),let aData = try? jsonDecoder.decode([MainAddOnModel].self, from: data){
                            self.arrAddOns = aData
                            self.tblProducts.reloadData()
                        }
                    }
                }else{
                    AppValidation().showAlertView(parentVC: self, withAlertTile: AppConstants.GlobalAlert.ALERT_TITLE, withAlertMsg: message, withActionsTitle: [AppConstants.GlobalAlert.ALERT_BTN_OK]) { (index) in
                        
                    }
                }
            }
        }
    }
    
    func CallDeleteProduct(){
        let dictParam = [String:Any]()
        AppCommonMethods.startProgressBar()
        WebServiceManager().requestAPI(params: dictParam, urlString: "\(AppConstants.APIURL.kTiffinTomMenus)\((isSearchEnabled ? arrSearchProducts[selectedRow].id : arrProducts[selectedRow].id) ?? 0)", method: "DELETE", isRestaurantAPI: true) { (message, response) in
            DispatchQueue.main.async {
                AppCommonMethods.stopProgressBar()
                let jsonDecoder = JSONDecoder()
                if let result = response as? NSDictionary, let data = AppCommonMethods.convertToJson(object: result), let _ = try? jsonDecoder.decode(OnlineProductModel.self, from: data){
                    if self.isSearchEnabled{
                        let index = self.arrProducts.firstIndex { (modle) -> Bool in
                            return modle.id ?? 0 == self.arrSearchProducts[self.selectedRow].id ?? 0
                        }
                        if index != nil{
                            self.arrProducts.remove(at: index!)
                        }
                        self.arrSearchProducts.remove(at: self.selectedRow)
                    }else{
                        self.arrProducts.remove(at: self.selectedRow)
                    }
                    self.tblProducts.reloadData()
                    var settings = BottomAlertSettings()
                    settings.strMessage = "Product has been deleted successfully"
                    AppValidation().showBottomAlertView(settings: settings)
                }else{
                    AppValidation().showAlertView(parentVC: self, withAlertTile: AppConstants.GlobalAlert.ALERT_TITLE, withAlertMsg: message, withActionsTitle: [AppConstants.GlobalAlert.ALERT_BTN_OK]) { (index) in
                        
                    }
                }
            }
        }
    }
    
    func CallDeleteAddOn(){
        let dictParam = [String:Any]()
        AppCommonMethods.startProgressBar()
        WebServiceManager().requestAPI(params: dictParam, urlString: "\(AppConstants.APIURL.kTiffinTomAddons)\((isSearchEnabled ? arrSearchAddOns[selectedRow].id : arrAddOns[selectedRow].id) ?? 0)", method: "DELETE", isRestaurantAPI: true) { (message, response) in
            DispatchQueue.main.async {
                AppCommonMethods.stopProgressBar()
                let jsonDecoder = JSONDecoder()
                if let result = response as? NSDictionary, let data = AppCommonMethods.convertToJson(object: result), let _ = try? jsonDecoder.decode(MainAddOnModel.self, from: data){
                    if self.isSearchEnabled{
                        let index = self.arrAddOns.firstIndex { (modle) -> Bool in
                            return modle.id ?? 0 == self.arrSearchAddOns[self.selectedRow].id ?? 0
                        }
                        if index != nil{
                            self.arrAddOns.remove(at: index!)
                        }
                        self.arrSearchAddOns.remove(at: self.selectedRow)
                    }else{
                        self.arrAddOns.remove(at: self.selectedRow)
                    }
                    self.tblProducts.reloadData()
                    var settings = BottomAlertSettings()
                    settings.strMessage = "Addon has been deleted successfully"
                    AppValidation().showBottomAlertView(settings: settings)
                }else{
                    AppValidation().showAlertView(parentVC: self, withAlertTile: AppConstants.GlobalAlert.ALERT_TITLE, withAlertMsg: message, withActionsTitle: [AppConstants.GlobalAlert.ALERT_BTN_OK]) { (index) in
                        
                    }
                }
            }
        }
    }
}

extension ProductsVC:UITableViewDelegate,UITableViewDataSource{
    func tableView(_ tableView: UITableView, numberOfRowsInSection section: Int) -> Int {
        if isProductView{
            return isSearchEnabled ? arrSearchProducts.count : arrProducts.count
        }else{
            return isSearchEnabled ? arrSearchAddOns.count : arrAddOns.count
        }
    }
    
    func tableView(_ tableView: UITableView, cellForRowAt indexPath: IndexPath) -> UITableViewCell {
        let cell = tableView.dequeueReusableCell(withIdentifier: "CategoryViewCell", for: indexPath) as! CategoryViewCell
        cell.switchEnable.tag = indexPath.row
        if !isProductView{
            let model = isSearchEnabled ? arrSearchAddOns[indexPath.row] : arrAddOns[indexPath.row]
            cell.lblProductName.text = model.mainAddonsName ?? ""
            cell.lblCategoryName.text = model.categoryName ?? ""
            if model.status ?? 0 == 1{
                cell.switchEnable.isOn = true
                cell.lblStatus.text = "Active"
                cell.lblStatus.textColor = AppConstants.Colors.kAppDarkGreenColor
            }else{
                cell.switchEnable.isOn = false
                cell.lblStatus.text = "Inactive"
                cell.lblStatus.textColor = AppConstants.Colors.kAppThemeRedColor
            }
        }else{
            let model = isSearchEnabled ? arrSearchProducts[indexPath.row] : arrProducts[indexPath.row]
            cell.lblProductName.text = model.menuName ?? ""
            cell.lblCategoryName.text = model.categoryName ?? ""
            if model.status ?? 0 == 1{
                cell.switchEnable.isOn = true
                cell.lblStatus.text = "Active"
                cell.lblStatus.textColor = AppConstants.Colors.kAppDarkGreenColor
            }else{
                cell.switchEnable.isOn = false
                cell.lblStatus.text = "Inactive"
                cell.lblStatus.textColor = AppConstants.Colors.kAppThemeRedColor
            }
        }
        
        return cell
    }
    
    func tableView(_ tableView: UITableView, didSelectRowAt indexPath: IndexPath) {
        selectedRow = indexPath.row
        if isProductView{
            //            if let VC = AddProductVC.instance(product: isSearchEnabled ? arrSearchProducts[selectedRow] : arrProducts[selectedRow]){
            //                if let controller = (VC.childViewController as! UINavigationController).viewControllers.first as? AddProductVC{
            //                    controller.delegate = self
            //                }
            //                self.present(VC, animated: true, completion: nil)
            //            }
        }else{
            //            if let VC = AddOnVC.instance(addon: isSearchEnabled ? arrSearchAddOns[selectedRow] : arrAddOns[selectedRow]){
            //                if let controller = (VC.childViewController as! UINavigationController).viewControllers.first as? AddOnVC{
            //                    controller.delegate = self
            //                }
            //                self.present(VC, animated: true, completion: nil)
            //            }
        }
    }
}


extension ProductsVC:ProductDelegate{
    func deleteProduct() {
        var settings = AlertSetting()
        settings.alertMessage = "Please enter your password to delete product"
        settings.alertTitle = "Delete product"
        settings.type = .kEnterAdminPassword
        settings.textPlcaeholder = "password"
        settings.titleColor = AppConstants.Colors.kAppLightGrayColor
        if let VC = AlertViewController.showPopup(parentVC: self, setting: settings){
            VC.delegate = self
        }
    }
    
    func productModified(product:OrderProductModel,index:Int?){
        CallGetProducts()
    }
    
    func assignToProduct(isAddon: Bool, product: ProductModel?) {
        
    }
}


extension ProductsVC:AddOnsDelegate{
    func deleteAddOn() {
        var settings = AlertSetting()
        settings.alertMessage = "Please enter your password to delete add on"
        settings.alertTitle = "Delete add on"
        settings.type = .kEnterAdminPassword
        settings.textPlcaeholder = "password"
        settings.titleColor = AppConstants.Colors.kAppLightGrayColor
        if let VC = AlertViewController.showPopup(parentVC: self, setting: settings){
            VC.delegate = self
        }
    }
    
    func addOnUpdated() {
        CallGetProducts()
    }
}

extension ProductsVC:AlertControllerDelegate{
    func alertButtonAction(index: Int, data: alertViewData, type: AlertType) {
        if isProductView{
            CallDeleteProduct()
        }else{
            CallDeleteAddOn()
        }
    }
}

