//
//  ProductsVC.swift
//  TiffinTomPartner
//
//  Created by Apple on 31/03/21.
//

import UIKit

protocol IngriedentDelegate: AnyObject {
    func ingriedentUpdated()
}

enum ProductViewType {
    case kProduct
    case kProductAddon
    case kProductIngredient
    case kIngredient
}

class EPOSProductsVC: UIViewController {
    
    //MARK: IBOutlet Instances
    @IBOutlet weak var tblProducts:UITableView!
    @IBOutlet weak var lblTitle:UILabel!
    @IBOutlet weak var btnSearch:UIButton!
    @IBOutlet weak var viewForSearch:UIView!
    @IBOutlet weak var txtSearch:UITextField!
    
    //MARK: Other Instances
    var arrProducts = [ProductModel]()
    var arrSearchProducts = [ProductModel]()
    var arrIngridents = [IngredientModel]()
    var arrSearchAddons = [AddOnModel]()
    var arrAddons = [AddOnModel]()
    var arrSearchIngridents = [IngredientModel]()
    var viewType = ProductViewType.kProduct
    var isSearchEnabled = false
    var selectedProduct:ProductModel!
    var parentVC:SideMenuVC!
    
    override func viewDidLoad() {
        super.viewDidLoad()
        
        // Do any additional setup after loading the view.
        CallGetProducts()
        if viewType == .kIngredient{
            lblTitle.text = "Ingredients"
        }else if viewType == .kProductAddon{
            lblTitle.text = "Product Addons"
        }else if viewType == .kProductIngredient{
            lblTitle.text = "Product Ingredients"
        }
    }
    
    //MARK: Create Viewcontrlloer instance
    static func addToParentView(parentVC:SideMenuVC)->EPOSProductsVC?{
        guard let VC = UIStoryboard.init(name: "Menus", bundle: nil).instantiateViewController(withIdentifier: "EPOSProductsVC") as? EPOSProductsVC else {
            return nil
        }
        VC.parentVC = parentVC
        parentVC.addChild(VC)
        parentVC.viewForContainer.addSubview(VC.view)
        VC.view.frame = CGRect.init(x: 0, y: 0, width: parentVC.viewForContainer.frame.width, height: parentVC.viewForContainer.frame.height)
        return VC
    }
    
    //MARK: General methods
    @IBAction func btnSearchAction(_ sender:UIButton){
        self.view.endEditing(true)
        UIView.animate(withDuration: 0.25) {
            self.viewForSearch.alpha = 1
        }
    }
    
    @IBAction func btnCancelSearchAction(_ sender:UIButton){
        isSearchEnabled = false
        txtSearch.text = ""
        self.view.endEditing(true)
        UIView.animate(withDuration: 0.25) {
            self.viewForSearch.alpha = 0
        }
        tblProducts.reloadData()
    }
    
    @IBAction func txtSearchChanged(_ sender:UITextField){
        if txtSearch.text ?? "" == ""{
            isSearchEnabled = false
        }else{
            isSearchEnabled = true
            if viewType == .kProduct{
                arrSearchProducts = arrProducts.filter({ (model) -> Bool in
                    return (model.name ?? "").lowercased().contains((txtSearch.text ?? "").lowercased())
                })
            }else if viewType == .kProductAddon{
                arrSearchAddons = arrAddons.filter({ (model) -> Bool in
                    return (model.name ?? "").lowercased().contains((txtSearch.text ?? "").lowercased())
                })
            }else{
                arrSearchIngridents = arrIngridents.filter({ (model) -> Bool in
                    return (model.name ?? "").lowercased().contains((txtSearch.text ?? "").lowercased())
                })
            }
        }
        tblProducts.reloadData()
    }
    
    @IBAction func btnAddMoreAction(_ sender:UIButton){
        self.view.endEditing(true)
//        if viewType == .kProduct{
//            if let VC = AddEPOSProductVC.instance(){
//                if let controller = (VC.childViewController as! UINavigationController).viewControllers.first as? AddEPOSProductVC{
//                    controller.delegate = self
//                }
//                self.present(VC, animated: true, completion: nil)
//            }
//        }else if viewType == .kProductAddon{
//            if let VC = AssignProductAddonVC.showPopup(parentVC: self, product: self.selectedProduct, addons: self.arrAddons){
//                VC.delegate = self
//            }
//        }else if viewType == .kProductIngredient{
//            if let VC = AssignIngridentVC.showPopup(parentVC: self, product: self.selectedProduct, ingredients: self.arrIngridents){
//                VC.delegate = self
//            }
//        }else{
//            if let VC = AddIngriedentVC.showPopup(parentVC: self){
//                VC.delegate = self
//            }
//        }
    }
    
    @IBAction func btnAssignAction(_ sender:UIButton){
        self.view.endEditing(true)
        let model = isSearchEnabled ? arrSearchProducts[sender.tag] : arrProducts[sender.tag]
        let alertController = UIAlertController(title: nil, message: nil, preferredStyle: .actionSheet)
        let addonAction = UIAlertAction(title: "Assign Product Addons", style: .default) { [unowned self] _ in
            if let VC = EPOSProductsVC.addToParentView(parentVC: self.parentVC){
                VC.viewType = .kProductAddon
                VC.selectedProduct = model
            }
        }
        alertController.addAction(addonAction)
        
        let ingredientsAction = UIAlertAction(title: "Assign Product Ingredients", style: .default) { [unowned self] _ in
            if let VC = EPOSProductsVC.addToParentView(parentVC: self.parentVC){
                VC.viewType = .kProductIngredient
                VC.selectedProduct = model
            }
        }
        alertController.addAction(ingredientsAction)
        
        alertController.addAction(UIAlertAction(title: "Cancel", style: .cancel, handler: nil))
        
        if UIDevice.current.userInterfaceIdiom == .pad {
            alertController.popoverPresentationController?.sourceView = sender
            alertController.popoverPresentationController?.sourceRect = sender.bounds
            alertController.popoverPresentationController?.permittedArrowDirections = [.down, .up]
        }
        
        self.present(alertController, animated: true)
    }
    
    @IBAction func switchEnableChanges(_ sender:UISwitch){
        self.view.endEditing(true)
        var strURL = ""
        if viewType == .kProduct{
            let product = isSearchEnabled ? self.arrSearchProducts[sender.tag] : self.arrProducts[sender.tag]
            strURL = "\(AppConstants.APIURL.kProductList)\(product.id ?? 0)/disable"
            if !sender.isOn{
                product.disabled = 1
            }else{
                product.disabled = 0
                strURL = "\(AppConstants.APIURL.kProductList)\(product.id ?? 0)/enable"
            }
            if isSearchEnabled{
                if let index = arrProducts.firstIndex(where: { model in
                    return model.id ?? 0 == product.id ?? 0
                }){
                    arrProducts[index].disabled = sender.isOn ? 0 : 1
                }
            }
        }else if viewType == .kProductAddon{
            let ingrident = isSearchEnabled ? self.arrSearchAddons[sender.tag] : self.arrAddons[sender.tag]
            strURL = "\(AppConstants.APIURL.kAddOnsList)\(ingrident.id ?? 0)/disable"
            if !sender.isOn{
                ingrident.disabled = 1
            }else{
                ingrident.disabled = 0
                strURL = "\(AppConstants.APIURL.kAddOnsList)\(ingrident.id ?? 0)/enable"
            }
            if isSearchEnabled{
                if let index = arrAddons.firstIndex(where: { model in
                    return model.id ?? 0 == ingrident.id ?? 0
                }){
                    arrAddons[index].disabled = sender.isOn ? 0 : 1
                }
            }
        }else if viewType == .kProductIngredient{
            let ingrident = isSearchEnabled ? self.arrSearchIngridents[sender.tag] : self.arrIngridents[sender.tag]
            strURL = "\(AppConstants.APIURL.kIngredientsList)\(ingrident.id ?? 0)/disable"
            if !sender.isOn{
                ingrident.disabled = 1
            }else{
                ingrident.disabled = 0
                strURL = "\(AppConstants.APIURL.kIngredientsList)\(ingrident.id ?? 0)/enable"
            }
            if isSearchEnabled{
                if let index = arrIngridents.firstIndex(where: { model in
                    return model.id ?? 0 == ingrident.id ?? 0
                }){
                    arrIngridents[index].disabled = sender.isOn ? 0 : 1
                }
            }
        }else{
            let ingrident = isSearchEnabled ? self.arrSearchIngridents[sender.tag] : self.arrIngridents[sender.tag]
            strURL = "\(AppConstants.APIURL.kEPOSIngrident)\(ingrident.id ?? 0)/disable"
            if !sender.isOn{
                ingrident.disabled = 1
            }else{
                ingrident.disabled = 0
                strURL = "\(AppConstants.APIURL.kEPOSIngrident)\(ingrident.id ?? 0)/enable"
            }
            if isSearchEnabled{
                if let index = arrIngridents.firstIndex(where: { model in
                    return model.id ?? 0 == ingrident.id ?? 0
                }){
                    arrIngridents[index].disabled = sender.isOn ? 0 : 1
                }
            }
        }
        self.tblProducts.reloadData()
        let dictParam = [String:Any]()
        WebServiceManager().requestAPI(params: dictParam, urlString: strURL, method: "POST") { (message, response) in
            
        }
    }
    
    func CallGetProducts(){
        var dictParam = [String:Any]()
        dictParam["nopaginate"] = "1"
        
        var strURL = AppConstants.APIURL.kProductList
        if viewType == .kIngredient{
            strURL = AppConstants.APIURL.kEPOSIngrident
        }else if viewType == .kProductAddon{
            dictParam["product_id"] = self.selectedProduct?.id ?? 0
            strURL = AppConstants.APIURL.kAddOnsList
        }else if viewType == .kProductIngredient{
            dictParam["product_id"] = self.selectedProduct?.id ?? 0
            strURL = AppConstants.APIURL.kIngredientsList
        }
        AppCommonMethods.startProgressBar()
        WebServiceManager().requestAPI(params: dictParam, urlString: strURL, method: "GET", isRestaurantAPI: true) { (message, response) in
            DispatchQueue.main.async {
                AppCommonMethods.stopProgressBar()
                self.arrProducts = [ProductModel]()
                self.arrIngridents = [IngredientModel]()
                var aMSG = message
                if let result = response as? [NSDictionary], let data = AppCommonMethods.convertToJson(object: result){
                    let jsonDecoder = JSONDecoder()
                    if self.viewType == .kProduct{
                        if let aData = try? jsonDecoder.decode([ProductModel].self, from: data){
                            self.arrProducts = aData
                            self.tblProducts.reloadData()
                            return
                        }
                        aMSG = "No products found"
                    }else if self.viewType == .kProductAddon{
                        if let aData = try? jsonDecoder.decode([AddOnModel].self, from: data){
                            self.arrAddons = aData
                            self.tblProducts.reloadData()
                            return
                        }
                        aMSG = "No product addons found"
                    }else{
                        if let aData = try? jsonDecoder.decode([IngredientModel].self, from: data){
                            self.arrIngridents = aData
                            self.tblProducts.reloadData()
                            return
                        }
                        aMSG = "No ingredients found"
                    }
                }
                AppValidation().showAlertView(parentVC: self, withAlertTile: AppConstants.GlobalAlert.ALERT_TITLE, withAlertMsg: aMSG, withActionsTitle: [AppConstants.GlobalAlert.ALERT_BTN_OK]) { (index) in
                    
                }
                
            }
        }
    }
}

extension EPOSProductsVC:UITableViewDelegate,UITableViewDataSource{
    func tableView(_ tableView: UITableView, numberOfRowsInSection section: Int) -> Int {
        if viewType == .kProduct{
            return isSearchEnabled ? arrSearchProducts.count : arrProducts.count
        }else if viewType == .kProductAddon{
            return isSearchEnabled ? arrSearchAddons.count : arrAddons.count
        }else{
            return isSearchEnabled ? arrSearchIngridents.count : arrIngridents.count
        }
    }
    
    func tableView(_ tableView: UITableView, cellForRowAt indexPath: IndexPath) -> UITableViewCell {
        if viewType == .kProduct{
            let cell = tableView.dequeueReusableCell(withIdentifier: "ProductViewCell", for: indexPath) as! CategoryViewCell
            cell.switchEnable.tag = indexPath.row
            let model = isSearchEnabled ? arrSearchProducts[indexPath.row] : arrProducts[indexPath.row]
            cell.btnAssign.tag = indexPath.row
            cell.lblProductName.text = model.name ?? ""
            cell.lblCategoryName.text = model.categoryName ?? ""
            if model.disabled ?? 0 == 0{
                cell.switchEnable.isOn = true
            }else{
                cell.switchEnable.isOn = false
            }
            cell.lblCategoryName.isHidden = false
            return cell
        }
        let cell = tableView.dequeueReusableCell(withIdentifier: "CategoryViewCell", for: indexPath) as! CategoryViewCell
        cell.switchEnable.tag = indexPath.row
        if viewType == .kProductAddon{
            let model = isSearchEnabled ? arrSearchAddons[indexPath.row] : arrAddons[indexPath.row]
            cell.lblProductName.text = model.name ?? ""
            if model.disabled ?? 0 == 0{
                cell.lblStatus.text = "Active"
                cell.switchEnable.isOn = true
                cell.lblStatus.textColor = AppConstants.Colors.kAppDarkGreenColor
            }else{
                cell.lblStatus.text = "Inactive"
                cell.switchEnable.isOn = false
                cell.lblStatus.textColor = AppConstants.Colors.kAppThemeRedColor
            }
        }else{
            let model = isSearchEnabled ? arrSearchIngridents[indexPath.row] : arrIngridents[indexPath.row]
            cell.lblProductName.text = model.name ?? ""
            if model.disabled ?? 0 == 0{
                cell.lblStatus.text = "Active"
                cell.switchEnable.isOn = true
                cell.lblStatus.textColor = AppConstants.Colors.kAppDarkGreenColor
            }else{
                cell.lblStatus.text = "Inactive"
                cell.switchEnable.isOn = false
                cell.lblStatus.textColor = AppConstants.Colors.kAppThemeRedColor
            }
            cell.lblCategoryName.isHidden = false
            if model.with ?? 0 == 1 && model.without ?? 0 == 1{
                cell.lblCategoryName.text = "With, Without"
            }else if model.with ?? 0 == 1{
                cell.lblCategoryName.text = "With"
            }else if model.without ?? 0 == 1{
                cell.lblCategoryName.text = "Without"
            }else{
                cell.lblCategoryName.isHidden = true
            }
        }
        return cell
    }
    
    func tableView(_ tableView: UITableView, didSelectRowAt indexPath: IndexPath) {
        self.view.endEditing(true)
        if viewType == .kProduct{
//            if let VC = AddEPOSProductVC.instance(product: isSearchEnabled ? arrSearchProducts[indexPath.row] : arrProducts[indexPath.row]){
//                if let controller = (VC.childViewController as! UINavigationController).viewControllers.first as? AddEPOSProductVC{
//                    controller.delegate = self
//                }
//                self.present(VC, animated: true, completion: nil)
//            }
        }else if viewType == .kProductAddon{
//            if let VC = AssignProductAddonVC.showPopup(parentVC: self, product: self.selectedProduct, addons: self.arrAddons, addon: isSearchEnabled ? arrSearchAddons[indexPath.row] : arrAddons[indexPath.row]){
//                VC.delegate = self
//            }
        }else if viewType == .kProductIngredient{
//            if let VC = EditAssignIngridentVC.showPopup(parentVC: self, product: self.selectedProduct, ingredients: self.arrIngridents, ingredient: isSearchEnabled ? arrSearchIngridents[indexPath.row] : arrIngridents[indexPath.row]){
//                VC.delegate = self
//            }
        }else{
//            if let VC = AddIngriedentVC.showPopup(parentVC: self, ingreident: isSearchEnabled ? arrSearchIngridents[indexPath.row] : arrIngridents[indexPath.row]){
//                VC.delegate = self
//            }
        }
    }
}


extension EPOSProductsVC:ProductDelegate{
    func deleteProduct() {
        
    }
    
    func productModified(product:OrderProductModel,index:Int?){
        CallGetProducts()
    }
    
    func assignToProduct(isAddon:Bool,product:ProductModel?){
        if let VC = EPOSProductsVC.addToParentView(parentVC: self.parentVC){
            if isAddon{
                VC.viewType = .kProductAddon
            }else{
                VC.viewType = .kProductIngredient
            }
            VC.selectedProduct = product
            self.navigationController?.pushViewController(VC, animated: true)
        }
    }
}

extension EPOSProductsVC:IngriedentDelegate{
    func ingriedentUpdated() {
        self.CallGetProducts()
    }
}

extension EPOSProductsVC:AddOnsDelegate{
    func addOnUpdated() {
        self.CallGetProducts()
    }
    
    func deleteAddOn() {
        
    }
}
