//
//  SetReminderVC.swift
//  TiffinTomPartner
//
//  Created by Tushar Premal on 07/11/20.
//

import UIKit
import ActionSheetPicker_3_0

class SetReminderVC: UIViewController {

    //MARK: IBOutlet
    @IBOutlet weak var lblCutomDate:UILabel!
    @IBOutlet weak var lblSelectedDate:UILabel!
    @IBOutlet var lblReminderDates:[UILabel]!
    
    //MARK: Instances
    var strCustomDate:String?
    var selectedReminderIndex:Int?
    var orderDetail:WebOrderModel!
    var arrReminder = [NSMutableDictionary]()
    var isDelayOrderView = false
    weak var delegate:OrderActionDelegate?
    var parentVC:SideMenuVC!
    
    //MARK: ViewController LifeCycle
    override func viewDidLoad() {
        super.viewDidLoad()

        // Do any additional setup after loading the view.
        if let arrData = AppCommonMethods.readObjfromUserDefault(withKey: AppConstants.userDefaultKey.kReminderData) as? [NSDictionary]{
            for dict in arrData{
                arrReminder.append(NSMutableDictionary.init(dictionary: dict))
            }
        }
        lblSelectedDate.text = ""
        setReminderView()
    }
    
    //MARK: create viewcontroller instance
    static func instance(orderDetail:WebOrderModel,parentVC:SideMenuVC)->SetReminderVC?{
        guard let controller = UIStoryboard.init(name: "BottomPopup", bundle: nil).instantiateViewController(withIdentifier: "SetReminderVC") as? SetReminderVC else { return nil }
        controller.orderDetail = orderDetail
        controller.parentVC = parentVC
        parentVC.addChild(controller)
        parentVC.viewForSideContainer.addSubview(controller.view)
        parentVC.constSideViewLeadingSpace.constant = AppConstants.ScreenSize.SCREEN_WIDTH - 700
        UIView.animate(withDuration: 0.25) {
            parentVC.viewForSideBG.alpha = 1.0
            parentVC.view.layoutIfNeeded()
        }
        controller.view.frame = CGRect.init(x: 0, y: 0, width: 700, height: parentVC.viewForContainer.frame.height)
        return controller
    }
    
    //MARK: General Methods
    func setReminderView(){
        lblCutomDate.superview?.backgroundColor = AppConstants.Colors.kAppThemeAquaColor
        for i in 0..<lblReminderDates.count{
            lblReminderDates[i].text = "\(i+1) hour before \(orderDetail.displayOrderType.lowercased())"
            lblReminderDates[i].superview?.backgroundColor = AppConstants.Colors.kAppThemeAquaColor
        }
        if strCustomDate != nil{
            lblSelectedDate.text = "Reminder set at \(strCustomDate!) for \(orderDetail.displayOrderType.lowercased())"
            lblCutomDate.superview?.backgroundColor = AppConstants.Colors.kAppThemeDarkAquaColor
        }else{
            if selectedReminderIndex != nil{
                lblSelectedDate.text = "Reminder set for \(lblReminderDates[selectedReminderIndex!].text ?? "")"
                lblReminderDates[selectedReminderIndex!].superview?.backgroundColor = AppConstants.Colors.kAppThemeDarkAquaColor
            }
        }
    }
    
    func closePopup(){
        parentVC.constSideViewLeadingSpace.constant = AppConstants.ScreenSize.SCREEN_WIDTH
        UIView.animate(withDuration: 0.25) {
            self.parentVC.viewForSideBG.alpha = 0.0
            self.parentVC.view.layoutIfNeeded()
        } completion: { (status) in
            self.view.removeFromSuperview()
            self.removeFromParent()
        }
    }
    
    //MARK: Button Actions
    @IBAction func btnCloseAction(_ sender:UIButton){
        self.closePopup()
    }
    
    @IBAction func btnSetReminderAction(_ sender:UIButton){
        if sender.tag == 5{
            var date = Date()
            if strCustomDate != nil{
                date = strCustomDate!.getDateFromString(format: "dd/MM/yy 'at' hh:mm a", locale: nil) ?? Date()
            }
            let datePicker = ActionSheetDatePicker(title: "Select date & time", datePickerMode: UIDatePicker.Mode.dateAndTime, selectedDate: date, doneBlock: {
                picker, value, index in
                self.strCustomDate = (value as! Date).getDateInString(format: "dd/MM/yy 'at' hh:mm a")
                self.lblCutomDate.text = (value as! Date).getDateInString(format: "dd/MM/yy 'at' hh:mm a")
                self.setReminderView()
            }, cancel: { ActionStringCancelBlock in return }, origin: sender)
            datePicker?.minimumDate =  Date()
            if let strDate = orderDetail.deliveryDate{
                var deliveryDate = strDate.components(separatedBy: "T").first ?? ""
                deliveryDate = "\(deliveryDate) \(self.orderDetail.deliveryTime ?? "")"
                if let date = deliveryDate.getDateFromString(format: "yyyy-MM-dd hh:mm a", locale: nil){
                    datePicker?.maximumDate = date
                }
            }
            datePicker?.show()
        }else{
            self.strCustomDate = nil
            selectedReminderIndex = sender.tag
            setReminderView()
        }
    }
    
    @IBAction func btnConfirmAction(_ sender:UIButton){
        if selectedReminderIndex == nil && strCustomDate == nil{
            AppValidation().showAlertView(parentVC: self, withAlertTile: AppConstants.GlobalAlert.ALERT_TITLE, withAlertMsg: AppConstants.GlobalAlert.ALERT_SELECT_REMINDERTIME, withActionsTitle: [AppConstants.GlobalAlert.ALERT_BTN_OK]) { (index) in
                
            }
            return
        }else{
            var reminderDate:Date?
            let index = arrReminder.firstIndex(where: { (dict) -> Bool in
                return dict.getIntValue("orderId") ?? 0 == self.orderDetail.id ?? 0
            })
            if index != nil{
                let dictReminder = arrReminder[index!]
                arrReminder.remove(at: index!)
                AppCommonMethods.cancelLocalNotification(orderId: dictReminder.getStringValue("orderId") ?? "")
            }
            var deliveryDate = (self.orderDetail.deliveryDate ?? "").components(separatedBy: "T").first ?? ""
            deliveryDate = "\(deliveryDate) \(self.orderDetail.deliveryTime ?? "")"
            if strCustomDate != nil{
                reminderDate = strCustomDate!.getDateFromString(format: "dd/MM/yy 'at' hh:mm a", locale: nil)
            }else{
                
                if let date = deliveryDate.getDateFromString(format: "yyyy-MM-dd hh:mm a", locale: nil){
                    switch selectedReminderIndex {
                    case 0:
                        reminderDate = date.addingTimeInterval(-60*60)
                    case 1:
                        reminderDate = date.addingTimeInterval(-2*60*60)
                    case 2:
                        reminderDate = date.addingTimeInterval(-3*60*60)
                    case 3:
                        reminderDate = date.addingTimeInterval(-4*60*60)
                    case 4:
                        reminderDate = date.addingTimeInterval(-5*60*60)
                    default:
                        break
                    }
                }
                
            }
            if reminderDate != nil{
                if reminderDate! < Date(){
                    AppValidation().showAlertView(parentVC: self, withAlertTile: AppConstants.GlobalAlert.ALERT_TITLE, withAlertMsg: AppConstants.GlobalAlert.ALERT_REMINDER_GREATER_DATE, withActionsTitle: [AppConstants.GlobalAlert.ALERT_BTN_OK]) { (index) in
                        
                    }
                    return
                }
                let interval = reminderDate!.timeIntervalSince(Date())
                let dictNewRenimder = NSMutableDictionary()
                dictNewRenimder["orderId"] = self.orderDetail.id ?? 0
                dictNewRenimder["date"] = reminderDate!.getDateInString(format: "dd/MM/yy 'at' hh:mm a")
                arrReminder.append(dictNewRenimder)
                
                AppCommonMethods.saveDataIntoUserDefault(value: arrReminder, withKey: AppConstants.userDefaultKey.kReminderData)
                var strMessage = ""
                if (orderDetail.orderType ?? "").lowercased() == "delivery"{
                    strMessage = "You have an upcoming order from \(self.orderDetail.customerName ?? "") to deliver at \(deliveryDate)"
                }else if (orderDetail.orderType ?? "").lowercased() == "pickup"{
                    strMessage = "You have an upcoming order from \(self.orderDetail.customerName ?? "") for collection at \(deliveryDate)"
                }else{
                    strMessage = "You have an upcoming order from \(self.orderDetail.customerName ?? "") for pickup at \(deliveryDate)"
                }
                AppCommonMethods.fireLocalNotification(interval: interval, orderId: "\(self.orderDetail.id ?? 0)", message: strMessage)
            }
            if delegate != nil{
                self.delegate?.reminderDateSet()
            }
            self.closePopup()
        }
        
    }
}
