//
//  ReservationDetailVC.swift
//  TiffinTomPartner
//
//  Created by Tushar Premal on 30/10/20.
//

import UIKit

class ReservationDetailVC: UIViewController {

    //MARK: IBOutlet
    @IBOutlet weak var lblUserName:UILabel!
    @IBOutlet weak var lblContactNo:UILabel!
    @IBOutlet weak var lblReservationDate:UILabel!
    @IBOutlet weak var lblCancelReason:UILabel!
    @IBOutlet weak var lblNoOfGuest:UILabel!
    @IBOutlet weak var lblInstructions:UILabel!
    @IBOutlet weak var lblReadMore:UILabel!
    @IBOutlet weak var viewForInstructions:UIView!
    @IBOutlet weak var constInstructionTrailingSpace:NSLayoutConstraint!
    @IBOutlet weak var constInstructionBottomSpace:NSLayoutConstraint!
    @IBOutlet weak var constLblInstructionHeight:NSLayoutConstraint!
    @IBOutlet weak var btnAccept:UIButton!
    @IBOutlet weak var btnReject:UIButton!
    @IBOutlet weak var btnCancel:UIButton!
    @IBOutlet weak var btnPrint:UIButton!
    
    //MARK: Instances
    var isShowMoreSelected = false
    var selectedBooking:OnlineReservationModel!
    weak var delegate:ReservationDelegate?

    //MARK: ViewController LifeCycle
    override func viewDidLoad() {
        super.viewDidLoad()

        // Do any additional setup after loading the view.
        
        setResrvationData()
    }

    //MARK: create viewcontroller instance
    static func instance(model:OnlineReservationModel)->SheetViewController?{
        guard let controller = UIStoryboard.init(name: "BottomPopup", bundle: nil).instantiateViewController(withIdentifier: "ReservationDetailVC") as? ReservationDetailVC else { return nil }
        controller.selectedBooking = model
        let height:CGFloat = 540 + AppConstants.ScreenSize.bottomPadding
        
        return SheetViewController(controller: controller, sizes: [.fixed(height)], options: SheetOptions(useInlineMode: false))
    }
    
    //MARK: General Methods
    func setResrvationData(){
        lblUserName.text = "Name: \(selectedBooking.customerName ?? "")"
        lblContactNo.text = "Contact number: \(selectedBooking.bookingPhone ?? "")"
        lblNoOfGuest.text = "Reservation No: \(selectedBooking.bookingId ?? "")\n\(selectedBooking.guestCount ?? 0) guests"
        if AppConstants.selectedPrinter == nil || (selectedBooking.status ?? "") == "Pending"{
            self.btnPrint.isHidden = true
        }else{
            self.btnPrint.isHidden = false
        }
        if selectedBooking.cancelReason ?? "" == ""{
            lblCancelReason.isHidden = true
        }else{
            lblCancelReason.isHidden = false
            lblCancelReason.text = "Reason for cancellation: \(selectedBooking.cancelReason ?? "")"
        }
        if selectedBooking.status ?? "" == "Pending"{
            btnAccept.isHidden = false
            btnReject.isHidden = false
        }else if selectedBooking.status ?? "" == "Approved"{
            let bookingDate = (selectedBooking.bookingDate ?? "").getDateFromString(format: "yyyy-MM-dd", locale: nil) ?? (selectedBooking.bookingDate ?? "").getDateFromString(format: "dd-MM-yyyy", locale: nil) ?? Date()
            let currentDate = Date().getDateInString(format: "yyyy-MM-dd").getDateFromString(format: "yyyy-MM-dd", locale: nil) ?? Date()
            if bookingDate >= currentDate{
                btnCancel.isHidden = false
            }
        }
        if selectedBooking.bookingInstruction ?? "" == ""{
            viewForInstructions.isHidden = true
        }else{
            lblInstructions.text = selectedBooking.bookingInstruction ?? ""
            let height = (selectedBooking.bookingInstruction ?? "").getHeightFromString(font: AppConstants.GlobalFontConstants.kBookFont(size: 12), width: AppConstants.ScreenSize.SCREEN_WIDTH - 78)
            if height > 17{
                lblReadMore.superview?.isHidden = false
                constInstructionTrailingSpace.constant = 70
            }else{
                lblReadMore.superview?.isHidden = true
                constInstructionTrailingSpace.constant = 9
            }
        }
        if let bDate = (selectedBooking.bookingDate ?? "").getDateFromString(format: "yyyy-MM-dd", locale: nil){
            lblReservationDate.text = "Reservation on: \(bDate.getDateInString(format: bDate.gatDateFormat())) at \(selectedBooking.bookingTime ?? "")"
        }else if let bDate = (selectedBooking.bookingDate ?? "").getDateFromString(format: "dd-MM-yyyy", locale: nil){
            lblReservationDate.text = "Reservation on: \(bDate.getDateInString(format: bDate.gatDateFormat())) at \(selectedBooking.bookingTime ?? "")"
        }
    }
    
    //MARK: Button Actions
    @IBAction func btnCloseAction(_ sender:UIButton){
        self.dismiss(animated: true, completion: nil)
    }
    
    @IBAction func btnPrintAction(_ sender:UIButton){
        PrintManager.shared.connectToPrinterWithPrint(model: selectedBooking!, controller: self)
    }
    
    @IBAction func btnAcceptAction(_ sender:UIButton){
        self.dismiss(animated: true) {
            if self.delegate != nil{
                self.delegate!.AcceptReservation()
            }
        }
    }
    
    @IBAction func btnRejectAction(_ sender:UIButton){
        self.dismiss(animated: true) {
            if self.delegate != nil{
                self.delegate!.cancelReservation()
            }
        }
        
    }
    
    @IBAction func btnReadMoreAction(_ sender:UIButton){
        if !lblReadMore.superview!.isHidden{
            isShowMoreSelected = !isShowMoreSelected
            if !isShowMoreSelected{
                lblReadMore.text = "read more"
                constInstructionTrailingSpace.constant = 70
                constInstructionBottomSpace.constant = 9
                constLblInstructionHeight.constant = 17
            }else{
                let height = (selectedBooking.bookingInstruction ?? "").getHeightFromString(font: AppConstants.GlobalFontConstants.kBookFont(size: 12), width: AppConstants.ScreenSize.SCREEN_WIDTH - 78)
                lblReadMore.text = "read less"
                constLblInstructionHeight.constant = height
                constInstructionTrailingSpace.constant = 9
                constInstructionBottomSpace.constant = 30
            }
        }
    }
}

