//
//  AddDiscountCodeVC.swift
//  TiffinTomPartner
//
//  Created by Tushar Premal on 22/12/20.
//

import UIKit
import ActionSheetPicker_3_0

class AddDiscountCodeVC: UIViewController {

    //MARK: IBOutlet
    @IBOutlet weak var btnDelivery:UIButton!
    @IBOutlet weak var btnCollection:UIButton!
    @IBOutlet weak var btnDineIn:UIButton!
    @IBOutlet weak var btnWeb:UIButton!
    @IBOutlet weak var btnApp:UIButton!
    @IBOutlet weak var btnSingle:UIButton!
    @IBOutlet weak var btnMultiple:UIButton!
    @IBOutlet weak var btnPrice:UIButton!
    @IBOutlet weak var btnPercentage:UIButton!
    @IBOutlet weak var btnFreeDelivery:UIButton!
    @IBOutlet weak var txtVoucherCode:UITextField!
    @IBOutlet weak var txtMultipleTime:UITextField!
    @IBOutlet weak var txtOfferValue:UITextField!
    @IBOutlet weak var txtMinValue:UITextField!
    @IBOutlet weak var lblFromDate:UILabel!
    @IBOutlet weak var lbltoDate:UILabel!
    
    //MARK: Instances
    var selectedVoucher:RestaurantVoucherModel!
    weak var delegate:AddDiscountCodeDelegate?
    var arrDeviceType = [String]()
    
    //MARK: ViewController LifeCycle
    override func viewDidLoad() {
        super.viewDidLoad()

        // Do any additional setup after loading the view.
        setVoucherView()
    }

    //MARK: Create Viewcontrlloer instance
    static func show(voucher:RestaurantVoucherModel)->SheetViewController?{
        guard let controller = UIStoryboard.init(name: "BottomPopup", bundle: nil).instantiateViewController(withIdentifier: "AddDiscountCodeVC") as? AddDiscountCodeVC else { return nil }
        controller.selectedVoucher = voucher
        let height:CGFloat = AppConstants.ScreenSize.SCREEN_HEIGHT-100
        return SheetViewController(controller: controller, sizes: [.fixed(height)], options: SheetOptions(useInlineMode: false))
    }
    
    //MARK: General Methods
    func setVoucherView(){
        self.btnSingle.backgroundColor = AppConstants.Colors.kAppThemeBGColor
        self.btnSingle.setTitleColor(AppConstants.Colors.kAppThemeTextColor, for: .normal)
        self.btnMultiple.backgroundColor = AppConstants.Colors.kAppThemeBGColor
        self.btnMultiple.setTitleColor(AppConstants.Colors.kAppThemeTextColor, for: .normal)
        if selectedVoucher.typeOffer ?? "" == "single"{
            self.btnSingle.backgroundColor = AppConstants.Colors.kAppThemeAquaColor
            self.btnSingle.setTitleColor(.white, for: .normal)
            self.txtMultipleTime.superview?.isHidden = true
        }else{
            self.txtMultipleTime.superview?.isHidden = false
            self.btnMultiple.backgroundColor = AppConstants.Colors.kAppThemeAquaColor
            self.btnMultiple.setTitleColor(.white, for: .normal)
            if let value = selectedVoucher.multipleValue{
                self.txtMultipleTime.text = "\(value)"
            }
        }
        self.txtOfferValue.superview?.isHidden = false
        if let value = selectedVoucher.offerValue{
            self.txtOfferValue.text = String.init(format: "%.0f", value)
        }
        if let value = selectedVoucher.minOrder{
            self.txtMinValue.text = String.init(format: "%.0f", value)
        }
        if let value = selectedVoucher.voucherCode{
            self.txtVoucherCode.text = value
        }
        self.btnWeb.backgroundColor = AppConstants.Colors.kAppThemeBGColor
        self.btnWeb.setTitleColor(AppConstants.Colors.kAppThemeTextColor, for: .normal)
        self.btnApp.backgroundColor = AppConstants.Colors.kAppThemeBGColor
        self.btnApp.setTitleColor(AppConstants.Colors.kAppThemeTextColor, for: .normal)
        arrDeviceType.removeAll()
        if selectedVoucher.deviceType ?? "" == "web"{
            arrDeviceType.append("web")
            self.btnWeb.backgroundColor = AppConstants.Colors.kAppThemeAquaColor
            self.btnWeb.setTitleColor(.white, for: .normal)
        }else if selectedVoucher.deviceType ?? "" == "app"{
            arrDeviceType.append("app")
            self.btnApp.backgroundColor = AppConstants.Colors.kAppThemeAquaColor
            self.btnApp.setTitleColor(.white, for: .normal)
        }else{
            arrDeviceType.append("web")
            arrDeviceType.append("app")
            self.btnApp.backgroundColor = AppConstants.Colors.kAppThemeAquaColor
            self.btnApp.setTitleColor(.white, for: .normal)
            self.btnWeb.backgroundColor = AppConstants.Colors.kAppThemeAquaColor
            self.btnWeb.setTitleColor(.white, for: .normal)
        }
        
        self.btnPrice.backgroundColor = AppConstants.Colors.kAppThemeBGColor
        self.btnPrice.setTitleColor(AppConstants.Colors.kAppThemeTextColor, for: .normal)
        self.btnFreeDelivery.backgroundColor = AppConstants.Colors.kAppThemeBGColor
        self.btnFreeDelivery.setTitleColor(AppConstants.Colors.kAppThemeTextColor, for: .normal)
        self.btnPercentage.backgroundColor = AppConstants.Colors.kAppThemeBGColor
        self.btnPercentage.setTitleColor(AppConstants.Colors.kAppThemeTextColor, for: .normal)
        if selectedVoucher.offerMode ?? "" == "percentage"{
            self.btnPercentage.backgroundColor = AppConstants.Colors.kAppThemeAquaColor
            self.btnPercentage.setTitleColor(.white, for: .normal)
        }else if selectedVoucher.offerMode ?? "" == "price"{
            self.btnPrice.backgroundColor = AppConstants.Colors.kAppThemeAquaColor
            self.btnPrice.setTitleColor(.white, for: .normal)
        }else{
            self.txtOfferValue.superview?.isHidden = true
            self.btnFreeDelivery.backgroundColor = AppConstants.Colors.kAppThemeAquaColor
            self.btnFreeDelivery.setTitleColor(.white, for: .normal)
        }
        
        if selectedVoucher.deliveryType ?? 0 == 1{
            self.btnDelivery.backgroundColor = AppConstants.Colors.kAppThemeAquaColor
            self.btnDelivery.setTitleColor(.white, for: .normal)
        }else{
            self.btnDelivery.backgroundColor = AppConstants.Colors.kAppThemeBGColor
            self.btnDelivery.setTitleColor(AppConstants.Colors.kAppThemeTextColor, for: .normal)
        }
        if selectedVoucher.pickupType ?? 0 == 1{
            self.btnCollection.backgroundColor = AppConstants.Colors.kAppThemeAquaColor
            self.btnCollection.setTitleColor(.white, for: .normal)
        }else{
            self.btnCollection.backgroundColor = AppConstants.Colors.kAppThemeBGColor
            self.btnCollection.setTitleColor(AppConstants.Colors.kAppThemeTextColor, for: .normal)
        }
        if selectedVoucher.dineinType ?? 0 == 1{
            self.btnDineIn.backgroundColor = AppConstants.Colors.kAppThemeAquaColor
            self.btnDineIn.setTitleColor(.white, for: .normal)
        }else{
            self.btnDineIn.backgroundColor = AppConstants.Colors.kAppThemeBGColor
            self.btnDineIn.setTitleColor(AppConstants.Colors.kAppThemeTextColor, for: .normal)
        }
        lblFromDate.text = (selectedVoucher.voucherFrom ?? "").changeDateFormat(fromFormat: "dd-MM-yyyy", toFormat: "dd/MM/yyyy") ?? ""
        lbltoDate.text = (selectedVoucher.voucherTo ?? "").changeDateFormat(fromFormat: "dd-MM-yyyy", toFormat: "dd/MM/yyyy") ?? ""
    }
    
    func checkValidation()->Bool{
        if (txtVoucherCode.text?.trimmingCharacters(in: .whitespaces).isEmpty)!{
            AppValidation().showAlertView(parentVC: self, withAlertTile: AppConstants.GlobalAlert.ALERT_TITLE, withAlertMsg: AppConstants.GlobalAlert.ALERT_ENTER_CODE, withActionsTitle: [AppConstants.GlobalAlert.ALERT_BTN_OK]) { (index) in
                
            }
            return false
        }
        if selectedVoucher.deliveryType ?? 0 == 0 && selectedVoucher.pickupType ?? 0 == 0 && selectedVoucher.dineinType ?? 0 == 0{
            AppValidation().showAlertView(parentVC: self, withAlertTile: AppConstants.GlobalAlert.ALERT_TITLE, withAlertMsg: AppConstants.GlobalAlert.ALERT_VOUCHER_TYPE, withActionsTitle: [AppConstants.GlobalAlert.ALERT_BTN_OK]) { (index) in
                
            }
            return false
        }
        if selectedVoucher.typeOffer ?? "" == "multiple"{
            if (txtMultipleTime.text?.trimmingCharacters(in: .whitespaces).isEmpty)!{
                AppValidation().showAlertView(parentVC: self, withAlertTile: AppConstants.GlobalAlert.ALERT_TITLE, withAlertMsg: AppConstants.GlobalAlert.ALERT_ENTER_MULTIPLE, withActionsTitle: [AppConstants.GlobalAlert.ALERT_BTN_OK]) { (index) in
                    
                }
                return false
            }else if Int(txtMultipleTime.text ?? "") == 0{
                AppValidation().showAlertView(parentVC: self, withAlertTile: AppConstants.GlobalAlert.ALERT_TITLE, withAlertMsg: AppConstants.GlobalAlert.ALERT_MULTIPLE_ZERO, withActionsTitle: [AppConstants.GlobalAlert.ALERT_BTN_OK]) { (index) in
                    
                }
                return false
            }
        }
        if selectedVoucher.offerMode != "free_delivery"{
            if (txtOfferValue.text?.trimmingCharacters(in: .whitespaces).isEmpty)!{
                AppValidation().showAlertView(parentVC: self, withAlertTile: AppConstants.GlobalAlert.ALERT_TITLE, withAlertMsg: AppConstants.GlobalAlert.ALERT_ENTER_OFFERVALUE, withActionsTitle: [AppConstants.GlobalAlert.ALERT_BTN_OK]) { (index) in
                    
                }
                return false
            }else if Int(txtOfferValue.text ?? "") == 0{
                AppValidation().showAlertView(parentVC: self, withAlertTile: AppConstants.GlobalAlert.ALERT_TITLE, withAlertMsg: AppConstants.GlobalAlert.ALERT_OFFERVALUE_ZERO, withActionsTitle: [AppConstants.GlobalAlert.ALERT_BTN_OK]) { (index) in
                    
                }
                return false
            }
        }
        if (txtMinValue.text?.trimmingCharacters(in: .whitespaces).isEmpty)!{
            AppValidation().showAlertView(parentVC: self, withAlertTile: AppConstants.GlobalAlert.ALERT_TITLE, withAlertMsg: AppConstants.GlobalAlert.ALERT_ENTER_OFFERMINVALUE, withActionsTitle: [AppConstants.GlobalAlert.ALERT_BTN_OK]) { (index) in
                
            }
            return false
        }else if Int(txtMinValue.text ?? "") == 0{
            AppValidation().showAlertView(parentVC: self, withAlertTile: AppConstants.GlobalAlert.ALERT_TITLE, withAlertMsg: AppConstants.GlobalAlert.ALERT_OFFERMINVALUE_ZERO, withActionsTitle: [AppConstants.GlobalAlert.ALERT_BTN_OK]) { (index) in
                
            }
            return false
        }else if selectedVoucher.deviceType == nil{
            AppValidation().showAlertView(parentVC: self, withAlertTile: AppConstants.GlobalAlert.ALERT_TITLE, withAlertMsg: AppConstants.GlobalAlert.ALERT_SELECT_DEVICETYPE, withActionsTitle: [AppConstants.GlobalAlert.ALERT_BTN_OK]) { (index) in
                
            }
            return false
        }
        return true
    }
    
    //MARK: Button Actions
    @IBAction func btnCloseAction(_ sender:UIButton){
        self.dismiss(animated: true, completion: nil)
    }
    
    @IBAction func btnOrderTpyeAction(_ sender:UIButton){
        if sender.tag == 0{
            selectedVoucher.deliveryType = (selectedVoucher.deliveryType ?? 0 == 0) ? 1 : 0
        }else if sender.tag == 1{
            selectedVoucher.pickupType = (selectedVoucher.pickupType ?? 0 == 0) ? 1 : 0
        }else{
            selectedVoucher.dineinType = (selectedVoucher.dineinType ?? 0 == 0) ? 1 : 0
        }
        setVoucherView()
    }
    
    @IBAction func btnDeviceTpyeAction(_ sender:UIButton){
        if sender.tag == 0{
            if arrDeviceType.contains("web"){
                self.btnWeb.backgroundColor = AppConstants.Colors.kAppThemeBGColor
                self.btnWeb.setTitleColor(AppConstants.Colors.kAppThemeTextColor, for: .normal)
                arrDeviceType.remove(at: arrDeviceType.firstIndex(of: "web")!)
            }else{
                self.btnWeb.backgroundColor = AppConstants.Colors.kAppThemeAquaColor
                self.btnWeb.setTitleColor(.white, for: .normal)
                arrDeviceType.append("web")
            }
        }else{
            if arrDeviceType.contains("app"){
                self.btnApp.backgroundColor = AppConstants.Colors.kAppThemeBGColor
                self.btnApp.setTitleColor(AppConstants.Colors.kAppThemeTextColor, for: .normal)
                arrDeviceType.remove(at: arrDeviceType.firstIndex(of: "app")!)
            }else{
                self.btnApp.backgroundColor = AppConstants.Colors.kAppThemeAquaColor
                self.btnApp.setTitleColor(.white, for: .normal)
                arrDeviceType.append("app")
            }
        }
        if arrDeviceType.contains("web") && arrDeviceType.contains("app"){
            selectedVoucher.deviceType = "all"
        }else if arrDeviceType.contains("web"){
            selectedVoucher.deviceType = "web"
        }else if arrDeviceType.contains("app"){
            selectedVoucher.deviceType = "app"
        }else{
            selectedVoucher.deviceType = nil
        }
    }
    
    @IBAction func btnUseTpyeAction(_ sender:UIButton){
        if sender.tag == 0{
            selectedVoucher.typeOffer = "single"
        }else{
            selectedVoucher.typeOffer = "multiple"
        }
        setVoucherView()
    }
    
    @IBAction func btnOfferTpyeAction(_ sender:UIButton){
        if sender.tag == 0{
            selectedVoucher.offerMode = "price"
        }else if sender.tag == 1{
            selectedVoucher.offerMode = "percentage"
        }else{
            selectedVoucher.offerMode = "free_delivery"
        }
        setVoucherView()
    }
    
    @IBAction func btnDateAction(_ sender:UIButton){
        var date = Date()
        if sender.accessibilityIdentifier == "0"{
            date = (selectedVoucher.voucherFrom ?? "").getDateFromString(format: "dd-MM-yyyy") ?? Date()
        }else{
            date = (selectedVoucher.voucherTo ?? "").getDateFromString(format: "dd-MM-yyyy") ?? Date()
        }
        let datePicker = ActionSheetDatePicker(title: "Select date", datePickerMode: UIDatePicker.Mode.date, selectedDate: date, doneBlock: {
            picker, value, index in
            if sender.accessibilityIdentifier == "0"{
                self.selectedVoucher.voucherFrom = (value as! Date).getDateInString(format: "dd-MM-yyyy")
            }else{
                self.selectedVoucher.voucherTo = (value as! Date).getDateInString(format: "dd-MM-yyyy")
            }
            self.setVoucherView()
        }, cancel: { ActionStringCancelBlock in return }, origin: sender)
        if sender.accessibilityIdentifier == "0"{
            datePicker?.maximumDate = ((selectedVoucher.voucherTo ?? "").getDateFromString(format: "dd-MM-yyyy") ?? Date()).addingTimeInterval(-24*60*60)
            datePicker?.minimumDate = Date()
        }else{
            datePicker?.minimumDate = ((selectedVoucher.voucherFrom ?? "").getDateFromString(format: "dd-MM-yyyy") ?? Date()).addingTimeInterval(24*60*60)
        }
        datePicker?.show()
    }
    
    @IBAction func btnSubmitAction(_ sender:UIButton){
        if checkValidation(){
            selectedVoucher.voucherCode = txtVoucherCode.text ?? ""
            selectedVoucher.minOrder = Double(txtMinValue.text ?? "") ?? 0
            selectedVoucher.offerValue = Double(txtOfferValue.text ?? "") ?? 0
            selectedVoucher.multipleValue = Int(txtOfferValue.text ?? "") ?? 0
            if delegate != nil{
                delegate!.discountCodeAdded(voucher: selectedVoucher)
            }
            self.dismiss(animated: true, completion: nil)
        }
    }
}
