//
//  ViewController.swift
//  EPOS
//
//  Created by Tushar Premal on 01/03/21.
//

import UIKit
import FirebaseMessaging

class LoginVC: UIViewController {
    
    //MARK:  IBOutlets
    @IBOutlet weak var tblUsers:UITableView!
    @IBOutlet weak var tblSettings:UITableView!
    @IBOutlet weak var txtUserName:UITextField!
    @IBOutlet weak var txtPassword:UITextField!
    @IBOutlet weak var viewForDevice:UIView!
    @IBOutlet weak var lblDeviceMessage:UILabel!
    @IBOutlet weak var txtDeviceName:UITextField!
    @IBOutlet weak var btnAddDevice:UIButton!
    @IBOutlet weak var viewForSideMenu:UIView!
    @IBOutlet weak var viewForSideMenuBG:UIView!
    @IBOutlet weak var lblVersion:UILabel!
    @IBOutlet weak var constSettingsLeadingSpace:NSLayoutConstraint!
    @IBOutlet weak var lblBusinessName:UILabel!
    @IBOutlet weak var imgBusinessLogo:UIImageView!
    
    //MARK:  Instances
    var arrUsers = [UserModel]()
    var selectedMode = AppConstants.DataSyncMode
    var isFromLogout = true
    var isDeviceAdded = false
    var arrSettings:[SettingsCellData] = [.init("Order Sync Mode", .kOrderSyncMode),.init("Remote Device", .kRemoteDevice),.init("Change Business", .kChangeBusiness)]
    var selectedUser:UserModel?
    var selectedSetting = SettingsType.kOrderSyncMode
    var isFromReconnect = false
    
    //MARK:  ViewController LifeCycle
    override func viewDidLoad() {
        super.viewDidLoad()
        // Do any additional setup after loading the view.
        CallValidateDeviceAPI()
        lblVersion.text = "Version \(Bundle.main.infoDictionary?["CFBundleShortVersionString"] as? String ?? "1.0")"
        lblBusinessName.text = AppConstants.businessData?.name ?? ""
        imgBusinessLogo.SetImageFromURL(strURL: AppCommonMethods.fetchSiteSettingValue(key: "logo", lowercased: false) ?? "")
        AppCommonMethods.FetchPrintSettings()
    }
    
    @objc func siteSettingsFetched(){
        DispatchQueue.main.async {
            self.arrSettings = [.init("Order Sync Mode", .kOrderSyncMode),.init("Remote Device", .kRemoteDevice)]
            if AppCommonMethods.fetchSiteSettingValue(key: "cloud_system") ?? "" == "no"{
                self.arrSettings.removeFirst()
            }
            self.tblSettings.reloadData()
        }
    }
    
    //MARK: Create ViewController Instance
    static func instance()->LoginVC?{
        return UIStoryboard.init(name: "Main", bundle: nil).instantiateViewController(withIdentifier: "LoginVC") as? LoginVC
    }
    
    //MARK:  Button Actions
    @IBAction func btnNumberAction(_ sender:UIButton){
        self.view.endEditing(true)
        if sender.tag == 10{
            var password = txtPassword.text ?? ""
            if password.count > 0{
                password.removeLast()
                txtPassword.text = password
            }
        }else{
            txtPassword.text = "\(txtPassword.text ?? "")\(sender.tag)"
        }
    }
    
    @IBAction func btnLoginAction(_ sender:UIButton){
        self.view.endEditing(true)
        if (txtUserName.text?.trimmingCharacters(in: .whitespaces).isEmpty)!{
            AppValidation().showAlertView(parentVC: self, withAlertTile: AppConstants.GlobalAlert.ALERT_TITLE, withAlertMsg:  AppConstants.GlobalAlert.ALERT_ENTER_USERNAME, withActionsTitle: [AppConstants.GlobalAlert.ALERT_BTN_OK]) { (index) in
                _ = self.txtUserName.becomeFirstResponder()
            }
            return
        }else if (txtPassword.text?.trimmingCharacters(in: .whitespaces).isEmpty)!{
            AppValidation().showAlertView(parentVC: self, withAlertTile: AppConstants.GlobalAlert.ALERT_TITLE, withAlertMsg:  AppConstants.GlobalAlert.ALERT_ENTER_PASSWORD, withActionsTitle: [AppConstants.GlobalAlert.ALERT_BTN_OK]) { (index) in
                _ = self.txtPassword.becomeFirstResponder()
            }
            return
        }
        CallLoginAPI()
    }
    
    @IBAction func btnUsersAction(_ sender:UIButton){
        self.view.endEditing(true)
        selectedUser = arrUsers[sender.tag]
        txtUserName.text = arrUsers[sender.tag].username ?? ""
        txtPassword.text = ""
        tblUsers.reloadData()
    }
    
    @IBAction func btnSettingsAction(_ sender:UIButton){
        self.view.endEditing(true)
        self.constSettingsLeadingSpace.constant = 0
        UIView.animate(withDuration: 0.25) {
            self.view.layoutIfNeeded()
            self.viewForSideMenuBG.alpha = 1.0
        }
    }
    
    @IBAction func btnCloseSettingsAction(_ sender:UIButton){
        self.constSettingsLeadingSpace.constant = -320
        UIView.animate(withDuration: 0.25) {
            self.view.layoutIfNeeded()
            self.viewForSideMenuBG.alpha = 0.0
        }
    }
    
    @IBAction func btnAddDeviceAction(_ sender:UIButton){
        self.view.endEditing(true)
        if !self.isDeviceAdded{
            if (txtDeviceName.text?.trimmingCharacters(in: .whitespaces).isEmpty)!{
                AppValidation().showAlertView(parentVC: self, withAlertTile: AppConstants.GlobalAlert.ALERT_TITLE, withAlertMsg:  AppConstants.GlobalAlert.ALERT_ENTER_DEVICENAME, withActionsTitle: [AppConstants.GlobalAlert.ALERT_BTN_OK]) { (index) in
                    _ = self.txtDeviceName.becomeFirstResponder()
                }
            }else{
                CallAddDevice()
            }
        }else{
            CallValidateDeviceAPI()
        }
    }
    
    @IBAction func btnLogoutAction(_ sender:UIButton){
        var setting = AlertSetting()
        setting.alertMessage = AppConstants.GlobalAlert.kAdminLogout
        setting.alertTitle = AppConstants.GlobalAlert.ALERT_BTN_LOGOUT.capitalized
        setting.confirmTitle = AppConstants.GlobalAlert.ALERT_BTN_LOGOUT
        setting.cancelTitle = AppConstants.GlobalAlert.ALERT_BTN_CANCEL
        setting.confirmBGColor = AppConstants.Colors.kAppDarkGrayColor
        setting.cancelBGColor = AppConstants.Colors.kAppLightGrayColor
        if let VC = AlertViewController.showPopup(parentVC: self, setting: setting){
            VC.delegate = self
        }
    }
    
    @IBAction func switchLoginChanged(_ sender:UISwitch){
        let user = arrUsers[sender.tag]
        if user.isLoggin == 1{
            AppValidation().showAlertView(parentVC: self, withAlertTile: AppConstants.GlobalAlert.ALERT_BTN_LOGOUT, withAlertMsg: "Are you sure you want to log out? Please confirm, as you may be logged in with another device.", withActionsTitle: [AppConstants.GlobalAlert.ALERT_BTN_CANCEL, "CONFIRM"]) { (index) in
                if index == 1{
                    let dictParam = [String:String]()
                    AppCommonMethods.startProgressBar()
                    WebServiceManager().requestAPI(params: dictParam, urlString: "\(AppConstants.APIURL.kUser)\(user.id ?? 0)/logout", method: "GET", isAdminURL: true, saveAdminToken: false) { (message, result) in
                        DispatchQueue.main.async {
                            AppCommonMethods.stopProgressBar()
                            if let response = result as? NSDictionary{
                                let jsonDecoder = JSONDecoder()
                                if let data = AppCommonMethods.convertToJson(object: response), let _ = try? jsonDecoder.decode(UserModel.self, from: data){
                                    var settings = BottomAlertSettings()
                                    settings.strMessage = "User logged out successfully."
                                    AppValidation().showBottomAlertView(settings: settings)
                                    user.isLoggin = 0
                                    sender.isUserInteractionEnabled = false
                                    if let encoded = AppCommonMethods.getjsonDataFromCodable(object: user) {
                                        AppCommonMethods.saveDataIntoUserDefault(value: encoded, withKey: AppConstants.userDefaultKey.kUserList)
                                    }
                                    return
                                }
                            }
                            AppValidation().showAlertView(parentVC: self, withAlertTile: AppConstants.GlobalAlert.ALERT_TITLE, withAlertMsg: message, withActionsTitle: [AppConstants.GlobalAlert.ALERT_BTN_OK]) { (index) in
                                
                            }
                        }
                    }
                }else{
                    sender.isOn = true
                }
            }
        }
    }
    
    //MARK: General Methods
    func gotoNextPage(){
        AppCommonMethods.getSiteSettings()
        AppConstants.arrDepositType = CoreDataHelper.shared.fetchDepositTypeData()
        AppConstants.arrOrderStatuses = SQLiteManage.fetchOrderStatusesData()
        AppConstants.arrOrderTypes = SQLiteManage.fetchOrderTypesData()
        if let topVC = UIApplication.topViewController(){
            if !(topVC is ForceFullyUpdateVC){
                let selectedPrinter = AppConstants.businessData?.printers?.filter({ (model) -> Bool in
                    return model.isDefault ?? 0 == 1
                }).first
                if selectedPrinter != nil{
                    if let encoded = AppCommonMethods.getjsonDataFromCodable(object: selectedPrinter!) {
                        AppCommonMethods.saveDataIntoUserDefault(value: encoded, withKey: AppConstants.userDefaultKey.kSelectedPrinter)
                    }
                }
                SocketService.shared?.startSocket()
                if let VC = SideMenuVC.instance(){
                    let navc = UINavigationController.init(rootViewController: VC)
                    navc.isNavigationBarHidden = true
                    AppCommonMethods.appDelegate.window!.rootViewController = navc
                }
            }
        }
    }
    
    func AdminLogout(){
        Messaging.messaging().unsubscribe(fromTopic: "business_\(AppConstants.businessData?.id ?? 0)") { error in
            if error != nil{
                print("Error topic: \(error?.localizedDescription ?? "")")
            }else{
                print("Unsubscribed to topic")
            }
        }
        CoreDataHelper.shared.DeleteAdminData()
        AppCommonMethods.removefromUserDefault(withKey: AppConstants.userDefaultKey.kBusinessData)
        AppCommonMethods.removefromUserDefault(withKey: AppConstants.userDefaultKey.kUserData)
        AppCommonMethods.removefromUserDefault(withKey: AppConstants.userDefaultKey.kHeaderToken)
        AppCommonMethods.removefromUserDefault(withKey: AppConstants.userDefaultKey.kRefreshHeaderToken)
        AppCommonMethods.removefromUserDefault(withKey: AppConstants.userDefaultKey.kAdminHeaderToken)
        AppCommonMethods.removefromUserDefault(withKey: AppConstants.userDefaultKey.kAdminRefreshHeaderToken)
        AppCommonMethods.removefromUserDefault(withKey: AppConstants.userDefaultKey.kAdminUserData)
        if let VC = AdminLoginVC.instance(){
            let navc = UINavigationController.init(rootViewController: VC)
            navc.isNavigationBarHidden = true
            AppConstants.appDelegate.window?.rootViewController = navc
        }
    }
    
    //MARK:  WebService Methods
    func FetchSiteSettings(shouldGetData:Bool = true){
        if Reachabilities.shared.isConnectedToNetwork(){
            AppCommonMethods.startProgressBar()
            AppCommonMethods.getRestaurantDetails { (status) in
                
            }
            AppCommonMethods.FetchOrderType {
                
            }
            if shouldGetData{
                AppCommonMethods.FetchOrderStatus()
                AppCommonMethods.FetchDeposits()
                AppCommonMethods.FetchTableStatus()
                AppCommonMethods.FetchAutoDiscount()
            }
        }
        if AppConstants.userData == nil{
            self.FetchUserListAPI()
            viewForDevice.isHidden = true
        }else{
            AppCommonMethods.startProgressBar(view: self.view)
            AppCommonMethods.FetchOrdersList{
                DispatchQueue.main.async {
                    AppCommonMethods.stopProgressBar(view: self.view)
                    self.gotoNextPage()
                }
            }
        }
    }
    
    func CallLoginAPI(){
        if Reachabilities.shared.isConnectedToNetwork(){
            var dictParam = [String:String]()
            dictParam["username"] = txtUserName.text ?? ""
            dictParam["password"] = txtPassword.text ?? ""
            dictParam["mode"] = self.selectedMode.lowercased()
            AppCommonMethods.startProgressBar()
            WebServiceManager().requestAPI(params: dictParam, urlString: "\(AppConstants.APIURL.kUser)\(selectedUser?.id ?? 0)/login", method: "POST", isAdminURL: true, saveAdminToken: false) { (message, result) in
                DispatchQueue.main.async {
                    AppCommonMethods.stopProgressBar()
                    if let response = result as? NSDictionary{
                        let jsonDecoder = JSONDecoder()
                        if let data = AppCommonMethods.convertToJson(object: response), let aLoginData = try? jsonDecoder.decode(UserModel.self, from: data){
                            if let encoded = AppCommonMethods.getjsonDataFromCodable(object: aLoginData) {
                                AppCommonMethods.saveDataIntoUserDefault(value: encoded, withKey: AppConstants.userDefaultKey.kUserData)
                            }
                            AppCommonMethods.saveDataIntoUserDefault(value: Int(Date().timeIntervalSince1970), withKey: AppConstants.userDefaultKey.kLoginTimeStamp)
                            AppCommonMethods.FetchUserProfile()
                            AppCommonMethods.startProgressBar(view: self.view,strMessage: "Fetching Order...")
                            AppCommonMethods.FetchOrdersList{
                                DispatchQueue.main.async {
                                    AppCommonMethods.stopProgressBar(view: self.view)
                                    self.gotoNextPage()
                                }
                            }
                            return
                        }
                    }
                    self.txtPassword.text = ""
                    AppValidation().showAlertView(parentVC: self, withAlertTile: AppConstants.GlobalAlert.ALERT_TITLE, withAlertMsg: message, withActionsTitle: [AppConstants.GlobalAlert.ALERT_BTN_OK]) { (index) in
                        
                    }
                }
            }
        }else{
            let user = arrUsers.filter { (model) -> Bool in
                return (model.username ?? "" == txtUserName.text ?? "") && (model.password ?? "" == txtPassword.text ?? "")
            }
            if user.count > 0{
                AppCommonMethods.saveDataIntoUserDefault(value: Int(Date().timeIntervalSince1970), withKey: AppConstants.userDefaultKey.kLoginTimeStamp)
                if let encoded = AppCommonMethods.getjsonDataFromCodable(object: user[0]) {
                    AppCommonMethods.saveDataIntoUserDefault(value: encoded, withKey: AppConstants.userDefaultKey.kUserData)
                }
                self.gotoNextPage()
            }else{
                AppValidation().showAlertView(parentVC: self, withAlertTile: AppConstants.GlobalAlert.ALERT_TITLE, withAlertMsg: AppConstants.GlobalAlert.kInvalidLogin, withActionsTitle: [AppConstants.GlobalAlert.ALERT_BTN_OK]) { (index) in
                    
                }
            }
        }
        
    }
    
    func FetchUserListAPI(){
        self.arrUsers = AppConstants.arrUserList ?? [UserModel]()
        self.tblUsers.reloadData()
        var dictParam = [String:String]()
        dictParam["nopaginate"] = "1"
        AppCommonMethods.startProgressBar()
        WebServiceManager().requestAPI(params: dictParam, urlString: AppConstants.APIURL.kUserList, method: "GET", isAdminURL: true, saveAdminToken: true) { (message, result) in
            DispatchQueue.main.async {
                AppCommonMethods.stopProgressBar()
                if let response = result as? [NSDictionary]{
                    let jsonDecoder = JSONDecoder()
                    if let data = AppCommonMethods.convertToJson(object: response), let aData = try? jsonDecoder.decode([UserModel].self, from: data){
                        self.arrUsers = aData
                        if let encoded = AppCommonMethods.getjsonDataFromCodable(object: aData) {
                            AppCommonMethods.saveDataIntoUserDefault(value: encoded, withKey: AppConstants.userDefaultKey.kUserList)
                        }
                        self.tblUsers.reloadData()
                        return
                    }
                }
            }
        }
    }
    
    func CallValidateDeviceAPI(){
        if !Reachabilities.shared.isConnectedToNetwork(){
            if AppConstants.deviceApproves{
                if AppConstants.userData == nil{
                    viewForDevice.isHidden = true
                    self.arrUsers = AppConstants.arrUserList ?? [UserModel]()
                    self.tblUsers.reloadData()
                    if self.arrUsers.count == 0 || CoreDataHelper.shared.numberOfRowOfEntity(name: "Product") ?? 0 == 0{
                        AppValidation().showAlertView(parentVC: self, withAlertTile: AppConstants.GlobalAlert.ALERT_TITLE, withAlertMsg: AppConstants.GlobalAlert.kNoInternetMsg, withActionsTitle: [AppConstants.GlobalAlert.ALERT_BTN_OK]) { (index) in
                            
                        }
                    }
                }else{
                    if CoreDataHelper.shared.numberOfRowOfEntity(name: "Product") ?? 0 == 0{
                        AppValidation().showAlertView(parentVC: self, withAlertTile: AppConstants.GlobalAlert.ALERT_TITLE, withAlertMsg: AppConstants.GlobalAlert.kNoInternetMsg, withActionsTitle: [AppConstants.GlobalAlert.ALERT_BTN_OK]) { (index) in
                            
                        }
                    }else{
                        self.gotoNextPage()
                    }
                }
            }else{
                self.isDeviceAdded = true
                viewForDevice.isHidden = false
                self.viewForDevice.isHidden = false
                self.btnAddDevice.superview?.superview?.isHidden = false
                self.btnAddDevice.setTitle("Refresh", for: .normal)
                self.lblDeviceMessage.superview?.isHidden = false
                self.lblDeviceMessage.text = "\(AppConstants.GlobalAlert.kNoInternetMsg) and try again later"
            }
            return
        }
        AppCommonMethods.startProgressBar()
        if let udid = AppCommonMethods.getUUID(){
            var dictParam = [String:String]()
            if AppConstants.FCMToken ?? "" != ""{
                dictParam["device_token"] = AppConstants.FCMToken ?? ""
            }
            WebServiceManager().requestAPI(params: dictParam, urlString: "\(AppConstants.APIURL.kValidateDevice)\(udid)", method: "POST", isAdminURL: true, saveAdminToken: true) { (message, result) in
                DispatchQueue.main.async {
                    self.isDeviceAdded = false
                    AppCommonMethods.stopProgressBar()
                    AppCommonMethods.saveDataIntoUserDefault(value: 0, withKey: AppConstants.userDefaultKey.kDeviceApproved)
                    if let data = result as? NSDictionary{
                        AppCommonMethods.saveDataIntoUserDefault(value: data.getIntValue("id") ?? 0, withKey: AppConstants.userDefaultKey.kDeviceId)
                        AppCommonMethods.saveDataIntoUserDefault(value: data.getStringValue("name") ?? "", withKey: AppConstants.userDefaultKey.kDeviceName)
                        if let status = data.getStringValue("status"){
                            self.isDeviceAdded = true
                            if status == "Approved"{
                                AppCommonMethods.saveDataIntoUserDefault(value: 1, withKey: AppConstants.userDefaultKey.kDeviceApproved)
                                if CoreDataHelper.shared.numberOfRowOfEntity(name: "Product") ?? 0 == 0{
                                    AppCommonMethods.startProgressBar(view: self.view,strMessage: "Pulling data\nfrom server...")
                                    AppCommonMethods.PullDataFromServer{
                                        AppCommonMethods.changeProgressMessage(msg: "Fetching customers...")
                                        AppCommonMethods.PullCustomerFromServer {
                                            DispatchQueue.main.async {
                                                AppCommonMethods.stopProgressBar(view: self.view)
                                                self.FetchSiteSettings(shouldGetData: false)
                                            }
                                        }
                                        self.siteSettingsFetched()
                                    }
                                }else{
                                    self.FetchSiteSettings(shouldGetData: false)
                                }
                                
                            }else{
                                self.viewForDevice.isHidden = false
                                self.btnAddDevice.superview?.superview?.isHidden = false
                                self.btnAddDevice.setTitle("Refresh", for: .normal)
                                self.lblDeviceMessage.superview?.isHidden = false
                                self.lblDeviceMessage.text = "Your device \(data.getStringValue("name") ?? "") is not approved yet, Please contact to service provider to approve your device"
                            }
                            return
                        }
                    }
                    self.viewForDevice.isHidden = false
                    self.btnAddDevice.superview?.superview?.isHidden = false
                    self.lblDeviceMessage.superview?.isHidden = false
                    self.txtDeviceName.superview?.superview?.isHidden = false
                    self.lblDeviceMessage.text = "Please submit your device name and contact to service provider to approve your device"
                }
            }
        }
    }
    
    func CallAddDevice(){
        if let udid = AppCommonMethods.getUUID(){
            var dictParam = [String:String]()
            dictParam["device_id"] = udid
            dictParam["device_type"] = "iOS"
            dictParam["service_type"] = "EPOS"
            dictParam["name"] = txtDeviceName.text ?? ""
            dictParam["business_id"] = "\(AppConstants.businessData?.id ?? 0)"
            AppCommonMethods.startProgressBar()
            WebServiceManager().requestAPI(params: dictParam, urlString: AppConstants.APIURL.kAddDevice, method: "POST", isAdminURL: true, saveAdminToken: true) { (message, result) in
                DispatchQueue.main.async {
                    AppCommonMethods.stopProgressBar()
                    if let data = result as? NSDictionary{
                        if let _ = data.getStringValue("status"){
                            self.isDeviceAdded = true
                            self.btnAddDevice.setTitle("Refresh", for: .normal)
                            self.lblDeviceMessage.text = "Your device \(self.txtDeviceName.text ?? "") is submitted, Please contact to service provider to approve your device"
                            self.txtDeviceName.superview?.superview?.isHidden = true
                            return
                        }
                    }
                    AppValidation().showAlertView(parentVC: self, withAlertTile: AppConstants.GlobalAlert.ALERT_TITLE, withAlertMsg: message, withActionsTitle: [AppConstants.GlobalAlert.ALERT_BTN_OK]) { (index) in
                        
                    }
                }
            }
        }
    }
}

//MARK:  UITableViewDataSource
extension LoginVC:UITableViewDelegate,UITableViewDataSource{
    func tableView(_ tableView: UITableView, numberOfRowsInSection section: Int) -> Int {
        if tableView == tblSettings{
            return arrSettings.count
        }
        return arrUsers.count
    }
    
    func tableView(_ tableView: UITableView, cellForRowAt indexPath: IndexPath) -> UITableViewCell {
        if tableView == tblSettings{
            let cell = tableView.dequeueReusableCell(withIdentifier: "PaymentDashboardCell", for: indexPath) as! PaymentDashboardCell
            cell.lblTitle.text = arrSettings[indexPath.row].title
            return cell
        }
        let cell = tableView.dequeueReusableCell(withIdentifier: "UsersListCell", for: indexPath) as! UsersListCell
        cell.lblUsers.text = arrUsers[indexPath.row].username ?? ""
        cell.btnUser.tag = indexPath.row
        cell.switchLogin.tag = indexPath.row
        if selectedUser?.id ?? 0 == arrUsers[indexPath.row].id ?? 0{
            cell.lblUsers.superview?.backgroundColor = AppConstants.Colors.kAppThemeAquaColor
            cell.lblUsers.textColor = .white
        }else{
            cell.lblUsers.superview?.backgroundColor = .white
            cell.lblUsers.textColor = AppConstants.Colors.kAppThemeTextColor
        }
        cell.switchLogin.isOn = arrUsers[indexPath.row].isLoggin == 1
        cell.switchLogin.isUserInteractionEnabled = arrUsers[indexPath.row].isLoggin == 1
        return cell
    }
    
    func tableView(_ tableView: UITableView, didSelectRowAt indexPath: IndexPath) {
        if tableView == tblSettings{
            selectedSetting = arrSettings[indexPath.row].type
            if selectedSetting == .kOrderSyncMode{
                if let VC = CancelReasonVC.showPopup(parentVC: self, viewType: .kOrderSyncType){
                    VC.delegate = self
                }
            }else if selectedSetting == .kRemoteDevice{
                if let VC = CancelReasonVC.showPopup(parentVC: self, viewType: .kRemoteDevice){
                    VC.delegate = self
                }
            }else if selectedSetting == .kChangeBusiness{
                Messaging.messaging().unsubscribe(fromTopic: "business_\(AppConstants.businessData?.id ?? 0)") { error in
                    if error != nil{
                        print("Error topic: \(error?.localizedDescription ?? "")")
                    }else{
                        print("Unsubscribed to topic")
                    }
                }
                if let VC = SelectBusinessVC.instance(){
                    let navc = UINavigationController.init(rootViewController: VC)
                    navc.isNavigationBarHidden = true
                    AppConstants.appDelegate.window?.rootViewController = navc
                }
            }
        }
    }
}

//MARK:  UITextFieldDelegate
extension LoginVC:UITextFieldDelegate{
    func textField(_ textField: UITextField, shouldChangeCharactersIn range: NSRange, replacementString string: String) -> Bool {
        let allowedCharacters = CharacterSet(charactersIn:"0123456789")
        let characterSet = CharacterSet(charactersIn: string)
        return allowedCharacters.isSuperset(of: characterSet)
    }
    
    func textFieldShouldReturn(_ textField: UITextField) -> Bool {
        if textField == txtPassword{
            btnLoginAction(UIButton())
        }
        return textField.resignFirstResponder()
    }
}

//MARK:  AlertControllerDelegate
extension LoginVC:AlertControllerDelegate{
    func alertButtonAction(index: Int, data: alertViewData, type: AlertType) {
        if index == 1{
            if type == .kRejectOrder{
                var setting = AlertSetting()
                setting.alertTitle = AppConstants.GlobalAlert.ALERT_ENTER_PASSWORD
                setting.alertMessage = (selectedSetting != .kRemoteDevice) ? AppConstants.GlobalAlert.ALERT_ENTER_PASSWORD_SYNCMODE : AppConstants.GlobalAlert.ALERT_ENTER_PASSWORD_REMOTE
                setting.cancelBGColor = AppConstants.Colors.kAppMediumGrayColor
                setting.confirmBGColor = AppConstants.Colors.kAppDarkGrayColor
                setting.textPlcaeholder = "password"
                setting.type = .kEnterEPOSPassword
                setting.textType = .default
                if let VC = AlertViewController.showPopup(parentVC: self, setting: setting){
                    VC.delegate = self
                }
                selectedMode = data.value
            }else if type == .kEnterEPOSPassword{
                if selectedSetting != .kRemoteDevice{
                    AppCommonMethods.showToastAlert(message: AppConstants.GlobalAlert.ALERT_SYNCMODE_CHANGE)
                    AppCommonMethods.saveDataIntoUserDefault(value: selectedMode, withKey: AppConstants.userDefaultKey.kDataSyncMode)
                    btnCloseSettingsAction(UIButton())
                }else{
                    AppCommonMethods.showToastAlert(message: (selectedMode  == "Yes") ? AppConstants.GlobalAlert.ALERT_REMOTE_ON : AppConstants.GlobalAlert.ALERT_REMOTE_OFF)
                    AppCommonMethods.saveDataIntoUserDefault(value: selectedMode, withKey: AppConstants.userDefaultKey.kRemoteDevice)
                    btnCloseSettingsAction(UIButton())
                }
            }else{
                let predicate = NSPredicate.init(format: "is_update == 1 AND business_id == %d", AppConstants.businessData?.id ?? 0)
                let orderCount = SQLiteManage.fetchCountOfTable(whereString: "WHERE is_update = \(1) AND business_id = \(AppConstants.businessData?.id ?? 0)", tableName: "Orders")
                let reservationCount = CoreDataHelper.shared.numberOfRowOfEntity(name: "Reservations",predict: predicate) ?? 0
                if orderCount > 0 || reservationCount > 0{
                    if Reachabilities.shared.isConnectedToNetwork(){
                        AppCommonMethods.startProgressBar(strMessage: "Pushing data\nto the server...")
                        BGAPIExecution.shared.allDataPushed = {
                            DispatchQueue.main.async {
                                AppCommonMethods.stopProgressBar()
                                self.AdminLogout()
                            }
                        }
                        BGAPIExecution.shared.fetchAllOfflineOrders()
                    }else{
                        AppCommonMethods.showToastAlert(message: AppConstants.GlobalAlert.ALERT_PUSHORDER_LOGOUT)
                    }
                    return
                }
                self.AdminLogout()
            }
        }
    }
}
