//
//  DineInTableVC.swift
//  EPOS
//
//  Created by Apple on 03/03/21.
//

import UIKit
import CoreData

//MARK: Table Collection Cell
class TableListCell:UICollectionViewCell, UICollectionViewDelegate, UICollectionViewDataSource, UICollectionViewDelegateFlowLayout{
    
    @IBOutlet weak var collectionTable:UICollectionView!
    var arrTables = [TableModel]()
    var parentVC:UIViewController!
    
    override class func awakeFromNib() {
        
    }
    
    func collectionView(_ collectionView: UICollectionView, numberOfItemsInSection section: Int) -> Int {
        return arrTables.count
    }
    
    func collectionView(_ collectionView: UICollectionView, cellForItemAt indexPath: IndexPath) -> UICollectionViewCell {
        let cell = collectionView.dequeueReusableCell(withReuseIdentifier: "TablesViewCell", for: indexPath) as! TablesViewCell
        let model = arrTables[indexPath.row]
        cell.btnMarkServed.tag = indexPath.row
        cell.lblTitle.text = model.tableStatus?.status ?? ""
        cell.btnMarkServed.isHidden = true
        cell.lblTableNo.text = model.number ?? ""
        if let _ = parentVC as? HomeViewController{
            cell.imgStatus.superview?.isHidden = true
            cell.lblTime.transform = CGAffineTransform(rotationAngle: CGFloat.pi / 2)
        }
        if (model.tableStatus?.status ?? "").lowercased() != "vacant"{
            cell.lastOrderTime = Int(model.lastOrderTime?.getDateFromString(format: "yyyy-MM-dd'T'HH:mm:ss.SSSSSS'Z'")?.timeIntervalSince1970 ?? 0)
            if let _ = self.parentVC as? DineInTableVC{
                cell.lblTotalOrder.text = String.init(format: "Total: %@%.2f", AppConstants.currencySign, model.lastOrderTotal ?? 0)
                if (model.tableStatus?.status ?? "").lowercased() == "merged"{
                    cell.lastOrderTime = nil
                    if let table = SQLiteManage.fetchTableDataFromId(id: model.mergeTableId){
                        cell.lblTitle.text = "Merged with \(table.number ?? "")"
                    }
                    cell.lblTotalOrder.text = ""
                    cell.btnMarkServed.isHidden = true
                }else if (model.tableStatus?.status ?? "").lowercased() == "served and paid"{
                    cell.btnMarkServed.isHidden = false
                    cell.btnMarkServed.setTitle("Mark as vacant", for: .normal)
                }else if (model.tableStatus?.status ?? "").lowercased() == "order taken"{
                    cell.btnMarkServed.isHidden = false
                    cell.btnMarkServed.setTitle("Mark as served", for: .normal)
                }else if (model.tableStatus?.status ?? "").lowercased() == "taking order"{
                    if AppConstants.userData?.permissions?.cancelOrder?.actions?.list ?? 0 == 1{
                        cell.btnMarkServed.isHidden = false
                        cell.btnMarkServed.setTitle("Cancel order", for: .normal)
                    }
                }else if (model.tableStatus?.status ?? "").lowercased() == "served"{
                    cell.btnMarkServed.isHidden = false
                    cell.btnMarkServed.setTitle("Pay order", for: .normal)
                }
                
            }else if let _ = self.parentVC as? HomeViewController{
                cell.imgStatus.superview?.isHidden = true
                if (model.tableStatus?.status ?? "").lowercased() == "merged"{
                    cell.lastOrderTime = nil
                    if let table = SQLiteManage.fetchTableDataFromId(id: model.mergeTableId){
                        cell.lblTitle.text = "Merged with \(table.number ?? "")"
                    }
                    cell.btnMarkServed.isHidden = true
                    cell.imgStatus.superview?.isHidden = true
                }else if (model.tableStatus?.status ?? "").lowercased() == "served and paid"{
                    cell.btnMarkServed.isHidden = false
                    cell.imgStatus.superview?.isHidden = false
                    cell.imgStatus.image = UIImage.init(named: "ic_selected_green")?.sd_tintedImage(with: AppConstants.Colors.kAppThemeTextColor)
                }else if (model.tableStatus?.status ?? "").lowercased() == "order taken"{
                    cell.btnMarkServed.isHidden = false
                    cell.imgStatus.superview?.isHidden = false
                    cell.imgStatus.image = UIImage.init(named: "serving-dish")
                }else if (model.tableStatus?.status ?? "").lowercased() == "taking order"{
                    if AppConstants.userData?.permissions?.cancelOrder?.actions?.list ?? 0 == 1{
                        cell.btnMarkServed.isHidden = false
                        cell.imgStatus.superview?.isHidden = false
                        cell.imgStatus.image = UIImage.init(named: "ic_close")
                    }
                }else if (model.tableStatus?.status ?? "").lowercased() == "served"{
                    cell.btnMarkServed.isHidden = false
                    cell.imgStatus.superview?.isHidden = false
                    cell.imgStatus.image = UIImage.init(named: "ic_cash")
                }
            }
        }else{
            cell.lastOrderTime = nil
            if let _ = parentVC as? DineInTableVC{
                cell.lblTotalOrder.text = ""
            }
        }
        cell.setTimer()
        cell.viewForBG.firstColor = UIColor.hexStr(hexStr: model.tableStatus?.topColor ?? "", alpha: 1)
        cell.viewForBG.secondColor = UIColor.hexStr(hexStr: model.tableStatus?.bottomColor ?? "", alpha: 1)
        return cell
    }
    
    func collectionView(_ collectionView: UICollectionView, didSelectItemAt indexPath: IndexPath) {
        let isDineIN = AppConstants.arrOrderTypes.contains { (model) -> Bool in
            return model.id ?? 0 == 1
        }
        if isDineIN{
            let table = arrTables[indexPath.row]
            if table.locked && AppConstants.userData?.id ?? 0 != table.updaterId{
                AppCommonMethods.showToastAlert(message: AppConstants.GlobalAlert.ALERT_TABLE_BUSY)
            }else{
                if (table.tableStatus?.status ?? "").lowercased() == "merged"{
                    if let mergeTable = SQLiteManage.fetchTableDataFromId(id: table.mergeTableId){
                        AppValidation().showAlertView(parentVC: self.parentVC, withAlertTile: "Merged", withAlertMsg: "\(table.number ?? "") merged with \(mergeTable.number ?? "")", withActionsTitle: ["Okay", "Vacant"]) { index in
                            if index == 1{
                                SQLiteManage.updateTableStatus(tableId: table.id ?? 0, status: "Vacant")
                                AppCommonMethods.SaveTable(table: table, status: "Vacant")
                                if let parentVC = self.parentVC as? DineInTableVC{
                                    parentVC.FetchFloorListFromDB()
                                }else if let parentVC = self.parentVC as? HomeViewController{
                                    parentVC.FetchFloorListFromDB()
                                }
                            }
                        }
                    }
                }else if table.lastOrderId ?? 0 == 0 || (table.tableStatus?.status ?? "").lowercased() == "vacant"{
                    if let parentVC = self.parentVC as? DineInTableVC{
                        if let VC = NewDineInOrderVC.showPopup(parentVC: parentVC.parentVC, table: table){
                            VC.delegate = parentVC
                        }
                    }else if let parentVC = self.parentVC as? HomeViewController{
                        if let VC = NewDineInOrderVC.showPopup(parentVC: parentVC.parentVC, table: table){
                            VC.delegate = parentVC
                        }
                    }
                }else{
                    if let parentVC = self.parentVC as? HomeViewController{
                        parentVC.goToOrderView(table: table)
                        return
                    }
                    if let _ = SQLiteManage.fetchOrderDataById(orderId: table.lastOrderId ?? 0){
                        if let VC = CreateOrderVC.instance(){
                            VC.selectedTable = table
                            let arr = AppConstants.arrOrderTypes.filter({ model in
                                return model.id ?? 0 == 1
                            })
                            if arr.count > 0{
                                VC.orderType = arr[0]
                            }
                            VC.orderId = table.lastOrderId ?? 0
                            if let parentVC = self.parentVC as? DineInTableVC{
                                parentVC.parentVC.navigationController?.pushViewController(VC, animated: true)
                            }else if let parentVC = self.parentVC as? HomeViewController{
                                parentVC.parentVC.navigationController?.pushViewController(VC, animated: true)
                            }
                        }
                    }else{
                        if let parentVC = self.parentVC as? DineInTableVC{
                            parentVC.FetchOrderDetail(table: table)
                        }else if let parentVC = self.parentVC as? HomeViewController{
                            parentVC.FetchOrderDetail(table: table)
                        }
                    }
                }
            }
        }
    }
    
    func nearestEqualWidth()->CGFloat{
        let width = self.contentView.frame.width
        let cellWidth = width/round(width/210)
        return floor(cellWidth)
    }
    
    func collectionView(_ collectionView: UICollectionView, layout collectionViewLayout: UICollectionViewLayout, sizeForItemAt indexPath: IndexPath) -> CGSize {
        if let _ = self.parentVC as? HomeViewController{
            return CGSize.init(width: nearestEqualWidth(), height: (AppConstants.ScreenSize.SCREEN_WIDTH > 1024) ? 95 : 85)
        }
        var itemWidth = self.contentView.frame.width/3
        if AppConstants.ScreenSize.SCREEN_HEIGHT >= 1024{
            itemWidth = self.contentView.frame.width/4
        }
        if itemWidth > 0{
            return CGSize.init(width: itemWidth, height: 180)
        }
        return CGSize.zero
    }
}

//MARK: Dine in Table Class
class DineInTableVC: UIViewController {

    //MARK:  IBOutlets
    @IBOutlet weak var collectionFloor:UICollectionView!
    @IBOutlet weak var collectionTable:UICollectionView!
    @IBOutlet weak var constFloorWidth:NSLayoutConstraint!
    
    //MARK:  Instances
    var arrFloors = [FloorModel]()
    var selectedFloorIndex = 0
    var parentVC:SideMenuVC!
    var selectedTable:TableModel!
    
    //MARK:  ViewController LifeCycle
    override func viewDidLoad() {
        super.viewDidLoad()

        // Do any additional setup after loading the view.
        reloadPageDate()
    }
    
    override func viewWillAppear(_ animated: Bool) {
        NotificationCenter.default.addObserver(self, selector: #selector(reloadPageDate), name: AppConstants.notifications.kDatabasePushed, object: nil)
        self.collectionTable.reloadData()
    }
    
    override func viewWillDisappear(_ animated: Bool) {
        NotificationCenter.default.removeObserver(self, name: AppConstants.notifications.kDatabasePushed, object: nil)
    }
    
    override func viewDidLayoutSubviews() {
        DispatchQueue.main.async {
            self.collectionTable.reloadData()
            let width = self.view.frame.width - 28
            self.collectionTable.contentOffset = CGPoint.init(x: width*CGFloat(self.selectedFloorIndex), y: 0)
        }
    }
    
    //MARK: Create ViewController Instance
    static func addToParentView(parentVC:SideMenuVC)->DineInTableVC?{
        guard let VC = UIStoryboard.init(name: "Main", bundle: nil).instantiateViewController(withIdentifier: "DineInTableVC") as? DineInTableVC else {
            return nil
        }
        VC.parentVC = parentVC
        parentVC.addChild(VC)
        parentVC.viewForContainer.addSubview(VC.view)
        VC.view.frame = CGRect.init(x: 0, y: 0, width: parentVC.viewForContainer.frame.width, height: parentVC.viewForContainer.frame.height)
        return VC
    }

    //MARK:  Button Actions
    @IBAction func btnRefreshAction(_ sender:UIButton){
        reloadPageDate()
    }

    @IBAction func btnMarkServedAction(_ sender:UIButton){
        if let table = arrFloors[selectedFloorIndex].tableData?[sender.tag]{
            if table.locked{
                AppCommonMethods.showToastAlert(message: AppConstants.GlobalAlert.ALERT_TABLE_BUSY)
                return
            }
            
            if (table.tableStatus?.status ?? "").lowercased() == "order taken"{
                if let status = CoreDataHelper.shared.fetchTableStatusData(name: "served").first{
                    AppCommonMethods.SaveTable(table: table, statusId: status.id)
                    table.tableStatusId = status.id ?? 0
                    SQLiteManage.updateTableStatus(tableId: table.id ?? 0, statusId: status.id)
                }else{
                    AppCommonMethods.showToastAlert(message: AppConstants.GlobalAlert.ALERT_NO_TABLESTATUS)
                }
            }else if (table.tableStatus?.status ?? "").lowercased() == "taking order"{
                var setting = AlertSetting()
                setting.alertMessage = AppConstants.GlobalAlert.ALERT_CANCEL_ORDER
                setting.alertTitle = AppConstants.GlobalAlert.ALERT_CANCEL_ORDER_TITLE
                if let VC = AlertViewController.showPopup(parentVC: self.parentVC, setting: setting){
                    VC.delegate = self
                }
                selectedTable = table
            }else{
                if let model = SQLiteManage.fetchOrderDataById(orderId: table.lastOrderId ?? 0){
                    self.performOrderAction(table: table, order: model)
                }else{
                    self.FetchOrderDetail(table: table, isFromAction: true)
                }
            }
        }
        self.collectionTable.reloadData()
    }
    
    //MARK: General Methods
    func performOrderAction(table:TableModel, order:OrderModel){
        if (table.tableStatus?.status ?? "").lowercased() == "served"{
            if let VC = CreateOrderVC.instance(){
                VC.orderId = order.id ?? 0
                let arr = AppConstants.arrOrderTypes.filter({ model in
                    return model.id ?? 0 == 1
                })
                if arr.count > 0{
                    VC.orderType = arr[0]
                }
                VC.orderData = AppCommonMethods.Copy(of: order) ?? order
                if order.splitCount ?? 0 > 0 || self.checkOrderSplite(orderData: order){
                    if let VC = SplitOrderVC.instance(){
                        if arr.count > 0{
                            VC.orderType = arr[0]
                        }
                        VC.orderData = AppCommonMethods.Copy(of: order) ?? order
                        self.navigationController?.pushViewController(VC, animated: true)
                    }
                }else{
                    if let VC = OrderReviewVC.instance(){
                        if arr.count > 0{
                            VC.orderType = arr[0]
                        }
                        VC.selectedTable = table
                        VC.orderData = AppCommonMethods.Copy(of: order) ?? order
                        self.navigationController?.pushViewController(VC, animated: true)
                    }
                }
                self.navigationController?.viewControllers.insert(VC, at: self.navigationController!.viewControllers.count - 1)
            }
        }else{
            if Reachabilities.shared.isConnectedToNetwork() && AppConstants.DataSyncMode == "Auto"{
                if let status = CoreDataHelper.shared.fetchTableStatusData(name: "vacant").first{
                    //AppCommonMethods.startProgressBar()
                    AppCommonMethods.SaveTable(table: table, statusId: status.id)
                    order.orderStatusId = 5
                    table.tableStatusId = status.id ?? 0
                    order.table = table
                    SQLiteManage.updateTableStatus(tableId: table.id ?? 0, statusId: status.id, lastOrderId: 0, lastOrderTotal: 0, lastOrderTime: "", offline: 1)
                    BGAPIExecution.shared.orderSaved = { orderId, message in
                        DispatchQueue.main.async {
                            AppCommonMethods.stopProgressBar()
                            print("Order \(orderId) Saved To Server")
                            self.collectionTable.reloadData()
                        }
                    }
                    BGAPIExecution.shared.AddOrderToQueue(order: order)
                    self.collectionTable.reloadData()
                }else{
                    AppCommonMethods.showToastAlert(message: AppConstants.GlobalAlert.ALERT_NO_TABLESTATUS)
                }
            }else{
                if let status = CoreDataHelper.shared.fetchTableStatusData(name: "vacant").first{
                    AppCommonMethods.SaveTable(table: table, statusId: status.id)
                    table.tableStatusId = status.id ?? 0
                    order.orderStatusId = 5
                    SQLiteManage.updateTableStatus(tableId: table.id ?? 0, statusId: status.id, lastOrderId: 0, lastOrderTotal: 0, lastOrderTime: "", offline: 1)
                    SQLiteManage.SaveOrderIntoDatabase(order: order, updated: 1)
                }else{
                    AppCommonMethods.showToastAlert(message: AppConstants.GlobalAlert.ALERT_NO_TABLESTATUS)
                }
            }
        }
    }
    
    @objc func reloadPageDate(){
        FetchFloorList()
    }
    
    func calculateFloorWidth(){
        var width:CGFloat = 0
        for floor in arrFloors{
            width = (width + (floor.name ?? "").getStringWidth(font: AppConstants.GlobalFontConstants.kBoldFont(size: 18)) + 20)
        }
        let maxWidth = AppConstants.ScreenSize.SCREEN_WIDTH - 683
        if width > maxWidth{
            self.constFloorWidth.constant = maxWidth
            self.collectionFloor.isScrollEnabled = true
        }else{
            self.collectionFloor.isScrollEnabled = false
            self.constFloorWidth.constant = width
        }
    }
    
    func checkOrderSplite(orderData:OrderModel)->Bool{
        var isSplited = false
        for model in orderData.arrProducts{
            if model.orderSplitId ?? 0 != 0{
                isSplited = true
                break
            }
        }
        return isSplited
    }
    
    func FetchFloorList(){
        self.arrFloors = CoreDataHelper.shared.fetchFloorData()
        var arrFloorName = [String]()
        for model in self.arrFloors{
            arrFloorName.append(model.name ?? "")
        }
//        if self.arrFloors.count > selectedFloorIndex{
//            if Reachabilities.shared.isConnectedToNetwork(){
//                FetchTableList(floorData: arrFloors[selectedFloorIndex])
//            }
//        }else if self.arrFloors.count > 0{
//            selectedFloorIndex = 0
//            if Reachabilities.shared.isConnectedToNetwork(){
//                FetchTableList(floorData: arrFloors[0])
//            }
//        }
        self.collectionTable.reloadData()
        self.collectionFloor.reloadData()
        self.calculateFloorWidth()
    }
    
    //MARK: WebService  Methods
    func FetchTableList(floorData:FloorModel){
        let dictParam = [String:String]()
        WebServiceManager().requestAPI(params: dictParam, urlString: "\(AppConstants.APIURL.kFloorList)/\(floorData.id ?? 0)", method: "GET") { (message, result) in
            DispatchQueue.main.async {
                if let response = result as? NSDictionary{
                    let jsonDecoder = JSONDecoder()
                    if let arr = response["tables"] as? [NSDictionary], let data = AppCommonMethods.convertToJson(object: arr), let aData = try? jsonDecoder.decode([TableModel].self, from: data){
                        SQLiteManage.insertTable(arrData: aData, floorId: floorData.id)
                    }
                }
                self.collectionTable.reloadData()
            }
        }
    }
    
    func FetchTableDetail(tableId:Int){
        var dictParam = [String:String]()
        dictParam["nopaginate"] = "1"
        WebServiceManager().requestAPI(params: dictParam, urlString: "\(AppConstants.APIURL.kTables)\(tableId)", method: "GET") { (message, result) in
            DispatchQueue.main.async {
                let jsonDecoder = JSONDecoder()
                if let response = result as? NSDictionary, let data = AppCommonMethods.convertToJson(object: response), let aData = try? jsonDecoder.decode(TableModel.self, from: data){
                    SQLiteManage.updateTable(model: aData)
                }
                self.collectionTable.reloadData()
            }
        }
    }
    
    func FetchOrderDetail(table:TableModel, isFromAction:Bool = false){
        if table.lastOrderId == nil{
            AppCommonMethods.showToastAlert(message: AppConstants.GlobalAlert.ALERT_NO_ORDER)
            return
        }
        let dictParam = [String:String]()
        AppCommonMethods.startProgressBar()
        WebServiceManager().requestAPI(params: dictParam, urlString: "\(AppConstants.APIURL.kCreateOrder)/\(table.lastOrderId ?? 0)", method: "GET") { (message, result) in
                DispatchQueue.main.async {
                AppCommonMethods.stopProgressBar()
                if let response = result as? NSDictionary{
                    let jsonDecoder = JSONDecoder()
                    if let data = AppCommonMethods.convertToJson(object: response), let aData = try? jsonDecoder.decode(OrderModel.self, from: data){
                        SQLiteManage.SaveOrderIntoDatabase(order: aData, updated: 0)
                        if let model = SQLiteManage.fetchOrderDataById(orderId: table.lastOrderId ?? 0){
                            if isFromAction{
                                self.performOrderAction(table: table, order: model)
                            }else{
                                if let VC = CreateOrderVC.instance(){
                                    VC.selectedTable = table
                                    let arr = AppConstants.arrOrderTypes.filter({ model in
                                        return model.id ?? 0 == 1
                                    })
                                    if arr.count > 0{
                                        VC.orderType = arr[0]
                                    }
                                    VC.orderId = table.lastOrderId ?? 0
                                    self.navigationController?.pushViewController(VC, animated: true)
                                }
                            }
                        }
                        return
                    }
                }
                AppCommonMethods.showToastAlert(message: AppConstants.GlobalAlert.ALERT_NO_ORDER)
            }
        }
    }
    
    func FetchFloorListFromDB(){
        self.arrFloors = CoreDataHelper.shared.fetchFloorData()
        var arrFloorName = [String]()
        for model in self.arrFloors{
            arrFloorName.append(model.name ?? "")
        }
        self.collectionTable.reloadData()
        self.collectionFloor.reloadData()
        self.calculateFloorWidth()
    }
}

//MARK:  UICollectionViewDataSource
extension DineInTableVC: UICollectionViewDelegate, UICollectionViewDataSource, UICollectionViewDelegateFlowLayout{
    func collectionView(_ collectionView: UICollectionView, numberOfItemsInSection section: Int) -> Int {
        return arrFloors.count
    }
    
    func collectionView(_ collectionView: UICollectionView, cellForItemAt indexPath: IndexPath) -> UICollectionViewCell {
        if collectionView == collectionFloor{
            let cell = collectionView.dequeueReusableCell(withReuseIdentifier: "FloorViewCell", for: indexPath) as! FloorViewCell
            let model = arrFloors[indexPath.row]
            cell.lblFloorName.text = model.name ?? ""
            cell.lblFloorName.textColor = AppConstants.Colors.kAppLightGrayColor
            cell.lblFloorLine.backgroundColor = AppConstants.Colors.kAppLightGrayColor
            if model.id ?? 0 == arrFloors[selectedFloorIndex].id ?? 0{
                cell.lblFloorName.textColor = AppConstants.Colors.kAppThemeTextColor
                cell.lblFloorLine.backgroundColor = AppConstants.Colors.kAppThemeAquaColor
            }
            return cell
        }
        let cell = collectionView.dequeueReusableCell(withReuseIdentifier: "TableListCell", for: indexPath) as! TableListCell
        cell.parentVC = self
        cell.arrTables = SQLiteManage.fetchTableData(floorId: arrFloors[indexPath.row].id ?? 0)
        arrFloors[indexPath.row].tableData = cell.arrTables
        cell.collectionTable.reloadData()
        return cell
    }
    
    func collectionView(_ collectionView: UICollectionView, layout collectionViewLayout: UICollectionViewLayout, sizeForItemAt indexPath: IndexPath) -> CGSize {
        if collectionView == collectionFloor{
            let width = ((arrFloors[indexPath.row].name ?? "").getStringWidth(font: AppConstants.GlobalFontConstants.kBoldFont(size: 18)) + 20)
            return CGSize.init(width: width, height: 53)
        }
        return CGSize.init(width: self.view.frame.width - 28, height: AppConstants.ScreenSize.SCREEN_HEIGHT - 117)
    }
    
    func collectionView(_ collectionView: UICollectionView, didSelectItemAt indexPath: IndexPath) {
        if collectionView == collectionFloor{
            selectedFloorIndex = indexPath.row
            let width = self.view.frame.width - 28
            collectionTable.contentOffset = CGPoint.init(x: width*CGFloat(selectedFloorIndex), y: 0)
            collectionFloor.reloadData()
        }
    }
    
    func scrollViewDidScroll(_ scrollView: UIScrollView) {
        if scrollView == collectionTable{
            NSObject.cancelPreviousPerformRequests(withTarget: self, selector: #selector(setTableSelectionView), object: nil)
            self.perform(#selector(setTableSelectionView), with: nil, afterDelay: 0.1)
        }
    }
    
    @objc func setTableSelectionView(){
//        if Reachabilities.shared.isConnectedToNetwork(){
//            FetchTableList(floorData: arrFloors[self.collectionTable.currentPage-1])
//        }
        selectedFloorIndex = self.collectionTable.currentPage-1
        self.collectionFloor.reloadData()
    }
}

//MARK:  NewOrderDelegate
extension DineInTableVC:NewOrderDelegate{
    func orderTypeSelected(orderType: OrderTypesModel?) {
        
    }
    
    func requestForNewOrder(customer: CustomerModel, orderType: OrderTypesModel?, delivery: DeliveryChargeModel?, table: TableModel?, noOfGuest:Int?) {
        if let VC = CreateOrderVC.instance(){
            let index = AppConstants.arrOrderTypes.firstIndex { (model) -> Bool in
                return model.id ?? 0 == 1
            }
            if index != nil{
                VC.orderType = AppConstants.arrOrderTypes[index!]
                VC.selectedCustomer = customer
                VC.selectedTable = table!
                VC.noOfGuest = noOfGuest ?? 1
                self.navigationController?.pushViewController(VC, animated: true)
            }
        }
    }
}

//MARK:  AlertControllerDelegate
extension DineInTableVC:AlertControllerDelegate{
    func alertButtonAction(index: Int, data:alertViewData,type:AlertType) {
        if index == 1{
            if let model = SQLiteManage.fetchOrderDataById(orderId: selectedTable.lastOrderId ?? 0){
                if Reachabilities.shared.isConnectedToNetwork() && AppConstants.DataSyncMode == "Auto"{
                    if let status = CoreDataHelper.shared.fetchTableStatusData(name: "vacant").first{
                        //AppCommonMethods.startProgressBar()
                        model.orderStatusId = 10
                        AppCommonMethods.SaveTable(table: selectedTable, statusId: status.id ?? 0)
                        selectedTable.tableStatusId = status.id ?? 0
                        model.table = selectedTable
                        SQLiteManage.updateTableStatus(tableId: selectedTable.id ?? 0, statusId: status.id ?? 0, lastOrderId: 0, lastOrderTotal: 0, lastOrderTime: "", offline: 1)
                        BGAPIExecution.shared.orderSaved = { orderId, message in
                            DispatchQueue.main.async {
                                AppCommonMethods.stopProgressBar()
                                print("Order \(orderId) Saved To Server")
                                self.collectionTable.reloadData()
                            }
                        }
                        BGAPIExecution.shared.AddOrderToQueue(order: model)
                        self.collectionTable.reloadData()
                    }else{
                        AppCommonMethods.showToastAlert(message: AppConstants.GlobalAlert.ALERT_NO_TABLESTATUS)
                    }
                }else{
                    if let status = CoreDataHelper.shared.fetchTableStatusData(name: "vacant").first{
                        selectedTable.tableStatus = status
                        selectedTable.tableStatusId = status.id ?? 0
                        model.table = selectedTable
                        model.orderStatusId = 10
                        SQLiteManage.updateTableStatus(tableId: selectedTable.id ?? 0, statusId: status.id, lastOrderId: 0, lastOrderTotal: 0, lastOrderTime: "", offline: 1)
                        SQLiteManage.SaveOrderIntoDatabase(order: model, updated: 1)
                        AppCommonMethods.SaveTable(table: selectedTable, statusId: status.id)
                        self.collectionTable.reloadData()
                    }else{
                        AppCommonMethods.showToastAlert(message: AppConstants.GlobalAlert.ALERT_NO_TABLESTATUS)
                    }
                }
            }
        }
    }
}
