//
//  UserModel.swift
//  EPOS
//
//  Created by Apple on 09/04/21.
//

import Foundation
import CoreData

class UserModel:Codable{
    
    var id: Int?
    var username: String?
    var email: String?
    var password: String?
    var imageURL: String?
    var permissions: PermissionModel?
    var isLoggin = 0
    var preffix = ""
    
    enum CodingKeys: String, CodingKey {
        case id, username, email, password, permissions, preffix
        case imageURL = "image_url"
        case isLoggin = "is_loggin"
    }
    
    required init(from decoder: Decoder) throws {
        let values = try decoder.container(keyedBy: CodingKeys.self)
        username = values.getStringValue(key: CodingKeys.username)
        password = values.getStringValue(key: CodingKeys.password)
        id = values.getIntValue(key: CodingKeys.id)
        email = values.getStringValue(key: CodingKeys.email)
        imageURL = values.getStringValue(key: CodingKeys.imageURL)
        permissions = try? values.decode(PermissionModel.self, forKey: .permissions)
        isLoggin = values.getIntValue(key: CodingKeys.isLoggin) ?? 0
        preffix = values.getStringValue(key: CodingKeys.preffix) ?? ""
    }
}

class AdminModel:Codable{
    
    var id: Int?
    var firstName: String?
    var lastName: String?
    var arrBusiness: [BusinessModel]?
    var password: String?
    
    enum CodingKeys: String, CodingKey {
        case id, password
        case firstName = "first_name"
        case lastName = "last_name"
        case arrBusiness = "businesses"
    }
    
    required init(from decoder: Decoder) throws {
        let values = try decoder.container(keyedBy: CodingKeys.self)
        firstName = values.getStringValue(key: CodingKeys.firstName)
        id = values.getIntValue(key: CodingKeys.id)
        lastName = values.getStringValue(key: CodingKeys.lastName)
        password = values.getStringValue(key: CodingKeys.password)
        arrBusiness = try? values.decode([BusinessModel].self, forKey: .arrBusiness)
    }
}

class BusinessModel:Codable{
    
    var id: Int?
    var name: String?
    var stripeMode: String?
    var stripePrivateKeyLive: String?
    var stripePrivateKeyTest: String?
    var stripePublicKeyLive: String?
    var stripePublicKeyTest: String?
    var statementDescription: String?
    var statementDescriptor: String?
    var adminPassword: String?
    var supervisorPassword: String?
    var supervisorPermissions: AdminPermissionModel?
    var adminPermissions: AdminPermissionModel?
    var country:CountryModel?
    var cardReaders:[CardReaderModel]?
    var printers:[PrinterModel]?
    var businessCommissions:BussinessComissionModel?
    var tip: Int?
    var merchantService: Int?
    var connectService: Int?
    var connectStripePrivateKey: String?
    var connectStripePublicKey: String?
    var sAccountId: String?
    var printLogo = false
    var autoMailEmail = ""
    
    enum CodingKeys: String, CodingKey {
        case id, name, country, printers, tip
        case autoMailEmail = "auto_mail_email"
        case businessCommissions = "business_commissions"
        case cardReaders = "card_readers"
        case stripeMode = "stripe_mode"
        case merchantService = "merchant_service"
        case stripePrivateKeyLive = "stripe_private_key_live"
        case stripePrivateKeyTest = "stripe_private_key_test"
        case stripePublicKeyLive = "stripe_public_key_live"
        case stripePublicKeyTest = "stripe_public_key_test"
        case statementDescription = "statement_description"
        case statementDescriptor = "statement_descriptor"
        case adminPassword = "admin_password"
        case adminPermissions = "admin_permissions"
        case supervisorPassword = "supervisor_password"
        case supervisorPermissions = "supervisor_permissions"
        case connectService = "connect_service"
        case connectStripePrivateKey = "connect_stripe_private_key"
        case connectStripePublicKey = "connect_stripe_public_key"
        case sAccountId = "s_account_id"
        case printLogo = "print_logo"
    }
    
    required init(from decoder: Decoder) throws {
        let values = try decoder.container(keyedBy: CodingKeys.self)
        autoMailEmail = values.getStringValue(key: CodingKeys.autoMailEmail) ?? ""
        stripeMode = values.getStringValue(key: CodingKeys.stripeMode)
        stripePrivateKeyLive = values.getStringValue(key: CodingKeys.stripePrivateKeyLive)
        stripePrivateKeyTest = values.getStringValue(key: CodingKeys.stripePrivateKeyTest)
        stripePublicKeyLive = values.getStringValue(key: CodingKeys.stripePublicKeyLive)
        stripePublicKeyTest = values.getStringValue(key: CodingKeys.stripePublicKeyTest)
        statementDescription = values.getStringValue(key: CodingKeys.statementDescription)
        statementDescriptor = values.getStringValue(key: CodingKeys.statementDescriptor)
        supervisorPassword = values.getStringValue(key: CodingKeys.supervisorPassword)
        adminPassword = values.getStringValue(key: CodingKeys.adminPassword)
        adminPermissions = try? values.decode(AdminPermissionModel.self, forKey: .adminPermissions)
        businessCommissions = try? values.decode(BussinessComissionModel.self, forKey: .businessCommissions)
        supervisorPermissions = try? values.decode(AdminPermissionModel.self, forKey: .supervisorPermissions)
        name = values.getStringValue(key: CodingKeys.name)
        id = values.getIntValue(key: CodingKeys.id)
        merchantService = values.getIntValue(key: CodingKeys.merchantService)
        tip = values.getIntValue(key: CodingKeys.tip)
        country = try? values.decode(CountryModel.self, forKey: .country)
        cardReaders = try? values.decode([CardReaderModel].self, forKey: .cardReaders)
        printers = try? values.decode([PrinterModel].self, forKey: .printers)
        connectStripePrivateKey = values.getStringValue(key: CodingKeys.connectStripePrivateKey)
        connectStripePublicKey = values.getStringValue(key: CodingKeys.connectStripePublicKey)
        sAccountId = values.getStringValue(key: CodingKeys.sAccountId)
        connectService = values.getIntValue(key: CodingKeys.connectService)
        printLogo = values.getBoolValue(key: CodingKeys.printLogo)
    }
}

class SiteSettingsModel:Codable{
    
    var key: String?
    var value: String?
    var id:Int?
    
    enum CodingKeys: String, CodingKey {
        case key, value, id
    }
    
    required init(from decoder: Decoder) throws {
        let values = try decoder.container(keyedBy: CodingKeys.self)
        id = values.getIntValue(key: CodingKeys.id)
        key = values.getStringValue(key: CodingKeys.key)
        value = values.getStringValue(key: CodingKeys.value)
    }
}

class TiffintomSiteSettingModel: Codable {
    
    var contactEmail: String?
    var contactPhone: String?
    var currency: String?
    var finance_stripe_mode = ""
    var finance_stripe_secretkey = ""
    var finance_stripe_publishkey = ""
    var finance_stripe_secretkeyTest = ""
    var finance_stripe_publishkeyTest = ""
    
    enum CodingKeys: String, CodingKey {
        case currency, finance_stripe_mode, finance_stripe_secretkey, finance_stripe_publishkey, finance_stripe_secretkeyTest, finance_stripe_publishkeyTest
        case contactPhone = "contact_phone"
        case contactEmail = "contact_us_email"
    }
    
    required init(from decoder: Decoder) throws {
        let values = try decoder.container(keyedBy: CodingKeys.self)
        currency = values.getStringValue(key: CodingKeys.currency)
        contactEmail = values.getStringValue(key: CodingKeys.contactEmail)
        contactPhone = values.getStringValue(key: CodingKeys.contactPhone)
        finance_stripe_mode = values.getStringValue(key: CodingKeys.finance_stripe_mode) ?? ""
        finance_stripe_secretkey = values.getStringValue(key: CodingKeys.finance_stripe_secretkey) ?? ""
        finance_stripe_publishkey = values.getStringValue(key: CodingKeys.finance_stripe_publishkey) ?? ""
        finance_stripe_secretkeyTest = values.getStringValue(key: CodingKeys.finance_stripe_secretkeyTest) ?? ""
        finance_stripe_publishkeyTest = values.getStringValue(key: CodingKeys.finance_stripe_publishkeyTest) ?? ""
    }
}

class CardReaderModel:Codable{
    
    var name: String?
    var connectivity: String?
    var ip: String?
    var merchantId: String?
    var merchantSecret: String?
    var sLocationId: String?
    var sRegistrationCode: String?
    var sTerminalId: String?
    var port: Int?
    var id: Int?
    var serialNumber:String = ""
    
    enum CodingKeys: String, CodingKey {
        case merchantId = "merchant_key"
        case merchantSecret = "merchant_secret"
        case sLocationId = "s_location_id"
        case sRegistrationCode = "s_registration_code"
        case sTerminalId = "s_terminal_id"
        case serialNumber = "serial_number"
        case id, connectivity, name, ip, port
    }
    
    required init(from decoder: Decoder) throws {
        let values = try decoder.container(keyedBy: CodingKeys.self)
        name = values.getStringValue(key: CodingKeys.name)
        connectivity = values.getStringValue(key: CodingKeys.connectivity)
        ip = values.getStringValue(key: CodingKeys.ip)
        merchantId = values.getStringValue(key: CodingKeys.merchantId)
        merchantSecret = values.getStringValue(key: CodingKeys.merchantSecret)
        sLocationId = values.getStringValue(key: CodingKeys.sLocationId)
        sRegistrationCode = values.getStringValue(key: CodingKeys.sRegistrationCode)
        sTerminalId = values.getStringValue(key: CodingKeys.sTerminalId)
        connectivity = values.getStringValue(key: CodingKeys.connectivity)
        port = values.getIntValue(key: CodingKeys.port)
        id = values.getIntValue(key: CodingKeys.id)
        serialNumber = values.getStringValue(key: CodingKeys.serialNumber) ?? ""
    }
}

class CountryModel:Codable{
    
    var currencyCode: String?
    var currencySymbol: String?
    var iso: String?
    
    enum CodingKeys: String, CodingKey {
        case iso
        case currencyCode = "currency_code"
        case currencySymbol = "currency_symbol"
    }
    
    required init(from decoder: Decoder) throws {
        let values = try decoder.container(keyedBy: CodingKeys.self)
        currencyCode = values.getStringValue(key: CodingKeys.currencyCode)
        currencySymbol = values.getStringValue(key: CodingKeys.currencySymbol)
        iso = values.getStringValue(key: CodingKeys.iso)
    }
}

class BussinessComissionModel:Codable{
    
    var connectCardAuthFeeType: String?
    var connectCardProcessingFeeType: String?
    var connecCardAuthFee: Double?
    var connecCardProcessingFee: Double?
    
    enum CodingKeys: String, CodingKey {
        case connecCardAuthFee = "connect_card_auth_fee"
        case connectCardAuthFeeType = "connect_card_auth_fee_type"
        case connecCardProcessingFee = "connect_card_processing_fee"
        case connectCardProcessingFeeType = "connect_card_processing_fee_type"
    }
    
    required init(from decoder: Decoder) throws {
        let values = try decoder.container(keyedBy: CodingKeys.self)
        connectCardAuthFeeType = values.getStringValue(key: CodingKeys.connectCardAuthFeeType)
        connectCardProcessingFeeType = values.getStringValue(key: CodingKeys.connectCardProcessingFeeType)
        connecCardAuthFee = values.getDoubleValue(key: CodingKeys.connecCardAuthFee)
        connecCardProcessingFee = values.getDoubleValue(key: CodingKeys.connecCardProcessingFee)
    }
}

class AdminPermissionModel:Codable{
    
    var archiveList:Int?
    var refundList:Int?
    var print:Int?
    var transactionList: Int?
    var archive: Int?
    var refund:Int?
    var statement: Int?
    var tips: Int?
    var recentList: Int?
    
    
    enum CodingKeys: String, CodingKey {
        case archiveList = "archive_list"
        case refundList = "refund_list"
        case archive, print, refund, statement, tips
        case transactionList = "transaction_list"
        case recentList = "recent_list"
        
    }
    
    required init(from decoder: Decoder) throws {
        let values = try decoder.container(keyedBy: CodingKeys.self)
        archiveList = values.getIntValue(key: CodingKeys.archiveList)
        refundList = values.getIntValue(key: CodingKeys.refundList)
        archive = values.getIntValue(key: CodingKeys.archive)
        print = values.getIntValue(key: CodingKeys.print)
        refund = values.getIntValue(key: CodingKeys.refund)
        statement = values.getIntValue(key: CodingKeys.statement)
        tips = values.getIntValue(key: CodingKeys.tips)
        recentList = values.getIntValue(key: CodingKeys.recentList)
        transactionList = values.getIntValue(key: CodingKeys.transactionList)
    }
}

class PermissionModel:Codable{

    var delivery:ActionModel?
    var waiting:ActionModel?
    var bar:ActionModel?
    var dinein:ActionModel?
    var collection:ActionModel?
    var cashdrawer:ActionModel?
    var misc:ActionModel?
    var gratutity:ActionModel?
    var comment:ActionModel?
    var split:ActionModel?
    var discount:ActionModel?
    var modify:ActionModel?
    var addons:ActionModel?
    var reservation:ActionModel?
    var weborder:ActionModel?
    var swapTable:ActionModel?
    var customerInfo:ActionModel?
    var convertOrder:ActionModel?
    var addQty:ActionModel?
    var sendOrder:ActionModel?
    var printAll:ActionModel?
    var payBill:ActionModel?
    var printBill:ActionModel?
    var cancelOrder:ActionModel?
    var vouchers:ActionModel?
    var cancelOrderAfterPayment:ActionModel?
    var archiveOrder:ActionModel?
    var orderPaymentWise:ActionModel?
    var orderStatusWise:ActionModel?
    var orderTypeWise:ActionModel?
    var productCategoryWise:ActionModel?
    var productWise:ActionModel?
    var orderCount:ActionModel?
    var ordersTotalProduct:ActionModel?
    var ordersAmountProduct:ActionModel?
    var totalDiscount:ActionModel?
    var totalNoGuest:ActionModel?
    var totalNoTable:ActionModel?
    var cancelOrderReport:ActionModel?
    var paymentLinkHistory:ActionModel?
    var deleteOrder:ActionModel?
    var onlineOrderHistory:ActionModel?
    var orderHistory:ActionModel?
    var mergeTable:ActionModel?
    var zReport:ActionModel?
    var transactionList:ActionModel?
    
    enum CodingKeys: String, CodingKey {
        case delivery, waiting, bar, dinein, collection, misc, gratutity, comment, discount, modify, addons, reservation, vouchers
        case transactionList = "transaction_list"
        case zReport = "z_report"
        case mergeTable = "merge_table"
        case deleteOrder = "delete_order"
        case orderPaymentWise = "order_payment_wise"
        case orderStatusWise = "order_status_wise"
        case orderTypeWise = "order_type_wise"
        case productCategoryWise = "product_category_wise"
        case productWise = "product_wise"
        case cashdrawer = "cash_draw"
        case cancelOrder = "cancel_order"
        case split = "split_bill"
        case weborder = "web_orders"
        case swapTable = "swap_table"
        case customerInfo = "customer_info"
        case convertOrder = "convert_order"
        case addQty = "add_qty"
        case sendOrder = "send_order"
        case printAll = "print_all"
        case payBill = "pay_bill"
        case printBill = "print_bill"
        case cancelOrderAfterPayment = "cancel_order_after_payment"
        case archiveOrder = "archive_order"
        case orderCount = "order_count"
        case ordersTotalProduct = "orders_total_product"
        case ordersAmountProduct = "orders_amount_product"
        case totalDiscount = "total_discount"
        case totalNoGuest = "total_no_guest"
        case totalNoTable = "total_no_table"
        case cancelOrderReport = "cancel_order_report"
        case paymentLinkHistory = "payment_link_history"
        case onlineOrderHistory = "online_order_history"
        case orderHistory = "order_history"
    }

    required init(from decoder: Decoder) throws {
        let values = try decoder.container(keyedBy: CodingKeys.self)
        zReport = try? values.decode(ActionModel.self, forKey: .zReport)
        transactionList = try? values.decode(ActionModel.self, forKey: .transactionList)
        orderCount = try? values.decode(ActionModel.self, forKey: .orderCount)
        ordersTotalProduct = try? values.decode(ActionModel.self, forKey: .ordersTotalProduct)
        ordersAmountProduct = try? values.decode(ActionModel.self, forKey: .ordersAmountProduct)
        totalDiscount = try? values.decode(ActionModel.self, forKey: .totalDiscount)
        totalNoGuest = try? values.decode(ActionModel.self, forKey: .totalNoGuest)
        totalNoTable = try? values.decode(ActionModel.self, forKey: .totalNoTable)
        cancelOrderReport = try? values.decode(ActionModel.self, forKey: .cancelOrderReport)
        orderPaymentWise = try? values.decode(ActionModel.self, forKey: .orderPaymentWise)
        orderStatusWise = try? values.decode(ActionModel.self, forKey: .orderStatusWise)
        orderTypeWise = try? values.decode(ActionModel.self, forKey: .orderTypeWise)
        productCategoryWise = try? values.decode(ActionModel.self, forKey: .productCategoryWise)
        productWise = try? values.decode(ActionModel.self, forKey: .productWise)
        delivery = try? values.decode(ActionModel.self, forKey: .delivery)
        waiting = try? values.decode(ActionModel.self, forKey: .waiting)
        bar = try? values.decode(ActionModel.self, forKey: .bar)
        dinein = try? values.decode(ActionModel.self, forKey: .dinein)
        collection = try? values.decode(ActionModel.self, forKey: .collection)
        cashdrawer = try? values.decode(ActionModel.self, forKey: .cashdrawer)
        misc = try? values.decode(ActionModel.self, forKey: .misc)
        gratutity = try? values.decode(ActionModel.self, forKey: .gratutity)
        comment = try? values.decode(ActionModel.self, forKey: .comment)
        split = try? values.decode(ActionModel.self, forKey: .split)
        discount = try? values.decode(ActionModel.self, forKey: .discount)
        modify = try? values.decode(ActionModel.self, forKey: .modify)
        addons = try? values.decode(ActionModel.self, forKey: .addons)
        reservation = try? values.decode(ActionModel.self, forKey: .reservation)
        weborder = try? values.decode(ActionModel.self, forKey: .weborder)
        swapTable = try? values.decode(ActionModel.self, forKey: .swapTable)
        customerInfo = try? values.decode(ActionModel.self, forKey: .customerInfo)
        convertOrder = try? values.decode(ActionModel.self, forKey: .convertOrder)
        addQty = try? values.decode(ActionModel.self, forKey: .addQty)
        sendOrder = try? values.decode(ActionModel.self, forKey: .sendOrder)
        printAll = try? values.decode(ActionModel.self, forKey: .printAll)
        payBill = try? values.decode(ActionModel.self, forKey: .payBill)
        printBill = try? values.decode(ActionModel.self, forKey: .printBill)
        vouchers = try? values.decode(ActionModel.self, forKey: .vouchers)
        cancelOrder = try? values.decode(ActionModel.self, forKey: .cancelOrder)
        cancelOrderAfterPayment = try? values.decode(ActionModel.self, forKey: .cancelOrderAfterPayment)
        archiveOrder = try? values.decode(ActionModel.self, forKey: .archiveOrder)
        paymentLinkHistory = try? values.decode(ActionModel.self, forKey: .paymentLinkHistory)
        deleteOrder = try? values.decode(ActionModel.self, forKey: .deleteOrder)
        onlineOrderHistory = try? values.decode(ActionModel.self, forKey: .onlineOrderHistory)
        orderHistory = try? values.decode(ActionModel.self, forKey: .orderHistory)
        mergeTable = try? values.decode(ActionModel.self, forKey: .mergeTable)
    }
}

class ActionModel:Codable{

    var actions:ListModel?

    enum CodingKeys: String, CodingKey {
        case actions
    }

    required init(from decoder: Decoder) throws {
        let values = try decoder.container(keyedBy: CodingKeys.self)
        actions = try? values.decode(ListModel.self, forKey: .actions)
    }
}

class ListModel:Codable{

    var list:Int?

    enum CodingKeys: String, CodingKey {
        case list
    }

    required init(from decoder: Decoder) throws {
        let values = try decoder.container(keyedBy: CodingKeys.self)
        list = values.getIntValue(key: CodingKeys.list)
    }
}
