//
//  PrinterModel.swift
//  EPOS
//
//  Created by Kamal Parmar on 12/07/22.
//

import Foundation
import CoreData

class PrinterModel:Codable{
    
    var id:Int?
    var ip:String?
    var isDefault:Int?
    var name: String?
    var port: Int?
    
    enum CodingKeys: String, CodingKey {
        case isDefault = "is_default"
        case id, ip, name, port
    }
    
    required init(from decoder: Decoder) throws {
        let values = try decoder.container(keyedBy: CodingKeys.self)
        name = values.getStringValue(key: CodingKeys.name)
        id = values.getIntValue(key: CodingKeys.id)
        ip = values.getStringValue(key: CodingKeys.ip)
        isDefault = values.getIntValue(key: CodingKeys.isDefault)
        port = values.getIntValue(key: CodingKeys.port)
    }
}


class EPOSPrinterModel:Codable{
    
    var id: Int?
    var name: String?
    var ip: String?
    var disabled: Int?
    
    enum CodingKeys: String, CodingKey {
        case id, disabled, ip, name
    }
    
    required init(from decoder: Decoder) throws {
        let values = try decoder.container(keyedBy: CodingKeys.self)
        name = values.getStringValue(key: CodingKeys.name)
        id = values.getIntValue(key: CodingKeys.id)
        ip = values.getStringValue(key: CodingKeys.ip)
        disabled = values.getIntValue(key: CodingKeys.disabled)
    }
    
    init(_ table:NSManagedObject) {
        self.id = table.value(forKey: "id") as? Int
        self.disabled = table.value(forKey: "disabled") as? Int
        self.name = table.value(forKey: "name") as? String
        self.ip = table.value(forKey: "ip") as? String
    }
}

class PrintSettingsModel:Codable{
    
    var name: String = ""
    var service: String = ""
    var structure = [PrintStructureDetailModel]()
    
    enum CodingKeys: String, CodingKey {
        case name, service, structure
    }
    
    required init(from decoder: Decoder) throws {
        let values = try decoder.container(keyedBy: CodingKeys.self)
        name = values.getStringValue(key: CodingKeys.name) ?? ""
        service = values.getStringValue(key: CodingKeys.service) ?? ""
        structure = (try? values.decode([PrintStructureDetailModel].self, forKey: .structure)) ??  [PrintStructureDetailModel]()
    }
}

class PrintStructureModel:Codable{
    
    var charity:PrintStructureDetailModel?
    var discount:PrintStructureDetailModel?
    var footer:PrintStructureDetailModel?
    var gratuity:PrintStructureDetailModel?
    var items:PrintStructureDetailModel?
    var subtotal:PrintStructureDetailModel?
    var title:PrintStructureDetailModel?
    var deliveryCharge:PrintStructureDetailModel?
    var footerOrderType:PrintStructureDetailModel?
    var grandTotal:PrintStructureDetailModel?
    var headerOrderType:PrintStructureDetailModel?
    var itemsHeader:PrintStructureDetailModel?
    var itemsSubaddon:PrintStructureDetailModel?
    var noOfDiners:PrintStructureDetailModel?
    var onlineComment:PrintStructureDetailModel?
    var onlineCustomerDetails:PrintStructureDetailModel?
    var onlineDeliveryAddress:PrintStructureDetailModel?
    var onlineDeliveryCharge:PrintStructureDetailModel?
    var onlineDeliveryInstruction:PrintStructureDetailModel?
    var onlineDriverTip:PrintStructureDetailModel?
    var onlineFailedReason:PrintStructureDetailModel?
    var onlineFooter:PrintStructureDetailModel?
    var onlineGrandTotal:PrintStructureDetailModel?
    var onlineItems:PrintStructureDetailModel?
    var onlineLoyalty:PrintStructureDetailModel?
    var onlineOffer:PrintStructureDetailModel?
    var onlineOrderDate:PrintStructureDetailModel?
    var onlineOrderTime:PrintStructureDetailModel?
    var onlineOrderNo:PrintStructureDetailModel?
    var onlineOrderStatus:PrintStructureDetailModel?
    var onlineOrderType:PrintStructureDetailModel?
    var onlinePaymentMethod:PrintStructureDetailModel?
    var onlinePaymentStatus:PrintStructureDetailModel?
    var onlineReceiptTime:PrintStructureDetailModel?
    var onlineRequestedFor:PrintStructureDetailModel?
    var onlineRestaurantAddress:PrintStructureDetailModel?
    var onlineServiceCharge:PrintStructureDetailModel?
    var onlineSite:PrintStructureDetailModel?
    var onlineSubTotal:PrintStructureDetailModel?
    var onlineTitle:PrintStructureDetailModel?
    var orderDate:PrintStructureDetailModel?
    var orderTime:PrintStructureDetailModel?
    var orderNo:PrintStructureDetailModel?
    var paymentStatus:PrintStructureDetailModel?
    var serveBy:PrintStructureDetailModel?
    var serviceCharge:PrintStructureDetailModel?
    var tableNo:PrintStructureDetailModel?
    var customerDetail:PrintStructureDetailModel?
    var orderComment:PrintStructureDetailModel?
    var paymentDetail:PrintStructureDetailModel?
    var paymentDetailHeader:PrintStructureDetailModel?
    var footerTableNumber:PrintStructureDetailModel?
    var footerOrderNumber:PrintStructureDetailModel?
    var dueAmount:PrintStructureDetailModel?
    var receiptTime:PrintStructureDetailModel?
    var ticketHeader:PrintStructureDetailModel?
    var headerCustomerName:PrintStructureDetailModel?
    var orderType:PrintStructureDetailModel?
    
    enum CodingKeys: String, CodingKey {
        case charity, discount, footer, gratuity, items, subtotal, title
        case deliveryCharge = "delivery_charge"
        case footerOrderType = "footer_order_type"
        case grandTotal = "grand_total"
        case headerOrderType = "header_order_type"
        case itemsHeader = "items_header"
        case itemsSubaddon = "items_subaddon"
        case noOfDiners = "no_of_diners"
        case onlineComment = "online_comment"
        case onlineCustomerDetails = "online_customer_details"
        case onlineDeliveryAddress = "online_delivery_address"
        case onlineDeliveryCharge = "online_delivery_charge"
        case onlineDeliveryInstruction = "online_delivery_instruction"
        case onlineDriverTip = "online_driver_tip"
        case onlineFailedReason = "online_failed_reason"
        case onlineFooter = "online_footer"
        case onlineGrandTotal = "online_grand_total"
        case onlineItems = "online_items"
        case onlineLoyalty = "online_loyalty"
        case onlineOffer = "online_offer"
        case onlineOrderDate = "online_order_date"
        case onlineOrderTime = "online_order_time"
        case onlineOrderNo = "online_order_no"
        case onlineOrderStatus = "online_order_status"
        case onlineOrderType = "online_order_type"
        case onlinePaymentMethod = "online_payment_method"
        case onlinePaymentStatus = "online_payment_status"
        case onlineReceiptTime = "online_receipt_time"
        case onlineRequestedFor = "online_requested_for"
        case onlineRestaurantAddress = "online_restaurant_address"
        case onlineServiceCharge = "online_service_charge"
        case onlineSite = "online_site"
        case onlineSubTotal = "online_sub_total"
        case onlineTitle = "online_title"
        case orderDate = "order_date"
        case orderTime = "order_time"
        case orderNo = "order_no"
        case paymentStatus = "payment_status"
        case serveBy = "serve_by"
        case serviceCharge = "service_charge"
        case tableNo = "table_no"
        case customerDetail = "customer_detail"
        case orderComment = "order_comment"
        case paymentDetail = "payment_detail"
        case paymentDetailHeader = "payment_detail_header"
        case footerTableNumber = "footer_table_number"
        case footerOrderNumber = "footer_order_number"
        case dueAmount = "due_amount"
        case receiptTime = "receipt_time"
        case ticketHeader = "ticket_header"
        case headerCustomerName = "header_customer_name"
        case orderType = "order_type"
    }
    
    required init(from decoder: Decoder) throws {
        let values = try decoder.container(keyedBy: CodingKeys.self)
        dueAmount = try? values.decode(PrintStructureDetailModel.self, forKey: .dueAmount)
        receiptTime = try? values.decode(PrintStructureDetailModel.self, forKey: .receiptTime)
        ticketHeader = try? values.decode(PrintStructureDetailModel.self, forKey: .ticketHeader)
        headerCustomerName = try? values.decode(PrintStructureDetailModel.self, forKey: .headerCustomerName)
        orderType = try? values.decode(PrintStructureDetailModel.self, forKey: .orderType)
        charity = try? values.decode(PrintStructureDetailModel.self, forKey: .charity)
        discount = try? values.decode(PrintStructureDetailModel.self, forKey: .discount)
        footer = try? values.decode(PrintStructureDetailModel.self, forKey: .footer)
        gratuity = try? values.decode(PrintStructureDetailModel.self, forKey: .gratuity)
        items = try? values.decode(PrintStructureDetailModel.self, forKey: .items)
        subtotal = try? values.decode(PrintStructureDetailModel.self, forKey: .subtotal)
        title = try? values.decode(PrintStructureDetailModel.self, forKey: .title)
        deliveryCharge = try? values.decode(PrintStructureDetailModel.self, forKey: .deliveryCharge)
        footerOrderType = try? values.decode(PrintStructureDetailModel.self, forKey: .footerOrderType)
        grandTotal = try? values.decode(PrintStructureDetailModel.self, forKey: .grandTotal)
        headerOrderType = try? values.decode(PrintStructureDetailModel.self, forKey: .headerOrderType)
        itemsHeader = try? values.decode(PrintStructureDetailModel.self, forKey: .itemsHeader)
        itemsSubaddon = try? values.decode(PrintStructureDetailModel.self, forKey: .itemsSubaddon)
        noOfDiners = try? values.decode(PrintStructureDetailModel.self, forKey: .noOfDiners)
        onlineComment = try? values.decode(PrintStructureDetailModel.self, forKey: .onlineComment)
        onlineCustomerDetails = try? values.decode(PrintStructureDetailModel.self, forKey: .onlineCustomerDetails)
        onlineDeliveryAddress = try? values.decode(PrintStructureDetailModel.self, forKey: .onlineDeliveryAddress)
        onlineDeliveryCharge = try? values.decode(PrintStructureDetailModel.self, forKey: .onlineDeliveryCharge)
        onlineDeliveryInstruction = try? values.decode(PrintStructureDetailModel.self, forKey: .onlineDeliveryInstruction)
        onlineDriverTip = try? values.decode(PrintStructureDetailModel.self, forKey: .onlineDriverTip)
        onlineFailedReason = try? values.decode(PrintStructureDetailModel.self, forKey: .onlineFailedReason)
        onlineFooter = try? values.decode(PrintStructureDetailModel.self, forKey: .onlineFooter)
        onlineGrandTotal = try? values.decode(PrintStructureDetailModel.self, forKey: .onlineGrandTotal)
        onlineItems = try? values.decode(PrintStructureDetailModel.self, forKey: .onlineItems)
        onlineLoyalty = try? values.decode(PrintStructureDetailModel.self, forKey: .onlineLoyalty)
        onlineOffer = try? values.decode(PrintStructureDetailModel.self, forKey: .onlineOffer)
        onlineOrderDate = try? values.decode(PrintStructureDetailModel.self, forKey: .onlineOrderDate)
        onlineOrderTime = try? values.decode(PrintStructureDetailModel.self, forKey: .onlineOrderTime)
        onlineOrderNo = try? values.decode(PrintStructureDetailModel.self, forKey: .onlineOrderNo)
        onlineOrderStatus = try? values.decode(PrintStructureDetailModel.self, forKey: .onlineOrderStatus)
        onlineOrderType = try? values.decode(PrintStructureDetailModel.self, forKey: .onlineOrderType)
        onlinePaymentMethod = try? values.decode(PrintStructureDetailModel.self, forKey: .onlinePaymentMethod)
        onlinePaymentStatus = try? values.decode(PrintStructureDetailModel.self, forKey: .onlinePaymentStatus)
        onlineReceiptTime = try? values.decode(PrintStructureDetailModel.self, forKey: .onlineReceiptTime)
        onlineRequestedFor = try? values.decode(PrintStructureDetailModel.self, forKey: .onlineRequestedFor)
        onlineRestaurantAddress = try? values.decode(PrintStructureDetailModel.self, forKey: .onlineRestaurantAddress)
        onlineServiceCharge = try? values.decode(PrintStructureDetailModel.self, forKey: .onlineServiceCharge)
        onlineSite = try? values.decode(PrintStructureDetailModel.self, forKey: .onlineSite)
        onlineSubTotal = try? values.decode(PrintStructureDetailModel.self, forKey: .onlineSubTotal)
        onlineTitle = try? values.decode(PrintStructureDetailModel.self, forKey: .onlineTitle)
        orderDate = try? values.decode(PrintStructureDetailModel.self, forKey: .orderDate)
        orderTime = try? values.decode(PrintStructureDetailModel.self, forKey: .orderTime)
        orderNo = try? values.decode(PrintStructureDetailModel.self, forKey: .orderNo)
        paymentStatus = try? values.decode(PrintStructureDetailModel.self, forKey: .paymentStatus)
        serveBy = try? values.decode(PrintStructureDetailModel.self, forKey: .serveBy)
        serviceCharge = try? values.decode(PrintStructureDetailModel.self, forKey: .serviceCharge)
        tableNo = try? values.decode(PrintStructureDetailModel.self, forKey: .tableNo)
        customerDetail = try? values.decode(PrintStructureDetailModel.self, forKey: .customerDetail)
        orderComment = try? values.decode(PrintStructureDetailModel.self, forKey: .orderComment)
        paymentDetail = try? values.decode(PrintStructureDetailModel.self, forKey: .paymentDetail)
        paymentDetailHeader = try? values.decode(PrintStructureDetailModel.self, forKey: .paymentDetailHeader)
        footerOrderNumber = try? values.decode(PrintStructureDetailModel.self, forKey: .footerOrderNumber)
        footerTableNumber = try? values.decode(PrintStructureDetailModel.self, forKey: .footerTableNumber)
    }
}

class PrintStructureDetailModel:Codable{
    
    var size:String = ""
    var alignment:String = ""
    var visibility:Int = 0
    var sequence:Int = 0
    var price:Int = 0
    var allSeparator:Int = 0
    var style: String = ""
    var separator:Bool = false
    var name = ""
    var type:PrintSettingName?
    var block = false
    var contain = false
    
    enum CodingKeys: String, CodingKey {
        case size, alignment, visibility, style, separator, sequence, name, price
        case block = "block_name"
        case contain = "is_contain"
        case allSeparator = "all_separator"
    }
    
    required init(from decoder: Decoder) throws {
        let values = try decoder.container(keyedBy: CodingKeys.self)
        style = values.getStringValue(key: CodingKeys.style) ?? ""
        visibility = values.getIntValue(key: CodingKeys.visibility) ?? 0
        alignment = values.getStringValue(key: CodingKeys.alignment) ?? ""
        size = values.getStringValue(key: CodingKeys.size) ?? ""
        sequence = values.getIntValue(key: CodingKeys.sequence) ?? 0
        separator = values.getBoolValue(key: CodingKeys.separator)
        price = values.getIntValue(key: CodingKeys.price) ?? 0
        allSeparator = values.getIntValue(key: CodingKeys.allSeparator) ?? 0
        type = PrintSettingName.init(rawValue: values.getStringValue(key: CodingKeys.name) ?? "")
        block = values.getBoolValue(key: CodingKeys.block)
        contain = values.getBoolValue(key: CodingKeys.contain)
    }
}

enum PrintSettingName:String{
    case charity, discount, footer, gratuity, items, subtotal, title, logo
    case deliveryCharge = "delivery_charge"
    case footerOrderType = "footer_order_type"
    case grandTotal = "grand_total"
    case headerOrderType = "header_order_type"
    case itemsHeader = "items_header"
    case itemsSubaddon = "items_subaddon"
    case noOfDiners = "no_of_diners"
    case onlineComment = "online_comment"
    case onlineCustomerDetails = "online_customer_details"
    case onlineDeliveryAddress = "online_delivery_address"
    case onlineDeliveryCharge = "online_delivery_charge"
    case onlineDeliveryInstruction = "online_delivery_instruction"
    case onlineDriverTip = "online_driver_tip"
    case onlineFailedReason = "online_failed_reason"
    case onlineFooter = "online_footer"
    case onlineGrandTotal = "online_grand_total"
    case onlineItems = "online_items"
    case onlineLoyalty = "online_loyalty"
    case onlineOffer = "online_offer"
    case onlineOrderDate = "online_order_date"
    case onlineOrderTime = "online_order_time"
    case onlineOrderNo = "online_order_no"
    case onlineOrderStatus = "online_order_status"
    case onlineOrderType = "online_order_type"
    case onlinePaymentMethod = "online_payment_method"
    case onlinePaymentStatus = "online_payment_status"
    case onlineReceiptTime = "online_receipt_time"
    case onlineRequestedFor = "online_requested_for"
    case onlineRestaurantAddress = "online_restaurant_address"
    case onlineServiceCharge = "online_service_charge"
    case onlineSite = "online_site"
    case onlineSubTotal = "online_sub_total"
    case onlineTitle = "online_title"
    case orderDate = "order_date"
    case orderTime = "order_time"
    case orderNo = "order_no"
    case paymentStatus = "payment_status"
    case serveBy = "serve_by"
    case serviceCharge = "service_charge"
    case tableNo = "table_no"
    case customerDetail = "customer_detail"
    case orderComment = "order_comment"
    case paymentDetail = "payment_detail"
    case paymentDetailHeader = "payment_detail_header"
    case footerTableNumber = "footer_table_number"
    case footerOrderNumber = "footer_order_number"
    case dueAmount = "due_amount"
    case receiptTime = "receipt_time"
    case ticketHeader = "ticket_header"
    case headerCustomerName = "header_customer_name"
    case orderType = "order_type"
    
}
