//
//  PaymentModel.swift
//  EPOS
//
//  Created by Apple on 24/04/21.
//

import Foundation
import CoreData

class VoucherModel:Codable{
    
    var id: Int?
    var orderTypeId: String?
    var customerId: Int?
    var voucherAmount: Double?
    var endDate: String?
    var minimumOrderValue: Double?
    var startDate: String?
    var voucherCode: String?
    var weekDay: String?
    var applied: Int?
    var offline = 1
    var updated = 1
    var customer:CustomerModel?
    var uniqueId = ""
    
    enum CodingKeys: String, CodingKey {
        case id, applied, customer, offline, updated
        case minimumOrderValue = "minimum_order_value"
        case orderTypeId = "order_type_id"
        case voucherAmount = "voucher_amount"
        case customerId = "customer_id"
        case endDate = "end_date"
        case startDate = "start_date"
        case voucherCode = "voucher_code"
        case weekDay = "week_day"
        case uniqueId = "unique_id"
    }
    
    required init(from decoder: Decoder) throws {
        let values = try decoder.container(keyedBy: CodingKeys.self)
        id = values.getIntValue(key: CodingKeys.id)
        applied = values.getIntValue(key: CodingKeys.applied)
        orderTypeId = values.getStringValue(key: CodingKeys.orderTypeId)
        endDate = values.getStringValue(key: CodingKeys.endDate)
        startDate = values.getStringValue(key: CodingKeys.startDate)
        voucherCode = values.getStringValue(key: CodingKeys.voucherCode)
        weekDay = values.getStringValue(key: CodingKeys.weekDay)
        customerId = values.getIntValue(key: CodingKeys.customerId)
        voucherAmount = values.getDoubleValue(key: CodingKeys.voucherAmount)
        minimumOrderValue = values.getDoubleValue(key: CodingKeys.minimumOrderValue)
        customer = try? values.decode(CustomerModel.self, forKey: .customer)
        
        offline = values.getIntValue(key: CodingKeys.offline) ?? 1
        updated = values.getIntValue(key: CodingKeys.updated) ?? 1
        uniqueId = values.getStringValue(key: CodingKeys.uniqueId) ?? ""
    }
    
    init(){
        
    }
}

class PaymentOrderModel:Codable{
    
    
    var id: Int?
    var paymentMethodId: Int?
    var paymentMethodName: String?
    var amount: Double?
    var offline = 0
    var orderSplitId:Int?
    var voucherId:Int?
    var txnId:String?
    var chequeNumber:String?
    var ccNumber:String?
    var updaterId:Int?
    var groupUniqueId = ""
    var isRefunded = 0
    
    enum CodingKeys: String, CodingKey {
        case id, amount, offline
        case isRefunded = "is_refunded"
        case groupUniqueId = "unique_id"
        case updaterId = "updater_id"
        case chequeNumber = "cheque_number"
        case ccNumber = "cc_number"
        case txnId = "txn_id"
        case voucherId = "voucher_id"
        case paymentMethodId = "payment_method_id"
        case paymentMethodName = "payment_method_name"
        case orderSplitId = "order_split_id"
    }
    
    required init(from decoder: Decoder) throws {
        let values = try decoder.container(keyedBy: CodingKeys.self)
        id = values.getIntValue(key: CodingKeys.id)
        offline = values.getIntValue(key: CodingKeys.offline) ?? 0
        isRefunded = values.getIntValue(key: CodingKeys.isRefunded) ?? 0
        updaterId = values.getIntValue(key: CodingKeys.updaterId)
        paymentMethodId = values.getIntValue(key: CodingKeys.paymentMethodId)
        paymentMethodName = values.getStringValue(key: CodingKeys.paymentMethodName)
        chequeNumber = values.getStringValue(key: CodingKeys.chequeNumber)
        txnId = values.getStringValue(key: CodingKeys.txnId)
        ccNumber = values.getStringValue(key: CodingKeys.ccNumber)
        amount = values.getDoubleValue(key: CodingKeys.amount)
        orderSplitId = values.getIntValue(key: CodingKeys.orderSplitId)
        voucherId = values.getIntValue(key: CodingKeys.voucherId)
        groupUniqueId = values.getStringValue(key: CodingKeys.groupUniqueId) ?? ""
    }
    
    init() {
        
    }
}

class OrderGroupModel:Codable{
    
    var id: Int?
    var groupName: String?
    var total: Double?
    var paidAmount: Double?
    var offline = 1
    var arrProducts = [OrderProductModel]()
    var uniqueId = ""
    var discount:Double = 0
    var gratuity:Double = 0
    var serviceCharge:Double = 0
    var autoGratuityRemove = false
    var autoDiscountRemove = false
    var autoServiceChargeRemove = false
    var subTotal:Double = 0.0
    
    enum CodingKeys: String, CodingKey {
        case id, total, offline, discount, gratuity
        case uniqueId = "unique_id"
        case groupName = "group_name"
        case paidAmount = "paid_amount"
        case autoGratuityRemove = "auto_gratuity_remove"
        case autoDiscountRemove = "auto_discount_remove"
        case autoServiceChargeRemove = "auto_service_charge_remove"
        case serviceCharge = "service_charge"
        case subTotal = "sub_total"
    }
    
    required init(from decoder: Decoder) throws {
        let values = try decoder.container(keyedBy: CodingKeys.self)
        id = values.getIntValue(key: CodingKeys.id)
        groupName = values.getStringValue(key: CodingKeys.groupName)
        total = values.getDoubleValue(key: CodingKeys.total)
        offline = values.getIntValue(key: CodingKeys.offline) ?? 0
        uniqueId = values.getStringValue(key: CodingKeys.uniqueId) ?? ""
        paidAmount = values.getDoubleValue(key: CodingKeys.paidAmount)
        autoGratuityRemove = values.getBoolValue(key: CodingKeys.autoGratuityRemove)
        autoDiscountRemove = values.getBoolValue(key: CodingKeys.autoDiscountRemove)
        autoServiceChargeRemove = values.getBoolValue(key: CodingKeys.autoServiceChargeRemove)
        discount = values.getDoubleValue(key: CodingKeys.discount) ?? 0
        serviceCharge = values.getDoubleValue(key: CodingKeys.serviceCharge) ?? 0
        gratuity = values.getDoubleValue(key: CodingKeys.gratuity) ?? 0
        subTotal = values.getDoubleValue(key: CodingKeys.subTotal) ?? 0
    }
    
    init() {
        
    }
}

class OrderDiscountModel:Codable{
    
    var startDate: String?
    var endDate: String?
    var discount: Double?
    var minimumValue: Double?
    var weekDay: String?
    var orderTypeId: String?
    var discountType: String?
    
    enum CodingKeys: String, CodingKey {
        case discount
        case startDate = "start_date"
        case minimumValue = "minimum_value"
        case endDate = "end_date"
        case orderTypeId = "order_type_id"
        case discountType = "discount_type"
        case weekDay = "week_day"
    }
    
    required init(from decoder: Decoder) throws {
        let values = try decoder.container(keyedBy: CodingKeys.self)
        startDate = values.getStringValue(key: CodingKeys.startDate)
        endDate = values.getStringValue(key: CodingKeys.endDate)
        orderTypeId = values.getStringValue(key: CodingKeys.orderTypeId)
        discountType = values.getStringValue(key: CodingKeys.discountType)
        weekDay = values.getStringValue(key: CodingKeys.weekDay)
        discount = values.getDoubleValue(key: CodingKeys.discount)
        minimumValue = values.getDoubleValue(key: CodingKeys.minimumValue)
    }
}
