//
//  CustomerModel.swift
//  EPOS
//
//  Created by Apple on 10/04/21.
//

import Foundation
import CoreData

class CustomerModel:Codable{
    
    var id: Int?
    var newsLetter: Int?
    var name: String?
    var mobile: String?
    var email: String?
    var houseNo: String?
    var street: String?
    var postcode: String?
    var city: String?
    var distance: Double?
    var offline = 0
    var uniqueId = ""
    
    enum CodingKeys: String, CodingKey {
        case name, id, mobile, email, street, postcode, city, distance, offline
        case newsLetter = "news_letter"
        case houseNo = "house_no"
        case uniqueId = "unique_id"
    }
    
    required init(from decoder: Decoder) throws {
        let values = try decoder.container(keyedBy: CodingKeys.self)
        offline = values.getIntValue(key: CodingKeys.offline) ?? 0
        name = values.getStringValue(key: CodingKeys.name)
        mobile = values.getStringValue(key: CodingKeys.mobile)
        email = values.getStringValue(key: CodingKeys.email)
        street = values.getStringValue(key: CodingKeys.street)
        postcode = values.getStringValue(key: CodingKeys.postcode)
        city = values.getStringValue(key: CodingKeys.city)
        houseNo = values.getStringValue(key: CodingKeys.houseNo)
        distance = values.getDoubleValue(key: CodingKeys.distance)
        id = values.getIntValue(key: CodingKeys.id)
        newsLetter = values.getIntValue(key: CodingKeys.newsLetter)
        uniqueId = values.getStringValue(key: CodingKeys.uniqueId) ?? ""
    }
    
    init(_ customer:NSManagedObject) {
        self.offline = (customer.value(forKey: "offline") as? Int) ?? 0
        self.id = customer.value(forKey: "id") as? Int
        self.newsLetter = customer.value(forKey: "news_letter") as? Int
        self.name = customer.value(forKey: "name") as? String
        self.mobile = customer.value(forKey: "mobile") as? String
        self.email = customer.value(forKey: "email") as? String
        self.street = customer.value(forKey: "street") as? String
        self.postcode = customer.value(forKey: "postcode") as? String
        self.city = customer.value(forKey: "city") as? String
        self.houseNo = customer.value(forKey: "house_no") as? String
        self.distance = customer.value(forKey: "distance") as? Double
        self.uniqueId = (customer.value(forKey: "unique_id") as? String) ?? ""
    }
    
    init() {
        
    }
}

class PostCodeModel:Codable{
    
    var id: Int?
    var street: String?
    var postTown: String?
    var postCode: String?
    var latitude: Double?
    var longitude: Double?
    
    enum CodingKeys: String, CodingKey {
        case latitude, id, longitude, street
        case postTown = "post_town"
        case postCode = "post_code"
    }
    
    required init(from decoder: Decoder) throws {
        let values = try decoder.container(keyedBy: CodingKeys.self)
        id = values.getIntValue(key: CodingKeys.id)
        postTown = values.getStringValue(key: CodingKeys.postTown)
        postCode = values.getStringValue(key: CodingKeys.postCode)
        street = values.getStringValue(key: CodingKeys.street)
        latitude = values.getDoubleValue(key: CodingKeys.latitude)
        longitude = values.getDoubleValue(key: CodingKeys.longitude)
    }
    
    init() {
        
    }
}

class DeliveryChargeModel:Codable{
    
    var id: Int?
    var charge: Double?
    var distance: Double?
    var disabled: Int?
    
    enum CodingKeys: String, CodingKey {
        case id, charge, distance, disabled
    }
    
    required init(from decoder: Decoder) throws {
        let values = try decoder.container(keyedBy: CodingKeys.self)
        id = values.getIntValue(key: CodingKeys.id)
        disabled = values.getIntValue(key: CodingKeys.disabled)
        charge = values.getDoubleValue(key: CodingKeys.charge)
        distance = values.getDoubleValue(key: CodingKeys.distance)
    }
    
    init(_ postcode:NSManagedObject? = nil) {
        if postcode != nil{
            self.id = postcode!.value(forKey: "id") as? Int
            self.charge = postcode!.value(forKey: "charge") as? Double
            self.distance = postcode!.value(forKey: "distance") as? Double
        }
    }
    
    init() {
        
    }
}
