//
//  ChatModel.swift
//  EPOS
//
//  Created by Apple on 14/06/21.
//

import Foundation

class orderChatModel: Codable {
    
    var id: Int?
    var user:OnlineUserModel?
    var orderId: Int?
    var unreadCount: Int?
    var modified: String?
    var cardNo: String?
    var grandTotal: Double?
    var orderNo: String?
    var paymentMode: String?
    var message: String?
    
    enum CodingKeys: String, CodingKey {
        case id, modified, message, user
        case orderId = "order_id"
        case unreadCount = "unread_count_user"
        case cardNo = "card_number"
        case grandTotal = "order_grand_total"
        case orderNo = "order_number"
        case paymentMode = "payment_method"
    }
    
    required init(from decoder: Decoder) throws {
        let values = try decoder.container(keyedBy: CodingKeys.self)
        modified = values.getStringValue(key: CodingKeys.modified)
        orderId = values.getIntValue(key: CodingKeys.orderId)
        id = values.getIntValue(key: CodingKeys.id)
        unreadCount = values.getIntValue(key: CodingKeys.unreadCount)
        cardNo = values.getStringValue(key: CodingKeys.cardNo)
        grandTotal = values.getDoubleValue(key: CodingKeys.grandTotal)
        orderNo = values.getStringValue(key: CodingKeys.orderNo)
        paymentMode = values.getStringValue(key: CodingKeys.paymentMode)
        message = values.getStringValue(key: CodingKeys.message)
        user = try? values.decode(OnlineUserModel.self, forKey: .user)
    }
}

class OnlineUserModel: Codable {
    
    var id: Int?
    var imageUrl: String?
    var firstName: String?
    var lastName: String?
    var username: String?
    var phoneNumber: String?
    var roleId = 0
    
    enum CodingKeys: String, CodingKey {
        case id, username
        case roleId = "role_id"
        case phoneNumber = "phone_number"
        case imageUrl = "image_url"
        case firstName = "first_name"
        case lastName = "last_name"
    }
    
    required init(from decoder: Decoder) throws {
        let values = try decoder.container(keyedBy: CodingKeys.self)
        imageUrl = values.getStringValue(key: CodingKeys.imageUrl)
        firstName = values.getStringValue(key: CodingKeys.firstName)
        lastName = values.getStringValue(key: CodingKeys.lastName)
        phoneNumber = values.getStringValue(key: CodingKeys.phoneNumber)
        username = values.getStringValue(key: CodingKeys.username)
        id = values.getIntValue(key: CodingKeys.id)
        roleId = values.getIntValue(key: CodingKeys.roleId) ?? 0
    }
    
    init(){}
}
