//
//  CategoryModel.swift
//  EPOS
//
//  Created by Apple on 09/04/21.
//

import Foundation
import CoreData

class CategoryModel:Codable{
    
    var id: Int?
    var name: String?
    var disabled:Int?
    var parentId:Int?
    var arrChildCategory:[CategoryModel]?
    var topColor: String?
    var bottomColor: String?
    var fontColor: String?
    var printBlockId:Int?
    var printBlock:PrintBlockModel?
    var isBanquet:Int?
    var isCollection:Int?
    var isDelivery:Int?
    var isDineIn:Int?
    
    enum CodingKeys: String, CodingKey {
        case name, id, disabled
        case printBlockId = "print_block_id"
        case parentId = "parent_id"
        case topColor = "top_color"
        case bottomColor = "bottom_color"
        case fontColor = "font_color"
        case printBlock = "assign_print_block"
        case isBanquet = "is_banquet"
        case isDineIn = "is_dinein"
        case isDelivery = "is_delivery"
        case isCollection = "is_collection"
    }
    
    required init(from decoder: Decoder) throws {
        let values = try decoder.container(keyedBy: CodingKeys.self)
        name = values.getStringValue(key: CodingKeys.name)
        id = values.getIntValue(key: CodingKeys.id)
        printBlockId = values.getIntValue(key: CodingKeys.printBlockId)
        parentId = values.getIntValue(key: CodingKeys.parentId)
        disabled = values.getIntValue(key: CodingKeys.disabled)
        topColor = values.getStringValue(key: CodingKeys.topColor)
        bottomColor = values.getStringValue(key: CodingKeys.bottomColor)
        fontColor = values.getStringValue(key: CodingKeys.fontColor)
        printBlock = try? values.decodeIfPresent(PrintBlockModel.self, forKey: .printBlock)
        printBlockId = printBlock?.id
        isDineIn = values.getIntValue(key: CodingKeys.isDineIn)
        isDelivery = values.getIntValue(key: CodingKeys.isDelivery)
        isCollection = values.getIntValue(key: CodingKeys.isCollection)
        isBanquet = values.getIntValue(key: CodingKeys.isBanquet)
    }
    
    init(_ category:NSManagedObject) {
        self.printBlockId = category.value(forKey: "print_block_id") as? Int
        self.id = category.value(forKey: "id") as? Int
        self.name = category.value(forKey: "name") as? String
        self.disabled = category.value(forKey: "disabled") as? Int
        self.parentId = category.value(forKey: "parent_id") as? Int
        self.topColor = category.value(forKey: "top_color") as? String
        self.bottomColor = category.value(forKey: "bottom_color") as? String
        self.fontColor = category.value(forKey: "font_color") as? String
        self.isCollection = category.value(forKey: "is_collection") as? Int
        self.isBanquet = category.value(forKey: "is_banquet") as? Int
        self.isDelivery = category.value(forKey: "is_delivery") as? Int
        self.isDineIn = category.value(forKey: "is_dinein") as? Int
    }
}

class PrintBlockModel:Codable{
    
    var id: Int?
    var printBlockId: Int?
    var name: String?
    var sequence:Int?
    var arrProducts = [OrderProductModel]()
    
    enum CodingKeys: String, CodingKey {
        case name, id, sequence
        case printBlockId = "print_block_id"
    }
    
    required init(from decoder: Decoder) throws {
        let values = try decoder.container(keyedBy: CodingKeys.self)
        name = values.getStringValue(key: CodingKeys.name)
        if let id = values.getIntValue(key: CodingKeys.printBlockId){
            self.id = id
        }else if let id = values.getIntValue(key: CodingKeys.id){
            self.id = id
        }
        sequence = values.getIntValue(key: CodingKeys.sequence)
    }
    
    init(_ block:NSManagedObject) {
        self.sequence = block.value(forKey: "sequence") as? Int
        self.id = block.value(forKey: "id") as? Int
        self.name = block.value(forKey: "name") as? String
    }
}
