//
//  DesignableButton.swift
//  SkyApp
//
//  Created by Tushar Premal on 12/18/16.
//  Copyright © 2016 Tushar Premal. All rights reserved.
//

import UIKit

@IBDesignable
class UIButtonX: UIButton {
   
    var shadowView: UIView!
    var alphaBefore: CGFloat = 1
    
    // MARK: - Borders
    
    @IBInspectable var cornerRadius: CGFloat = 0 {
        didSet {
            layer.cornerRadius = cornerRadius
        }
    }
    
    @IBInspectable var borderWidth: CGFloat = 0.0 {
        didSet {
            layer.borderWidth = borderWidth
        }
    }
    
    @IBInspectable var borderColor: UIColor = UIColor.clear {
        didSet {
            layer.borderColor = borderColor.cgColor
        }
    }
    
    // MARK: - Shadow
    
    @IBInspectable public var shadowOpacity: CGFloat = 0 {
        didSet {
            layer.shadowOpacity = Float(shadowOpacity)
        }
    }
    
    @IBInspectable public var shadowColor: UIColor = UIColor.clear {
        didSet {
            layer.shadowColor = shadowColor.cgColor
        }
    }
    
    @IBInspectable public var shadowRadius: CGFloat = 0 {
        didSet {
            layer.shadowRadius = shadowRadius
        }
    }
    
    @IBInspectable public var shadowOffsetY: CGFloat = 0 {
        didSet {
            layer.shadowOffset.height = shadowOffsetY
        }
    }
    
    
   //    MARK: - Gradient
    @IBInspectable var firstColor: UIColor = UIColor.white {
        didSet {
            updateView()
        }
    }
    
    @IBInspectable var secondColor: UIColor = UIColor.white {
        didSet {
            updateView()
        }
    }
    
    @IBInspectable var horizontalGradient: Bool = false {
        didSet {
            updateView()
        }
    }
    
    @IBInspectable public var imageColor: UIColor? {
        didSet {
            if imageColor != nil{
                self.setImageColor(color: imageColor!)
            }
        }
    }
    
    override public class var layerClass: AnyClass {
        get {
            return CAGradientLayer.self
        }
    }
    
    func setImageColor(color: UIColor) {
       guard let imgView = self.imageView, let img = imgView.image else {
           return
       }
       let templateImage = img.withRenderingMode(.alwaysTemplate)
       self.setImage(templateImage, for: .normal)
       self.tintColor = color
    }
    
    func updateView() {
        
        if let layer = self.layer as? CAGradientLayer{
            layer.colors = [ firstColor.cgColor, secondColor.cgColor ]
            
            if (horizontalGradient) {
                layer.startPoint = CGPoint(x: 0.0, y: 0.5)
                layer.endPoint = CGPoint(x: 1.0, y: 0.5)
            } else {
                layer.startPoint = CGPoint(x: 0, y: 0)
                layer.endPoint = CGPoint(x: 0, y: 1)
            }
        }else{
            let layer = CAGradientLayer()
            layer.colors = [ firstColor.cgColor, secondColor.cgColor ]
            
            if (horizontalGradient) {
                layer.startPoint = CGPoint(x: 0.0, y: 0.5)
                layer.endPoint = CGPoint(x: 1.0, y: 0.5)
            } else {
                layer.startPoint = CGPoint(x: 0, y: 0)
                layer.endPoint = CGPoint(x: 0, y: 1)
            }
            self.layer.insertSublayer(layer, at: 0)
        }
        
    }
}
