//
//  HeaderView.swift
//  EPOS
//
//  Created by Apple on 01/03/21.
//

import UIKit



class HeaderView: UIView {
    
    @IBOutlet weak var btnMenu:UIButton!
    @IBOutlet weak var lblCurrentTime:UILabel!
    
    var controller:UIViewController!
    
    static func addToViewHeader(VC:UIViewController)->HeaderView{
        let view = Bundle.main.loadNibNamed("HeaderView", owner: self, options: nil)?[0] as! HeaderView
        view.frame = CGRect.init(x: 0, y: 0, width: AppConstants.ScreenSize.SCREEN_WIDTH, height: 115)
        VC.view.addSubview(view)
        view.controller = VC
        return view
    }
    
    func setViewData(){
        lblCurrentTime.text = Date().getDateInString(format: "HH:mm a")
        
    }
    
    @IBAction func btnMenuAction(){
        controller.navigationController?.popViewController(animated: true)
    }
}

